/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamDataType;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.ParamValueRangeInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.util.LocaleUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ParamUtile {
    public static final String ALL_PARAM = "ALL";

    public static String getParamVal(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        try {
            Map<String, String> reurnData = ParamUtile.getParamVal(ctx, Collections.singletonList(number));
            return reurnData == null ? null : reurnData.get(number);
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, String> getParamVal(Context ctx, String[] numbers) throws BOSException {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        try {
            return ParamUtile.getParamVal(ctx, Arrays.asList(numbers));
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, String> getParamVal(Context ctx, List<String> numbers) throws BOSException {
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT param.fnumber, item.FVALUE" + MLUtile.getMlFlag(ctx) + " FROM T_BAS_PARAMITEM ITEM ");
        sql.append(" join T_BAS_Param param on param.fid = item.fkeyid");
        sql.append(" where param.fnumber in ").append(AtsCollectionUtile.joinForSqlWithBrackets(numbers));
        return AtsCollectionUtile.trimValue(AtsSqlUtile.getTwoField(ctx, sql.toString()));
    }

    public static Map<String, String> getParamValFuzzy(Context ctx, String number) throws BOSException {
        if (StringUtils.isBlank((String)number)) {
            return Collections.emptyMap();
        }
        return ParamUtile.getParamValFuzzy(ctx, Collections.singletonList(number));
    }

    public static Map<String, String> getParamValFuzzy(Context ctx, String[] numbers) throws BOSException {
        if (numbers == null || numbers.length == 0) {
            return Collections.emptyMap();
        }
        return ParamUtile.getParamValFuzzy(ctx, Arrays.asList(numbers));
    }

    public static Map<String, String> getParamValFuzzy(Context ctx, List<String> numbers) throws BOSException {
        if (AtsCollectionUtile.isEmpty(numbers)) {
            return Collections.emptyMap();
        }
        boolean getAllAtsParam = false;
        if (numbers.size() == 1 && ALL_PARAM.equals(numbers.get(0))) {
            numbers = Collections.singletonList("");
            getAllAtsParam = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT param.fnumber, item.FVALUE" + MLUtile.getMlFlag(ctx) + " FROM T_BAS_PARAMITEM ITEM ");
        sql.append(" join T_BAS_Param param on param.fid = item.fkeyid");
        sql.append(" where  ").append(AtsCollectionUtile.join(numbers, " or ", " param.fnumber like '%", "%'"));
        if (getAllAtsParam) {
            sql.append(" and fsubsysid='com.kingdee.eas.hr.ats.ats'");
        }
        return AtsCollectionUtile.trimValue(AtsSqlUtile.getTwoField(ctx, sql.toString()));
    }

    public static void updateParam(Context ctx, String number, String defValue) throws BOSException {
        try {
            IParam iCoreBase = ParamFactory.getLocalInstance((Context)ctx);
            ParamCollection colls = iCoreBase.getParamCollection("where param.number='" + number + "'");
            if (colls != null && colls.size() == 1) {
                colls.get(0).setDefaultValue(defValue);
                iCoreBase.save((CoreBaseInfo)colls.get(0));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static void updateParamItem(Context ctx, String number, String value) throws BOSException {
        try {
            IParamItem iCoreBase = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemCollection colls = iCoreBase.getParamItemCollection("where keyID.number='" + number + "'");
            CoreBaseCollection collection = new CoreBaseCollection();
            if (colls != null && colls.size() == 1) {
                for (int i = 0; i < colls.size(); ++i) {
                    colls.get(i).setValue(value);
                    colls.get(i).setValueAlias(value);
                    collection.add((CoreBaseInfo)colls.get(i));
                }
                iCoreBase.saveBatchData(collection);
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static void createParam(Context ctx, JSONObject param) {
        if (!param.containsKey((Object)"item.value")) {
            param.put("item.value", (Object)param.getString("defaultValue"));
        }
        if (!param.containsKey((Object)"desc")) {
            param.put("desc", (Object)param.getString("name"));
        }
        ParamInfo paramInfo = new ParamInfo();
        paramInfo.setName(param.getString("name"));
        paramInfo.setNumber(param.getString("number"));
        try {
            if (ParamManager.getParamByNumber((Context)ctx, (String)paramInfo.getNumber()) != null) {
                return;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        paramInfo.setDesc(param.getString("desc"));
        paramInfo.setDefaultValue(param.getString("defaultValue"));
        paramInfo.setDefaultValue(param.getString("defaultValue"), LocaleUtils.locale_l1);
        paramInfo.setDefaultValue(param.getString("defaultValue"), LocaleUtils.locale_l2);
        paramInfo.setDefaultValue(param.getString("defaultValue"), LocaleUtils.locale_l3);
        paramInfo.setDataType((ParamDataType)param.getObject("paramDataType", ParamDataType.class));
        if (param.containsKey((Object)"OrgType")) {
            paramInfo.setOrgType((OrgType)param.getObject("OrgType", OrgType.class));
        } else {
            paramInfo.setOrgType(OrgType.HRO);
        }
        if (param.containsKey((Object)"subSysID")) {
            paramInfo.setSubSysID(param.getString("isUserDefine"));
        } else {
            paramInfo.setSubSysID("com.kingdee.eas.hr.ats.ats");
        }
        if (param.containsKey((Object)"isUserDefine")) {
            paramInfo.setIsUserDefine(param.getBooleanValue("isUserDefine"));
        } else {
            paramInfo.setIsUserDefine(true);
        }
        if (param.containsKey((Object)"isGroupControl")) {
            paramInfo.setIsGroupControl(param.getBooleanValue("isGroupControl"));
        } else {
            paramInfo.setIsGroupControl(true);
        }
        if (param.containsKey((Object)"canBeModified")) {
            paramInfo.setCanBeModified(param.getBooleanValue("canBeModified"));
        } else {
            paramInfo.setCanBeModified(true);
        }
        if (param.containsKey((Object)"valueAlais")) {
            paramInfo.setValueAlias(param.getString("valueAlais"));
        } else {
            paramInfo.setValueAlias(paramInfo.getDefaultValue());
        }
        paramInfo.setTheValueRange(ParamUtile.createParamValueRange(param));
        try {
            ParamFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)paramInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static ParamItemInfo createParamItem(JSONObject param) {
        ParamItemInfo paramItemInfo = new ParamItemInfo();
        paramItemInfo.setValue(param.getString("item.value"));
        if (param.containsKey((Object)"item.valueAlais")) {
            paramItemInfo.setValueAlias(param.getString("item.valueAlais"));
        } else {
            paramItemInfo.setValueAlias(paramItemInfo.getValue());
        }
        if (param.containsKey((Object)"item.isModify")) {
            paramItemInfo.setIsModify(param.getBoolean("item.isModify").booleanValue());
        } else {
            paramItemInfo.setIsModify(true);
        }
        if (param.containsKey((Object)"item.isControlSub")) {
            paramItemInfo.setIsControlSub(param.getBoolean("item.isControlSub").booleanValue());
        } else {
            paramItemInfo.setIsControlSub(true);
        }
        return paramItemInfo;
    }

    public static ParamValueRangeInfo createParamValueRange(JSONObject param) {
        ParamValueRangeInfo paramValueRangeInfo = new ParamValueRangeInfo();
        if (param.containsKey((Object)"valueRange.maxValue")) {
            paramValueRangeInfo.setMaxValue(param.getString("valueRange.maxValue"));
        }
        if (param.containsKey((Object)"valueRange.minValue")) {
            paramValueRangeInfo.setMinValue(param.getString("valueRange.minValue"));
        }
        if (param.containsKey((Object)"valueRange.valueEnum")) {
            paramValueRangeInfo.setValueEnum(param.getString("valueRange.valueEnum"));
        }
        if (param.containsKey((Object)"valueRange.exclusValue")) {
            paramValueRangeInfo.setExclusValue(param.getString("valueRange.exclusValue"));
        }
        return paramValueRangeInfo;
    }

    public static void test(Context ctx) {
        JSONObject param = new JSONObject();
    }
}

