/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.pcRule.EmpQueryImpl;
import com.kingdee.eas.hr.ats.pcRule.GridDataEntity;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsArrayUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class PersonCombineInfoAnalysor {
    private List<String> configList;
    private FilterInfo filterInfo;

    public PersonCombineInfoAnalysor() {
    }

    PersonCombineInfoAnalysor(List<String> configList) {
        this.configList = configList;
    }

    public void analyze() {
        if (AtsCollectionUtile.isEmpty(this.configList)) {
            return;
        }
        this.filterInfo = this.filterInfo == null ? new FilterInfo() : this.filterInfo;
        for (String config : this.configList) {
            this.doAnalyze(config);
        }
    }

    public String analyzeToSql(Context ctx, String[] columnModel) {
        this.analyze();
        if (StringUtils.isEmpty((String)this.filterInfo.toString())) {
            return null;
        }
        SqlParam param = PersonCombineInfoAnalysor.getCombineSqlParam(columnModel, this.filterInfo);
        try {
            return FilterUtil.getSql((Context)ctx, (SqlParam)param);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public GridDataEntity analyzeToPerson(Context ctx, String[] columnModel) {
        this.analyze();
        String uipk = "com.kingdee.eas.basedata.person.app.Person.list";
        SqlParam param = PersonCombineInfoAnalysor.getCombineSqlParam(columnModel, this.filterInfo);
        GridDataEntity gridData = null;
        try {
            gridData = EmpQueryImpl.execQuery(ctx, uipk, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gridData;
    }

    private void doAnalyze(String configStr) {
        if (StringUtils.isEmpty((String)configStr)) {
            AtsLog.getWSLog().info((Object)"has not config person sql!");
            return;
        }
        JSONObject config = JSON.parseObject((String)configStr);
        if (config.containsKey((Object)"config")) {
            config = config.getJSONObject("config");
        }
        String prop_field = config.getString("name");
        Object value = AtsViewUtile.convertDataByType(config.getString("value"), config.getString("type"));
        CompareType compareType = CompareType.getEnum((String)config.getString("compareType"));
        if (value != null && value instanceof Set) {
            AtsViewUtile.assembleFilter(compareType, (Set)value, prop_field, this.filterInfo);
            return;
        }
        if ("enrollSource.name".equals(prop_field) || "wed.name".equals(prop_field) || "contract.state".equals(prop_field)) {
            AtsViewUtile.getAllowNullFilter(compareType, CompareType.NOTLIKE, prop_field, value, this.filterInfo);
        } else {
            AtsViewUtile.assembleFilter(compareType, prop_field, value, this.filterInfo);
        }
        AtsLog.getWSLog().info((Object)("person analyze result:" + this.filterInfo));
    }

    public static SqlParam getCombineSqlParam(String[] columnModel, FilterInfo filterInfo) {
        SqlParam param = new SqlParam();
        Date effectDate = DateTimeUtils.truncateDate((Date)new Date());
        param.setFilterDate(effectDate);
        HashMap<String, String> map = new HashMap<String, String>();
        if (AtsArrayUtil.isEmpty(columnModel)) {
            columnModel = new String[]{"person.id"};
        }
        int length = columnModel.length;
        for (int i = 0; i < length; ++i) {
            map.put(columnModel[i], columnModel[i]);
        }
        param.setSelectMapping(map);
        param.setFilterInfo(filterInfo);
        param.setScheme("001");
        param.setNeedDistinct(false);
        param.setHistoryMode(false);
        param.setRows(999999999);
        param.setPage(1);
        param.setNewSearch(true);
        return param;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }
}

