/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.BaseTripTimeZoneTrigger;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.base.HRTimeZoneInfo;
import com.kingdee.eas.hr.base.timezone.TimeZoneDataFetcher;
import com.kingdee.eas.hr.base.timezone.TimeZoneEventEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TripTimeZoneTrigger
extends BaseTripTimeZoneTrigger {
    public TripTimeZoneTrigger() {
        this.billEntryClass = AtsTripBillEntryInfo.class;
    }

    @Override
    protected java.util.Date getMaxDateForLatest() {
        return (java.util.Date)AtsCommonUtile.getDateRange(this.getEntryIterator(), "tripStartTime").getUpBound();
    }

    public Map<Object, String> calCrossTimeZone(boolean returnStringKey) throws EASBizException {
        RangeDate rangeDate = AtsCommonUtile.getDateRange(this.getEntryIterator(), "tripStartTime", "tripEndTime");
        TimeZoneDataFetcher fetcher = new TimeZoneDataFetcher();
        fetcher.setCtx(this.ctx).addFilterObj(AtsCommonUtile.getValFromeCoreBaseWithDotField(this.getEntryIterator(), "person"));
        fetcher.setBeginTime(rangeDate.getLowBound()).setEndTime(rangeDate.getUpBound()).setAsendResult(true);
        Map entryTimeZoneMap = fetcher.fetchMapData();
        if (AtsCollectionUtile.isEmpty(entryTimeZoneMap)) {
            return Collections.emptyMap();
        }
        HashMap<Object, String> returnData = new HashMap<Object, String>();
        Iterator<?> it = this.getEntryIterator();
        while (it.hasNext()) {
            returnData.putAll(this.getRelateTimeZoneChangeDate((AtsTripBillEntryInfo)it.next(), entryTimeZoneMap, returnStringKey));
        }
        return returnData;
    }

    private Map<Object, String> getRelateTimeZoneChangeDate(AtsTripBillEntryInfo tripEntry, Map<String, List<HRTimeZoneInfo>> entryTimeZoneMap, boolean returnStringKey) {
        List<HRTimeZoneInfo> personTimeZone;
        PersonInfo person = tripEntry.getPerson() == null ? null : tripEntry.getPerson();
        List<HRTimeZoneInfo> list = personTimeZone = person == null ? null : entryTimeZoneMap.get(person.getString("id"));
        if (AtsCollectionUtile.isEmpty(personTimeZone)) {
            return Collections.emptyMap();
        }
        Date start = Date.getDate(tripEntry.getTripStartTime());
        Date end = Date.getDate(tripEntry.getTripEndTime());
        ArrayList<HRTimeZoneInfo> entryTimeZone = new ArrayList<HRTimeZoneInfo>(personTimeZone);
        Iterator it = entryTimeZone.iterator();
        while (it.hasNext()) {
            HRTimeZoneInfo hrTimeZoneInfo = (HRTimeZoneInfo)it.next();
            if (!hrTimeZoneInfo.getEffdt().after(end) && !hrTimeZoneInfo.getLeffdt().before(start)) continue;
            it.remove();
        }
        StringBuffer dateList = new StringBuffer();
        for (int i = 1; i < entryTimeZone.size(); ++i) {
            if (((HRTimeZoneInfo)entryTimeZone.get(i)).getTimeZone().equals((Object)((HRTimeZoneInfo)entryTimeZone.get(i - 1)).getTimeZone())) continue;
            dateList.append(",").append(Date.getTime(((HRTimeZoneInfo)entryTimeZone.get(i)).getEffdt()).toDateStr());
        }
        if (dateList.length() > 0) {
            AtsTripBillEntryInfo key = !returnStringKey ? tripEntry : new StringBuffer().append(start).append(",").append(end).append(",").append(tripEntry.getPerson().getString("id"));
            return Collections.singletonMap(key, dateList.substring(1));
        }
        return Collections.emptyMap();
    }

    @Override
    protected Object getTimeZoneChangeEventInner(boolean authenOperation) {
        if (authenOperation) {
            return TimeZoneEventEnum.ATS_TRIP_AUTHON;
        }
        return null;
    }

    @Override
    protected void beforTriggerUnAuthen() throws EASBizException {
        Iterator<?> it = this.getEntryIterator();
        while (it.hasNext()) {
            CoreBaseInfo entry = (CoreBaseInfo)it.next();
            HRTimeZoneInfo hrTimeZoneInfo = this.getPreTimeZone((AtsTripBillEntryInfo)entry);
            entry.put("changeEvent", (Object)hrTimeZoneInfo.getChangeEvent());
            entry.put("timeZone", (Object)hrTimeZoneInfo.getTimeZone());
        }
        this.timeZoneUpdater.setForceUpdateLevel(this.getTripTimeZoneLevel());
    }
}

