/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.person;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class AtsPersonUtils {
    private static PagingHelper pagingHelper = new PagingHelper();
    private static final String LAST_ORG_RELATION_DATE_CONDITION = "{ts'2199-12-31'}";

    public static Map<String, String> getPersonNameByIds(Context ctx, String personIds) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)personIds)) {
            return res;
        }
        PersonCollection personCollection = AtsPersonUtils.getPersonByIds(ctx, personIds);
        for (int i = 0; i < personCollection.size(); ++i) {
            PersonInfo personInfo = personCollection.get(i);
            res.put(personInfo.getId().toString(), personInfo.getName());
        }
        return res;
    }

    public static PersonCollection getPersonByIds(Context ctx, String personIds) {
        PersonCollection res = new PersonCollection();
        if (StringUtils.isEmpty((String)personIds)) {
            return res;
        }
        try {
            personIds = AtsUtil.getStrFromStringArr(personIds.split(","));
            res = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id,number, name where id in (" + personIds + ")");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static Map<String, Object> getPersonsByPersonIdPage(Context ctx, String personId, int page, int size) {
        if (StringUtils.isBlank((String)personId)) {
            return null;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("records", 0);
        res.put("page", page);
        res.put("rows", new LinkedList());
        String adminOrgUnitId = AtsPersonUtils.getAdminOrgUnitIdByPersonId(ctx, personId);
        if (StringUtils.isEmpty((String)adminOrgUnitId)) {
            return res;
        }
        StringBuffer commonSql = new StringBuffer();
        commonSql.append("FROM T_BD_Person AS PERSON ");
        commonSql.append("inner JOIN T_HR_EmpOrgRelation AS EMPPOSORGRELATION ON PERSON.FID = EMPPOSORGRELATION.FPersonID ");
        commonSql.append("inner JOIN T_ORG_Admin AS ADMINORGUNIT ON EMPPOSORGRELATION.FAdminOrgID = ADMINORGUNIT.FID ");
        commonSql.append("inner join T_ORG_Admin org ON ( CHARINDEX( concat ( ADMINORGUNIT.flongnumber, '!' ), org.flongnumber ) = 1 OR ADMINORGUNIT.flongnumber = org.flongnumber ) AND org.FISSTARTSHR = 1 ");
        commonSql.append("where adminOrgUnit.Fid ='").append(adminOrgUnitId).append("' ");
        int total = AtsPersonUtils.getTotal(ctx, commonSql);
        String mlFlag = MLUtile.getMlFlag(ctx);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("SELECT ");
        selectSql.append("PERSON.FID                    AS personID, ");
        selectSql.append("PERSON.FName" + mlFlag + "    AS personName, ");
        selectSql.append("PERSON.FNumber                AS personNumber, ");
        selectSql.append("EMPPOSORGRELATION.FAdminOrgID AS adminOrgUnitID, ");
        selectSql.append("ADMINORGUNIT.FLongNumber      AS adminOrgUnitLongNumber, ");
        selectSql.append("ADMINORGUNIT.FDisplayName" + mlFlag + "  AS adminOrgUnitDisplayName, ");
        selectSql.append("ADMINORGUNIT.FName" + mlFlag + " AS adminOrgUnitName, ");
        selectSql.append("ADMINORGUNIT.FNumber          AS adminOrgUnitNumber, ");
        selectSql.append("EMPPOSORGRELATION.FID         AS EmpOrgRelationID ");
        String orderSql = " order by adminOrgUnitName asc, personName asc ";
        String sql = selectSql.toString() + commonSql.toString() + orderSql;
        LinkedList rows = new LinkedList();
        try {
            int start = page < 0 ? 0 : (page - 1) * size;
            int length = size > 0 ? size : 1;
            IRowSet iRowSet = DbUtile.executeQuery(ctx, pagingHelper.getPagingSqlNoOptmize(ctx, sql, start, length));
            while (iRowSet.next()) {
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("personID", iRowSet.getString("personID"));
                row.put("personName", iRowSet.getString("personName"));
                row.put("personNumber", iRowSet.getString("personNumber"));
                row.put("adminOrgUnitID", iRowSet.getString("adminOrgUnitID"));
                row.put("adminOrgUnitLongNumber", iRowSet.getString("adminOrgUnitLongNumber"));
                row.put("adminOrgUnitDisplayName", iRowSet.getString("adminOrgUnitDisplayName"));
                row.put("adminOrgUnitName", iRowSet.getString("adminOrgUnitName"));
                row.put("adminOrgUnitNumber", iRowSet.getString("adminOrgUnitNumber"));
                row.put("EmpOrgRelationID", iRowSet.getString("EmpOrgRelationID"));
                rows.add(row);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        res.put("records", total);
        res.put("total", total / size + (total % size > 0 ? 1 : 0));
        res.put("page", page);
        res.put("rows", rows);
        return res;
    }

    protected static int getTotal(Context ctx, StringBuffer sql) {
        String totalSql = "select count(1) recordsCount " + sql.toString();
        try {
            IRowSet iRowSet = DbUtile.executeQuery(ctx, totalSql);
            iRowSet.next();
            return iRowSet.getInt("recordsCount");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getAdminOrgUnitIdByPersonId(Context ctx, String personId) {
        if (StringUtils.isBlank((String)personId)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FAdminOrgID adminOrgId");
        sql.append(" from T_HR_EmpOrgRelation ");
        sql.append(" where FPersonID ='").append(personId).append("'").append("and fleffdt = {ts'2199-12-31'}");
        try {
            IRowSet iRowSet = DbUtile.executeQuery(ctx, sql.toString());
            if (iRowSet.next()) {
                return iRowSet.getString("adminOrgId");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static FilterInfo getAdminOrgUnitControlFilter(Context ctx, String personId) {
        FilterInfo adminControlFilter = new FilterInfo();
        String adminOrgUnitId = AtsPersonUtils.getAdminOrgUnitIdByPersonId(ctx, personId);
        try {
            String tempSql = "select fLongNumber from T_ORG_Admin where fid = '" + adminOrgUnitId + "'";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)tempSql);
            Object[] result = iRowSet.toCollection().toArray();
            if (result != null && result.length > 0) {
                Vector flongNumberV = (Vector)result[0];
                String flongNumber = (String)flongNumberV.get(0);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.longNumber", (Object)flongNumber, CompareType.EQUALS));
                FilterInfo filterInfo1 = new FilterInfo();
                filterInfo1.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.longNumber", (Object)(flongNumber + "!%"), CompareType.LIKE));
                filterInfo1.mergeFilter(filterInfo, "OR");
                adminControlFilter.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.ISSTARTSHR", (Object)1, CompareType.EQUALS));
                Date now = new Date();
                adminControlFilter.getFilterItems().add(new FilterItemInfo("EMPPOSORGRELATION.EFFDT", (Object)now, CompareType.LESS_EQUALS));
                adminControlFilter.getFilterItems().add(new FilterItemInfo("EMPPOSORGRELATION.LEFFDT", (Object)now, CompareType.GREATER));
                adminControlFilter.getFilterItems().add(new FilterItemInfo("PERSON.ID", (Object)personId, CompareType.NOTEQUALS));
                adminControlFilter.mergeFilter(filterInfo1, "AND");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return adminControlFilter;
    }
}

