/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsInfo;
import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.AtsAcrossStoreBillHelper;
import com.kingdee.eas.hr.ats.validator.BillValidator;
import com.kingdee.eas.hr.ats.validator.PlateformType;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Set;

public class AtsAcrossStoreValidator
extends BillValidator<AtsAcrossStoreSopportInfo> {
    AtsAcrossStoreBillHelper billHelper;

    @Override
    public String validateEntryDAC(String field, AtsAffairEntryBaseInfo entryBill, AtsAcrossStoreSopportInfo billInfo) throws Exception {
        AtsAcrossStoreSptsInfo sptsEntry = (AtsAcrossStoreSptsInfo)entryBill;
        AtsAcrossStoreSptsCollection sptsEntries = billInfo.getSpts();
        if (PlateformType.isSelf(this.getValidateCtx().getPlateformType())) {
            boolean flag = this.isCurrentPerson(sptsEntry.getPerson());
            if (flag) {
                return null;
            }
            Iterator iterator = sptsEntries.iterator();
            while (iterator.hasNext()) {
                AtsAcrossStoreSptsInfo sptsInfo = (AtsAcrossStoreSptsInfo)iterator.next();
                if (!CoreBaseUtile.getId(sptsInfo.getEntryBill()).equals(CoreBaseUtile.getId(sptsEntry))) continue;
                iterator.remove();
            }
            return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NOT_SELF", this.getValidateCtx().getBosCtx());
        }
        if (PlateformType.isTeam(this.getValidateCtx().getPlateformType()) || PlateformType.isPro(this.getValidateCtx().getPlateformType())) {
            Set<String> adminOrgRange = this.getValidateCtx().getAdminOrgRange();
            AdminOrgUnitInfo adminInfo = sptsEntry.getAdminOrgUnit();
            if (adminInfo != null && adminOrgRange.contains(CoreBaseUtile.getId(adminInfo)) || adminOrgRange.contains(CoreBaseUtile.getId(billInfo.getAdminOrg()))) {
                return null;
            }
            Iterator iterator = sptsEntries.iterator();
            while (iterator.hasNext()) {
                AtsAcrossStoreSptsInfo sptsInfo = (AtsAcrossStoreSptsInfo)iterator.next();
                if (!CoreBaseUtile.getId(sptsInfo.getEntryBill()).equals(CoreBaseUtile.getId(sptsEntry))) continue;
                iterator.remove();
            }
            return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_PERM", this.getValidateCtx().getBosCtx());
        }
        return null;
    }

    @Override
    protected void beforeValidate() throws Exception {
        super.beforeValidate();
        this.billHelper = new AtsAcrossStoreBillHelper();
        this.billHelper.setCtx(this.getValidateCtx().getBosCtx());
    }

    @Override
    protected String afterValidateAllEntry(AtsAcrossStoreSopportInfo billInfo) {
        if (billInfo.getCollaborator() != null && !StringUtils.isEmpty((String)CoreBaseUtile.getId(billInfo.getCollaborator()))) {
            return null;
        }
        AtsAcrossStoreSptEntryCollection entries = billInfo.getEntries();
        AtsAcrossStoreSptsCollection spts = billInfo.getSpts();
        Iterator entriesIterator = entries.iterator();
        while (entriesIterator.hasNext()) {
            AtsAcrossStoreSptEntryInfo entryInfo = (AtsAcrossStoreSptEntryInfo)entriesIterator.next();
            Iterator sptsIterator = spts.iterator();
            boolean removeFlag = true;
            while (sptsIterator.hasNext()) {
                AtsAcrossStoreSptsInfo sptsInfo = (AtsAcrossStoreSptsInfo)sptsIterator.next();
                if (!CoreBaseUtile.getId(entryInfo).equals(CoreBaseUtile.getId(sptsInfo.getEntryBill()))) continue;
                removeFlag = false;
            }
            if (!removeFlag) continue;
            entriesIterator.remove();
        }
        return null;
    }

    @Override
    protected String validateEntryBiz(String field, AtsAffairEntryBaseInfo entryBillInfo, AtsAcrossStoreSopportInfo billInfo) throws Exception {
        return super.validateEntryBiz(field, entryBillInfo, billInfo);
    }

    @Override
    public String validateDAC(AtsAcrossStoreSopportInfo target) throws Exception {
        return super.validateDAC(target);
    }

    @Override
    protected String validateBiz(AtsAcrossStoreSopportInfo target) throws Exception {
        String errorMsg = super.validateBiz(target);
        target.put("actionSSC", this.getValidateCtx().getMethodName());
        errorMsg = this.billHelper.validateBill(target);
        return errorMsg;
    }
}

