/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.ats.AbstractAtsDataBaseInfo;
import com.kingdee.eas.hr.ats.AtsDataBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BaseValidator;
import com.kingdee.eas.hr.ats.validator.PlateformType;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CommonValidator<T extends AtsDataBaseInfo>
extends BaseValidator<T> {
    @Override
    protected void initConvertSelectFields() {
        super.initConvertSelectFields();
        if (PlateformType.isSelf(this.getValidateCtx().getPlateformType())) {
            this.getValidateCtx().addConvertSelectField("proposer");
        } else {
            this.getValidateCtx().addConvertSelectField("attendFile.isDefaultManage");
            this.getValidateCtx().addConvertSelectField("hrOrgUnit");
            this.getValidateCtx().addConvertSelectField("adminOrgUnit");
        }
    }

    @Override
    protected String validateDAC(T target) throws Exception {
        String errorStr = this.validateHRO(target);
        if (StringUtils.isNotBlank((CharSequence)errorStr)) {
            return errorStr;
        }
        if (!this.isDefaultManage(target)) {
            return null;
        }
        errorStr = this.validateAdmin(target);
        if (StringUtils.isNotBlank((CharSequence)errorStr)) {
            return errorStr;
        }
        return null;
    }

    @Override
    protected String validateHRO(T target) throws Exception {
        if (PlateformType.isTeam(this.getValidateCtx().getPlateformType()) && !this.getValidateCtx().isUpdateMethod()) {
            return null;
        }
        Set<String> hrOrgRange = this.getValidateCtx().getHrOrgRange();
        if (((AbstractAtsDataBaseInfo)target).getHrOrgUnit() != null && hrOrgRange.contains(((AbstractAtsDataBaseInfo)target).getHrOrgUnit().getString("id"))) {
            return null;
        }
        return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_PERM_HRO", this.getValidateCtx().getBosCtx());
    }

    @Override
    protected String validateAdmin(T target) throws Exception {
        if (!(target instanceof AtsDataBaseInfo)) {
            return null;
        }
        Set<String> adminOrgRange = this.getValidateCtx().getAdminOrgRange();
        AdminOrgUnitInfo adminInfo = ((AbstractAtsDataBaseInfo)target).getAdminOrgUnit();
        if (adminInfo != null && adminOrgRange.contains(adminInfo.getString("id"))) {
            return null;
        }
        adminInfo = (AdminOrgUnitInfo)target.get("attAdminOrgUnit");
        if (adminInfo != null && adminOrgRange.contains(adminInfo.getString("id"))) {
            return null;
        }
        return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_PERM_ADMIN", this.getValidateCtx().getBosCtx());
    }

    @Override
    protected boolean isDefaultManage(Object target) throws Exception {
        if (!(target instanceof AtsDataBaseInfo)) {
            return true;
        }
        if (((AtsDataBaseInfo)target).containsKey("isDefaultManage")) {
            return ((AtsDataBaseInfo)target).getBoolean("isDefaultManage");
        }
        AttendanceFileInfo attendFile = (AttendanceFileInfo)((AtsDataBaseInfo)target).get("attendFile");
        return attendFile.getBoolean("isDefaultManage");
    }
}

