/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.vo.common;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class ChainList<E> {
    private static final long serialVersionUID = 1L;
    private ArrayList<E> list;

    public ChainList() {
        this(4);
    }

    public ChainList(int initialSize) {
        this.list = new ArrayList(initialSize);
    }

    public ChainList(E e) {
        this(4);
        this.list.add(e);
    }

    public ChainList(ChainList<E> chainList) {
        this(chainList.getOriginList());
    }

    public ChainList(Collection<E> collection) {
        this.list = new ArrayList<E>(collection);
    }

    public ChainList<E> trimToSize() {
        this.list.trimToSize();
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    public ChainList<E> clone() {
        return new ChainList<E>((List)this.list.clone());
    }

    public E[] toArray() {
        if (this.list.isEmpty()) {
            return null;
        }
        Class<?> parameClass = this.list.get(0).getClass();
        Object[] eArr = (Object[])Array.newInstance(parameClass, this.list.size());
        this.list.toArray(eArr);
        return eArr;
    }

    public E[] toArray(E[] e) {
        return this.list.toArray(e);
    }

    public E get(int index) {
        return this.list.get(index);
    }

    public ChainList<E> set(int index, E element) {
        this.list.set(index, element);
        return this;
    }

    public ChainList<E> add(E e) {
        this.list.add(e);
        return this;
    }

    public ChainList<E> preAdd(E e) {
        return this.add(0, e);
    }

    public ChainList<E> add(E element, E refrenceEle) {
        int ind = this.list.indexOf(refrenceEle);
        if (ind == -1 || ind == this.list.size() - 1) {
            this.add(element);
        } else {
            this.add(ind + 1, element);
        }
        return this;
    }

    public ChainList<E> preAdd(E element, E refrenceEle) {
        int ind = this.list.indexOf(refrenceEle);
        if (ind == -1) {
            ind = 0;
        }
        this.add(ind, element);
        return this;
    }

    public ChainList<E> add(int index, E element) {
        this.list.add(index, element);
        return this;
    }

    public ChainList<E> remove(int index) {
        this.list.remove(index);
        return this;
    }

    public ChainList<E> remove(Object o) {
        this.list.remove(o);
        return this;
    }

    public ChainList<E> clear() {
        this.list.clear();
        return this;
    }

    public ChainList<E> addAll(Collection<? extends E> c) {
        this.list.addAll(c);
        return this;
    }

    public ChainList<E> addAll(int index, Collection<? extends E> c) {
        this.list.addAll(index, c);
        return this;
    }

    public ChainList<E> removeAll(Collection<?> c) {
        this.list.removeAll(c);
        return this;
    }

    public ChainList<E> retainAll(Collection<?> c) {
        this.list.retainAll(c);
        return this;
    }

    public ListIterator<E> iterator(int index) {
        return this.list.listIterator(index);
    }

    public ListIterator<E> iterator() {
        return this.list.listIterator();
    }

    public ChainList<E> subList(int fromIndex, int toIndex) {
        ChainList<E> chainList = new ChainList<E>(toIndex - fromIndex + 1);
        for (E e : this.list.subList(fromIndex, toIndex)) {
            chainList.add(e);
        }
        return chainList;
    }

    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    public ArrayList<E> getOriginList() {
        return this.list;
    }
}

