/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.arrange;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryInfo;
import com.kingdee.eas.hr.ats.AtsTurnShiftInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftUtile;
import com.kingdee.eas.hr.ats.workShift.arrange.BaseArrangeShift;
import com.kingdee.eas.hr.ats.workShift.arrange.EArrangeState;
import java.util.Map;

public class ArrangeShitByTurns
extends BaseArrangeShift
implements Cloneable {
    private int startSegment;
    private int currentSegment;
    private String turnShiftId;
    private Map<Integer, AtsTurnShiftEntryInfo> turnShiftEntrys;

    public ArrangeShitByTurns() {
    }

    public ArrangeShitByTurns(Context ctx) {
        super(ctx);
    }

    @Override
    void beforeArrangeShift() {
        super.beforeArrangeShift();
        if (this.turnShiftEntrys == null) {
            this.turnShiftEntrys = ArrangeShiftUtile.getTurnShiftEntrys(this.ctx, this.turnShiftId);
        }
        if (!AtsCollectionUtile.isEmpty(this.turnShiftEntrys) && this.turnShiftEntrys.size() < this.startSegment) {
            this.startSegment %= this.turnShiftEntrys.size();
        }
        if (AtsCollectionUtile.isEmpty(this.turnShiftEntrys)) {
            this.setContinueArrangeShift(false);
        }
        this.currentSegment = this.startSegment;
    }

    @Override
    public void afterArrangeShift() {
        super.afterArrangeShift();
    }

    @Override
    public void holidayProcss() {
        switch (this.holidayProcessWay.getValue()) {
            case 1: {
                this.holidayProcssByTurn();
                break;
            }
            case 2: {
                this.holidayProcssByTurn();
                this.incrementSegment();
                break;
            }
            default: {
                this.workDayProcess();
            }
        }
    }

    @Override
    public void workDayProcess() {
        AtsTurnShiftEntryInfo atsTurnShift = this.turnShiftEntrys.get(this.currentSegment);
        this.getCurentArrangingSchedule().setDefaultShift(atsTurnShift.getDefaultShift());
        this.getCurentArrangingSchedule().setDayType(atsTurnShift.getDateType());
        this.incrementSegment();
        if (this.getArrangeState() == EArrangeState.SHOW_RESULT) {
            return;
        }
    }

    private void holidayProcssByTurn() {
        this.getCurentArrangingSchedule().setDayType(DayTypeEnum.legalHoliday);
        this.getCurentArrangingSchedule().setDefaultShift(null);
        if (this.getArrangeState() == EArrangeState.SHOW_RESULT) {
            return;
        }
    }

    @Override
    protected void setBasicScheduleInfo() {
        super.setBasicScheduleInfo();
        AtsTurnShiftInfo atsTurnShift = new AtsTurnShiftInfo();
        atsTurnShift.setId(BOSUuid.read((String)this.turnShiftId));
        this.getCurentArrangingSchedule().setAtsTurnShift(atsTurnShift);
        this.getCurentArrangingSchedule().setShiftByTurnSegment(this.getCurrentSegment());
    }

    @Override
    public void weekendProcess() {
        this.workDayProcess();
    }

    private void incrementSegment() {
        if (this.turnShiftEntrys != null && this.currentSegment >= this.turnShiftEntrys.size()) {
            this.currentSegment = 0;
        }
        ++this.currentSegment;
    }

    public int getStartSegment() {
        return this.startSegment;
    }

    public void setStartSegment(int startSegment) {
        this.startSegment = startSegment;
    }

    public int getCurrentSegment() {
        return this.currentSegment;
    }

    public void setCurrentSegment(int currentSegment) {
        this.currentSegment = currentSegment;
    }

    public String getTurnShiftId() {
        return this.turnShiftId;
    }

    public void setTurnShiftId(String turnShiftId) {
        this.turnShiftId = turnShiftId;
    }

    public Map<Integer, AtsTurnShiftEntryInfo> getTurnShiftEntrys() {
        return this.turnShiftEntrys;
    }

    public void setTurnShiftEntrys(Map<Integer, AtsTurnShiftEntryInfo> turnShiftEntrys) {
        this.turnShiftEntrys = turnShiftEntrys;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

