/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.matchSchedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsScheduleIntelInfo;
import com.kingdee.eas.hr.ats.AtsShiftAdminOrgCollection;
import com.kingdee.eas.hr.ats.AtsShiftAdminOrgFactory;
import com.kingdee.eas.hr.ats.AtsShiftElasticType;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftCollection;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftFactory;
import com.kingdee.eas.hr.ats.CardShiftType;
import com.kingdee.eas.hr.ats.PunchCardRecordCollection;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.TwoFieldProcessor;
import com.kingdee.eas.hr.ats.vo.common.RangeInt;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.WorkShiftUtile;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.dto.CardSetDTO;
import com.kingdee.eas.hr.ats.workShift.save.BaseSaveShift;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class MatchScheduleUtile {
    public static List<AtsScheduleIntelInfo> getPlanes(Context ctx, Collection<String> ids, boolean isEntryIds) {
        if (AtsCollectionUtile.isEmpty(ids)) {
            return null;
        }
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"atsScheduleIntelSet.frontDate", "atsScheduleIntelSet.name", "atsScheduleIntelSet.adminOrgUnit.id", "atsScheduleIntelSet.adminOrgUnit.longNumber", "atsScheduleIntelSet.hrOrgUnit", "atsScheduleIntelSet.number", "atsScheduleIntelSet.intervalTime", "atsScheduleIntelSet.sameCard", "atsScheduleIntelSet.atsShiftRest", "atsScheduleIntelSet.atsShiftLegal", "atsScheduleIntelSet.atsWorkRest", "atsScheduleIntelSet.atsLegalShift", "atsScheduleIntelSet.punchCardShift", "atsScheduleIntelSet.noCardDay", "atsScheduleIntelSet.intervalCardSet", "atsScheduleIntelSet.matchShiftType", "*", "conditionItems.items.*"});
        AtsViewUtile.addSorter("atsScheduleIntelSet.number", SortType.ASCEND, evi);
        AtsViewUtile.addSorter("schedulePriority", SortType.ASCEND, evi);
        if (!isEntryIds) {
            ids = AtsSqlUtile.getOneField(ctx, "select fid from T_ATS_AtsScheduleIntel where FAtsScheduleIntelSetID in " + AtsCollectionUtile.joinForSqlWithBrackets(ids));
        }
        AtsViewUtile.getViewByFilter("id", new HashSet<String>(ids), CompareType.INCLUDE, evi);
        try {
            return AtsSqlUtile.getList(ctx, evi, AtsScheduleIntelInfo.class);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Map<String, List<Date>>> getPunchCards(Context ctx, Collection<String> personNums, Date beginDate, Date endDate) {
        HashMap<String, Map<String, List<Date>>> punchCards = new HashMap<String, Map<String, List<Date>>>(personNums.size());
        if (AtsCollectionUtile.isEmpty(personNums)) {
            return punchCards;
        }
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"proposer.id", "proposer.number", "punchCardTime"});
        AtsViewUtile.getViewByFilter("proposer.number", new HashSet<String>(personNums), CompareType.INCLUDE, evi);
        AtsViewUtile.getViewByFilter("punchCardTime", AtsCommonUtile.getDayStart(beginDate), CompareType.GREATER_EQUALS, evi);
        AtsViewUtile.getViewByFilter("punchCardTime", AtsCommonUtile.getDayEnd(endDate), CompareType.LESS_EQUALS, evi);
        PunchCardRecordCollection colls = null;
        try {
            colls = PunchCardRecordFactory.getLocalInstance(ctx).getPunchCardRecordCollection(evi.toString() + " and (punchCardState is null or punchCardState=0) order by punchCardTime");
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)("" + (Object)((Object)e)));
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)colls)) {
            for (int i = 0; i < colls.size(); ++i) {
                ArrayList<Timestamp> dayCards;
                String personNum = colls.get(i).getProposer().getNumber();
                String curDate = AtsCommonUtile.formateDate(colls.get(i).getPunchCardTime());
                HashMap<String, ArrayList<Timestamp>> personCards = (HashMap<String, ArrayList<Timestamp>>)punchCards.get(personNum);
                if (personCards == null) {
                    personCards = new HashMap<String, ArrayList<Timestamp>>();
                    punchCards.put(personNum, personCards);
                }
                if ((dayCards = (ArrayList<Timestamp>)personCards.get(curDate)) == null) {
                    dayCards = new ArrayList<Timestamp>();
                    personCards.put(curDate, dayCards);
                }
                dayCards.add(colls.get(i).getPunchCardTime());
            }
        }
        return punchCards;
    }

    public static Map<String, List<AtsTripBillEntryInfo>> getTripBills(Context ctx, Collection<String> personNums, Date beginDate, Date endDate, String hrOrgId) {
        EntityViewInfo evi = MatchScheduleUtile.getBillEntryEiew("realTripStartTime", "realTripEndTime", beginDate, endDate, personNums);
        AtsViewUtile.getViewByFilter("bill.hrOrgUnit", hrOrgId, CompareType.EQUALS, evi);
        AtsTripBillEntryCollection colls = null;
        try {
            colls = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryCollection(evi);
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)("" + (Object)((Object)e)));
        }
        return MatchScheduleUtile.convertBillInfoToMap((IObjectCollection)colls, AtsTripBillEntryInfo.class);
    }

    public static Map<String, List<AtsLeaveBillEntryInfo>> getLeaveBills(Context ctx, Collection<String> personNums, Date beginDate, Date endDate) {
        EntityViewInfo evi = MatchScheduleUtile.getBillEntryEiew("realBeginTime", "realEndTime", beginDate, endDate, personNums);
        AtsLeaveBillEntryCollection colls = null;
        try {
            colls = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(evi);
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)("" + (Object)((Object)e)));
        }
        return MatchScheduleUtile.convertBillInfoToMap((IObjectCollection)colls, AtsLeaveBillEntryInfo.class);
    }

    public static Map<String, List<AtsOverTimeBillEntryInfo>> getOverTimeBills(Context ctx, Collection<String> personNums, Date beginDate, Date endDate, String hrOrgId) {
        EntityViewInfo evi = MatchScheduleUtile.getBillEntryEiew("startTime", "endTime", beginDate, endDate, personNums);
        AtsViewUtile.getViewByFilter("bill.hrOrgUnit", hrOrgId, CompareType.EQUALS, evi);
        AtsViewUtile.getViewBySelector(new String[]{"otType.name", "otDate"}, evi);
        AtsOverTimeBillEntryCollection colls = null;
        try {
            colls = AtsOverTimeBillEntryFactory.getLocalInstance(ctx).getAtsOverTimeBillEntryCollection(evi);
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)("" + (Object)((Object)e)));
        }
        return MatchScheduleUtile.convertBillInfoToMap((IObjectCollection)colls, AtsOverTimeBillEntryInfo.class);
    }

    public static EntityViewInfo getBillEntryEiew(String beginTimeField, String endTimeField, Date beginDate, Date endDate, Collection<String> personNums) {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"person.id", "person.number", beginTimeField, endTimeField});
        AtsViewUtile.getViewByFilter("person.number", new HashSet<String>(personNums), CompareType.INCLUDE, evi);
        AtsViewUtile.getViewByFilter("bill.billState", 3, CompareType.EQUALS, evi);
        AtsViewUtile.getViewByFilter(beginTimeField, AtsCommonUtile.getDayEnd(endDate), CompareType.LESS_EQUALS, evi);
        AtsViewUtile.getViewByFilter(endTimeField, AtsCommonUtile.getDayStart(beginDate), CompareType.GREATER_EQUALS, evi);
        AtsViewUtile.addSorter("person.number", SortType.ASCEND, evi);
        AtsViewUtile.addSorter(beginTimeField, SortType.ASCEND, evi);
        return evi;
    }

    public static <T extends AtsAffairEntryBaseInfo> Map<String, List<T>> convertBillInfoToMap(IObjectCollection colls, Class<T> classType) {
        HashMap<String, List<T>> returnMap = new HashMap<String, List<T>>();
        if (AtsCollectionUtile.isEmpty(colls)) {
            return returnMap;
        }
        for (int i = 0; i < colls.size(); ++i) {
            AtsAffairEntryBaseInfo curBillInfo = (AtsAffairEntryBaseInfo)colls.getObject(i);
            String personNum = curBillInfo.getPerson().getNumber();
            ArrayList<AtsAffairEntryBaseInfo> personBillInfos = (ArrayList<AtsAffairEntryBaseInfo>)returnMap.get(personNum);
            if (personBillInfos == null) {
                personBillInfos = new ArrayList<AtsAffairEntryBaseInfo>();
                returnMap.put(personNum, personBillInfos);
            }
            personBillInfos.add(curBillInfo);
        }
        return returnMap;
    }

    public static RangeMap<Integer, Map<Integer, Integer>> getSegmentPriority(String segmentPriorityStr) {
        if (StringUtils.isEmpty((String)segmentPriorityStr)) {
            boolean useSameLevel = true;
            return new RangeMap<Integer, Map<Integer, Integer>>(3){
                {
                    HashMap<Integer, Integer> part1 = new HashMap<Integer, Integer>(3);
                    part1.put(1, 1);
                    part1.put(2, 1);
                    part1.put(3, 1);
                    HashMap<Integer, Integer> part2 = new HashMap<Integer, Integer>(3);
                    part2.put(2, 1);
                    part2.put(3, 1);
                    part2.put(1, 1);
                    HashMap<Integer, Integer> part3 = new HashMap<Integer, Integer>(3);
                    part3.put(3, 1);
                    part3.put(2, 1);
                    part3.put(1, 1);
                    this.put(new RangeInt(0, 2), part1);
                    this.put(new RangeInt(3, 4), part2);
                    this.put(new RangeInt(5, Integer.MAX_VALUE), part3);
                    JSON.toJSONString(part2);
                }
            };
        }
        List params = JSON.parseArray((String)segmentPriorityStr, JSONObject.class);
        RangeMap<Integer, Map<Integer, Integer>> rangeMap = new RangeMap<Integer, Map<Integer, Integer>>(3);
        for (JSONObject punchRange : params) {
            if (!punchRange.containsKey((Object)"cardTimeRange")) continue;
            String[] strArr = punchRange.getString("cardTimeRange").split("_");
            List punchcardMounts = JSON.parseArray((String)punchRange.getString("data"), String.class);
            HashMap<Integer, Integer> onePart = new HashMap<Integer, Integer>(punchcardMounts.size());
            rangeMap.put(new RangeInt(Integer.valueOf(strArr[0]), Integer.valueOf(strArr[1])), onePart);
            for (String proprity : punchcardMounts) {
                strArr = proprity.split("_");
                onePart.put(Integer.valueOf(strArr[0]), Integer.valueOf(strArr[1]));
            }
        }
        return rangeMap;
    }

    public static Map<String, List<AtsShiftInfo>> getLatestAtsShift(Context ctx, Collection<String> personNums, Date beginDate, Date endDate, String hrOrgUnitId) {
        EntityViewInfo evi = MatchScheduleUtile.getlatestShiftView(ctx, personNums, beginDate, endDate, "proposer.number", hrOrgUnitId);
        ScheduleShiftCollection colls = null;
        try {
            colls = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashMap<String, List<AtsShiftInfo>> returnData = new HashMap<String, List<AtsShiftInfo>>(personNums.size());
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)colls)) {
            final HashMap<String, AtsShiftInfo> shifts = new HashMap<String, AtsShiftInfo>();
            HashMap<String, Set<String>> personShiftMap = new HashMap<String, Set<String>>(personNums.size());
            for (int i = 0; i < colls.size(); ++i) {
                AtsShiftInfo shift = colls.get(i).getDefaultShift();
                if (shift == null) {
                    shift = colls.get(i).getMatchShift();
                }
                if (shift.getState() != BaseItemStateEnum.ENABLE) continue;
                MatchScheduleUtile.updateShiftIdMap(shift, shifts);
                String personNum = colls.get(i).getProposer().getNumber();
                MatchScheduleUtile.updateShiftToTarget(shift, personNum, personShiftMap);
            }
            WorkShiftUtile.updateShiftItems(ctx, colls, shifts.keySet());
            for (String person : personNums) {
                returnData.put(person, AtsCollectionUtile.map((Collection)personShiftMap.get(person), new AtsMapFn<String, AtsShiftInfo>(){

                    @Override
                    public AtsShiftInfo map(String t) {
                        return (AtsShiftInfo)shifts.get(t);
                    }
                }));
            }
        }
        return returnData;
    }

    public static Map<String, List<AtsShiftInfo>> getLatestGroupAtsShift(Context ctx, Collection<String> personNums, Date beginDate, Date endDate, String hrOrgUnitId) {
        StringBuffer sql = new StringBuffer().append(" select distinct person.fnumber,attGroup.fgroupId").append(" from T_HR_ATS_AttenceGroupItem attGroup join t_bd_person person on attGroup.fproposerId=person.fid").append(" where person.fnumber in ").append(AtsCollectionUtile.joinForSqlWithBrackets(personNums)).append(" and attGroup.fstartTime >= {ts '").append(AtsCommonUtile.getDayStartStr(endDate)).append("'}").append(" and attGroup.fendTime <= {ts '").append(AtsCommonUtile.getDayStartStr(endDate)).append("'}");
        HashMap<String, List<AtsShiftInfo>> returnData = new HashMap<String, List<AtsShiftInfo>>(personNums.size());
        TwoFieldProcessor twoFieldProcessor = new TwoFieldProcessor(sql.toString(), ctx);
        ((TwoFieldProcessor)twoFieldProcessor.setCollectAllData(true)).process();
        Map personNum2Group = twoFieldProcessor.getAllPageDataForTwoField();
        if (AtsCollectionUtile.isEmpty(personNum2Group)) {
            return returnData;
        }
        EntityViewInfo evi = MatchScheduleUtile.getlatestShiftView(ctx, personNum2Group.values(), beginDate, endDate, "attenceGroup.id", hrOrgUnitId);
        AttendanceGroupShiftCollection colls = null;
        try {
            colls = AttendanceGroupShiftFactory.getLocalInstance(ctx).getAttendanceGroupShiftCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)colls)) {
            final HashMap<String, AtsShiftInfo> shifts = new HashMap<String, AtsShiftInfo>();
            HashMap<String, Set<String>> groupShiftMap = new HashMap<String, Set<String>>(personNums.size());
            for (int i = 0; i < colls.size(); ++i) {
                MatchScheduleUtile.updateShiftIdMap(colls.get(i).getDefaultShift(), shifts);
                String groupId = colls.get(i).getAttenceGroup().getId().toString();
                MatchScheduleUtile.updateShiftToTarget(colls.get(i).getDefaultShift(), groupId, groupShiftMap);
            }
            Map person2Shift = AtsCollectionUtile.assembleMap(personNum2Group, groupShiftMap);
            for (String person : personNums) {
                returnData.put(person, AtsCollectionUtile.map((Collection)person2Shift.get(person), new AtsMapFn<String, AtsShiftInfo>(){

                    @Override
                    public AtsShiftInfo map(String t) {
                        return (AtsShiftInfo)shifts.get(t);
                    }
                }));
            }
        }
        return returnData;
    }

    public static Map<String, List<AtsShiftInfo>> getLatestAdminOrgAtsShift(Context ctx, Collection<String> personNums, Date beginDate, Date endDate, String hrOrgUnitId) {
        StringBuffer sql = new StringBuffer().append(" select distinct person.fnumber,att.fadminOrgUnitID").append(" from T_HR_ATS_AttendanceFileHIS att join t_bd_person person on att.fproposerId=person.fid").append(" where person.fnumber in ").append(AtsCollectionUtile.joinForSqlWithBrackets(personNums)).append(" and att.fleffdt >= {ts '").append(AtsCommonUtile.getDayStartStr(endDate)).append("'}").append(" and att.feffdt <= {ts '").append(AtsCommonUtile.getDayStartStr(endDate)).append("'}");
        TwoFieldProcessor twoFieldProcessor = new TwoFieldProcessor(sql.toString(), ctx);
        ((TwoFieldProcessor)twoFieldProcessor.setCollectAllData(true)).process();
        Map personNum2Org = ((TwoFieldProcessor)twoFieldProcessor.process()).getAllPageDataForTwoField();
        EntityViewInfo evi = MatchScheduleUtile.getlatestShiftView(ctx, personNum2Org.values(), beginDate, endDate, "adminOrgUnit.id", hrOrgUnitId);
        AtsShiftAdminOrgCollection colls = null;
        try {
            colls = AtsShiftAdminOrgFactory.getLocalInstance(ctx).getAtsShiftAdminOrgCollection(evi);
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)("" + (Object)((Object)e)));
        }
        HashMap<String, List<AtsShiftInfo>> returnData = new HashMap<String, List<AtsShiftInfo>>(personNums.size());
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)colls)) {
            final HashMap<String, AtsShiftInfo> shifts = new HashMap<String, AtsShiftInfo>();
            HashMap<String, Set<String>> orgShiftMap = new HashMap<String, Set<String>>(personNums.size());
            for (int i = 0; i < colls.size(); ++i) {
                MatchScheduleUtile.updateShiftIdMap(colls.get(i).getAtsShift(), shifts);
                String orgId = colls.get(i).getAdminOrgUnit().getId().toString();
                MatchScheduleUtile.updateShiftToTarget(colls.get(i).getAtsShift(), orgId, orgShiftMap);
            }
            Map person2Shift = AtsCollectionUtile.assembleMap(personNum2Org, orgShiftMap);
            for (String person : personNums) {
                returnData.put(person, AtsCollectionUtile.map((Collection)person2Shift.get(person), new AtsMapFn<String, AtsShiftInfo>(){

                    @Override
                    public AtsShiftInfo map(String t) {
                        return (AtsShiftInfo)shifts.get(t);
                    }
                }));
            }
        }
        return returnData;
    }

    public static EntityViewInfo getlatestShiftView(Context ctx, Collection<String> filterIds, Date beginDate, Date endDate, String filterIdName, String hrOrgUnitId) {
        String shiftField = filterIdName.contains("adminOrgUnit") ? "atsShift" : "defaultShift";
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{filterIdName, shiftField + ".*", shiftField + ".items.*", shiftField + ".cardRule.segAftFirtakeCardType", shiftField + ".cardRule.segAftFirEndNum"});
        if (!AtsCollectionUtile.isEmpty(filterIds)) {
            evi = AtsViewUtile.getViewByFilter(filterIdName, new HashSet<String>(filterIds), CompareType.INCLUDE, evi);
        }
        AtsViewUtile.getViewByFilter("attendDate", endDate, CompareType.LESS_EQUALS, evi);
        AtsViewUtile.getViewByFilter("attendDate", beginDate, CompareType.GREATER_EQUALS, evi);
        AtsViewUtile.getViewByFilter("hrOrgUnit.id", hrOrgUnitId, CompareType.EQUALS, evi);
        FilterInfo shiftNotNullF = new FilterInfo();
        shiftNotNullF.getFilterItems().add(new FilterItemInfo(shiftField + ".state", (Object)1, CompareType.EQUALS));
        shiftNotNullF.getFilterItems().add(new FilterItemInfo(shiftField, null, CompareType.NOTEQUALS));
        if ("proposer.number".equals(filterIdName)) {
            AtsViewUtile.getViewBySelector(new String[]{"matchShift", "matchShift.*", "matchShift.items.*", "matchShift.cardRule.segAftFirtakeCardType", "matchShift.cardRule.segAftFirEndNum"}, evi);
            shiftNotNullF.getFilterItems().add(new FilterItemInfo("matchShift.state", (Object)1, CompareType.EQUALS));
            shiftNotNullF.getFilterItems().add(new FilterItemInfo("matchShift", null, CompareType.NOTEQUALS));
            shiftNotNullF.setMaskString(" ( #0 and #1 ) or ( #2 and #3 ) ");
        }
        FilterInfo filterInfo = new FilterInfo();
        try {
            filterInfo.mergeFilter(evi.getFilter(), "AND");
            filterInfo.mergeFilter(shiftNotNullF, "AND");
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)"filter conbine error", (Throwable)e);
        }
        evi.setFilter(filterInfo);
        return evi;
    }

    public static Map<String, List<AtsShiftInfo>> getOrgAvaiableShift(Context ctx, Collection<String> personNums, Date beginDate, Date endDate, AtsShiftElasticType elastic) {
        StringBuffer sql = new StringBuffer().append(" select person.fnumber personNum,aShift.fbaseinfoid fid,shift.fnumber, case when shift.fhrOrgUnitid=att.fhrOrgUnitid then 1 else 2 end priority").append(" from T_HR_ATS_AttendanceFileHIS att").append(" join t_bd_person person on att.fproposerId=person.fid").append(" join T_ATS_AtsShiftAvaliable aShift on aShift.fhrorguseid=att.fHrOrgUnitID").append(" join T_HR_ATS_Shift shift on shift.fid=aShift.fbaseinfoid").append(" left outer join T_ATS_BlindAdmin bdAdmin on aShift.fid=bdAdmin.FAvaliableId").append(" left outer join t_org_admin bindAdminInfo on bindAdminInfo.fid=bdAdmin.fadminOrgUnitid").append(" left outer join t_org_admin fileAdmin on fileAdmin.fid=att.fAdminOrgUnitID").append(" where shift.fstate = 1").append(" and ( CHARINDEX(concat(bindAdminInfo.flongnumber,'!'),fileAdmin.flongnumber )=1").append("  or bindAdminInfo.flongnumber = fileAdmin.flongnumber or bdAdmin.fid is null)").append(" and att.fleffdt >= {ts '").append(AtsCommonUtile.getDayStartStr(endDate)).append("'}").append(" and att.feffdt <= {ts '").append(AtsCommonUtile.getDayStartStr(endDate)).append("'}").append(" and person.fnumber in ").append(AtsCollectionUtile.joinForSqlWithBrackets(personNums));
        if (elastic != null) {
            sql.append(" and shift.felasticType=").append(elastic.getValue()).append(" and shift.fisElastic=1");
        }
        sql.append(" order by personNum,priority,shift.fnumber");
        TwoFieldProcessor processor = new TwoFieldProcessor(sql.toString(), ctx);
        ((TwoFieldProcessor)processor.setMutiModel(true).setCollectAllData(true)).process();
        Map personShift = processor.getAllPageDataForTwoField();
        HashSet<String> shiftIds = new HashSet<String>();
        for (Set shifts : personShift.values()) {
            shiftIds.addAll(shifts);
        }
        List<AtsShiftInfo> colls = WorkShiftUtile.getAtsShift(ctx, shiftIds);
        HashMap<String, List<AtsShiftInfo>> returnData = new HashMap<String, List<AtsShiftInfo>>(personNums.size());
        if (!AtsCollectionUtile.isEmpty(colls)) {
            final HashMap<String, AtsShiftInfo> shifts = new HashMap<String, AtsShiftInfo>();
            for (int i = 0; i < colls.size(); ++i) {
                MatchScheduleUtile.updateShiftIdMap(colls.get(i), shifts);
            }
            for (String person : personNums) {
                returnData.put(person, AtsCollectionUtile.map((Collection)personShift.get(person), new AtsMapFn<String, AtsShiftInfo>(){

                    @Override
                    public AtsShiftInfo map(String t) {
                        return (AtsShiftInfo)shifts.get(t);
                    }
                }));
            }
        }
        return returnData;
    }

    public static void saveMatchNewShift(Context ctx, ScheduleShiftCollection newColls) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)newColls)) {
            return;
        }
        HashMap<String, ScheduleShiftCollection> scheduleMap = new HashMap<String, ScheduleShiftCollection>();
        for (int i = 0; i < newColls.size(); ++i) {
            ScheduleShiftInfo schedule = newColls.get(i);
            String hrOrgStr = schedule.getHrOrgUnit().getId().toString();
            ScheduleShiftCollection colls = (ScheduleShiftCollection)((Object)scheduleMap.get(hrOrgStr));
            if (colls == null) {
                colls = new ScheduleShiftCollection();
                scheduleMap.put(hrOrgStr, colls);
            }
            colls.add(schedule);
        }
        for (ScheduleShiftCollection schedules : scheduleMap.values()) {
            if (AtsCollectionUtile.isEmpty((IObjectCollection)schedules)) continue;
            BaseSaveShift baseSaveShift = new BaseSaveShift(ctx);
            baseSaveShift.setHrOrgUnitId(schedules.get(0).getHrOrgUnit().toString());
            baseSaveShift.setMatchModel(true);
            baseSaveShift.save(schedules);
        }
    }

    public static void saveMatchShift(Context ctx, List<Object[]> updateMatchShift) {
        if (AtsCollectionUtile.isEmpty(updateMatchShift)) {
            return;
        }
        String saveSql = "update t_hr_ats_scheduleshift set fmatchShift = ?,fmatchDaytype = ?,fmatchPlan = ? ,fmatchRule = ? where fid = ? ";
        try {
            DbUtil.executeBatch((Context)ctx, (String)saveSql, updateMatchShift);
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)("" + (Object)((Object)e)));
        }
    }

    public static void updateShiftIdMap(AtsShiftInfo curShift, Map<String, AtsShiftInfo> shifts) {
        AtsCollectionUtile.updateTargetToValMap(curShift.getId().toString(), curShift, shifts);
    }

    public static void updateShiftToTarget(AtsShiftInfo curShift, String target, Map<String, Set<String>> targetToShiftIds) {
        AtsCollectionUtile.updateTargetToValSet(target, curShift.getId().toString(), targetToShiftIds);
    }

    public static ArrayList<CardSetDTO> getCardSet(String intervalCardSet) {
        List params = JSON.parseArray((String)intervalCardSet, JSONObject.class);
        if (AtsCollectionUtile.isEmpty(params)) {
            return new ArrayList<CardSetDTO>();
        }
        ArrayList<CardSetDTO> cardSetList = new ArrayList<CardSetDTO>();
        for (JSONObject cardSet : params) {
            CardSetDTO cardSetDTO = new CardSetDTO();
            if (cardSet.containsKey((Object)"enable") && "1".equalsIgnoreCase(cardSet.getString("enable"))) {
                Integer enable = cardSet.getInteger("enable");
                cardSetDTO.setEnable(enable);
                List cardSetData = JSON.parseArray((String)cardSet.getString("data"), String.class);
                if (cardSetData.size() > 3) {
                    return new ArrayList<CardSetDTO>();
                }
                cardSetDTO.setCardNumber(Integer.parseInt((String)cardSetData.get(0)));
                cardSetDTO.setBiasTime((long)Integer.parseInt((String)cardSetData.get(1)) * 60000L);
                String shiftType = (String)cardSetData.get(2);
                if (CardShiftType.CardAfterEndTime.getValue().equalsIgnoreCase(shiftType)) {
                    cardSetDTO.setShiftType(CardShiftType.CardAfterEndTime);
                } else if (CardShiftType.CardBeforeStartTime.getValue().equalsIgnoreCase(shiftType)) {
                    cardSetDTO.setShiftType(CardShiftType.CardBeforeStartTime);
                } else {
                    cardSetDTO.setShiftType(CardShiftType.ColseToShiftTime);
                }
                cardSetList.add(cardSetDTO);
                continue;
            }
            return new ArrayList<CardSetDTO>();
        }
        return cardSetList;
    }
}

