/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.matchSchedule;

import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsPunchCardResEnum;
import com.kingdee.eas.hr.ats.AtsShiftElasticType;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.CardRuleTakeCardTypeEnum;
import com.kingdee.eas.hr.ats.CardShiftType;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.EMatchRule;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.WorkoffShiftType;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.WorkShiftUtile;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.BaseMatchRuleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.dto.CardSetDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShiftMatchRuleAnalysor
extends BaseMatchRuleAnalysor {
    protected long allowedMinusMount;
    protected long validPunchcardInterVal;
    protected DayTypeEnum dayTypeWhenWork;
    protected DayTypeEnum dayTypeWhenRest;
    protected DayTypeEnum dayTypeWhenHoliday;
    protected boolean noCardRelateAtsShift;
    protected boolean restRelateAtsShift;
    protected boolean holidayRelateAtsShift;
    protected boolean enableScheduleIntersect;
    protected boolean enableShiftSegmentPriority = true;
    protected RangeMap<Integer, Map<Integer, Integer>> shiftSegmentPriority;
    protected WorkoffShiftType shiftTypeAfterWork;
    protected ArrayList<CardSetDTO> cardSetList;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.ShiftMatchRuleAnalysor");

    public ShiftMatchRuleAnalysor() {
    }

    public ShiftMatchRuleAnalysor(BaseMatchRuleAnalysor nextAnalysor) {
        super(nextAnalysor);
    }

    @Override
    public void doAnalyze() {
        super.doAnalyze();
        this.matchShift();
    }

    @Override
    protected void beforeAnalyze() {
        ArrayList<Date> allCard = new ArrayList<Date>();
        this.matchShiftEnv.setPunchcards(this.getValidPunchCards());
        logger.info((Object)(this.matchShiftEnv.getPunchcards() != null ? this.matchShiftEnv.getPunchcards().toString() : "no punchcard "));
        if (!AtsCollectionUtile.isEmpty(this.matchShiftEnv.getPunchcards())) {
            allCard.addAll(this.matchShiftEnv.getPunchcards());
        }
        if (!AtsCollectionUtile.isEmpty(this.matchShiftEnv.getPunchcardSimulate())) {
            allCard.addAll(this.matchShiftEnv.getPunchcardSimulate());
        }
        if (AtsCollectionUtile.isEmpty(allCard)) {
            AtsLog.getWSLog().info((Object)(this.matchShiftEnv.getShiftTarget().getNumber() + " " + AtsCommonUtile.formateTime((Date)this.matchShiftEnv.getAttendRange().getLowBound()) + MLUtile.getRes(AtsPunchCardResEnum.NoCardNoBill, this.ctx)));
            return;
        }
        Collections.sort(allCard);
        this.validatePunchcard(allCard);
        if (AtsCollectionUtile.isEmpty(allCard)) {
            AtsLog.getWSLog().info((Object)(this.matchShiftEnv.getShiftTarget().getNumber() + " " + AtsCommonUtile.formateTime((Date)this.matchShiftEnv.getAttendRange().getLowBound()) + "no fit card"));
            return;
        }
        Date lastPunchcard = (Date)allCard.get(allCard.size() - 1);
        RangeDate punchcardRange = new RangeDate(allCard.get(0), lastPunchcard.getTime() - ((Date)allCard.get(0)).getTime() > this.validPunchcardInterVal ? lastPunchcard : null);
        logger.info((Object)punchcardRange.toString());
        this.matchShiftEnv.setPunchcardRange(punchcardRange);
        this.matchShiftEnv.setAllPunchCards(allCard);
    }

    private List<Date> getValidPunchCards() {
        if (AtsCollectionUtile.isEmpty(this.matchShiftEnv.getCurAtsShifts())) {
            return null;
        }
        if (AtsCollectionUtile.isEmpty(this.matchShiftEnv.getPunchcards())) {
            return null;
        }
        HashSet<Date> result = new HashSet<Date>();
        block0: for (AtsShiftInfo curShifts : this.matchShiftEnv.getCurAtsShifts()) {
            Date preTime = WorkShiftUtile.buildShiftPreTime(curShifts, (Date)this.matchShiftEnv.getAttendRange().getLowBound());
            Date nextTime = WorkShiftUtile.buildShiftNextTime(curShifts, (Date)this.matchShiftEnv.getAttendRange().getLowBound());
            boolean mark = false;
            for (Date punchCard : this.matchShiftEnv.getPunchcards()) {
                if (Math.abs(punchCard.getTime() - preTime.getTime()) <= this.allowedMinusMount || !preTime.after(punchCard) && !nextTime.before(punchCard) || punchCard.after(nextTime) && result.size() > 0) {
                    result.add(punchCard);
                }
                if (mark) continue block0;
                if (punchCard.getTime() <= nextTime.getTime()) continue;
                mark = true;
            }
        }
        return new ArrayList<Date>(result);
    }

    protected void validatePunchcard(List<Date> punchcard) {
        Date startDate = this.matchShiftEnv.getPreScheduleWorkOffDate();
        CardRuleInfo preScheduleCardRule = this.matchShiftEnv.getPreScheduleCardRule();
        if (punchcard == null || startDate == null || preScheduleCardRule == null || this.enableScheduleIntersect) {
            return;
        }
        int endValue = 0;
        if (null != preScheduleCardRule.getSegAftFirEndNum()) {
            endValue = preScheduleCardRule.getSegAftFirEndNum().intValue();
        } else if (null != preScheduleCardRule.getEndNum()) {
            endValue = preScheduleCardRule.getEndNum().intValue();
        }
        startDate = AtsCommonUtile.dateAdd(startDate, 10, endValue);
        boolean isTakeFirstCard = preScheduleCardRule.getSegAftFirtakeCardType() == CardRuleTakeCardTypeEnum.firstCard;
        for (int i = 0; i < punchcard.size(); ++i) {
            if (punchcard.get(i).after(startDate)) {
                return;
            }
            if (isTakeFirstCard && !punchcard.get(i).before(this.matchShiftEnv.getPreScheduleWorkOffDate())) {
                punchcard.remove(i);
                return;
            }
            punchcard.remove(i);
            --i;
        }
    }

    protected void matchShift() {
        List<AtsShiftInfo> curShifts = this.matchShiftEnv.getCurAtsShifts();
        RangeDate punchcardRange = this.matchShiftEnv.getPunchcardRange();
        EMatchRule matchRule = this.matchShiftEnv.getSchedule().getMatchRule().getIntelType();
        if (punchcardRange != null && !this.matchShiftEnv.isAllShiftValid() && !AtsCollectionUtile.isEmpty(curShifts) && matchRule != EMatchRule.allElastic) {
            for (int i = 0; i < curShifts.size(); ++i) {
                Date preTime = WorkShiftUtile.buildShiftPreTime(curShifts.get(i), (Date)this.matchShiftEnv.getAttendRange().getLowBound());
                if (Math.abs(((Date)punchcardRange.getLowBound()).getTime() - preTime.getTime()) <= this.allowedMinusMount) continue;
                curShifts.remove(i);
                --i;
            }
        }
        List<ShiftParams> allShifts = this.buildParamShifts(curShifts);
        logger.info((Object)("allshifts : " + allShifts.toString()));
        if (this.matchShiftEnv.getSchedule().getMatchRule().getIntelType() != EMatchRule.allElastic) {
            int punchcardCound = this.matchShiftEnv.getPunchcards() == null ? 0 : this.matchShiftEnv.getPunchcards().size();
            Collections.sort(allShifts, this.getComparator(punchcardCound, this.shiftTypeAfterWork));
        }
        if (!AtsCollectionUtile.isEmpty(this.matchShiftEnv.getAllPunchCards()) && this.matchShiftEnv.getSchedule().getMatchRule().getIntelType() != EMatchRule.allElastic && this.matchShiftEnv.getSchedule().getMatchRule().getIntelType() != EMatchRule.elastic) {
            allShifts = this.cardSetRuleFilter(allShifts);
        }
        Collections.sort(allShifts, this.getComparator());
        logger.info((Object)("prepare build allshifts : " + allShifts.toString()));
        this.buildAanlyzeResult(allShifts);
    }

    protected List<ShiftParams> cardSetRuleFilter(List<ShiftParams> allShifts) {
        int allPunchCardSize;
        List<ShiftParams> samePriorityParams = this.getSamePriorityParams(allShifts);
        ArrayList<ShiftParams> lastShiftParams = new ArrayList<ShiftParams>(samePriorityParams.size());
        lastShiftParams.addAll(samePriorityParams);
        int enable = 0;
        enable = AtsCollectionUtile.isEmpty(this.cardSetList) ? 0 : this.cardSetList.get(0).getEnable();
        int n = allPunchCardSize = this.matchShiftEnv.getAllPunchCards() == null ? 0 : this.matchShiftEnv.getAllPunchCards().size();
        if (!AtsCollectionUtile.isEmpty(samePriorityParams) && enable == 1) {
            for (int i = 0; i < this.cardSetList.size(); ++i) {
                ShiftParams shiftParam;
                CardSetDTO cardSetDTO = this.cardSetList.get(i);
                long biasTime = cardSetDTO.getBiasTime();
                int cardNumber = cardSetDTO.getCardNumber();
                CardShiftType shiftType = cardSetDTO.getShiftType();
                if (CardShiftType.CardAfterEndTime.equals((Object)shiftType) && cardNumber % 2 == 0) {
                    for (int j = 0; j < samePriorityParams.size(); ++j) {
                        shiftParam = samePriorityParams.get(j);
                        if (cardNumber > Math.min(allPunchCardSize, shiftParam.getSegment() * 2) || AtsCollectionUtile.isEmpty(shiftParam.getShiftCardDiff())) {
                            samePriorityParams.remove(j);
                            --j;
                            continue;
                        }
                        long diffTime = shiftParam.getShiftCardDiff().get(cardNumber - 1);
                        if (diffTime < 0L && Math.abs(diffTime) <= biasTime) continue;
                        samePriorityParams.remove(j);
                        --j;
                    }
                } else if (CardShiftType.CardBeforeStartTime.equals((Object)shiftType) && cardNumber % 2 == 1) {
                    for (int j = 0; j < samePriorityParams.size(); ++j) {
                        shiftParam = samePriorityParams.get(j);
                        if (cardNumber > Math.min(allPunchCardSize, shiftParam.getSegment() * 2) || AtsCollectionUtile.isEmpty(shiftParam.getShiftCardDiff())) {
                            samePriorityParams.remove(j);
                            --j;
                            continue;
                        }
                        long diffTime = shiftParam.getShiftCardDiff().get(cardNumber - 1);
                        if (diffTime > 0L && Math.abs(diffTime) <= biasTime) continue;
                        samePriorityParams.remove(j);
                        --j;
                    }
                } else if (CardShiftType.ColseToShiftTime.equals((Object)shiftType)) {
                    for (int j = 0; j < samePriorityParams.size(); ++j) {
                        shiftParam = samePriorityParams.get(j);
                        if (cardNumber > Math.min(allPunchCardSize, shiftParam.getSegment() * 2) || AtsCollectionUtile.isEmpty(shiftParam.getShiftCardDiff())) {
                            samePriorityParams.remove(j);
                            --j;
                            continue;
                        }
                        long diffTime = shiftParam.getShiftCardDiff().get(cardNumber - 1);
                        if (Math.abs(diffTime) <= biasTime) continue;
                        samePriorityParams.remove(j);
                        --j;
                    }
                    if (samePriorityParams.size() > 0) {
                        Collections.sort(samePriorityParams, this.getComparator(cardNumber));
                        logger.info((Object)("cardNumber : " + cardNumber + " Min(shift segment , allpunchcardSize)" + Math.min(samePriorityParams.get(0).getSegment(), allPunchCardSize)));
                        Long firstCardDiff = samePriorityParams.get(0).getShiftCardDiff().get(cardNumber - 1);
                        Iterator<ShiftParams> iterator = samePriorityParams.iterator();
                        while (iterator.hasNext()) {
                            ShiftParams next = iterator.next();
                            Long cardDiff = next.getShiftCardDiff().get(cardNumber - 1);
                            if (Math.abs(cardDiff) <= Math.abs(firstCardDiff)) continue;
                            iterator.remove();
                        }
                    }
                }
                if (samePriorityParams.size() == 1 || samePriorityParams.size() == 0) break;
                lastShiftParams.clear();
                lastShiftParams.addAll(samePriorityParams);
            }
        }
        if (samePriorityParams.size() >= 1) {
            lastShiftParams.clear();
            lastShiftParams.addAll(samePriorityParams);
        }
        return lastShiftParams;
    }

    protected Comparator<ShiftParams> getComparator() {
        return new Comparator<ShiftParams>(){

            @Override
            public int compare(ShiftParams o1, ShiftParams o2) {
                if (o1.getPreTimeDiff() == o2.getPreTimeDiff()) {
                    return o1.getShift().getNumber().compareTo(o2.getShift().getNumber());
                }
                boolean isSameSign = o1.getPreTimeDiff() * o2.getPreTimeDiff() > 0L;
                return (int)(isSameSign ? Math.abs(o1.getPreTimeDiff()) - Math.abs(o2.getPreTimeDiff()) : o2.getPreTimeDiff() - o1.getPreTimeDiff());
            }
        };
    }

    protected Comparator<ShiftParams> getComparator(final int cardNumber) {
        return new Comparator<ShiftParams>(){

            @Override
            public int compare(ShiftParams o1, ShiftParams o2) {
                Long o1CardDiff = o1.getShiftCardDiff().get(cardNumber - 1);
                Long o2CardDiff = o2.getShiftCardDiff().get(cardNumber - 1);
                return (int)(Math.abs(o1CardDiff) - Math.abs(o2CardDiff));
            }
        };
    }

    protected List<ShiftParams> getSamePriorityParams(List<ShiftParams> allShifts) {
        ArrayList<ShiftParams> shiftParams = new ArrayList<ShiftParams>();
        if (AtsCollectionUtile.isEmpty(allShifts)) {
            return shiftParams;
        }
        if (allShifts.size() > 0) {
            ShiftParams firstshiftParam = allShifts.get(0);
            int allPunchCardSize = this.matchShiftEnv.getAllPunchCards() == null ? 0 : this.matchShiftEnv.getAllPunchCards().size();
            int firstSegPriority = this.shiftSegmentPriority.get(allPunchCardSize).get(firstshiftParam.getShift().getItems().size());
            Long firstLastTimeDiff = 0L;
            if (!AtsCollectionUtile.isEmpty(firstshiftParam.getShiftCardDiff())) {
                firstLastTimeDiff = firstshiftParam.getShiftCardDiff().get(Math.min(allPunchCardSize, firstshiftParam.getSegment() * 2) - 1);
            }
            long firstMinusMouns = firstshiftParam.getMinusMouns();
            for (ShiftParams shiftParam : allShifts) {
                int segPriority = this.shiftSegmentPriority.get(allPunchCardSize).get(shiftParam.getShift().getItems().size());
                long minusMouns = shiftParam.getMinusMouns();
                Long lastTimeDiff = 0L;
                if (!AtsCollectionUtile.isEmpty(shiftParam.getShiftCardDiff())) {
                    lastTimeDiff = shiftParam.getShiftCardDiff().get(Math.min(allPunchCardSize, shiftParam.getSegment() * 2) - 1);
                }
                if (firstSegPriority == segPriority && "2".equalsIgnoreCase(this.shiftTypeAfterWork.getValue()) && lastTimeDiff * firstLastTimeDiff > 0L && minusMouns == firstMinusMouns) {
                    shiftParams.add(shiftParam);
                }
                if (firstSegPriority != segPriority || minusMouns != firstMinusMouns) continue;
                shiftParams.add(shiftParam);
            }
        }
        return shiftParams;
    }

    protected Comparator<ShiftParams> getComparator(final int punchcardCound, final WorkoffShiftType shiftTypeAfterWork) {
        if (this.matchShiftEnv.getPunchcardRange() == null) {
            return new Comparator<ShiftParams>(){

                @Override
                public int compare(ShiftParams o1, ShiftParams o2) {
                    return o1.getShift().getNumber().compareTo(o2.getShift().getNumber());
                }
            };
        }
        return new Comparator<ShiftParams>(){

            @Override
            public int compare(ShiftParams o1, ShiftParams o2) {
                int segPriority2;
                int segPriority1 = ShiftMatchRuleAnalysor.this.shiftSegmentPriority.get(punchcardCound).get(o1.getShift().getItems().size());
                if (segPriority1 == (segPriority2 = ShiftMatchRuleAnalysor.this.shiftSegmentPriority.get(punchcardCound).get(o2.getShift().getItems().size()).intValue())) {
                    if ("2".equalsIgnoreCase(shiftTypeAfterWork.getValue()) && !AtsCollectionUtile.isEmpty(o1.getShiftCardDiff()) && !AtsCollectionUtile.isEmpty(o2.getShiftCardDiff())) {
                        int minO1 = Math.min(o1.getAllPunchCards().size() - 1, o1.getSegment() * 2 - 1);
                        int minO2 = Math.min(o2.getAllPunchCards().size() - 1, o2.getSegment() * 2 - 1);
                        if (o1.getShiftCardDiff().get(minO1) < 0L && o2.getShiftCardDiff().get(minO2) < 0L) {
                            return (int)(o2.getMinusMouns() - o1.getMinusMouns());
                        }
                        if (o1.getShiftCardDiff().get(minO1) < 0L) {
                            return (int)Math.abs(o1.getShiftCardDiff().get(minO1));
                        }
                        return o2.getShiftCardDiff().get(minO2).intValue();
                    }
                    return (int)(o2.getMinusMouns() - o1.getMinusMouns());
                }
                return segPriority1 - segPriority2;
            }
        };
    }

    private List<ShiftParams> buildParamShifts(List<AtsShiftInfo> curShifts) {
        if (AtsCollectionUtile.isEmpty(curShifts)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ShiftParams> allShifts = new ArrayList<ShiftParams>(curShifts.size());
        Date attendDate = (Date)this.matchShiftEnv.getAttendRange().getLowBound();
        RangeDate punchcardRange = this.matchShiftEnv.getPunchcardRange();
        List<Date> allPunchCards = this.matchShiftEnv.getAllPunchCards();
        for (int i = 0; i < curShifts.size(); ++i) {
            ShiftParams shiftParams;
            ShiftParams shiftParams2 = shiftParams = punchcardRange == null ? new ShiftParams(curShifts.get(i), attendDate, allPunchCards) : new ShiftParams(curShifts.get(i), punchcardRange, allPunchCards);
            if (shiftParams.isValid()) {
                allShifts.add(shiftParams);
                continue;
            }
            curShifts.remove(i);
            --i;
        }
        return allShifts;
    }

    protected void buildAanlyzeResult(List<ShiftParams> shiftParams) {
        ScheduleShiftInfo schedule = this.matchShiftEnv.getSchedule();
        PersonInfo personInfo = new PersonInfo();
        personInfo.setNumber(this.matchShiftEnv.getShiftTarget().getNumber());
        schedule.setProposer(personInfo);
        if (AtsCollectionUtile.isEmpty(this.matchShiftEnv.getPunchcards())) {
            this.noCardProcess();
            if (schedule.getMatchDaytype() == DayTypeEnum.workDay && AtsCollectionUtile.isEmpty(this.matchShiftEnv.getPunchcardSimulate()) && this.matchShiftEnv.getDayType() == null && !this.matchShiftEnv.isAllShiftValid() || this.matchShiftEnv.getPunchcardRange() == null) {
                return;
            }
        } else {
            this.hasCardProcess();
        }
        if (this.matchShiftEnv.getDayType() != null) {
            schedule.setMatchDaytype(this.matchShiftEnv.getDayType());
        }
        if (this.matchShiftEnv.isRelateAtsShift() && !AtsCollectionUtile.isEmpty(shiftParams)) {
            schedule.setMatchShift(shiftParams.get(0).getShift());
            this.matchShiftEnv.setScheduleWorkOffDate(shiftParams.get(0).getOrginalNextTime());
        }
        if (schedule.getMatchDaytype() == DayTypeEnum.workDay && schedule.getMatchShift() == null) {
            this.matchShiftEnv.setValid(false);
        }
    }

    protected void noCardProcess() {
        ScheduleShiftInfo schedule = this.matchShiftEnv.getSchedule();
        if (schedule.getMatchDaytype() == DayTypeEnum.workDay && AtsCollectionUtile.isEmpty(this.matchShiftEnv.getPunchcardSimulate()) && this.matchShiftEnv.getDayType() == null && !this.matchShiftEnv.isAllShiftValid()) {
            if (!this.noCardRelateAtsShift && this.dayTypeWhenWork != DayTypeEnum.workDay) {
                this.matchShiftEnv.setRelateAtsShift(false);
                schedule.setMatchDaytype(DayTypeEnum.restDay);
            } else {
                schedule.setMatchDaytype(DayTypeEnum.workDay);
                Date curDate = (Date)this.matchShiftEnv.getAttendRange().getLowBound();
                RangeMap<Date, ScheduleShiftInfo> RangeShiftMap = this.matchShiftEnv.getScheduleMap().get(this.matchShiftEnv.getShiftTarget().getNumber());
                ScheduleShiftInfo scheduleShiftInfo = RangeShiftMap.get(curDate);
                AtsShiftInfo defaultShift = scheduleShiftInfo.getDefaultShift();
                if (RangeShiftMap == null || scheduleShiftInfo == null || defaultShift == null) {
                    this.matchShiftEnv.setValid(false);
                    AtsLog.getWSLog().info((Object)"can not find this employee's shift of attandancefilehis ");
                    return;
                }
                schedule.setMatchShift(defaultShift);
                Date workOffTime = WorkShiftUtile.buildShiftNextTime(defaultShift, curDate);
                this.matchShiftEnv.setScheduleWorkOffDate(workOffTime);
            }
        }
        if (schedule.getMatchDaytype() != DayTypeEnum.workDay && !this.matchShiftEnv.isAllShiftValid()) {
            this.matchShiftEnv.setRelateAtsShift(false);
        }
    }

    protected void hasCardProcess() {
        ScheduleShiftInfo schedule = this.matchShiftEnv.getSchedule();
        if (schedule.getMatchDaytype() == DayTypeEnum.restDay) {
            schedule.setMatchDaytype(this.dayTypeWhenRest);
            if (!this.restRelateAtsShift && this.dayTypeWhenRest != DayTypeEnum.workDay) {
                this.matchShiftEnv.setRelateAtsShift(false);
            }
            return;
        }
        if (schedule.getMatchDaytype() == DayTypeEnum.legalHoliday) {
            schedule.setMatchDaytype(this.dayTypeWhenHoliday);
            if (!this.holidayRelateAtsShift && this.dayTypeWhenHoliday != DayTypeEnum.workDay) {
                this.matchShiftEnv.setRelateAtsShift(false);
            }
        }
    }

    public long getAllowedMinusMount() {
        return this.allowedMinusMount;
    }

    public void setAllowedMinusMount(long allowedMinusMount) {
        this.allowedMinusMount = allowedMinusMount;
    }

    public long getValidPunchcardInterVal() {
        return this.validPunchcardInterVal;
    }

    public void setValidPunchcardInterVal(long validPunchcardInterVal) {
        this.validPunchcardInterVal = validPunchcardInterVal;
    }

    public boolean isEnableShiftSegmentPriority() {
        return this.enableShiftSegmentPriority;
    }

    public void setEnableShiftSegmentPriority(boolean enableShiftSegmentPriority) {
        this.enableShiftSegmentPriority = enableShiftSegmentPriority;
    }

    public RangeMap<Integer, Map<Integer, Integer>> getShiftSegmentPriority() {
        return this.shiftSegmentPriority;
    }

    public void setShiftSegmentPriority(RangeMap<Integer, Map<Integer, Integer>> shiftSegmentPriority) {
        this.shiftSegmentPriority = shiftSegmentPriority;
    }

    public DayTypeEnum getDayTypeWhenRest() {
        return this.dayTypeWhenRest;
    }

    public void setDayTypeWhenRest(DayTypeEnum dayTypeWhenRest) {
        this.dayTypeWhenRest = dayTypeWhenRest;
    }

    public DayTypeEnum getDayTypeWhenHoliday() {
        return this.dayTypeWhenHoliday;
    }

    public void setDayTypeWhenHoliday(DayTypeEnum dayTypeWhenHoliday) {
        this.dayTypeWhenHoliday = dayTypeWhenHoliday;
    }

    public boolean isRestRelateAtsShift() {
        return this.restRelateAtsShift;
    }

    public void setRestRelateAtsShift(boolean restRelateAtsShift) {
        this.restRelateAtsShift = restRelateAtsShift;
    }

    public boolean isHolidayRelateAtsShift() {
        return this.holidayRelateAtsShift;
    }

    public void setHolidayRelateAtsShift(boolean holidayRelateAtsShift) {
        this.holidayRelateAtsShift = holidayRelateAtsShift;
    }

    public boolean isEnableScheduleIntersect() {
        return this.enableScheduleIntersect;
    }

    public void setEnableScheduleIntersect(boolean enableScheduleIntersect) {
        this.enableScheduleIntersect = enableScheduleIntersect;
    }

    public DayTypeEnum getDayTypeWhenWork() {
        return this.dayTypeWhenWork;
    }

    public void setDayTypeWhenWork(DayTypeEnum dayTypeWhenWork) {
        this.dayTypeWhenWork = dayTypeWhenWork;
    }

    public boolean isNoCardRelateAtsShift() {
        return this.noCardRelateAtsShift;
    }

    public void setNoCardRelateAtsShift(boolean noCardRelateAtsShift) {
        this.noCardRelateAtsShift = noCardRelateAtsShift;
    }

    public WorkoffShiftType getShiftTypeAfterWork() {
        return this.shiftTypeAfterWork;
    }

    public void setShiftTypeAfterWork(WorkoffShiftType shiftTypeAfterWork) {
        this.shiftTypeAfterWork = shiftTypeAfterWork;
    }

    public ArrayList<CardSetDTO> getCardSetList() {
        return this.cardSetList;
    }

    public void setCardSetList(ArrayList<CardSetDTO> cardSetList) {
        this.cardSetList = cardSetList;
    }

    public String toString() {
        return "ShiftMatchRuleAnalysor [allowedMinusMount=" + this.allowedMinusMount + ", validPunchcardInterVal=" + this.validPunchcardInterVal + ", dayTypeWhenRest=" + (Object)((Object)this.dayTypeWhenRest) + ", dayTypeWhenHoliday=" + (Object)((Object)this.dayTypeWhenHoliday) + ", restRelateAtsShift=" + this.restRelateAtsShift + ", holidayRelateAtsShift=" + this.holidayRelateAtsShift + ", enableScheduleIntersect=" + this.enableScheduleIntersect + ", enableShiftSegmentPriority=" + this.enableShiftSegmentPriority + ", shiftSegmentPriority=" + this.shiftSegmentPriority + "]";
    }

    class ShiftParams {
        private AtsShiftInfo shift;
        private Date preTime;
        private Date nextTime;
        private Date orginalNextTime;
        private int segment;
        private long minusMouns;
        private RangeDate punchcardRange;
        private Date attendDate;
        private long preTimeDiff;
        private List<Date> allPunchCards;
        private List<Date> shiftTimes = new ArrayList<Date>();
        private List<Long> shiftCardDiff = new ArrayList<Long>();

        public ShiftParams(AtsShiftInfo shift, RangeDate punchcardRange, List<Date> allPunchCards) {
            this.shift = shift;
            this.attendDate = (Date)punchcardRange.getLowBound();
            this.punchcardRange = punchcardRange;
            this.allPunchCards = allPunchCards;
            if (shift != null) {
                this.init();
            }
        }

        public ShiftParams(AtsShiftInfo shift, Date attendDate, List<Date> allPunchCards) {
            this.shift = shift;
            this.attendDate = attendDate;
            this.allPunchCards = allPunchCards;
            if (shift != null) {
                this.init();
            }
        }

        public boolean isValid() {
            return this.shift != null && this.preTime != null && this.nextTime != null;
        }

        public boolean hasIntersec() {
            return this.isValid() && this.minusMouns > 0L;
        }

        private void init() {
            this.preTime = WorkShiftUtile.buildShiftPreTime(this.shift, this.attendDate);
            this.nextTime = this.orginalNextTime = WorkShiftUtile.buildShiftNextTime(this.shift, this.attendDate);
            if (this.shift.isIsElastic() && this.shift.getElasticType() == AtsShiftElasticType.commuteElastic) {
                this.nextTime = AtsCommonUtile.dateAdd(this.orginalNextTime, 10, this.shift.getElasticValue().intValue());
            }
            if (this.punchcardRange != null) {
                this.preTimeDiff = this.preTime.getTime() - ((Date)this.punchcardRange.getLowBound()).getTime();
                RangeDate intersec = this.punchcardRange.retainAll(this.preTime, this.nextTime);
                if (intersec.isValid()) {
                    this.minusMouns = ((Date)intersec.getUpBound()).getTime() - ((Date)intersec.getLowBound()).getTime();
                }
            }
            this.segment = this.shift.getItems().size();
            for (int i = 0; i < this.segment; ++i) {
                this.shiftTimes.add(WorkShiftUtile.buildShiftItemPreTime(this.shift.getItems().get(i), this.attendDate));
                Date shiftNextTime = WorkShiftUtile.buildShiftItemNextTime(this.shift.getItems().get(i), this.attendDate);
                if (this.shift.isIsElastic() && this.shift.getElasticType() == AtsShiftElasticType.commuteElastic) {
                    shiftNextTime = AtsCommonUtile.dateAdd(shiftNextTime, 10, this.shift.getElasticValue().intValue());
                }
                this.shiftTimes.add(shiftNextTime);
            }
            if (!AtsCollectionUtile.isEmpty(this.allPunchCards) && !AtsCollectionUtile.isEmpty(this.shiftTimes)) {
                for (int index = 0; index < Math.min(this.shiftTimes.size(), this.allPunchCards.size()); ++index) {
                    this.shiftCardDiff.add(this.shiftTimes.get(index).getTime() - this.allPunchCards.get(index).getTime());
                }
            }
        }

        public AtsShiftInfo getShift() {
            return this.shift;
        }

        public void setShift(AtsShiftInfo shift) {
            this.shift = shift;
        }

        public Date getPreTime() {
            return this.preTime;
        }

        public void setPreTime(Date preTime) {
            this.preTime = preTime;
        }

        public Date getNextTime() {
            return this.nextTime;
        }

        public void setNextTime(Date nextTime) {
            this.nextTime = nextTime;
        }

        public long getMinusMouns() {
            return this.minusMouns;
        }

        public void setMinusMouns(long minusMouns) {
            this.minusMouns = minusMouns;
        }

        public RangeDate getPunchcardRange() {
            return this.punchcardRange;
        }

        public void setPunchcardRange(RangeDate punchcardRange) {
            this.punchcardRange = punchcardRange;
        }

        public int getSegment() {
            return this.segment;
        }

        public void setSegment(int segment) {
            this.segment = segment;
        }

        public Date getAttendDate() {
            return this.attendDate;
        }

        public void setAttendDate(Date attendDate) {
            this.attendDate = attendDate;
        }

        public long getPreTimeDiff() {
            return this.preTimeDiff;
        }

        public void setPreTimeDiff(long preTimeDiff) {
            this.preTimeDiff = preTimeDiff;
        }

        public Date getOrginalNextTime() {
            return this.orginalNextTime;
        }

        public void setOrginalNextTime(Date orginalNextTime) {
            this.orginalNextTime = orginalNextTime;
        }

        public List<Date> getAllPunchCards() {
            return this.allPunchCards;
        }

        public void setAllPunchCards(List<Date> allPunchCards) {
            this.allPunchCards = allPunchCards;
        }

        public List<Date> getShiftTimes() {
            return this.shiftTimes;
        }

        public void setShiftTimes(List<Date> shiftTimes) {
            this.shiftTimes = shiftTimes;
        }

        public List<Long> getShiftCardDiff() {
            return this.shiftCardDiff;
        }

        public void setShiftCardDiff(List<Long> shiftCardDiff) {
            this.shiftCardDiff = shiftCardDiff;
        }

        public String toString() {
            return "{shift=" + (this.shift == null ? "" : this.shift.getName()) + ", shiftNum=" + (this.shift == null ? "" : this.shift.getNumber()) + ", segment=" + this.segment + ", minusMouns=" + this.minusMouns + ", preTimeDiff=" + this.preTimeDiff + ", punchcardRange=" + this.punchcardRange + ", preTime=" + (this.shift == null ? "" : AtsCommonUtile.formateTime(this.preTime)) + ", nextTime=" + (this.shift == null ? "" : AtsCommonUtile.formateTime(this.nextTime)) + "}";
        }
    }
}

