/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup.arrange;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.ArrangeShiftUtile;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.BaseArrangeShift;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.EArrangeState;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.EArrangeWay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;

public class ArrangeShiftByCopy
extends BaseArrangeShift
implements Cloneable {
    private Date sourceBeginDate;
    private Date sourceEndDate;
    private PersonInfo source;
    private int postponeTime = 0;
    private Map<String, Integer> sourceHolidayMap;
    private Long inherentPostpone;
    private Map<String, AttendanceGroupShiftInfo> sourceScheduleShifts;
    private AttendanceGroupShiftInfo currentSourceSchedule;
    private AttendanceGroupShiftInfo latestSchedule;
    private String hrOrgUnitIdD;
    private Map<Integer, AtsTurnShiftEntryInfo> turnShiftEntrys;
    private boolean holidayWithWorkDayShift = true;
    private boolean holidayWithWorkDayUnshift = true;
    private boolean holidayWithRestDayShift = true;
    private boolean holidayWithRestDayUnshift = true;

    public ArrangeShiftByCopy() {
        this.arrangeWay = EArrangeWay.COPY;
    }

    public ArrangeShiftByCopy(Context ctx) {
        super(ctx);
        this.arrangeWay = EArrangeWay.COPY;
    }

    @Override
    protected void doArrange() {
        this.currentSourceSchedule = this.sourceScheduleShifts.get(AtsCommonUtile.getDateFormat().format(this.getRelateDate()));
        if (this.currentSourceSchedule == null) {
            this.addErrorMsg(MLUtile.getRes(AtsScheduleShiftResEnum.ScheduleShiftOrder2, this.ctx));
            return;
        }
        this.currentSourceSchedule = (AttendanceGroupShiftInfo)this.currentSourceSchedule.clone();
        super.doArrange();
    }

    @Override
    public void holidayProcss() {
        if (this.currentSourceSchedule.getDayType() == DayTypeEnum.legalHoliday) {
            this.getCurentArrangingSchedule().setDayType(DayTypeEnum.legalHoliday);
            this.getCurentArrangingSchedule().setDefaultShift(this.currentSourceSchedule.getDefaultShift());
            this.setBasicInfo();
            return;
        }
        switch (this.holidayProcessWay) {
            case POSTPONE: {
                this.holidayReplaceProcess();
                this.incrementPostponeDayCount();
                break;
            }
            case REPLACE: {
                this.holidayReplaceProcess();
                break;
            }
            default: {
                this.workDayProcess();
            }
        }
    }

    @Override
    public void weekendProcess() {
        if (this.currentSourceSchedule.getDayType() == DayTypeEnum.legalHoliday && (this.holidayWithRestDayShift || this.holidayWithRestDayUnshift)) {
            this.getCurentArrangingSchedule().setDayType(DayTypeEnum.restDay);
        } else {
            this.getCurentArrangingSchedule().setDayType(this.currentSourceSchedule.getDayType());
        }
        this.getCurentArrangingSchedule().setDefaultShift(this.currentSourceSchedule.getDefaultShift());
        this.setBasicInfo();
        if (this.getArrangeState() == EArrangeState.SHOW_RESULT) {
            return;
        }
    }

    @Override
    public void workDayProcess() {
        DayTypeEnum currentDayType = this.currentSourceSchedule.getDayType();
        if (this.currentSourceSchedule.getDayType() == DayTypeEnum.legalHoliday && (this.holidayWithWorkDayShift || this.holidayWithWorkDayUnshift)) {
            AttendanceGroupShiftInfo latestSchedule;
            if (this.currentSourceSchedule.getDefaultShift() == null && this.holidayWithWorkDayUnshift && (latestSchedule = this.getLatestSchedule()) != null) {
                this.currentSourceSchedule = (AttendanceGroupShiftInfo)latestSchedule.clone();
            }
            if (this.currentSourceSchedule.getDefaultShift() != null) {
                currentDayType = DayTypeEnum.workDay;
            }
        }
        this.getCurentArrangingSchedule().setDayType(currentDayType);
        this.getCurentArrangingSchedule().setDefaultShift(this.currentSourceSchedule.getDefaultShift());
        this.setBasicInfo();
        if (this.getArrangeState() == EArrangeState.SHOW_RESULT) {
            return;
        }
    }

    private AttendanceGroupShiftInfo getLatestSchedule() {
        ArrayList<AttendanceGroupShiftInfo> sourceSchedule = new ArrayList<AttendanceGroupShiftInfo>(this.sourceScheduleShifts.values());
        Collections.sort(sourceSchedule, new Comparator<AttendanceGroupShiftInfo>(){

            @Override
            public int compare(AttendanceGroupShiftInfo o1, AttendanceGroupShiftInfo o2) {
                return o1.getAttendDate().compareTo(o2.getAttendDate());
            }
        });
        Date relateDate = this.getRelateDate();
        AttendanceGroupShiftInfo AttendanceGroupShiftInfo2 = null;
        AttendanceGroupShiftInfo scheduleTemp = null;
        for (int i = 0; i < sourceSchedule.size(); ++i) {
            scheduleTemp = (AttendanceGroupShiftInfo)sourceSchedule.get(i);
            if (scheduleTemp.getDefaultShift() == null) continue;
            if (scheduleTemp.getAttendDate().before(relateDate)) {
                AttendanceGroupShiftInfo2 = scheduleTemp;
            }
            if (!scheduleTemp.getAttendDate().after(relateDate)) continue;
            if (AttendanceGroupShiftInfo2 != null) break;
            AttendanceGroupShiftInfo2 = scheduleTemp;
            break;
        }
        return AttendanceGroupShiftInfo2 == null ? this.latestSchedule : AttendanceGroupShiftInfo2;
    }

    private void holidayReplaceProcess() {
        this.getCurentArrangingSchedule().setDayType(DayTypeEnum.legalHoliday);
        this.getCurentArrangingSchedule().setDefaultShift(null);
        this.setBasicInfo();
    }

    private Date getRelateDate() {
        return new Date(this.currentShiftDate.getTime() - this.inherentPostpone + (long)this.postponeTime);
    }

    @Override
    void beforeArrangeShift() {
        super.beforeArrangeShift();
        if (this.sourceScheduleShifts == null) {
            String sourceNum = this.getPersonInfo() != null ? this.getPersonInfo().getNumber() : "";
            String[] selects = new String[]{"shiftByTurnSegment", "atsTurnShift.id", "defaultShift.*"};
            this.sourceScheduleShifts = ArrangeShiftUtile.getScheduleShifts(this.ctx, sourceNum, AtsCommonUtile.getDateFormat().format(this.sourceBeginDate), AtsCommonUtile.getDateFormat().format(this.sourceEndDate), AtsViewUtile.getViewBySelector(selects));
        }
        if (this.source == null && this.sourceHolidayMap == null) {
            this.sourceHolidayMap = this.holidayMap;
        }
        this.inherentPostpone = this.beginDate.getTime() - this.sourceBeginDate.getTime();
        if (this.sourceScheduleShifts.size() == 0) {
            this.setContinueArrangeShift(false);
        }
    }

    private void setBasicInfo() {
        if (this.currentSourceSchedule.getTurnShift() != null) {
            this.getCurentArrangingSchedule().setTurnShift(this.currentSourceSchedule.getTurnShift());
        }
        if (this.currentSourceSchedule.getShiftByTurnSegment() != 0) {
            this.getCurentArrangingSchedule().setShiftByTurnSegment(this.currentSourceSchedule.getShiftByTurnSegment());
        }
    }

    public Date getSourceBeginDate() {
        return this.sourceBeginDate;
    }

    public void setSourceBeginDate(Date sourceBeginDate) {
        this.sourceBeginDate = sourceBeginDate;
    }

    public Date getSourceEndDate() {
        return this.sourceEndDate;
    }

    public void setSourceEndDate(Date sourceEndDate) {
        this.sourceEndDate = sourceEndDate;
    }

    public PersonInfo getSource() {
        return this.source;
    }

    public void setSource(PersonInfo source) {
        this.source = source;
    }

    public Map<String, AttendanceGroupShiftInfo> getsourceScheduleShifts() {
        return this.sourceScheduleShifts;
    }

    public void setSourceScheduleShifts(Map<String, AttendanceGroupShiftInfo> sourceScheduleShifts) {
        this.sourceScheduleShifts = sourceScheduleShifts;
    }

    public int getPostponeTime() {
        return this.postponeTime;
    }

    public void setPostponeTime(int postponeTime) {
        this.postponeTime = postponeTime;
    }

    public Long getInherentPostpone() {
        return this.inherentPostpone;
    }

    public void setInherentPostpone(Long inherentPostpone) {
        this.inherentPostpone = inherentPostpone;
    }

    private void incrementPostponeDayCount() {
        this.inherentPostpone = this.inherentPostpone + 86400000L;
    }

    public Map<String, Integer> getSourceHolidayMap() {
        return this.sourceHolidayMap;
    }

    public void setSourceHolidayMap(Map<String, Integer> sourceHolidayMap) {
        this.sourceHolidayMap = sourceHolidayMap;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ArrangeShiftByCopy copy = (ArrangeShiftByCopy)super.clone();
        if (this.sourceBeginDate != null) {
            copy.setSourceBeginDate((Date)this.sourceBeginDate.clone());
        }
        if (this.sourceEndDate != null) {
            copy.setSourceEndDate((Date)this.sourceEndDate.clone());
        }
        if (this.source != null) {
            copy.setSource((PersonInfo)this.source.clone());
        }
        return copy;
    }

    public AttendanceGroupShiftInfo getCurrentSourceSchedule() {
        return this.currentSourceSchedule;
    }

    public void setCurrentSourceSchedule(AttendanceGroupShiftInfo currentSourceSchedule) {
        this.currentSourceSchedule = currentSourceSchedule;
    }

    public boolean isHolidayWithWorkDayShift() {
        return this.holidayWithWorkDayShift;
    }

    public void setHolidayWithWorkDayShift(boolean holidayWithWorkDayShift) {
        this.holidayWithWorkDayShift = holidayWithWorkDayShift;
    }

    public boolean isHolidayWithWorkDayUnshift() {
        return this.holidayWithWorkDayUnshift;
    }

    public void setHolidayWithWorkDayUnshift(boolean holidayWithWorkDayUnshift) {
        this.holidayWithWorkDayUnshift = holidayWithWorkDayUnshift;
    }

    public boolean isHolidayWithRestDayShift() {
        return this.holidayWithRestDayShift;
    }

    public void setHolidayWithRestDayShift(boolean holidayWithRestDayShift) {
        this.holidayWithRestDayShift = holidayWithRestDayShift;
    }

    public boolean isHolidayWithRestDayUnshift() {
        return this.holidayWithRestDayUnshift;
    }

    public void setHolidayWithRestDayUnshift(boolean holidayWithRestDayUnshift) {
        this.holidayWithRestDayUnshift = holidayWithRestDayUnshift;
    }

    public Map<String, AttendanceGroupShiftInfo> getSourceScheduleShifts() {
        return this.sourceScheduleShifts;
    }

    public void setLatestSchedule(AttendanceGroupShiftInfo latestSchedule) {
        this.latestSchedule = latestSchedule;
    }

    public String getHrOrgUnitIdD() {
        return this.hrOrgUnitIdD;
    }

    public void setHrOrgUnitIdD(String hrOrgUnitIdD) {
        this.hrOrgUnitIdD = hrOrgUnitIdD;
    }

    public Map<Integer, AtsTurnShiftEntryInfo> getTurnShiftEntrys() {
        return this.turnShiftEntrys;
    }

    public void setTurnShiftEntrys(Map<Integer, AtsTurnShiftEntryInfo> turnShiftEntrys) {
        this.turnShiftEntrys = turnShiftEntrys;
    }
}

