/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup.arrange;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryCollection;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryFactory;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftCollection;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftFactory;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.CollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ArrangeShiftUtile {
    public static Map<String, Map<String, Integer>> getPersonHoliday(Context ctx, String CalendarGroupID, Collection<String> personNums, String beginDateStr, String endDateStr) {
        if (CollectionUtile.isEmpty(personNums)) {
            return new HashMap<String, Map<String, Integer>>();
        }
        StringBuffer sql = new StringBuffer("select ");
        sql.append(" Item.FCalendarGroupID as calId, Item.FDayType as dayType,item.FDate as dateStr").append(" from T_HR_ATS_WorkCalendarItem Item where  Item.FCalendarGroupID = '" + CalendarGroupID + "'").append(" and item.FDate >= {ts '").append(beginDateStr).append("'}").append(" and item.FDate <= {ts '").append(endDateStr).append("'}").append(" and Item.FDayType in(1,2)");
        HashMap<String, Integer> holidayCalendar = new HashMap<String, Integer>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                holidayCalendar.put(AtsCommonUtile.getDateFormat().format(rowSet.getDate("dateStr")), rowSet.getInt("dayType"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, HashMap<String, Integer>> personHolidayCalendar = new HashMap<String, HashMap<String, Integer>>(personNums.size());
        for (String number : personNums) {
            personHolidayCalendar.put(number, holidayCalendar);
        }
        return Collections.unmodifiableMap(personHolidayCalendar);
    }

    public static Map<String, Integer> getPersonHoliday(Context ctx, String personNum, String beginDateStr, String endDateStr, String endDateSt) {
        if (StringUtils.isEmpty((String)personNum)) {
            return new HashMap<String, Integer>();
        }
        return ArrangeShiftUtile.getPersonHoliday(ctx, "", Collections.singleton(personNum), beginDateStr, endDateStr).get(personNum);
    }

    public static Map<String, Map<Integer, AtsTurnShiftEntryInfo>> getTurnShiftEntrys(Context ctx, Collection<String> turnShiftIds) {
        if (CollectionUtile.isEmpty(turnShiftIds)) {
            return new HashMap<String, Map<Integer, AtsTurnShiftEntryInfo>>();
        }
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"id", "defaultShift.items.*", "defaultShift.*", "group.id", "dateType", "segment"});
        evi = AtsViewUtile.getViewByFilter("group.id", turnShiftIds, CompareType.INCLUDE, evi);
        AtsViewUtile.addSorter("segment", SortType.ASCEND, evi);
        AtsTurnShiftEntryCollection entryCollection = null;
        try {
            entryCollection = AtsTurnShiftEntryFactory.getLocalInstance(ctx).getAtsTurnShiftEntryCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashMap<String, Map<Integer, AtsTurnShiftEntryInfo>> turnShiftEntrys = new HashMap<String, Map<Integer, AtsTurnShiftEntryInfo>>();
        if (entryCollection != null && entryCollection.size() > 0) {
            for (int i = 0; i < entryCollection.size(); ++i) {
                String turnShifId = entryCollection.get(i).getGroup().getId().toString();
                HashMap<Integer, AtsTurnShiftEntryInfo> oneShiftEntrys = (HashMap<Integer, AtsTurnShiftEntryInfo>)turnShiftEntrys.get(turnShifId);
                if (oneShiftEntrys == null) {
                    oneShiftEntrys = new HashMap<Integer, AtsTurnShiftEntryInfo>();
                    turnShiftEntrys.put(turnShifId, oneShiftEntrys);
                }
                oneShiftEntrys.put(entryCollection.get(i).getSegment(), entryCollection.get(i));
            }
        }
        return turnShiftEntrys;
    }

    public static Map<Integer, AtsTurnShiftEntryInfo> getTurnShiftEntrys(Context ctx, String turnShiftId) {
        if (StringUtils.isEmpty((String)turnShiftId)) {
            return new HashMap<Integer, AtsTurnShiftEntryInfo>();
        }
        return ArrangeShiftUtile.getTurnShiftEntrys(ctx, Collections.singleton(turnShiftId)).get(turnShiftId);
    }

    public static Map<String, Map<String, AttendanceGroupShiftInfo>> getScheduleShifts(Context ctx, Collection<String> personNums, String beginDate, String endDate, EntityViewInfo evi) {
        evi = AtsViewUtile.getViewBySelector(new String[]{"attendDate", "attenceGroup.id", "items.*", "dayType", "TurnShift", "shiftByTurnSegment"}, evi);
        evi = AtsViewUtile.getViewByFilter("attendDate", endDate + " 00:00:00", CompareType.LESS_EQUALS, evi);
        evi = AtsViewUtile.getViewByFilter("attendDate", beginDate + " 00:00:00", CompareType.GREATER_EQUALS, evi);
        if (!AtsCollectionUtile.isEmpty(personNums)) {
            evi = AtsViewUtile.getViewByFilter("attenceGroup.id", new HashSet<String>(personNums), CompareType.INCLUDE, evi);
        }
        AttendanceGroupShiftCollection AttendanceGroupShiftCollection2 = null;
        try {
            AttendanceGroupShiftCollection2 = AttendanceGroupShiftFactory.getLocalInstance(ctx).getAttendanceGroupShiftCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        int initSize = AttendanceGroupShiftCollection2 == null ? 0 : AttendanceGroupShiftCollection2.size();
        HashMap<String, HashMap<String, AttendanceGroupShiftInfo>> allScheduleShifts = new HashMap<String, HashMap<String, AttendanceGroupShiftInfo>>(initSize);
        if (AttendanceGroupShiftCollection2 != null && AttendanceGroupShiftCollection2.size() > 0) {
            if (evi.toString().contains("defaultShift.items")) {
                ArrangeShiftUtile.updateShiftItems(ctx, AttendanceGroupShiftCollection2, null);
            }
            for (int i = 0; i < AttendanceGroupShiftCollection2.size(); ++i) {
                String personNum = AttendanceGroupShiftCollection2.get(i).getAttenceGroup().getId().toString();
                HashMap<String, AttendanceGroupShiftInfo> oneScheduleShift = (HashMap<String, AttendanceGroupShiftInfo>)allScheduleShifts.get(personNum);
                if (oneScheduleShift == null) {
                    oneScheduleShift = new HashMap<String, AttendanceGroupShiftInfo>();
                    allScheduleShifts.put(personNum, oneScheduleShift);
                }
                oneScheduleShift.put(AtsCommonUtile.getDateFormat().format(AttendanceGroupShiftCollection2.get(i).getAttendDate()), AttendanceGroupShiftCollection2.get(i));
            }
        }
        return Collections.unmodifiableMap(allScheduleShifts);
    }

    public static void updateShiftItems(Context ctx, AttendanceGroupShiftCollection scheduleShiftCollection, Collection<String> shiftIds) {
        int i;
        AtsShiftInfo shift;
        if (shiftIds == null) {
            shiftIds = new HashSet<String>();
            for (int i2 = 0; i2 < scheduleShiftCollection.size(); ++i2) {
                shift = scheduleShiftCollection.get(i2).getDefaultShift();
                if (shift == null) continue;
                shiftIds.add(shift.getId().toString());
            }
        }
        AtsShiftCollection shifts = null;
        try {
            shifts = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection("select id,items.* where id in " + AtsCollectionUtile.joinForSqlWithBrackets(shiftIds));
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)"", (Throwable)e);
        }
        if (AtsCollectionUtile.isEmpty(shifts)) {
            return;
        }
        HashMap<String, AtsShiftItemCollection> mapItems = new HashMap<String, AtsShiftItemCollection>(shiftIds.size());
        for (i = 0; i < shifts.size(); ++i) {
            mapItems.put(shifts.get(i).getId().toString(), shifts.get(i).getItems());
        }
        for (i = 0; i < scheduleShiftCollection.size(); ++i) {
            shift = scheduleShiftCollection.get(i).getDefaultShift();
            if (shift == null) continue;
            shift.getItems().addCollection((AtsShiftItemCollection)((Object)mapItems.get(shift.getId().toString())));
        }
    }

    public static Map<String, AttendanceGroupShiftInfo> getScheduleShifts(Context ctx, String personNum, String beginDate, String endDate, EntityViewInfo evi) {
        if (StringUtils.isEmpty((String)personNum)) {
            return new HashMap<String, AttendanceGroupShiftInfo>();
        }
        return ArrangeShiftUtile.getScheduleShifts(ctx, Collections.singleton(personNum), beginDate, endDate, evi).get(personNum);
    }

    public static String isNull(List<String[]> fields) {
        if (fields == null || fields.isEmpty()) {
            return "";
        }
        for (String[] fieldValue : fields) {
            if (fieldValue.length != 2 || !StringUtils.isEmpty((String)fieldValue[0])) continue;
            return fieldValue[1];
        }
        return "";
    }

    public static boolean isNullAndResponse(HttpServletRequest request, HttpServletResponse response, List<String[]> fields) throws Exception {
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        for (String[] fieldValue : fields) {
            if (fieldValue.length != 2 || StringUtils.isEmpty((String)fieldValue[0]) || !StringUtils.isEmpty((String)request.getParameter(fieldValue[0]))) continue;
            AtsCommonUtile.responseError(response, fieldValue[1]);
            return true;
        }
        return false;
    }

    public static Set<String> getPersonNumFromRequest(HttpServletRequest request) {
        String personNumsStr = request.getParameter("attenceGroup_el");
        if (StringUtils.isEmpty((String)personNumsStr)) {
            return null;
        }
        List personNumList = JSON.parseArray((String)personNumsStr, String.class);
        return AtsCollectionUtile.delRepeatAndEmpty(personNumList);
    }

    public static Map<String, JSONObject> getshiftTurnFromSchedule(Context ctx, Collection<String> personNums, Date postponedTo) {
        if (AtsCollectionUtile.isEmpty(personNums)) {
            return new HashMap<String, JSONObject>(0);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        StringBuffer sqlBuffer = new StringBuffer("select ").append("schedule1.FAttenceGroupID attenceGroupID, schedule1.fattenddate attendDate,schedule1.fshiftByTurnSegment currentSegment,schedule1.FTurnShiftID turnShiftId").append(" from T_ATS_AttendanceGroupShift schedule1").append(" where FAttenceGroupID in ").append(AtsCollectionUtile.joinForSqlWithBrackets(personNums)).append(" and schedule1.FTurnShiftID is not null").append(" and schedule1.fattenddate >= {ts '").append(AtsCommonUtile.getDateFormat().format(calendar.getTime())).append("'}").append(" and schedule1.fattenddate < {ts '").append(AtsCommonUtile.getDateFormat().format(postponedTo)).append("'}").append(" and schedule1.fattenddate=(select MAX(fattenddate) FROM T_ATS_AttendanceGroupShift schedule2 where schedule1.FAttenceGroupID = schedule2.FAttenceGroupID ").append(" and schedule2.fattenddate >= {ts '").append(AtsCommonUtile.getDateFormat().format(calendar.getTime())).append("'}").append(" and schedule2.fattenddate < {ts '").append(AtsCommonUtile.getDateFormat().format(postponedTo)).append("'})");
        HashMap<String, JSONObject> personNumToLatestSheduleTurn = new HashMap<String, JSONObject>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            while (rowSet.next()) {
                JSONObject latestTurns = new JSONObject();
                latestTurns.put("currentSegment", (Object)rowSet.getInt("currentSegment"));
                latestTurns.put("turnShiftId", (Object)rowSet.getString("turnShiftId"));
                latestTurns.put("attendDate", (Object)rowSet.getDate("attendDate"));
                personNumToLatestSheduleTurn.put(rowSet.getString("attenceGroupID"), latestTurns);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return personNumToLatestSheduleTurn;
    }
}

