/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup.arrange;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftCollection;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.EArrangeState;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.EArrangeWay;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.EHolidayProcessWay;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.IArrangeShift;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class BaseArrangeShift
implements IArrangeShift,
Cloneable {
    protected DataBaseInfo personInfo;
    protected Date beginDate;
    protected Date endDate;
    protected Date currentShiftDate;
    protected String workCalendarId;
    protected SchlShiftSrcTypeEnum operationType;
    protected EArrangeWay arrangeWay;
    protected EHolidayProcessWay holidayProcessWay;
    protected EArrangeState arrangeState;
    protected boolean continueArrangeShift = true;
    protected AttendanceGroupShiftCollection arrangeResult;
    protected AttendanceGroupShiftInfo curentArrangingSchedule;
    protected Map<String, Integer> holidayMap;
    protected Set<String> errorMsg = new HashSet<String>();
    protected Context ctx;

    public BaseArrangeShift() {
    }

    public BaseArrangeShift(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void arrangeShift() {
        this.arrangeResult = new AttendanceGroupShiftCollection();
        this.currentShiftDate = (Date)this.beginDate.clone();
        if (this.holidayProcessWay == null) {
            this.holidayProcessWay = EHolidayProcessWay.UNOPROCESS;
        }
        this.beforeArrangeShift();
        while (!this.currentShiftDate.after(this.endDate) && this.getContinueArrangeShift()) {
            this.doArrange();
            this.nextDay();
        }
        this.afterArrangeShift();
    }

    protected void doArrange() {
        Integer holidayType = this.holidayMap.get(AtsCommonUtile.getDateFormat().format(this.currentShiftDate));
        this.curentArrangingSchedule = new AttendanceGroupShiftInfo();
        this.setBasicScheduleInfo();
        switch (holidayType == null ? 0 : holidayType) {
            case 2: {
                this.holidayProcss();
                break;
            }
            case 1: {
                this.weekendProcess();
                break;
            }
            default: {
                this.workDayProcess();
            }
        }
        if (this.curentArrangingSchedule != null) {
            this.arrangeResult.add(this.curentArrangingSchedule);
        }
    }

    void beforeArrangeShift() {
        if (this.holidayMap == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String string = this.personInfo.getNumber();
        }
    }

    @Override
    public JSONArray showArrangeResult() throws JSONException {
        AttendanceGroupShiftCollection arrangeResult = this.getArrangeResult();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)arrangeResult)) {
            return new JSONArray(0);
        }
        JSONArray shiftResult = new JSONArray(arrangeResult.size());
        for (int i = 0; i < arrangeResult.size(); ++i) {
            AttendanceGroupShiftInfo currentShift = arrangeResult.get(i);
            JSONObject dateShift = new JSONObject(4);
            dateShift.put("dayType", (Object)currentShift.getDayType().getAlias());
            dateShift.put("attendDate", (Object)AtsCommonUtile.getDateFormat().format(currentShift.getAttendDate()));
            dateShift.put("shiftName", (Object)(currentShift.getDefaultShift() == null || currentShift.getDefaultShift() == null ? "" : currentShift.getDefaultShift().getName()));
            if ((this.arrangeWay == EArrangeWay.TURNS || this.arrangeWay == EArrangeWay.TURNS_POSTPINE || this.arrangeWay == EArrangeWay.COPY) && currentShift.getTurnShift() != null && currentShift.getShiftByTurnSegment() != 0) {
                dateShift.put("turnShiftId", (Object)currentShift.getTurnShift().getId().toString());
                dateShift.put("segment", (Object)String.valueOf(currentShift.getShiftByTurnSegment()));
            }
            shiftResult.add((Object)dateShift);
        }
        return shiftResult;
    }

    protected void setBasicScheduleInfo() {
        this.curentArrangingSchedule.setAttendDate((Date)this.currentShiftDate.clone());
        this.curentArrangingSchedule.setProposer((PersonInfo)this.getPersonInfo());
    }

    protected void afterArrangeShift() {
    }

    protected void addErrorMsg(String errorInfo) {
        this.curentArrangingSchedule = null;
        if (StringUtils.isNotEmpty((String)errorInfo)) {
            this.errorMsg.add(errorInfo);
        }
    }

    @Override
    public DataBaseInfo getPersonInfo() {
        return this.personInfo;
    }

    public void setPersonInfo(DataBaseInfo personInfo) {
        this.personInfo = personInfo;
    }

    @Override
    public Date getBeginDate() {
        return this.beginDate;
    }

    @Override
    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public AttendanceGroupShiftCollection getArrangeResult() {
        return this.arrangeResult;
    }

    @Override
    public void setArrangeResult(AttendanceGroupShiftCollection arrangeResult) {
        this.arrangeResult = arrangeResult;
    }

    @Override
    public EArrangeWay getArrangeWay() {
        return this.arrangeWay;
    }

    @Override
    public void setArrangeWay(EArrangeWay arrangeWay) {
        this.arrangeWay = arrangeWay;
    }

    @Override
    public Date getCurrentShiftDate() {
        return this.currentShiftDate;
    }

    @Override
    public void setCurrentShiftDate(Date currentShiftDate) {
        this.currentShiftDate = currentShiftDate;
    }

    @Override
    public void nextDay() {
        this.getCurrentShiftDate().setTime(this.getCurrentShiftDate().getTime() + 86400000L);
    }

    @Override
    public EHolidayProcessWay getHolidayProcessWay() {
        return this.holidayProcessWay;
    }

    @Override
    public void setHolidayProcessWay(EHolidayProcessWay holidayProcessWay) {
        this.holidayProcessWay = holidayProcessWay;
    }

    @Override
    public EArrangeState getArrangeState() {
        return this.arrangeState;
    }

    @Override
    public void setArrangeState(EArrangeState arrangeState) {
        this.arrangeState = arrangeState;
    }

    @Override
    public boolean getContinueArrangeShift() {
        return this.continueArrangeShift;
    }

    @Override
    public void setContinueArrangeShift(boolean isContinueArrangeShift) {
        this.continueArrangeShift = isContinueArrangeShift;
    }

    @Override
    public Map<String, Integer> getHolidayMap() {
        return this.holidayMap;
    }

    @Override
    public void setHolidayMap(Map<String, Integer> holidayMap) {
        this.holidayMap = holidayMap;
    }

    public AttendanceGroupShiftInfo getCurentArrangingSchedule() {
        return this.curentArrangingSchedule;
    }

    public void setCurentArrangingSchedule(AttendanceGroupShiftInfo curentArrangingSchedule) {
        this.curentArrangingSchedule = curentArrangingSchedule;
    }

    @Override
    public Set<String> getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMsg(Set<String> errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getWorkCalendarId() {
        return this.workCalendarId;
    }

    public void setWorkCalendarId(String workCalendarId) {
        this.workCalendarId = workCalendarId;
    }

    @Override
    public SchlShiftSrcTypeEnum getOperationType() {
        return this.operationType;
    }

    @Override
    public void setOperationType(SchlShiftSrcTypeEnum operationType) {
        this.operationType = operationType;
    }

    protected Object clone() throws CloneNotSupportedException {
        BaseArrangeShift abstractArrangeShift = (BaseArrangeShift)super.clone();
        if (this.personInfo != null) {
            abstractArrangeShift.setPersonInfo((DataBaseInfo)((PersonInfo)this.personInfo.clone()));
        }
        if (this.beginDate != null) {
            abstractArrangeShift.setBeginDate((Date)this.beginDate.clone());
        }
        if (this.endDate != null) {
            abstractArrangeShift.setEndDate((Date)this.endDate.clone());
        }
        if (this.currentShiftDate != null) {
            abstractArrangeShift.setCurrentShiftDate((Date)this.currentShiftDate.clone());
        }
        return abstractArrangeShift;
    }
}

