/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup.update;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsOtherBizException;
import com.kingdee.eas.hr.ats.AtsShiftBizException;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftResEnum;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.CardRuleFactory;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.GroupProcessorBySize;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.OrgUintPermissionUtile;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.ArrangeShiftUtile;
import com.kingdee.eas.hr.ats.workShiftGroup.save.SaveShiftUtile;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UpdateScheduleManager {
    private Context ctx;
    private HttpServletRequest request;
    private JSONObject updateFields;
    private JSONObject rangeSetting;
    private int totalCount = 0;
    private boolean needToUpdateItem;
    private Map<String, List<String>> needUpdatePersonAndDate;
    private AtsShiftInfo defaultShift;
    private CardRuleInfo cardRule;
    private Set<String> errorMsg = new HashSet<String>();
    private List<Object[]> updateShiftItemParams = new ArrayList<Object[]>();

    public UpdateScheduleManager() {
    }

    public UpdateScheduleManager(JSONObject rangeSetting, JSONObject updateFields) {
        this.updateFields = updateFields;
        this.rangeSetting = rangeSetting;
    }

    private void init() throws Exception {
        if (this.updateFields == null || this.rangeSetting == null) {
            throw new AtsOtherBizException(AtsOtherBizException.SETUPDATEFIELD);
        }
        AtsCommonUtile.correctFields(this.updateFields);
        AtsCommonUtile.correctFields(this.rangeSetting);
        if (this.updateFields.containsKey((Object)"defaultShiftID")) {
            this.needToUpdateItem = true;
            this.defaultShift = AtsShiftFactory.getLocalInstance(this.ctx).getAtsShiftInfo((IObjectPK)new ObjectUuidPK(this.updateFields.getString("defaultShiftID")));
        }
        if (this.updateFields.containsKey((Object)"cardRuleID")) {
            this.cardRule = CardRuleFactory.getLocalInstance(this.ctx).getCardRuleInfo((IObjectPK)new ObjectUuidPK(this.updateFields.getString("cardRuleID")));
        }
        if (this.defaultShift != null && this.cardRule != null && this.defaultShift.getItems().size() != this.cardRule.getStartSegmentNum().getValue()) {
            throw new AtsShiftBizException(AtsShiftBizException.NOMATCHSEGWITHCARDRULE);
        }
        if (this.rangeSetting.containsKey((Object)"needUpdatePersonAndDate")) {
            this.needUpdatePersonAndDate = new HashMap<String, List<String>>();
            List updateShiftItemParams = JSON.parseArray((String)this.rangeSetting.getString("needUpdatePersonAndDate"), JSONObject.class);
            for (JSONObject schedule : updateShiftItemParams) {
                List<String> personSchedule = this.needUpdatePersonAndDate.get(schedule.getString("personNum"));
                if (personSchedule == null) {
                    personSchedule = new ArrayList<String>();
                    this.needUpdatePersonAndDate.put(schedule.getString("personNum"), personSchedule);
                }
                personSchedule.add(schedule.getString("attendDate"));
            }
        }
    }

    private StringBuffer getUpdateSql() {
        StringBuffer sql = new StringBuffer("update t_hr_ats_scheduleshift set ");
        for (String field : this.updateFields.keySet()) {
            sql.append("F").append(field).append("='").append(this.updateFields.getString(field)).append("', ");
        }
        if (this.defaultShift != null && this.cardRule == null) {
            sql.append("FcardRuleID='").append(this.defaultShift.getCardRule().getId()).append("', ");
        }
        return new StringBuffer(sql.substring(0, sql.length() - ", ".length())).append(" where fid in ");
    }

    private EntityViewInfo getEntityViewInfo() throws Exception {
        ArrayList<String> viewSeletor = new ArrayList<String>();
        viewSeletor.add("id");
        viewSeletor.add("proposer.name");
        if (this.defaultShift != null || this.cardRule != null) {
            viewSeletor.add("defaultShift.name");
        }
        if (this.defaultShift == null && this.cardRule != null) {
            viewSeletor.add("cardRule.name");
        }
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(viewSeletor);
        if (this.rangeSetting.containsKey((Object)"hrOrgUnitID")) {
            AtsViewUtile.getViewByFilter("hrOrgUnit", (Object)this.rangeSetting.getString("hrOrgUnitID"), evi);
        }
        if (this.rangeSetting.containsKey((Object)"adminOrgUnitNum")) {
            AtsViewUtile.getViewByFilter("adminOrgUnit", OrgUintPermissionUtile.getRangeSqlWithLongNum(this.ctx, this.request, this.rangeSetting.getString("adminOrgUnitNum")), CompareType.INNER, evi);
        }
        return evi;
    }

    public void update() throws Exception {
        this.init();
        HashSet<String> scheduleIds = new HashSet<String>();
        Map<String, Map<String, AttendanceGroupShiftInfo>> needUpdateSchedules = this.getNeedUpdateSchedule();
        Iterator<Map<String, AttendanceGroupShiftInfo>> personScheduleIt = needUpdateSchedules.values().iterator();
        while (personScheduleIt.hasNext()) {
            for (AttendanceGroupShiftInfo schedule : personScheduleIt.next().values()) {
                String personNum = schedule.getProposer().getNumber();
                if (this.needUpdatePersonAndDate != null && (this.needUpdatePersonAndDate.get(personNum) == null || !this.needUpdatePersonAndDate.get(personNum).contains(AtsCommonUtile.formateDate(schedule.getAttendDate()))) || schedule.getDefaultShift() == null && this.defaultShift != null) continue;
                ++this.totalCount;
                if (!this.validate(schedule)) continue;
                scheduleIds.add(schedule.getId().toString());
                if (!this.needToUpdateItem) continue;
                schedule.setDefaultShift(this.defaultShift);
                this.updateShiftItemParams.addAll(SaveShiftUtile.getScheduleShiftItemParams(schedule));
            }
        }
        this.saveSchedule(scheduleIds);
    }

    private void saveSchedule(Set<String> scheduleIds) throws Exception {
        try {
            new GroupProcessorBySize<String, Object>(){

                @Override
                public Object process(Object Key, List<String> groupedElement, Object outerParams) throws Exception {
                    DbUtil.execute((Context)UpdateScheduleManager.this.ctx, (String)UpdateScheduleManager.this.getUpdateSql().append(AtsCollectionUtile.joinForSqlWithBrackets(groupedElement)).toString());
                    return null;
                }
            }.groupAndProcess(scheduleIds, null);
            if (this.needToUpdateItem && this.updateShiftItemParams.size() > 0) {
                SaveShiftUtile.insertScheduleShiftItemsBatch(this.ctx, this.updateShiftItemParams, scheduleIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AtsCommonBizException(AtsCommonBizException.SAVEFAILANDAGAIN);
        }
    }

    private Map<String, Map<String, AttendanceGroupShiftInfo>> getNeedUpdateSchedule() throws Exception {
        Collection<Object> personNums = null;
        if (this.rangeSetting.containsKey((Object)"personNums")) {
            personNums = JSON.parseArray((String)this.rangeSetting.getString("personNums"), String.class);
        }
        if (this.rangeSetting.containsKey((Object)"needUpdatePersonAndDate")) {
            personNums = this.needUpdatePersonAndDate.keySet();
        }
        Map<String, Map<String, AttendanceGroupShiftInfo>> needUpdateSchedules = ArrangeShiftUtile.getScheduleShifts(this.ctx, personNums, this.rangeSetting.getString("beginDate"), this.rangeSetting.getString("endDate"), this.getEntityViewInfo());
        return needUpdateSchedules;
    }

    private boolean validate(AttendanceGroupShiftInfo schedule) {
        return this.validateShiftMatchToCardRule(schedule);
    }

    private boolean validateShiftMatchToCardRule(AttendanceGroupShiftInfo schedule) {
        if (schedule.getDefaultShift() != null && this.defaultShift == null && this.cardRule != null && schedule.getItems().size() != this.cardRule.getStartSegmentNum().getValue()) {
            this.errorMsg.add(this.addErrorMsg(schedule.getProposer().getName(), AtsCommonUtile.getDateFormat().format(schedule.getAttendDate()), MLUtile.getRes((ResourceEnum)AtsShiftResEnum.InconformCardRuleAndShift, this.ctx, schedule.getDefaultShift().getName(), schedule.getCardRule().getName())));
            return false;
        }
        return true;
    }

    private String addErrorMsg(String personName, String attendDate, String errorMsg) {
        JSONObject msg = new JSONObject(3);
        msg.put("personName", (Object)personName);
        msg.put("attendDate", (Object)attendDate);
        msg.put("errorMsg", (Object)errorMsg);
        return msg.toJSONString();
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public JSONObject getUpdateFields() {
        return this.updateFields;
    }

    public void setUpdateFields(JSONObject updateFields) {
        this.updateFields = updateFields;
    }

    public JSONObject getRangeSetting() {
        return this.rangeSetting;
    }

    public void setRangeSetting(JSONObject rangeSetting) {
        this.rangeSetting = rangeSetting;
    }

    public boolean isNeedToUpdateItem() {
        return this.needToUpdateItem;
    }

    public void setNeedToUpdateItem(boolean needToUpdateItem) {
        this.needToUpdateItem = needToUpdateItem;
    }

    public AtsShiftInfo getDefaultShift() {
        return this.defaultShift;
    }

    public void setDefaultShift(AtsShiftInfo defaultShift) {
        this.defaultShift = defaultShift;
    }

    public CardRuleInfo getCardRule() {
        return this.cardRule;
    }

    public void setCardRule(CardRuleInfo cardRule) {
        this.cardRule = cardRule;
    }

    public Set<String> getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(Set<String> errorMsg) {
        this.errorMsg = errorMsg;
    }

    public List<Object[]> getUpdateShiftItemParams() {
        return this.updateShiftItemParams;
    }

    public void setUpdateShiftItemParams(List<Object[]> updateShiftItemParams) {
        this.updateShiftItemParams = updateShiftItemParams;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }
}

