/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.abnormal.task;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.hr.ats.AbnormalAttendanceCollection;
import com.kingdee.eas.hr.ats.AbnormalAttendanceFactory;
import com.kingdee.eas.hr.ats.AbnormalAttendanceInfo;
import com.kingdee.eas.hr.ats.AtsAbnormalDataStatus;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class AbnormalTaskUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.abnormal.task.AbnormalTaskUtils");

    public static int getAbnormalCount(Context ctx, String dateLongToString) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select count(fid) from T_HR_ATS_AbnormalAttendance where Fstatus = 1 and FasOfDate >= {ts '" + dateLongToString + "'}");
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            int totalCount = 0;
            while (row.next()) {
                totalCount = row.getInt(1);
            }
            return totalCount;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    public static AbnormalAttendanceCollection getAbnormal(Context ctx, String dateLongToString) {
        try {
            AbnormalAttendanceCollection abnormals = AbnormalAttendanceFactory.getLocalInstance(ctx).getAbnormalAttendanceCollection("where status = 1 and asOfDate >= {ts '" + dateLongToString + "'}");
            return abnormals;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static AbnormalAttendanceCollection getAbnormalByPage(Context ctx, String dateLongToString, int start, int count) {
        try {
            AbnormalAttendanceCollection abnormals = new AbnormalAttendanceCollection();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter("status = 1 and asOfDate >= {ts '" + dateLongToString + "'} and createTime < {ts '" + dateLongToString + "'}");
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
            sorterItemInfo.setSortType(SortType.ASCEND);
            sorterItemCollection.add(sorterItemInfo);
            SorterItemInfo sorterItemId = new SorterItemInfo("id");
            sorterItemId.setSortType(SortType.ASCEND);
            sorterItemCollection.add(sorterItemId);
            entityViewInfo.setSorter(sorterItemCollection);
            List pagingList = AbnormalAttendanceFactory.getLocalInstance(ctx).getPagingList(entityViewInfo, start, count);
            if (pagingList == null || pagingList.size() == 0) {
                return abnormals;
            }
            for (int index = 0; index < pagingList.size(); ++index) {
                abnormals.add((AbnormalAttendanceInfo)pagingList.get(index));
            }
            return abnormals;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static int getSendAbThreadNum(Context ctx) {
        int MinVal = 2;
        int MaxVal = 10;
        int val = 1;
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FVALUE" + MLUtile.getMlFlag(ctx) + " VALUE FROM T_BAS_PARAMITEM ITEM ");
        sb.append(" INNER JOIN T_BAS_PARAM PARAM ON PARAM.FID = ITEM.FKEYID ");
        sb.append(" WHERE FKEYID = ? ");
        boolean flag = false;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{"UAEHwgF6QWi1h5I52+O286iB8+c="});
            if (row.next()) {
                val = row.getInt("value") > MinVal ? row.getInt("value") : MinVal;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (val > MaxVal) {
            val = MaxVal;
        }
        return val;
    }

    public static int getSendAbNumEveryAb(Context ctx) {
        int val = 99;
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FVALUE" + MLUtile.getMlFlag(ctx) + " VALUE FROM T_BAS_PARAMITEM ITEM ");
        sb.append(" INNER JOIN T_BAS_PARAM PARAM ON PARAM.FID = ITEM.FKEYID ");
        sb.append(" WHERE FKEYID = ? ");
        boolean flag = false;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{"uMgumjuySaKY4QA9b/Ps3qiB8+c="});
            if (row.next()) {
                val = row.getInt("value");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    public static void changeAbnormalIdTrue(Context ctx) {
        try {
            String sqlQuery = "select fid from T_HR_ATS_AbnormalAttendance where FDataStatus = " + AtsAbnormalDataStatus.updateId.getValue();
            IRowSet iRowSet = DbUtile.executeQuery(ctx, sqlQuery);
            Date date = new Date();
            Timestamp timestamp = new Timestamp(date.getTime());
            if (iRowSet != null && iRowSet.size() > 0) {
                String id = null;
                ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
                while (iRowSet.next()) {
                    id = iRowSet.getString("fid");
                    if (null == id || "".equals(id)) continue;
                    Object[] objects = new Object[]{timestamp, id};
                    sqlParams.add(objects);
                }
                String sql = "update T_HR_ATS_AbnormalAttendance set fid = newbosid('D66A6FAB'),FLastUpdateTime = ?,FDataStatus = " + AtsAbnormalDataStatus.normal.getValue() + "  where fid = ?";
                DbUtile.executeBatch(ctx, sql, sqlParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

