/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.atsTrip;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.CanTripBillEntryCollection;
import com.kingdee.eas.hr.ats.CanTripBillEntryFactory;
import com.kingdee.eas.hr.ats.CanTripBillEntryInfo;
import com.kingdee.eas.hr.ats.CanTripBillInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SegmentUnitEnum;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.Precision.PrecisionHelper;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CanTripBillControllerBeanUtils {
    private static final String effectBillStates = AtsCollectionUtile.joinForSql(Arrays.asList(HRBillStateEnum.SUBMITED.getValue(), HRBillStateEnum.AUDITING.getValue(), HRBillStateEnum.AUDITED.getValue()));

    public static void updateBillAndEntryInfo(Context ctx, AtsTripBillEntryInfo tripEntryInfo, String personId) throws BOSException, EASBizException {
        CanTripBillInfo billInfo;
        CanTripBillEntryInfo entryInfo;
        CanTripBillEntryCollection entryCollection = CanTripBillEntryFactory.getLocalInstance(ctx).getCanTripBillEntryCollection("select * , bill.* where tripEntryBill.id = '" + tripEntryInfo.getId() + "' and bill.billState in (" + effectBillStates + ")");
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entryCollection) || null == (entryInfo = entryCollection.get(0)) || null == (billInfo = entryInfo.getBill())) {
            return;
        }
        if (entryInfo.isIsAllDay()) {
            CanTripBillControllerBeanUtils.setEntryBeginAndEndTime(ctx, entryInfo, personId);
        }
        BigDecimal tripBillRealLength = CanTripBillControllerBeanUtils.getBillRealLength(ctx, entryInfo, personId);
        entryInfo.setRealTripDays(tripBillRealLength);
        if (HRBillStateEnum.AUDITED.equals((Object)billInfo.getBillState())) {
            tripEntryInfo.setRealTripStartTime(entryInfo.getRealStartTime());
            tripEntryInfo.setRealTripEndTime(entryInfo.getRealEndTime());
            tripEntryInfo.setRealTripDays(tripBillRealLength);
        }
        CanTripBillEntryInfo billEntryInfo = new CanTripBillEntryInfo();
        billEntryInfo.setId(entryInfo.getId());
        billEntryInfo.setStartTimeDate(entryInfo.getStartTimeDate());
        billEntryInfo.setStartTimeDateType(entryInfo.getStartTimeDateType());
        billEntryInfo.setStartTimeHMS(entryInfo.getStartTimeHMS());
        billEntryInfo.setRealStartTime(entryInfo.getRealStartTime());
        billEntryInfo.setEndTimeDate(entryInfo.getEndTimeDate());
        billEntryInfo.setEndTimeDateType(entryInfo.getEndTimeDateType());
        billEntryInfo.setEndTimeHMS(entryInfo.getEndTimeHMS());
        billEntryInfo.setRealEndTime(entryInfo.getRealEndTime());
        billEntryInfo.setRealTripDays(entryInfo.getRealTripDays());
        CanTripBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), billEntryInfo);
        CanTripBillControllerBeanUtils.updateBillInfo(ctx, billInfo);
    }

    private static void updateBillInfo(Context ctx, CanTripBillInfo info) throws BOSException {
        String nowDatetime = AtsDateUtils.dateLongToString(new Date());
        String updateSql = "update T_ATS_CanTripBill set FLastUpdateTime={ts '" + nowDatetime + "'} where fid ='" + info.getId() + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private static BigDecimal getBillRealLength(Context ctx, CanTripBillEntryInfo entryInfo, String personId) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("personId", personId);
        paraMap.put("tripStartTime", AtsDateUtils.timestampToString(entryInfo.getRealStartTime()));
        paraMap.put("tripEndTime", AtsDateUtils.timestampToString(entryInfo.getRealEndTime()));
        paraMap.put("isElasticCalLen", entryInfo.isIsElasticCalLen());
        paraMap.put("isAllDay", entryInfo.isIsAllDay());
        Map OsfResult = (Map)OSFExecutor.executeOSF((Context)ctx, paraMap, (String)"getTripDayLength");
        Object lengObj = OsfResult == null ? null : OsfResult.get("realLength");
        BigDecimal result = lengObj == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(lengObj));
        PrecisionHelper precisionHelper = new PrecisionHelper();
        precisionHelper.setCtx(ctx).setRoundingMode(RoundingMode.UP);
        return precisionHelper.precisionProcess(result);
    }

    private static void setEntryBeginAndEndTime(Context ctx, CanTripBillEntryInfo entryInfo, String personId) {
        String endTime;
        String beginTime = AtsDateUtils.timestampToShortString(CanTripBillControllerBeanUtils.getRealAttendDate(entryInfo.getRealStartTime(), entryInfo.getStartTimeDateType()));
        Map<String, ScheduleShiftInfo> scheduleShiftForPerson = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personId, beginTime, endTime = AtsDateUtils.timestampToShortString(CanTripBillControllerBeanUtils.getRealAttendDate(entryInfo.getRealEndTime(), entryInfo.getEndTimeDateType())));
        if (null == scheduleShiftForPerson) {
            return;
        }
        String pTime = AtsScheduleShiftUtil.getKey(personId, beginTime);
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(pTime);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)(scheduleShiftInfo == null ? null : scheduleShiftInfo.getItems()))) {
            scheduleShiftForPerson.put(pTime, AtsScheduleShiftUtil.getDefaultSchedule(ctx, personId, beginTime));
        }
        CanTripBillControllerBeanUtils.setStartTime(personId, entryInfo, beginTime, scheduleShiftForPerson);
        pTime = AtsScheduleShiftUtil.getKey(personId, endTime);
        scheduleShiftInfo = scheduleShiftForPerson.get(pTime);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)(scheduleShiftInfo == null ? null : scheduleShiftInfo.getItems()))) {
            scheduleShiftForPerson.put(pTime, AtsScheduleShiftUtil.getDefaultSchedule(ctx, personId, endTime));
        }
        CanTripBillControllerBeanUtils.setEndTime(personId, entryInfo, endTime, scheduleShiftForPerson);
    }

    private static Timestamp getRealAttendDate(Timestamp time, SegmentUnitEnum dateType) {
        if (null == time) {
            return time;
        }
        Timestamp ret = new Timestamp(time.getTime());
        if (SegmentUnitEnum.nextDay.equals((Object)dateType)) {
            ret.setTime(AtsDateUtils.getPreDay(time).getTime());
        } else if (SegmentUnitEnum.preDay.equals((Object)dateType)) {
            ret.setTime(AtsDateUtils.getNextDay(time).getTime());
        }
        return ret;
    }

    private static void setEndTime(String personId, CanTripBillEntryInfo billEntryInfo, String attendDateStr, Map<String, ScheduleShiftInfo> scheduleShiftForPerson) {
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(AtsScheduleShiftUtil.getKey(personId, attendDateStr));
        if (null == scheduleShiftInfo) {
            return;
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftInfo.getItems())) {
            return;
        }
        ScheduleShiftItemInfo itemInfo = scheduleShiftInfo.getItems().get(scheduleShiftInfo.getItems().size() - 1);
        billEntryInfo.setEndTimeDate(AtsDateUtils.dateToTimestamp(AtsDateUtils.dateShortFormatToDate(itemInfo.getNextDateTime())));
        billEntryInfo.setEndTimeDateType(itemInfo.getNextTimeDayType());
        billEntryInfo.setEndTimeHMS(itemInfo.getNextDateTime());
        billEntryInfo.setRealEndTime(itemInfo.getNextDateTime());
    }

    private static void setStartTime(String personId, CanTripBillEntryInfo billEntryInfo, String attendDateStr, Map<String, ScheduleShiftInfo> scheduleShiftForPerson) {
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(AtsScheduleShiftUtil.getKey(personId, attendDateStr));
        if (null == scheduleShiftInfo) {
            return;
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftInfo.getItems())) {
            return;
        }
        ScheduleShiftItemInfo itemInfo = scheduleShiftInfo.getItems().get(0);
        billEntryInfo.setStartTimeDate(AtsDateUtils.dateToTimestamp(AtsDateUtils.dateShortFormatToDate(itemInfo.getPreDateTime())));
        billEntryInfo.setStartTimeDateType(itemInfo.getPreTimeDayType());
        billEntryInfo.setStartTimeHMS(itemInfo.getPreDateTime());
        billEntryInfo.setRealStartTime(itemInfo.getPreDateTime());
    }
}

