/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.fillControl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsFileBillCtrlInfo;
import com.kingdee.eas.hr.ats.AtsFileBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsFilebillBizException;
import com.kingdee.eas.hr.ats.AttencePolicyCycleTypeEnum;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.IAttendanceFileHIS;
import com.kingdee.eas.hr.ats.fillControl.FillControlCommon;
import com.kingdee.eas.hr.ats.fillControl.dto.FillControlDto;
import com.kingdee.eas.hr.base.HRCommonException;
import java.math.BigDecimal;

public class AtsFileBillSupplyCtrl
extends FillControlCommon {
    private AtsFileBillEntryInfo atsFileBillentryInfo;

    public AtsFileBillSupplyCtrl(Context ctx) {
        super(ctx);
    }

    public AtsFileBillSupplyCtrl(Context ctx, AtsFileBillEntryInfo atsFileBillentryInfo) {
        this(ctx);
        this.atsFileBillentryInfo = atsFileBillentryInfo;
    }

    public boolean isInControl() {
        this.control();
        return this.getResult().isSuccess();
    }

    public boolean isInControlWithExep() throws EASBizException {
        this.control();
        if (!this.getResult().isSuccess()) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{this.getBillString()});
        }
        return this.getResult().isSuccess();
    }

    @Override
    public void control() {
        if (this.atsFileBillentryInfo == null) {
            throw new IllegalArgumentException("atsFileBillentryInfo is null");
        }
        try {
            this.initControlData();
        }
        catch (Exception e) {
            this.getResult().setSuccess(false);
            this.setBillString(e.getMessage());
            e.printStackTrace();
            return;
        }
        this.setBillString(new AtsFilebillBizException(AtsFilebillBizException.OUTSUPPLYCTRL, new Object[]{""}).getMessage());
        super.control();
    }

    public void initControlData() throws EASBizException, BOSException {
        this.getFillControl().setStartTime(this.atsFileBillentryInfo.getEFEFFDT());
        this.getFillControl().setEndTime(this.atsFileBillentryInfo.getEFLEFFDT());
        this.getFillControl().setApplyDate(this.atsFileBillentryInfo.getBill().getApplyDate());
        this.getFillControl().setUseStartTimeOnTimeCtrl(true);
        this.getFillControl().setUseStartTimeOnCycleCtrl(true);
        AttencePolicyInfo attencePolicyInfo = this.getAttencePolicy();
        if (attencePolicyInfo == null) {
            throw new AtsFileBizException(AtsFileBizException.NOTEXISTPOLICYINATTFILE);
        }
        AtsFileBillCtrlInfo fileBillCtrl = attencePolicyInfo.getAtsFileBillCtrl();
        if (fileBillCtrl == null || !fileBillCtrl.isEnable()) {
            return;
        }
        this.setAttencePolicyInfo(attencePolicyInfo);
        this.getFillControl().setFill(fileBillCtrl.isEnable());
        if (fileBillCtrl.isCtrlByTime()) {
            this.getFillControl().setFillByTimeCtl(fileBillCtrl.isCtrlByTime());
            this.getFillControl().setFillByTimeAmount(BigDecimal.valueOf(fileBillCtrl.getTimeCtrlVal()));
            this.getFillControl().setFillByTimeAmountUnit(FillAmountUnitEnum.getEnum(fileBillCtrl.getTimeCtrlUnit().getValue()));
        }
        if (fileBillCtrl.isCtrlByPeriod()) {
            this.getFillControl().setFillByCycleCtrl(fileBillCtrl.isCtrlByPeriod());
            this.getFillControl().setFillByCycleAmount(BigDecimal.valueOf(fileBillCtrl.getPeriodCtrlVal()));
            this.getFillControl().setFillByCycleAmountUnit(FillAmountUnitEnum.getEnum(fileBillCtrl.getPeriodCtrlUnit().getValue()));
            this.getFillControl().setFillCycleType(AttencePolicyCycleTypeEnum.getEnum(fileBillCtrl.getPeriodCtrlType().getValue() + 1));
        }
    }

    protected AttencePolicyInfo getAttencePolicy() throws EASBizException, BOSException {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("attencePolicy.attenceCycle");
            evi.getSelector().add("attencePolicy.atsFileBillCtrl.*");
            evi.getSelector().add("attencePolicy.workCalendar");
            evi.getSelector().add("calendar");
            FilterInfo filterInfo = new FilterInfo();
            evi.setFilter(filterInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)this.atsFileBillentryInfo.getPerson().getString("id"), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("effdt", (Object)this.getCycleControlValidateDate(), CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("leffdt", (Object)this.getCycleControlValidateDate(), CompareType.GREATER_EQUALS));
            IAttendanceFileHIS iAttendanceFileHIS = AttendanceFileHISFactory.getLocalInstance(this.getCtx());
            AttendanceFileHISInfo attendanceFileHISInfo = iAttendanceFileHIS.getAttendanceFileHISInfo(evi.toString());
            AttencePolicyInfo attencePolicy = attendanceFileHISInfo.getAttencePolicy();
            attencePolicy.setWorkCalendar(attendanceFileHISInfo.getCalendar());
            return attencePolicy;
        }
        catch (BOSException e) {
            String oql = "select name where id='" + this.atsFileBillentryInfo.getPerson().getString("id") + "'";
            PersonInfo p = (PersonInfo)PersonFactory.getLocalInstance((Context)this.getCtx()).getValue(oql);
            if (e.getMessage() != null && e.getMessage().contains("TooManyRecord")) {
                throw new AtsFileBizException(AtsFileBizException.MULTIATSFILE, e, new Object[]{p.getName()});
            }
            throw new AtsFileBizException(AtsFileBizException.NOTEXISTHFILE, e, new Object[]{p.getName()});
        }
    }

    public AtsFileBillEntryInfo getAtsFileBillentryInfo() {
        return this.atsFileBillentryInfo;
    }

    public AtsFileBillSupplyCtrl setAtsFileBillentryInfo(AtsFileBillEntryInfo atsFileBillentryInfo) {
        this.atsFileBillentryInfo = atsFileBillentryInfo;
        return this;
    }

    @Override
    public void buildParam(FillControlDto dto) {
    }

    @Override
    protected StringBuffer getBilltypeStr() {
        return null;
    }
}

