/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.fillControl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AbstractAttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyCycleTypeEnum;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodCollection;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.fillControl.IFillControl;
import com.kingdee.eas.hr.ats.fillControl.dto.FillControl;
import com.kingdee.eas.hr.ats.fillControl.util.AtsFillControlUtils;
import com.kingdee.eas.hr.ats.fillControl.vo.FillControlVO;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public abstract class FillControlCommon
implements IFillControl {
    private Context ctx;
    private AttencePolicyInfo attencePolicyInfo;
    private FillControl fillControl;
    private StringBuffer billString;
    private FillControlVO result;

    private FillControlCommon() {
    }

    public FillControlCommon(Context ctx) {
        this.ctx = ctx;
        this.setFillControl(new FillControl());
        this.setResult(new FillControlVO());
    }

    @Override
    public void control() {
        this.judgeAndInit();
        if (!this.getFillControl().isFill()) {
            return;
        }
        boolean controlResult = true;
        if (this.getFillControl().isFillByTimeCtl()) {
            controlResult = this.validateByTimeControle(this.getTimeControlValidateDate());
        }
        if (this.getFillControl().isFillByCycleCtrl() && controlResult) {
            controlResult = this.validateByCycleControle(this.getCycleControlValidateDate());
        }
        this.buildResult(controlResult);
    }

    protected void judgeAndInit() {
    }

    protected boolean validateByTimeControle(Date attendDate) {
        boolean retValue = true;
        FillAmountUnitEnum unit = this.getFillControl().getFillByTimeAmountUnit();
        BigDecimal amount = this.getFillControl().getFillByTimeAmount();
        Date applyDate = this.getFillControl().getApplyDate();
        if (amount == null || unit == null) {
            return true;
        }
        Calendar applyDateCal = Calendar.getInstance();
        if (applyDate != null) {
            applyDateCal.setTime(applyDate);
        }
        int amountIntValue = amount.intValue();
        if (unit == FillAmountUnitEnum.year) {
            applyDateCal.set(1, applyDateCal.get(1) - amountIntValue);
        } else if (unit == FillAmountUnitEnum.month) {
            applyDateCal.set(2, applyDateCal.get(2) - amountIntValue);
        } else if (unit == FillAmountUnitEnum.day) {
            applyDateCal.set(5, applyDateCal.get(5) - amountIntValue);
        } else {
            if (unit == FillAmountUnitEnum.daywork) {
                return this.getWorkDayCount(attendDate, applyDate) <= amountIntValue;
            }
            return this.validateByTimeControleExt();
        }
        applyDate = AtsDateUtils.dateShortFormatToDate(applyDateCal.getTime());
        if (attendDate.getTime() < applyDate.getTime()) {
            retValue = false;
        }
        return retValue;
    }

    protected boolean validateByTimeControleExt() {
        return true;
    }

    protected int getWorkDayCount(Date attendDate, Date applyDate) {
        int workDayCount = 0;
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("dayType", (Object)0));
            filterInfo.getFilterItems().add(new FilterItemInfo("calendarGroup", (Object)this.getAttencePolicyInfo().getWorkCalendar().getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("DATE", (Object)AtsDateUtils.dateShortFormatToDate(attendDate), CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("DATE", (Object)applyDate, CompareType.LESS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            workDayCount = WorkCalendarItemFactory.getLocalInstance(this.getCtx()).getCount(evi);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.buildResult(MLUtile.getRes(AtsAttenceCycleResEnum.NotExistsCycle, this.getCtx()) + "!");
        }
        return workDayCount;
    }

    protected Date getTimeControlValidateDate() {
        return this.getFillControl().isUseStartTimeOnTimeCtrl() ? this.getFillControl().getStartTime() : this.getFillControl().getEndTime();
    }

    protected Date getCycleControlValidateDate() {
        return this.getFillControl().isUseStartTimeOnCycleCtrl() ? this.getFillControl().getStartTime() : this.getFillControl().getEndTime();
    }

    protected boolean validateByCycleControle(Date attenDate) {
        long attendDateTime = attenDate.getTime();
        int amount = this.getFillControl().getFillByCycleAmount().intValue();
        Calendar applyDate = Calendar.getInstance();
        if (this.getFillControl().getApplyDate() != null) {
            applyDate.setTime(this.getFillControl().getApplyDate());
        }
        boolean retValue = AttencePolicyCycleTypeEnum.naturalMonth.equals((Object)this.getFillControl().getFillCycleType()) ? this.validateNaturalMonthByCycleControl(attendDateTime, applyDate, amount) : (AttencePolicyCycleTypeEnum.attendanceCycle.equals((Object)this.getFillControl().getFillCycleType()) ? this.validateAttendanceCycleByCycleControl(attendDateTime, applyDate, amount) : this.validateAttendanceCycleByExt(attendDateTime, applyDate, amount));
        return retValue;
    }

    protected boolean validateAttendanceCycleByExt(long attendDateTime, Calendar applyDate, int amount) {
        return true;
    }

    protected boolean validateAttendanceCycleByCycleControl(long attendDateTime, Calendar applyDate, int amount) {
        boolean retValue = FillAmountUnitEnum.mouthEndDay.equals((Object)this.getFillControl().getFillByCycleAmountUnit()) ? this.validateCycleControlByMonthEndDay(attendDateTime, applyDate, amount) : (FillAmountUnitEnum.day.equals((Object)this.getFillControl().getFillByCycleAmountUnit()) ? this.validateCycleControlByNaturalday(attendDateTime, applyDate, amount) : (FillAmountUnitEnum.daywork.equals((Object)this.getFillControl().getFillByCycleAmountUnit()) ? this.validateCycleControlByWorkday(attendDateTime, applyDate, amount) : this.validateAttendanceCycleByCycleControlExt()));
        return retValue;
    }

    protected boolean validateCycleControlByMonthEndDay(long attendDateTime, Calendar applyDate, int amount) {
        Boolean ok = false;
        try {
            String attenceCycleId = this.getAttencePolicyInfo().getAttenceCycle().getId().toString();
            String theDate = AtsDateUtils.dateLongToString(new Date(attendDateTime));
            ok = AttencePolicyFillUtil.validMonthlyStatementDateByAttencecycle(this.getCtx(), attenceCycleId, amount, theDate, applyDate.getTime());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        boolean retValue = null != ok && ok != false;
        return retValue;
    }

    protected boolean validateCycleControlByNaturalday(long attendDateTime, Calendar applyDate, int amount) {
        return this.validateAttendanceCycleByCycleControlOld(attendDateTime, applyDate, amount);
    }

    protected boolean validateCycleControlByWorkday(long attendDateTime, Calendar applyDate, int amount) {
        String workCalendarId = this.getAttencePolicyInfo().getWorkCalendar().getId().toString();
        int daysBetweenTwoDate = AtsFillControlUtils.getRealDayCountFromWorkWorkCalendar(this.getCtx(), workCalendarId, this.getFillControl().getApplyDate(), amount);
        boolean retValue = this.validateAttendanceCycleByCycleControlOld(attendDateTime, applyDate, daysBetweenTwoDate);
        return retValue;
    }

    protected boolean validateAttendanceCycleByCycleControlOld(long attendDateTime, Calendar applyDate, int amount) {
        boolean retValue = true;
        if (null != this.getAttencePolicyInfo() && this.getAttencePolicyInfo().getAttenceCycle() != null && this.getAttencePolicyInfo().getAttenceCycle().getId() != null) {
            AttendancePeriodInfo curPeriod;
            String attendanceCycleId = this.getAttencePolicyInfo().getAttenceCycle().getId().toString();
            AttendancePeriodCollection attendancePeriodCollection = null;
            try {
                attendancePeriodCollection = AttendancePeriodFactory.getLocalInstance(this.getCtx()).getAttendancePeriodCollection(" where group.id = '" + attendanceCycleId + "' order by endDate DESC");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (attendancePeriodCollection == null || attendancePeriodCollection.size() == 0) {
                this.setBillString(MLUtile.getRes(AtsAttenceCycleResEnum.LeakToCompleteAudit, this.getCtx()) + "!");
                return false;
            }
            AbstractAttendancePeriodInfo prePeriod = null;
            int preIndex = 0;
            for (int j = 0; j < attendancePeriodCollection.size(); ++j) {
                AttendancePeriodInfo attendancePeriodInfo = attendancePeriodCollection.get(j);
                if (attendancePeriodInfo.getEndDate().getTime() > applyDate.getTime().getTime()) continue;
                prePeriod = attendancePeriodCollection.get(j);
                preIndex = j;
                break;
            }
            AttendancePeriodInfo attendancePeriodInfo = curPeriod = preIndex - 1 >= 0 ? attendancePeriodCollection.get(preIndex - 1) : null;
            if (prePeriod != null) {
                Date currDate;
                Date curPeriodStartDate;
                Date startDate = prePeriod.getStartDate();
                Date endDate = prePeriod.getEndDate();
                Date addAfterDate = AtsDateUtils.dateAdd(endDate, 3, amount, false);
                Date date = curPeriodStartDate = curPeriod != null ? curPeriod.getStartDate() : null;
                if (curPeriod != null && addAfterDate.getTime() > curPeriod.getEndDate().getTime()) {
                    addAfterDate = curPeriod.getEndDate();
                }
                if ((currDate = AtsDateUtils.dateShortFormatToDate(applyDate.getTime())).getTime() > addAfterDate.getTime()) {
                    if (curPeriodStartDate != null && attendDateTime < curPeriodStartDate.getTime()) {
                        retValue = false;
                    }
                } else if (attendDateTime < startDate.getTime()) {
                    retValue = false;
                }
            }
        } else {
            Date monthFirstDay;
            if (applyDate.get(5) <= amount) {
                applyDate.set(2, applyDate.get(2) - 1);
            }
            if (attendDateTime < (monthFirstDay = AtsDateUtils.getMonthFirstDay(applyDate.getTime())).getTime()) {
                retValue = false;
            }
        }
        return retValue;
    }

    protected boolean validateAttendanceCycleByCycleControlExt() {
        return true;
    }

    protected boolean validateNaturalMonthByCycleControl(long attendDateTime, Calendar applyDate, int amount) {
        if (FillAmountUnitEnum.daywork == this.getFillControl().getFillByCycleAmountUnit()) {
            Calendar lastDateCal = Calendar.getInstance();
            lastDateCal.setTime(this.getCycleControlValidateDate());
            lastDateCal.set(5, lastDateCal.getActualMaximum(5));
            return this.getWorkDayCount(lastDateCal.getTime(), applyDate.getTime()) <= amount;
        }
        int dayOfMonth = applyDate.get(5);
        if (dayOfMonth <= amount) {
            applyDate.set(2, applyDate.get(2) - 1);
        }
        return attendDateTime >= AtsDateUtils.getMonthFirstDay(applyDate.getTime()).getTime();
    }

    protected abstract StringBuffer getBilltypeStr();

    protected void buildResult(boolean ok) {
        this.getResult().setSuccess(ok);
        this.getResult().setMessage(ok ? "" : this.getBillString().toString());
        this.buildResultExt(ok);
    }

    private void buildResultExt(boolean ok) {
    }

    @Override
    public FillControlVO getResult() {
        return this.result;
    }

    protected void buildResult(String errorString) {
        this.setBillString(errorString);
    }

    protected void appendResult(String errorString) {
        this.getBillString().append(errorString);
    }

    public void setAttencePolicyInfo(AttencePolicyInfo attencePolicyInfo) {
        assert (attencePolicyInfo != null);
        assert (attencePolicyInfo.getAttenceCycle() != null);
        assert (attencePolicyInfo.getAttenceCycle().getId() != null);
        this.attencePolicyInfo = attencePolicyInfo;
    }

    public AttencePolicyInfo getAttencePolicyInfo() {
        return this.attencePolicyInfo;
    }

    public FillControl getFillControl() {
        return this.fillControl;
    }

    public void setFillControl(FillControl fillControl) {
        this.fillControl = fillControl;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public StringBuffer getBillString() {
        return this.billString;
    }

    public void setBillString(String billString) {
        this.billString = new StringBuffer(billString);
    }

    public void setBillString(StringBuffer billString) {
        this.billString = billString;
    }

    public void setResult(FillControlVO result) {
        this.result = result;
    }

    public void setAttencePolicyWorkCalendarId(String workCalendarId) {
        if (StringUtils.isNotBlank((String)workCalendarId)) {
            this.getAttencePolicyInfo().getWorkCalendar().setId(BOSUuid.read((String)workCalendarId));
        }
    }
}

