/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AtsOverTimeBillMobileHelper {
    public static final String COMPENSATION_DAY_ID = "+ZM5jTmrS0KHCjDSYGcFLf0tUpg=";

    public Map<String, Object> checkMaxQuotaCore(Context ctx, String personId, String otDate, double currentValue) throws BOSException {
        boolean resFlag = true;
        String resMsg = "";
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("maxQuota", "");
        res.put("totalQuota", "");
        double totalQuota = this.getTotalQuota(ctx, personId, otDate);
        Map<String, String> maxQuotaMap = this.getMaxQuotaMap(ctx, personId);
        boolean maxQuotaFlag = Boolean.parseBoolean(maxQuotaMap.get("resFlag"));
        int unit = Integer.parseInt(maxQuotaMap.get("unit"));
        int unitConvertRule = Integer.parseInt(maxQuotaMap.get("unitConvertRule"));
        double dayHour = 0.0;
        if (unitConvertRule == 2) {
            dayHour = Double.parseDouble(maxQuotaMap.get("fixedHour"));
        } else {
            ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, otDate);
            if (null != scheduleShiftInfo) {
                dayHour = scheduleShiftInfo.getStandardHour().doubleValue();
            } else {
                AttendanceFileHISCollection hisColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection("select *, atsShift.* where proposer.id ='" + personId + "' and EFFDT <= {ts '" + otDate + "'} and LEFFDT >= {ts '" + otDate + "'}");
                if (hisColl != null && hisColl.size() > 0) {
                    AttendanceFileHISInfo his = hisColl.get(0);
                    dayHour = his.getAtsShift().getStandardHour().doubleValue();
                }
            }
        }
        if (maxQuotaFlag) {
            if (!"".equals(maxQuotaMap.get("maxTotalQuota")) && maxQuotaMap.get("maxTotalQuota") != null) {
                double maxQuota = Double.parseDouble(maxQuotaMap.get("maxTotalQuota"));
                if (unit == 1) {
                    currentValue = BigDecimal.valueOf(currentValue / dayHour).setScale(2, 4).doubleValue();
                }
                if (maxQuota == 0.0 || totalQuota + currentValue <= maxQuota) {
                    resFlag = true;
                } else {
                    resFlag = false;
                    resMsg = unit == 1 ? MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.ForbidOTBillForOverMaxDay, ctx, totalQuota + currentValue, "\uff08" + totalQuota + "+" + currentValue + "\uff09", maxQuota) : MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.ForbidOTBillForOverMaxHour, ctx, totalQuota + currentValue, "\uff08" + totalQuota + "+" + currentValue + "\uff09", maxQuota);
                    res.put("maxQuota", "" + maxQuota);
                    res.put("totalQuota", "" + totalQuota);
                }
            } else {
                resFlag = false;
                resMsg = MLUtile.getRes(AtsHolidayResEnum.NullMaxSumLimit, ctx);
            }
        } else {
            resFlag = false;
            resMsg = MLUtile.getRes(AtsHolidayResEnum.NoAtsTakeWorking, ctx);
        }
        res.put("resFlag", resFlag);
        res.put("resMsg", resMsg);
        return res;
    }

    public double getTotalQuota(Context ctx, String personId, String otDate) {
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT TO_NUMBER(SUM(A.FremainLimit)) remainLimit  ").append("   FROM T_HR_ATS_HolidayLimit A  ").append("   LEFT OUTER JOIN T_HR_ATS_HolidayPolicy B  ").append("   ON A.FHOLIDAYPOLICYID=B.FID  ").append("  WHERE B.FHOLIDAYTYPEID = '+ZM5jTmrS0KHCjDSYGcFLf0tUpg='").append("    AND A.FStatus = '1'  ").append("    AND A.FPROPOSERID='" + personId + "'  ");
        if (!otDate.equals("")) {
            sql.append("  AND A.FEffectDate <= {ts '" + otDate + "'} ");
            sql.append("  AND A.FDelayDate >= {ts '" + otDate + "'} ");
        }
        double resTotalQuota = 0.0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                rowSet.next();
                resTotalQuota = rowSet.getDouble("remainLimit");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException s) {
            s.printStackTrace();
        }
        return resTotalQuota;
    }

    public Map<String, String> getMaxQuotaMap(Context ctx, String personId) {
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT D.fixedHour,D.funitConvertRule,D.FMAXTOTALQUOTA,C.FUnit ").append("   FROM T_HR_ATS_AtsHolidayFile A  ").append("   LEFT OUTER JOIN T_HR_ATS_HolidayPolicySet B  ").append("    ON A.FHolidayPolicySetID = B.FID  ").append("   LEFT OUTER JOIN T_HR_ATS_HolidayPolicy C  ").append("     ON B.FID = C.Fholidaypolicysetid  ").append("   LEFT OUTER JOIN T_HR_ATS_TakeWorking D  ").append("     ON FTakeWorkingRuleID = D.FID  ").append("  WHERE A.FPROPOSERID = '" + personId + "'  ").append("    AND C.FHOLIDAYTYPEID = '+ZM5jTmrS0KHCjDSYGcFLf0tUpg='  ");
        HashMap<String, String> resData = new HashMap<String, String>();
        resData.put("maxTotalQuota", "");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                rowSet.next();
                if (null != rowSet.getString("fmaxtotalquota")) {
                    resData.put("resFlag", "true");
                    resData.put("maxTotalQuota", rowSet.getString("fmaxtotalquota"));
                    resData.put("unit", rowSet.getInt("FUnit") + "");
                    resData.put("unitConvertRule", rowSet.getInt("funitConvertRule") + "");
                    if (rowSet.getBigDecimal("FixedHour") != null) {
                        resData.put("fixedHour", rowSet.getBigDecimal("FixedHour").doubleValue() + "");
                    } else {
                        resData.put("fixedHour", "0");
                    }
                }
            } else {
                resData.put("resFlag", "false");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resData;
    }

    public Map<String, Object> isWorkTime(Context ctx, String personId, String overTimeBegin, String overTimeEnd, String overDate) throws BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Boolean isWorkTime = false;
        if (overTimeBegin.trim().length() != 19) {
            overTimeBegin = overTimeBegin.substring(0, 19);
        }
        if (overTimeEnd.trim().length() != 19) {
            overTimeEnd = overTimeEnd.substring(0, 19);
        }
        Timestamp overTimeBeginTS = HRTimeWebUtils.stringToTimestamp(overTimeBegin);
        Timestamp overTimeEndTS = HRTimeWebUtils.stringToTimestamp(overTimeEnd);
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, overDate);
        if (null != scheduleShiftInfo) {
            ScheduleShiftItemCollection scheduleShiftItemColl = scheduleShiftInfo.getItems();
            for (int i = 0; i < scheduleShiftItemColl.size(); ++i) {
                int dayType;
                if (!scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("1") && !scheduleShiftItemColl.get(i).getAttendanceType().getValue().equals("3") || 0 != (dayType = scheduleShiftInfo.getDayType().getValue())) continue;
                if (scheduleShiftItemColl.get(i).getPreDateTime() == null || scheduleShiftItemColl.get(i).getNextDateTime() == null) {
                    isWorkTime = true;
                    continue;
                }
                if (scheduleShiftItemColl.get(i).getPreDateTime().compareTo(overTimeEndTS) != -1 || scheduleShiftItemColl.get(i).getNextDateTime().compareTo(overTimeBeginTS) != 1) continue;
                isWorkTime = true;
            }
        }
        res.put("isWorkTime", isWorkTime);
        return res;
    }

    public Map<String, Object> checkDuplicate(Context ctx, String personId, String overTimeBegin, String overTimeEnd, String overDate, String billId) throws BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        StringBuilder ksqlSB = new StringBuilder();
        String billStateString = "1,2,3";
        ksqlSB.append(" select m.fid,m.fnumber,m.fbillstate,e.fstarttime,e.fendtime,e.fpersonid,p.fname" + MLUtile.getMlFlag(ctx) + " name,e.FCREATETAG \n").append("   from T_HR_ATS_OverTimeBillEntry e  \n").append("   inner join T_HR_ATS_OverTimeBill m on  e.fbillid=m.fid  \n").append("   left join T_BD_Person p on e.fpersonid= p.fid \n").append("   where  \n").append("   m.fbillstate in (" + billStateString + ") \n");
        if (!StringUtils.isEmpty((CharSequence)billId)) {
            ksqlSB.append(" and m.fid != '" + billId + "' ");
        }
        ksqlSB.append("   and e.FCREATETAG !='2' ").append("   and e.FCREATETAG !='3' ").append("   and ( \n").append("   ( e.fstarttime<? and e.fendtime>? and e.fpersonid=? )      \n").append("   ) \n");
        String resMsg = "";
        try {
            Object[] params = new Object[]{HRTimeWebUtils.stringToTimestamp(overTimeEnd), HRTimeWebUtils.stringToTimestamp(overTimeBegin), personId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksqlSB.toString(), (Object[])params);
            if (rs != null && rs.size() > 0 && rs.next()) {
                resMsg = MLUtile.getRes((ResourceEnum)AtsOverTimeBillResEnum.ExistsOverlapTimeInOTBill, ctx, rs.getString("fnumber"), rs.getString("name") + "," + HRTimeWebUtils.dateLongToString(rs.getDate("fstarttime")) + "," + HRTimeWebUtils.dateLongToString(rs.getDate("fendtime"))) + "<br/>";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        res.put("resMsg", resMsg);
        return res;
    }

    public Map<String, Object> isExistsAttanceFile(Context ctx, String personId, String overTimeBegin, String overTimeEnd, String overDate) throws BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String resMsg = "";
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (StringUtils.isNotEmpty((CharSequence)personId)) {
            fi.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)personId, CompareType.EQUALS));
        }
        evi.setFilter(fi);
        AttendanceFileCollection attendanceFileCollection = null;
        try {
            attendanceFileCollection = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (attendanceFileCollection == null || attendanceFileCollection.size() == 0) {
            resMsg = MLUtile.getRes(AtsFileResEnum.NotExistFile, ctx);
        }
        res.put("resMsg", resMsg);
        return res;
    }

    public Map<String, Object> isHaveEffectiveFile(Context ctx, String personId, String overTimeBegin, String overTimeEnd, String overDate) throws BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String resMsg = "";
        AttendanceFileCollection attendanceFileColl = new AttendanceFileCollection();
        try {
            attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (attendanceFileColl.size() == 0) {
            resMsg = MLUtile.getRes(AtsFileResEnum.NotExistFile, ctx);
        }
        res.put("resMsg", resMsg);
        return res;
    }
}

