/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.metasBuilder;

import com.kingdee.eas.hr.ats.metasBuilder.IMetasBuilder;
import com.kingdee.eas.hr.ats.metasBuilder.MetasType;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public abstract class MetasBuilder
implements IMetasBuilder {
    protected String javaPublishPath;
    protected String MetasPublishPath;
    protected MetasType metasType;
    protected String packageName;
    protected String name;
    protected String alias;
    protected String anchorName;
    protected String descripe;
    protected Map<String, String> allResource = new HashMap<String, String>();
    private static Properties charactors = new Properties();

    public static String convertWords(String simple) {
        if (StringUtils.isBlank((String)simple)) {
            return null;
        }
        StringBuffer returnData = new StringBuffer();
        if (charactors.get(simple) != null) {
            return charactors.get(simple).toString();
        }
        for (int i = 0; i < simple.length(); ++i) {
            String charStr = String.valueOf(simple.charAt(i));
            if (charactors.get(charStr) != null) {
                returnData.append(charactors.get(charStr));
                continue;
            }
            returnData.append(charStr);
        }
        return returnData.toString();
    }

    @Override
    public void build() throws IOException, DocumentException {
        this.init();
        Element metasDoc = this.buildMetasDoc();
        this.buildTitle(metasDoc);
        this.buildBody(metasDoc);
        this.buildResource(metasDoc);
        this.writeMetas(metasDoc);
        this.buildPropertiesFile(this.getPropertiesMap(metasDoc));
        this.writeJavaFile(metasDoc);
    }

    protected void init() {
        this.anchorName = (Object)((Object)this.metasType) + "[" + this.packageName + "." + this.name + "].";
    }

    protected String getJavaFileContent(Element metasEle) {
        return null;
    }

    protected StringBuffer buildJavaFileDesc(StringBuffer file, Element metasEle) {
        List rsList;
        String descriptionKey;
        if (metasEle.getDocument() == null || metasEle.getDocument().getRootElement() == null) {
            return file;
        }
        Element description = metasEle.getDocument().getRootElement().element("description");
        String string = descriptionKey = description == null ? null : description.getText();
        if (StringUtils.isBlank((String)descriptionKey)) {
            return file;
        }
        Element resource = metasEle.getDocument().getRootElement().element("resource");
        List list = rsList = resource == null ? null : resource.elements("rs");
        if (rsList == null || rsList.size() == 0) {
            return file;
        }
        String localeFlag = "zh_CN";
        block0: for (Object rs : rsList) {
            if (!(rs instanceof Element) || !descriptionKey.equals(((Element)rs).attributeValue("key"))) continue;
            for (Object lang : ((Element)rs).elements("lang")) {
                if (!(lang instanceof Element) || !localeFlag.equals(((Element)lang).attributeValue("locale"))) continue;
                file.append("/**\r\n *").append(((Element)lang).attributeValue("value")).append("\r\n */\r\n");
                continue block0;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJavaFile(Element metasEle) {
        String content = this.getJavaFileContent(metasEle);
        if (StringUtils.isBlank((String)content)) {
            return;
        }
        String publishPath = this.javaPublishPath + "/" + this.packageName.replaceAll("\\.", "/");
        File javaFile = new File(publishPath);
        if (!javaFile.exists()) {
            javaFile.mkdirs();
        }
        FileWriterWithEncoding fileWriter = null;
        try {
            fileWriter = new FileWriterWithEncoding(new File(publishPath + "/" + this.name + ".java"), "GBK");
            fileWriter.write(content);
            fileWriter.flush();
            this.closeIO((Closeable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.closeIO((Closeable)fileWriter);
        }
    }

    protected void closeIO(Closeable io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void buildPropertiesFile(Map<String, String> propertiesRes) {
        Properties stand = new Properties();
        Properties en_US = new Properties();
        Properties zh_CN = new Properties();
        Properties zh_HK = new Properties();
        if (propertiesRes == null) {
            return;
        }
        for (String key : propertiesRes.keySet()) {
            stand.put(key, propertiesRes.get(key));
            zh_CN.put(key, propertiesRes.get(key));
            en_US.put(key, "value_new");
            zh_HK.put(key, MetasBuilder.convertWords(propertiesRes.get(key)));
        }
        String publishPath = this.javaPublishPath + "/" + this.packageName.replaceAll("\\.", "/");
        publishPath = publishPath + "/" + this.name;
        this.writePropertyFile(stand, publishPath + ".properties");
        this.writePropertyFile(zh_CN, publishPath + "_l2.properties");
        this.writePropertyFile(en_US, publishPath + "_l1.properties");
        this.writePropertyFile(zh_HK, publishPath + "_l3.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writePropertyFile(Properties properties, String filePath) {
        block8: {
            FileOutputStream fio = null;
            try {
                File file = new File(filePath.substring(0, filePath.lastIndexOf("/")));
                if (!file.exists()) {
                    file.mkdirs();
                }
                fio = new FileOutputStream(filePath);
                properties.store(fio, "");
                this.closeIO(fio);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeIO(fio);
            }
        }
    }

    protected void buildTitleInner(Element parentElement) {
    }

    protected abstract void buildBodyInner(Element var1);

    protected void buildResourceInner(Element parentElement) {
    }

    protected Map<String, String> getPropertiesMap(Element metasEle) {
        HashMap<String, String> returnData = new HashMap<String, String>();
        if (metasEle == null || metasEle.getDocument() == null || metasEle.getDocument().getRootElement() == null) {
            return returnData;
        }
        Element rootEle = metasEle.getDocument().getRootElement();
        Element resource = rootEle.element("resource");
        if (resource == null || resource.elements() == null) {
            return returnData;
        }
        block0: for (Object rsObj : resource.elements()) {
            Element item = (Element)rsObj;
            String key = item.attributeValue("key");
            int keyStart = key.indexOf("[");
            if ((keyStart = key.indexOf("[", keyStart + 1)) == -1) continue;
            for (Object langObj : item.elements()) {
                Element lang = (Element)langObj;
                if (!StringUtils.equals((String)lang.attributeValue("locale"), (String)"zh_CN")) continue;
                returnData.put(key.substring(keyStart + 1, key.lastIndexOf("]")), lang.attributeValue("value"));
                continue block0;
            }
        }
        return returnData;
    }

    protected Element buildMetasDoc() {
        String path = this.MetasPublishPath.split(",")[0];
        String publishPath = path + "/" + this.packageName.replaceAll("\\.", "/");
        publishPath = publishPath + "/" + this.name + "." + this.metasType.getValue();
        File metaFile = new File(publishPath);
        Element head = null;
        if (metaFile.exists()) {
            try {
                Document metasDoc = new SAXReader().read(metaFile);
                head = metasDoc.getRootElement();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Document metasDoc = DocumentHelper.createDocument();
            head = metasDoc.addElement(this.metasType.toString());
            head.addAttribute("xmlns", "com.kingdee.bos.metadata");
        }
        return head;
    }

    protected MetasBuilder validateTitle(Element parentElement, String name, String text) {
        Element editEle = parentElement.element(name);
        if (editEle == null) {
            editEle = parentElement.addElement(name);
        }
        if (!StringUtils.isBlank((String)text)) {
            editEle.setText(text);
        }
        if (StringUtils.isBlank((String)editEle.getText())) {
            throw new IllegalArgumentException(name + " is required");
        }
        return this;
    }

    protected void buildTitle(Element parentElement) {
        this.validateTitle(parentElement, "package", this.packageName);
        this.validateTitle(parentElement, "name", this.name);
        this.validateTitle(parentElement, "alias", this.anchorName + "alias");
        this.validateTitle(parentElement, "description", this.anchorName + "description");
        this.validateTitle(parentElement, "userDefined", "false");
        this.validateTitle(parentElement, "className", this.packageName + "." + this.name);
        this.addResourceItem("alias", this.alias);
        this.addResourceItem("description", this.descripe);
        this.buildTitleInner(parentElement);
    }

    protected void buildBody(Element parentElement) {
        this.buildBodyInner(parentElement);
    }

    protected void addResourceItem(String field, String name) {
        this.allResource.put(field, name);
    }

    protected Element buildResource(Element parentElement) {
        Element resource = parentElement.element("resource");
        if (resource == null) {
            resource = parentElement.addElement("resource");
        }
        for (String key : this.allResource.keySet()) {
            this.buildResourceItem(resource, key, this.allResource.get(key));
        }
        this.buildResourceInner(parentElement);
        return resource;
    }

    protected Element buildResourceItem(Element resourceParent, String filedName, String simpleChinese) {
        Element curResourceItem = null;
        for (Object resourceItem : resourceParent.elements("rs")) {
            if (resourceItem == null || !StringUtils.equals((String)((Element)resourceItem).attributeValue("key"), (String)(this.anchorName + filedName))) continue;
            curResourceItem = (Element)resourceItem;
            break;
        }
        if (StringUtils.isBlank((String)simpleChinese)) {
            return null;
        }
        Element resources = resourceParent.getParent();
        if (resources != null) {
            resources.remove(resourceParent);
            resources.add(resourceParent);
        }
        if (curResourceItem != null) {
            for (Object child : curResourceItem.elements("lang").toArray()) {
                curResourceItem.remove((Element)child);
            }
        } else {
            curResourceItem = resourceParent.addElement("rs");
            curResourceItem.addAttribute("key", this.anchorName + filedName);
        }
        curResourceItem.addElement("lang").addAttribute("locale", "en_US").addAttribute("value", "null");
        curResourceItem.addElement("lang").addAttribute("locale", "zh_CN").addAttribute("value", simpleChinese);
        curResourceItem.addElement("lang").addAttribute("locale", "zh_HK").addAttribute("value", MetasBuilder.convertWords(simpleChinese));
        curResourceItem.addElement("lang").addAttribute("locale", "zh_TW").addAttribute("value", MetasBuilder.convertWords(simpleChinese));
        return curResourceItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMetas(Element parentElement) throws IOException, DocumentException {
        Document metasDoc = parentElement.getDocument();
        if (metasDoc == null || StringUtils.isBlank((String)this.MetasPublishPath)) {
            return;
        }
        OutputFormat outputFormat = OutputFormat.createCompactFormat();
        outputFormat.setEncoding("UTF-8");
        outputFormat.setNewlines(true);
        outputFormat.setIndent("   ");
        for (String path : this.MetasPublishPath.split(",")) {
            String publishPath = path + "/" + this.packageName.replaceAll("\\.", "/");
            File file = new File(SHRCheck.checkFilePath((String)publishPath));
            if (!file.exists()) {
                file.mkdirs();
            }
            publishPath = publishPath + "/" + this.name + "." + this.metasType.getValue();
            XMLWriter write = null;
            try {
                write = new XMLWriter((Writer)new FileWriter(SHRCheck.checkFilePath((String)publishPath)), outputFormat);
                write.write(metasDoc);
            }
            finally {
                if (write != null) {
                    try {
                        write.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getJavaPublishPath() {
        return this.javaPublishPath;
    }

    public void setJavaPublishPath(String javaPublishPath) {
        this.javaPublishPath = javaPublishPath;
    }

    public String getMetasPublishPath() {
        return this.MetasPublishPath;
    }

    public void setMetasPublishPath(String metasPublishPath) {
        this.MetasPublishPath = metasPublishPath;
    }

    public MetasType getMetasType() {
        return this.metasType;
    }

    public void setMetasType(MetasType metasType) {
        this.metasType = metasType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public void setAnchorName(String anchorName) {
        this.anchorName = anchorName;
    }

    public String getDescripe() {
        return this.descripe;
    }

    public void setDescripe(String descripe) {
        this.descripe = descripe;
    }

    public Map<String, String> getAllResource() {
        return this.allResource;
    }

    public void setAllResource(Map<String, String> allResource) {
        this.allResource = allResource;
    }

    public String toString() {
        return "MetasBuilder [metasType=" + (Object)((Object)this.metasType) + ", packageName=" + this.packageName + ", alias=" + this.alias + ", anchorName=" + this.anchorName + ", descripe=" + this.descripe + "]";
    }

    static {
        try {
            charactors = SHRSyssettingUtil.getPropertiesFileByPath((String)SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"s2t.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

