/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.metasBuilder;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.hr.ats.metasBuilder.MetasBuilder;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class ResMetasBuilder
extends MetasBuilder {
    protected JSONObject bosResourceItems;

    @Override
    protected void buildBodyInner(Element parentElement) {
        if (this.bosResourceItems == null) {
            return;
        }
        Element bosResourceItemsParent = parentElement.element("resourceItems");
        if (bosResourceItemsParent == null) {
            bosResourceItemsParent = parentElement.addElement("resourceItems");
        }
        TreeMap<String, Element> allRes = new TreeMap<String, Element>();
        for (Object item : bosResourceItemsParent.elements()) {
            Element itemEle = (Element)item;
            allRes.put(itemEle.elementText("name"), itemEle);
        }
        for (String item : this.bosResourceItems.keySet()) {
            Element bosResourceItem = (Element)allRes.get(item);
            if (bosResourceItem == null) {
                bosResourceItem = bosResourceItemsParent.addElement("resourceItem");
                bosResourceItem.addElement("name").setText(item);
                String fieldName = "resourceItems.resourceItem[" + item + "].value";
                bosResourceItem.addElement("value").setText(this.anchorName + fieldName);
                this.addResourceItem(fieldName, this.bosResourceItems.getString(item));
            }
            bosResourceItem.setParent(null);
            allRes.put(item, bosResourceItem);
        }
        parentElement.remove(bosResourceItemsParent);
        bosResourceItemsParent = parentElement.addElement("resourceItems");
        for (Element ele : allRes.values()) {
            ele.setParent(null);
            bosResourceItemsParent.add(ele);
        }
    }

    @Override
    protected String getJavaFileContent(Element metasEle) {
        StringBuffer file = new StringBuffer();
        file.append("package ").append(this.packageName).append(";\r\n");
        file.append("\r\n");
        file.append("\r\n");
        this.buildJavaFileDesc(file, metasEle);
        file.append("public enum ").append(this.name).append(" implements ResourceEnum {\r\n");
        file.append("\r\n");
        file.append("\r\n");
        this.addResSubItems(file, metasEle);
        file.append("}");
        return file.toString();
    }

    protected void addResSubItems(StringBuffer file, Element metasEle) {
        List resources = metasEle.getDocument().getRootElement().element("resource").elements("rs");
        if (resources == null || resources.size() == 0) {
            return;
        }
        String localeFlag = "zh_CN";
        Pattern rsPattern = Pattern.compile(this.name + "\\]\\.resourceItems\\.resourceItem\\[([\\w_\\d]+)\\]\\.value");
        TreeMap<String, String> enums = new TreeMap<String, String>();
        block0: for (Object rs : resources) {
            Matcher matcher = rsPattern.matcher(((Element)rs).attributeValue("key"));
            if (!(rs instanceof Element) || !matcher.find()) continue;
            for (Object lang : ((Element)rs).elements("lang")) {
                if (!(lang instanceof Element) || !localeFlag.equals(((Element)lang).attributeValue("locale"))) continue;
                enums.put(matcher.group(1), ((Element)lang).attributeValue("value"));
                continue block0;
            }
        }
        for (String key : enums.keySet()) {
            file.append("\t/**\r\n\t *").append((String)enums.get(key)).append("\r\n\t */\r\n");
            file.append("\t").append(key).append(",\n\n");
        }
        file.replace(file.length() - 3, file.length(), ";\n\n");
    }

    public JSONObject getBosResourceItems() {
        return this.bosResourceItems;
    }

    public void setBosResourceItems(JSONObject bosResourceItems) {
        this.bosResourceItems = bosResourceItems;
    }
}

