/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.punchcard;

import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.syn.httpclient.MySSLProtocolSocketFactory;
import com.kingdee.eas.hr.ats.syn.punchcard.HttpProcessor;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsErrorMsg;
import com.kingdee.portal.biz.common.exception.BizException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractHttpProcessor
extends AtsErrorMsg
implements HttpProcessor {
    private static Logger logger = Logger.getLogger(AbstractHttpProcessor.class);
    private String url;
    private int statusCode;
    private int connectTimeout = 20000;
    private int socketTimeout = 60000;
    private int connectCount = 1;
    private int maxConnectCount = 3;
    private boolean reTryWhenException = true;
    private boolean success;
    private boolean printResponseText = true;
    private int errorCode;
    private List<String> responseData;
    private HttpMethod method;
    private StringBuffer getMethoParams;
    private boolean getMethod = true;
    private HttpClient httpClient;

    @Override
    public void processRequest() throws BizException {
        this.reset();
        this.initHttpClient();
        this.initMethod();
        this.initAuthentication();
        this.getHttpClient().getHttpConnectionManager().getParams().setConnectionTimeout(this.connectTimeout);
        this.getMethod().getParams().setSoTimeout(this.socketTimeout);
        try {
            this.processRequestInner();
        }
        catch (Exception e) {
            this.add(e.getMessage());
            this.releaseConnection();
            throw new BizException(e.getMessage(), (Throwable)e);
        }
    }

    protected void processRequestInner() throws BizException {
        this.statusCode = -1;
        Exception excuteExeption = null;
        this.beforeRequest();
        try {
            this.method.setURI(new URI(this.getMethoParams == null ? this.url : this.url + this.getMethoParams.toString(), true));
            this.statusCode = this.httpClient.executeMethod(this.method);
        }
        catch (Exception e) {
            excuteExeption = e;
            logger.error((Object)("HTTP execute error,detail:" + e.getMessage()), (Throwable)e);
        }
        logger.info((Object)("http status code:" + this.statusCode));
        this.afterRequest();
        if (this.statusCode == 204) {
            this.success = true;
            return;
        }
        try {
            if (excuteExeption == null) {
                this.processResult();
                this.success = this.validateResult();
            }
        }
        catch (Exception e) {
            excuteExeption = e;
            if (!this.reTryWhenException) {
                throw new BizException(e.getMessage(), (Throwable)e);
            }
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.releaseConnection();
        if (excuteExeption != null || this.statusCode != 200) {
            if (this.connectCount == this.maxConnectCount) {
                String errorMsg = MLUtile.getRes(AtsCommonResEnum.FailUntilMaxConnectTime, this.ctx);
                errorMsg = errorMsg + "\r\n" + MLUtile.getRes((ResourceEnum)AtsCommonResEnum.ErrorDetail, this.ctx, excuteExeption == null ? "AbstractHttpProcessor excuteExeption is null" : excuteExeption.getMessage()) + ";";
                errorMsg = errorMsg + "\r\n" + MLUtile.getRes((ResourceEnum)AtsBillResEnum.LastResponseIs, this.ctx, this.responseData);
                throw new BizException(errorMsg, (Throwable)excuteExeption);
            }
            try {
                Thread.sleep((long)(60.0 * Math.pow(2.0, this.connectCount - 1)));
            }
            catch (InterruptedException e) {
                logger.error((Object)("sleep failure when processRequestInner" + e.getMessage()), (Throwable)e);
            }
            logger.error((Object)("reconnect" + this.connectCount));
            ++this.connectCount;
            this.processRequestInner();
        }
    }

    protected void releaseConnection() {
        if (this.method != null) {
            this.beforeReleaseConnection();
            this.method.releaseConnection();
        }
    }

    protected void reset() {
        this.success = false;
        this.errorCode = -1;
        this.connectCount = 1;
        this.responseData = null;
        this.errorMsg.clear();
        this.getMethoParams = null;
    }

    @Override
    public void processResult() throws BizException {
        this.processResultInner();
    }

    protected void processResultInner() throws BizException {
        this.responseData = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.method.getResponseBodyAsStream()));
            String result = null;
            while ((result = reader.readLine()) != null) {
                this.responseData.add(result);
            }
            if (this.printResponseText) {
                logger.info((Object)"response_data_area start");
                this.printResponse();
                logger.info((Object)"response_data_area end");
            }
        }
        catch (IOException e) {
            throw new BizException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.GETHTTPDATAERROR, e, new Object[]{e.getMessage(), e})));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void printResponse() {
        logger.error(this.responseData);
    }

    @Override
    public boolean validateResult() throws BizException {
        return true;
    }

    public void addParameter(Object name, Object value) {
        if (name != null && StringUtils.isNotBlank((String)name.toString())) {
            if (this.getMethod) {
                if (this.getMethoParams == null) {
                    this.getMethoParams = new StringBuffer();
                }
                this.getMethoParams.append(this.getMethoParams.length() == 0 ? "?" : "&");
                try {
                    this.getMethoParams.append(name).append("=").append(URLEncoder.encode(String.valueOf(value), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.getMethoParams.append(name).append("=").append(URLEncoder.encode(String.valueOf(value)));
                    e.printStackTrace();
                }
            } else {
                ((PostMethod)this.method).addParameter(name.toString(), String.valueOf(value));
            }
        }
    }

    public void addParameters(Object[][] parameters) {
        if (parameters != null && parameters.length > 0) {
            for (Object[] param : parameters) {
                if (param == null || param.length != 2) continue;
                this.addParameter(param[0], param[1]);
            }
        }
    }

    public void addParameters(Map parameters) {
        if (!AtsCollectionUtile.isEmpty(parameters)) {
            for (Map.Entry cur : parameters.entrySet()) {
                this.addParameter(cur.getKey(), cur.getValue());
            }
        }
    }

    public String toString() {
        return super.toString();
    }

    protected void initHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
    }

    protected void initMethod() {
        this.method = this.getMethod ? new GetMethod() : new PostMethod();
    }

    protected void initAuthentication() throws BizException {
    }

    protected void beforeRequest() {
        if (this.getUrl().trim().startsWith("https")) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new MySSLProtocolSocketFactory(), 443));
        } else {
            Protocol.unregisterProtocol((String)"https");
        }
    }

    protected void afterRequest() {
    }

    protected void beforeReleaseConnection() {
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public List<String> getResponseData() {
        return this.responseData;
    }

    public void setResponseData(List<String> responseData) {
        this.responseData = responseData;
    }

    public boolean isGetMethod() {
        return this.getMethod;
    }

    public void setGetMethod(boolean getMethod) {
        this.getMethod = getMethod;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public int getConnectCount() {
        return this.connectCount;
    }

    public void setConnectCount(int connectCount) {
        this.connectCount = connectCount;
    }

    public int getMaxConnectCount() {
        return this.maxConnectCount;
    }

    public void setMaxConnectCount(int maxConnectCount) {
        this.maxConnectCount = maxConnectCount;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public StringBuffer getGetMethoParams() {
        return this.getMethoParams;
    }

    public void setGetMethoParams(StringBuffer getMethoParams) {
        this.getMethoParams = getMethoParams;
    }

    public boolean isReTryWhenException() {
        return this.reTryWhenException;
    }

    public void setReTryWhenException(boolean reTryWhenException) {
        this.reTryWhenException = reTryWhenException;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        AbstractHttpProcessor.logger = logger;
    }

    public boolean isPrintResponseText() {
        return this.printResponseText;
    }

    public void setPrintResponseText(boolean printResponseText) {
        this.printResponseText = printResponseText;
    }
}

