/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.synch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsTimeCommonResEnum;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.AuditOpinionEnum;
import com.kingdee.eas.hr.ats.BizDataOAuthFactory;
import com.kingdee.eas.hr.ats.BizDataOAuthInfo;
import com.kingdee.eas.hr.ats.BizDataSynchAssistCollection;
import com.kingdee.eas.hr.ats.BizDataSynchAssistFactory;
import com.kingdee.eas.hr.ats.BizDataSynchAssistInfo;
import com.kingdee.eas.hr.ats.IBizDataOAuth;
import com.kingdee.eas.hr.ats.IBizDataSynchAssist;
import com.kingdee.eas.hr.ats.IPunchCardRecord;
import com.kingdee.eas.hr.ats.ISignRecord;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.PunchCardSourceEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.SignRecordCollection;
import com.kingdee.eas.hr.ats.SignRecordFactory;
import com.kingdee.eas.hr.ats.SignRecordInfo;
import com.kingdee.eas.hr.ats.syn.SynResultInfo;
import com.kingdee.eas.hr.ats.syn.SynchUtil;
import com.kingdee.eas.hr.ats.syn.SynchronizationContext;
import com.kingdee.eas.hr.ats.syn.datasynch.UpdateCloudHubTimesThread;
import com.kingdee.eas.hr.ats.syn.fetch.PunchCardByHttpUrlGetOuterData;
import com.kingdee.eas.hr.ats.syn.synch.AbstractSynchronization;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynUtile;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsManageLoggerUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class PunchCardByHttpUrlSynchroniztion
extends AbstractSynchronization {
    private Logger loggerSignSyn = AtsManageLoggerUtil.getLogger("shr_ats_punchcard_log", "getkdcloudpunchcard");
    private Map<String, PersonInfo> pMap = null;
    private Map<String, PersonPositionInfo> ppMap = null;
    private Map<String, PersonInfo> allOpenID2PersonMap = null;
    private Map<String, AttendanceFileInfo> allOpenID2AttFileMap = null;
    private Set<String> allCloudAttendPosition = null;
    private Timestamp nowTimestamp = new Timestamp(System.currentTimeMillis());

    @Override
    protected void synchronize(SynchronizationContext synContext, SynResultInfo resultInfo) throws EASBizException, BOSException {
    }

    @Override
    protected void synchronize(SynchronizationContext synContext, SynResultInfo resultInfo, Map<String, Object> paramMap) throws EASBizException, BOSException {
        String dataString = "";
        this.pMap = SynchUtil.GetAllPersonInfo(synContext.getBosCtx());
        this.ppMap = SynchUtil.GetAllPersonPositionInfo(synContext.getBosCtx());
        this.allOpenID2PersonMap = SynchUtil.GetAllOpenID2Person(synContext.getBosCtx());
        this.allOpenID2AttFileMap = SynchUtil.GetAllOpenID2AttendanceFile(synContext.getBosCtx());
        int cannotfindMapPerson = 0;
        Timestamp lastsynchtime_orgin = (Timestamp)paramMap.get("lastsynchtime");
        Timestamp lastsynchtime = (Timestamp)paramMap.get("lastsynchtime");
        lastsynchtime = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(lastsynchtime)).getTime());
        Timestamp nowTimestamp = (Timestamp)paramMap.get("nowTimestamp");
        String authkey = (String)paramMap.get("authkey");
        String openapikey = (String)paramMap.get("openapikey");
        Set notFoundPersonSet = (Set)paramMap.get("notFoundPersonSet");
        BizDataOAuthInfo bizDataOAuthInfo = null;
        IBizDataOAuth bizDataOAuth = BizDataOAuthFactory.getLocalInstance(synContext.getBosCtx());
        if (!bizDataOAuth.exists(" where key='" + authkey + "' ")) {
            throw new BOSException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.NOYUNZHIJIAAUTH)));
        }
        bizDataOAuthInfo = bizDataOAuth.getBizDataOAuthInfo(" where key='" + authkey + "' ");
        long lastsynchtime_orgin_long = lastsynchtime_orgin.getTime();
        long LtempTimestamp1 = lastsynchtime.getTime();
        long LtempTimestamp2 = lastsynchtime.getTime();
        long LendTimestamp = nowTimestamp.getTime();
        Timestamp tempTimestamp1 = lastsynchtime;
        Timestamp tempTimestamp2 = lastsynchtime;
        IPunchCardRecord punchCardRecord = PunchCardRecordFactory.getLocalInstance(synContext.getBosCtx());
        ISignRecord signRecord = SignRecordFactory.getLocalInstance(synContext.getBosCtx());
        boolean needCmpBegin = true;
        boolean needCmpEnd = false;
        BizDataSynchAssistInfo bizDataSynchAssistInfo = this.getBizDataSynchAssist(synContext.getBosCtx(), openapikey);
        IBizDataSynchAssist bizDataSynchAssist = BizDataSynchAssistFactory.getLocalInstance(synContext.getBosCtx());
        this.loggerSignSyn.info((Object)MLUtile.getRes((ResourceEnum)AtsTimeCommonResEnum.SyncTimeRange, synContext.getBosCtx(), AtsDateUtils.timestampToString(lastsynchtime), " \u2014\u2014 ", AtsDateUtils.timestampToString(nowTimestamp), " ", synContext.getBosCtx().get((Object)"synStyle")));
        long totalSize = 0L;
        long successSize = 0L;
        long batchNumber = 1L;
        String batchStartDateString = AtsDateUtils.timestampToString(new Timestamp(System.currentTimeMillis()));
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        AttendanceLogInfo logInfo = new AttendanceLogInfo();
        String jobId = (String)synContext.getBosCtx().get((Object)"jobInstId");
        logInfo.setJobid(jobId);
        long runningStartTime = System.currentTimeMillis();
        long totalTimes = 0L;
        int loopTime = 1;
        while (LtempTimestamp1 < LendTimestamp) {
            tempTimestamp1 = new Timestamp(LtempTimestamp1);
            LtempTimestamp2 = AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(new Timestamp(LtempTimestamp1 + 86400000L))).getTime() - 1L;
            if (LtempTimestamp2 >= LendTimestamp) {
                needCmpEnd = true;
                LtempTimestamp2 = LendTimestamp;
            }
            tempTimestamp2 = new Timestamp(LtempTimestamp2);
            HashMap<String, Object> paramMap4Get = new HashMap<String, Object>();
            paramMap4Get.put("bizDataOAuthInfo", bizDataOAuthInfo);
            paramMap4Get.put("beginDate", AtsDateUtils.timestampToString(tempTimestamp1));
            paramMap4Get.put("endDate", AtsDateUtils.timestampToString(tempTimestamp2));
            PunchCardByHttpUrlGetOuterData punchCardByHttpUrlGetOuterData = new PunchCardByHttpUrlGetOuterData();
            boolean haveMore = true;
            long start = 0L;
            long limit = 150L;
            CoreBaseCollection crdColl = new CoreBaseCollection();
            CoreBaseCollection signRcdColl = new CoreBaseCollection();
            while (haveMore) {
                paramMap4Get.put("start", start);
                paramMap4Get.put("limit", limit);
                this.loggerSignSyn.info((Object)(batchStartDateString + "start_cur_batch:" + batchNumber++));
                JSONArray recordsJsonArr = (JSONArray)punchCardByHttpUrlGetOuterData.getOuterData(synContext, paramMap4Get);
                this.loggerSignSyn.info((Object)("fetched data:\r\n" + recordsJsonArr == null ? "" : recordsJsonArr.join("\r\n")));
                if (recordsJsonArr != null && recordsJsonArr.size() > 0) {
                    totalSize += (long)recordsJsonArr.size();
                }
                cannotfindMapPerson = 0;
                if (recordsJsonArr != null && recordsJsonArr.size() > 0) {
                    this.loggerSignSyn.info((Object)("Synch total data size====" + recordsJsonArr.size()));
                    PunchCardRecordInfo crdInfo = null;
                    SignRecordInfo signRecordInfo = null;
                    StringBuilder records = new StringBuilder();
                    for (int i = 0; i < recordsJsonArr.size(); ++i) {
                        JSONObject json = recordsJsonArr.getJSONObject(i);
                        long punchTime = json.getLong("time");
                        if (!(!needCmpBegin && !needCmpEnd || punchTime >= LtempTimestamp1 && punchTime <= LtempTimestamp2)) continue;
                        String plc = StringUtils.cnulls((String)json.getString("position")).trim();
                        String attendanceQN = json.getString("attendanceQN");
                        if ("0".equals(attendanceQN)) {
                            crdInfo = PunchCardSynUtile.assemblePunchCardRecordInfo(json, openapikey, nowTimestamp, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap, this.pMap);
                            if (crdInfo.getProposer() != null) {
                                crdColl.add((CoreBaseInfo)crdInfo);
                            } else {
                                ++cannotfindMapPerson;
                            }
                        } else {
                            signRecordInfo = PunchCardSynUtile.assembleSignRecordInfo(json, openapikey, this.ppMap, this.allOpenID2PersonMap, this.pMap, this.allOpenID2AttFileMap);
                            if (signRecordInfo.getPerson() != null) {
                                signRcdColl.add((CoreBaseInfo)signRecordInfo);
                            } else {
                                ++cannotfindMapPerson;
                            }
                        }
                        if (this.allOpenID2PersonMap == null || this.allOpenID2PersonMap.containsKey(json.getString("userId"))) continue;
                        notFoundPersonSet.add(json.getString("userName") + "(" + json.getString("userId") + ")");
                    }
                    this.loggerSignSyn.info((Object)records.toString());
                }
                if (recordsJsonArr == null || recordsJsonArr.size() < 150) {
                    haveMore = false;
                    break;
                }
                start += (long)recordsJsonArr.size();
                System.out.println("Cannot find usermappping data size====" + cannotfindMapPerson);
            }
            if (!crdColl.isEmpty()) {
                PunchCardByHttpUrlSynchroniztion.removePunchCardData(synContext, PunchCardSourceEnum.openapisynch.getValue(), openapikey, tempTimestamp1, tempTimestamp2);
                punchCardRecord.save(crdColl);
                successSize += (long)crdColl.size();
            }
            successSize += (long)signRcdColl.size();
            if (!(signRcdColl = PunchCardSynUtile.compareSignRcdColl(signRecord, signRcdColl, tempTimestamp1, tempTimestamp2)).isEmpty()) {
                signRecord.save(signRcdColl);
            }
            this.deleteCardEqualCancel(synContext.getBosCtx(), tempTimestamp1, tempTimestamp2);
            if (bizDataSynchAssistInfo != null) {
                bizDataSynchAssistInfo.setLastsynchtime(tempTimestamp2);
                bizDataSynchAssist.save(bizDataSynchAssistInfo);
            }
            LtempTimestamp1 = AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(new Timestamp(LtempTimestamp1 + 86400000L))).getTime();
            needCmpBegin = false;
            long runningEndTime = System.currentTimeMillis();
            if (loopTime == 1) {
                long days = (nowTimestamp.getTime() - lastsynchtime.getTime()) / 86400000L;
                if (days == 0L) {
                    days = 1L;
                }
                totalTimes = (runningEndTime - runningStartTime) * days;
            }
            ++loopTime;
            executorService.execute(new UpdateCloudHubTimesThread(synContext.getBosCtx(), totalTimes, runningStartTime, logInfo));
        }
        String batchEndDateString = AtsDateUtils.timestampToString(new Timestamp(System.currentTimeMillis()));
        this.loggerSignSyn.info((Object)(batchStartDateString + " end\uff08end time\uff1a" + batchEndDateString + "\uff0ctotal size" + totalSize + "\uff09"));
        dataString = MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item7, synContext.getBosCtx(), AtsDateUtils.timestampToString(lastsynchtime), AtsDateUtils.timestampToString(nowTimestamp), totalSize, successSize) + "\r\n";
        logInfo.setCreateTime(AtsDateUtils.stringToTimestamp(batchStartDateString));
        logInfo.setLastUpdateTime(AtsDateUtils.stringToTimestamp(batchEndDateString));
        logInfo.setSumPerson(BigDecimal.valueOf(totalSize));
        logInfo.setSumDays(BigDecimal.valueOf(successSize));
        synContext.getBosCtx().put((Object)"log", (Object)logInfo);
        synContext.getBosCtx().put((Object)"dataString", (Object)dataString);
    }

    private static void removePunchCardData(SynchronizationContext synContext, String type, String openapikey, Timestamp beginDate, Timestamp enddate) throws BOSException {
        System.out.println("Delete punchcard data beginDate====" + AtsDateUtils.timestampToString(beginDate));
        System.out.println("Delete punchcard data endDate====" + AtsDateUtils.timestampToString(enddate));
        Object[] params1 = new Object[]{type, openapikey, beginDate, enddate};
        String sql1 = " delete  from T_HR_ATS_PunchCardRecord where FPUNCHCARDSOURCE= ? and FEQUIPMENTNUM = ? and FPUNCHCARDTIME >=? and FPUNCHCARDTIME <=? and FPunchCardState is Null and FProposerID  in (select fpersonid from t_pm_easxtusermap)";
        DbUtil.execute((Context)synContext.getBosCtx(), (String)sql1, (Object[])params1);
    }

    private BizDataSynchAssistInfo getBizDataSynchAssist(Context ctx, String openapikey) throws SQLDataException, BOSException {
        IBizDataSynchAssist bizDataSynchAssist = BizDataSynchAssistFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("openapiurlkey", (Object)openapikey, CompareType.EQUALS));
        view.setFilter(fi);
        BizDataSynchAssistCollection collection = bizDataSynchAssist.getBizDataSynchAssistCollection(view);
        if (collection.isEmpty()) {
            return null;
        }
        return collection.get(0);
    }

    private CoreBaseCollection removeRepeatSignRecords(ISignRecord signRecord, CoreBaseCollection signRcdColl, Timestamp beginDate, Timestamp endDate) {
        beginDate = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(beginDate)).getTime());
        endDate = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(endDate)).getTime() + 86400000L - 1L);
        CoreBaseCollection col = new CoreBaseCollection();
        if (signRcdColl == null || signRcdColl.isEmpty()) {
            return col;
        }
        HashSet<String> pidSet = new HashSet<String>();
        Iterator iterator = signRcdColl.iterator();
        boolean havePersonNull = false;
        while (iterator.hasNext()) {
            SignRecordInfo signRecordInfo = (SignRecordInfo)iterator.next();
            if (signRecordInfo.getPerson() != null && signRecordInfo.getPerson().getId() != null) {
                pidSet.add(signRecordInfo.getPerson().getId().toString());
                continue;
            }
            havePersonNull = true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("signTime"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        FilterInfo fi = new FilterInfo();
        if (pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
        } else if (!pidSet.isEmpty() && !havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
        } else if (!pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
            FilterInfo fi2 = new FilterInfo();
            fi2.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
            try {
                fi.mergeFilter(fi2, "OR");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            return col;
        }
        FilterInfo fi3 = new FilterInfo();
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)endDate, CompareType.LESS_EQUALS));
        try {
            fi.mergeFilter(fi3, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        evi.setFilter(fi);
        try {
            SignRecordCollection signRecordCollection = signRecord.getSignRecordCollection(evi);
            for (SignRecordInfo signRecordInfo : signRcdColl) {
                if (signRecordCollection.contains(signRecordInfo)) continue;
                col.add((CoreBaseInfo)signRecordInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    private PunchCardRecordInfo assemblePunchCardRecordInfo(JSONObject json, String openapikey) {
        PunchCardRecordInfo crdInfo = new PunchCardRecordInfo();
        String openID = json.getString("userId");
        String workNum = json.getString("workNum");
        crdInfo.setEquipmentNum(openapikey);
        crdInfo.setPunchCardDate(AtsDateUtils.stringToShortDate(json.getString("day")));
        crdInfo.setPunchCardTime(new Timestamp(json.getLong("time")));
        crdInfo.setPunchCardPlace(json.getString("position"));
        crdInfo.setPunchCardSource(PunchCardSourceEnum.openapisynch);
        if (this.allOpenID2PersonMap != null && this.allOpenID2PersonMap.containsKey(openID)) {
            PersonPositionInfo ppInfo;
            crdInfo.setProposer(this.allOpenID2PersonMap.get(openID));
            if (crdInfo.getProposer() != null && this.ppMap != null && (ppInfo = this.ppMap.get(crdInfo.getProposer().getId().toString())) != null) {
                crdInfo.setHrOrgUnit(ppInfo.getHrOrgUnit());
                crdInfo.setAdminOrgUnit(ppInfo.getPersonDep());
            }
            if (this.allOpenID2AttFileMap != null && this.allOpenID2AttFileMap.containsKey(openID) && this.allOpenID2AttFileMap.get(openID).getAttendanceNum() != null) {
                crdInfo.setAttendanceNum(this.allOpenID2AttFileMap.get(openID).getAttendanceNum());
                crdInfo.setHrOrgUnit(this.allOpenID2AttFileMap.get(openID).getHrOrgUnit());
                crdInfo.setAdminOrgUnit(this.allOpenID2AttFileMap.get(openID).getAdminOrgUnit());
                crdInfo.setAttAdminOrgUnit(this.allOpenID2AttFileMap.get(openID).getAttAdminOrgUnit());
            } else {
                crdInfo.setAttendanceNum(crdInfo.getProposer().getNumber());
            }
        } else if (workNum != null && !"".equals(workNum) && !"null".equals(workNum)) {
            crdInfo.setAttendanceNum(workNum);
            crdInfo.setProposer(this.pMap.get(workNum));
        }
        crdInfo.setCreateTime(this.nowTimestamp);
        crdInfo.setLastUpdateTime(this.nowTimestamp);
        return crdInfo;
    }

    private SignRecordInfo assembleSignRecordInfo(JSONObject json, String openapikey) {
        SignRecordInfo crdInfo = new SignRecordInfo();
        String openID = json.getString("userId");
        String workNum = json.getString("workNum");
        crdInfo.setSignDate(AtsDateUtils.stringToShortDate(json.getString("day")));
        crdInfo.setSignTime(new Timestamp(json.getLong("time")));
        crdInfo.setAddress(json.getString("position"));
        crdInfo.setNote(json.getString("remark"));
        if (this.allOpenID2PersonMap != null && this.allOpenID2PersonMap.containsKey(openID)) {
            crdInfo.setPerson(this.allOpenID2PersonMap.get(openID));
        } else if (workNum != null && !"".equals(workNum) && !"null".equals(workNum)) {
            crdInfo.setPerson(this.pMap.get(workNum));
        }
        if (crdInfo.getPerson() != null) {
            PersonPositionInfo ppInfo;
            if (this.ppMap != null && (ppInfo = this.ppMap.get(crdInfo.getPerson().getId().toString())) != null) {
                crdInfo.setHrOrgUnit(ppInfo.getHrOrgUnit());
                crdInfo.setAdminOrg(ppInfo.getPersonDep());
            }
            if (this.allOpenID2AttFileMap != null && this.allOpenID2AttFileMap.containsKey(openID)) {
                crdInfo.setHrOrgUnit(this.allOpenID2AttFileMap.get(openID).getHrOrgUnit());
                crdInfo.setAdminOrg(this.allOpenID2AttFileMap.get(openID).getAdminOrgUnit());
                crdInfo.setAttAdminOrgUnit(this.allOpenID2AttFileMap.get(openID).getAttAdminOrgUnit());
            }
        }
        crdInfo.setAuditOpinion(AuditOpinionEnum.unaudited);
        crdInfo.setSignType(1);
        return crdInfo;
    }

    @Override
    public SynResultInfo synchronizatioin(SynchronizationContext synContext, Map<String, Object> paramMap) throws EASBizException, BOSException {
        SynResultInfo resultInfo = new SynResultInfo();
        this.synchronize(synContext, resultInfo, paramMap);
        return resultInfo;
    }

    public void deleteCardEqualCancel(Context ctx, Timestamp t1, Timestamp t2) {
        String strT1 = AtsDateUtils.timestampToString(t1);
        String strT2 = AtsDateUtils.timestampToString(t2);
        String sql = " DELETE FROM T_HR_ATS_PunchCardRecord WHERE FID in (   SELECT FID FROM T_HR_ATS_PunchCardRecord pd1  WHERE  pd1.FPunchCardSource = '6'  AND pd1.FPunchCardState IS NULL  AND pd1.FPunchCardTime >= {ts '" + strT1 + "'}  AND pd1.FPunchCardTime <= {ts '" + strT2 + "'}  AND EXISTS (  SELECT 1 FROM T_HR_ATS_PunchCardRecord pd2  WHERE  pd2.FPunchCardSource = '6'  AND pd2.FPunchCardState = 1  AND pd2.FPunchCardTime >= {ts '" + strT1 + "'}  AND pd2.FPunchCardTime <= {ts '" + strT2 + "'}  AND pd1.FProposerID = pd2.FProposerID  AND pd1.FPunchCardTime = pd2.FPunchCardTime  ) )";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public StringBuilder resolverRecords(JSONObject json, StringBuilder records) {
        records.append("userName:" + json.get("userName") + ",");
        records.append("userId:" + json.get("userId") + ",");
        if (json.get("time") != null && org.apache.commons.lang.StringUtils.isNotEmpty((String)json.get("time").toString())) {
            records.append("time:" + AtsDateUtils.timestampToString(new Timestamp(Long.valueOf(json.get("time").toString()))) + ",");
        } else {
            records.append("time: ,");
        }
        records.append("position:" + json.get("position") + ",");
        records.append("attendanceQN:" + json.get("attendanceQN") + "\n");
        return records;
    }
}

