/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.takeWorkLimit.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractHolidayLimitInfo;
import com.kingdee.eas.hr.ats.AtsBizLimitBizException;
import com.kingdee.eas.hr.ats.AtsCountLimitBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillFactory;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsTakeWorkingInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceLogCollection;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.HolidayLimitBillTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailFactory;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitDetailStatusEnum;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetCollection;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.HolidayTypeFactory;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.IHolidayLimitDetail;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailCollection;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.TakeWoring;
import com.kingdee.eas.hr.ats.TakeWorkSourceType;
import com.kingdee.eas.hr.ats.TakeWorkUnitConvertRule;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.holidayLimit.generate.preparedata.InitHolidayLimitData;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.GenHolidayLimitUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.takeWorkLimit.factory.TakeWorkLimitFactory;
import com.kingdee.eas.hr.ats.takeWorkLimit.impl.CoreCalTakeWorkLimit;
import com.kingdee.eas.hr.ats.takeWorkLimit.util.TakeWorkLimitUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.LoggerAtsJobInst;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenerateTakeWorkLimit {
    private static Logger logger = Logger.getLogger(GenerateTakeWorkLimit.class);
    private int failTimes = 0;
    private int successTimes = 0;
    private Set<String> personIdSet = new HashSet<String>();
    private Map<String, AttendanceFileInfo> attendanceFileMap = new HashMap<String, AttendanceFileInfo>();
    private Map<String, List<AtsHolidayFileHisInfo>> atsHolidayFileHisMap = new HashMap<String, List<AtsHolidayFileHisInfo>>();
    private Map<String, PersonPositionInfo> personPositionMap = new HashMap<String, PersonPositionInfo>();
    private Map<String, HolidayLimitInfo> existedLimitMap = new HashMap<String, HolidayLimitInfo>();
    private Map<String, HolidayLimitInfo> preLimitMap = new HashMap<String, HolidayLimitInfo>();
    private Map<String, Set<OTtoTakeWorkDetailInfo>> existedDetailMap = new HashMap<String, Set<OTtoTakeWorkDetailInfo>>();
    private Map<String, Object> ruleBasedDataMap = new HashMap<String, Object>();
    private Map<String, List<AtsOverTimeBillInfo>> otEntryMap = new HashMap<String, List<AtsOverTimeBillInfo>>();
    private Map<String, Set<HashMap<String, Object>>> resultMap = new HashMap<String, Set<HashMap<String, Object>>>();
    private Map<String, BigDecimal> stdHourMap = new HashMap<String, BigDecimal>();
    private Map<String, EmpPosOrgRelationInfo> empPosOrgRelationMap = new HashMap<String, EmpPosOrgRelationInfo>();
    private Map<String, EmpLaborRelationInfo> empLaborRelationMap = new HashMap<String, EmpLaborRelationInfo>();
    private HolidayPolicyInfo policyInfo = null;
    private AtsTakeWorkingInfo twRule = null;
    private int attfileNotHaveHldply = 0;

    public GenerateTakeWorkLimit(Context ctx) {
        this.prepareInitClearData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTakeWorkLimitBackGround(Context ctx, Map param) {
        param.put("transaction", "transaction");
        String cycleDate = (String)param.get("cycleDate");
        if (StringUtils.isEmpty((String)cycleDate)) {
            cycleDate = AtsDateUtils.dateShortToString(new Date());
            param.put("cycleDate", AtsDateUtils.dateShortToString(new Date()));
        }
        param.put("accessSrc", "backgroudTransaction");
        this.successTimes = 0;
        this.failTimes = 0;
        StringBuffer calPersonSql = new StringBuffer();
        TakeWorkLimitUtils.getCalPerson(ctx, calPersonSql, param);
        int forwardDay = 0;
        String forwardDayStr = (String)param.get("forwardDay");
        if (!StringUtils.isEmpty((String)forwardDayStr)) {
            forwardDay = Integer.valueOf(forwardDayStr) > 0 ? Integer.valueOf(forwardDayStr) : 0;
        }
        List<String> cycleDates = null;
        System.out.println("---back job ot trans takeWork start---");
        try {
            int personSum = TakeWorkLimitUtils.getAllCount(ctx, calPersonSql);
            this.writeLogPrimary(ctx, personSum, 1, 1);
            HolidayPolicySetCollection policySetColl = GenerateTakeWorkLimit.getDisableFormulaHolidayPolicySet(ctx);
            if (policySetColl != null && policySetColl.size() > 0) {
                for (int i = 0; i < policySetColl.size(); ++i) {
                    StringBuffer calPersonByPolicySetSQL = new StringBuffer(calPersonSql);
                    HolidayPolicySetInfo policySetInfo = policySetColl.get(i);
                    String policySetId = policySetInfo.getId().toString();
                    param.put("policySet", policySetInfo);
                    TakeWorkLimitUtils.getCalPersonByPolicySet(calPersonByPolicySetSQL, policySetId);
                    int totalCount = TakeWorkLimitUtils.getAllCount(ctx, calPersonByPolicySetSQL);
                    calPersonByPolicySetSQL.append(" order by person.fid desc ");
                    int rows_one = 200;
                    int pages_one = 0;
                    pages_one = totalCount % rows_one == 0 ? totalCount / rows_one : totalCount / rows_one + 1;
                    for (int page = 1; page <= pages_one; ++page) {
                        logger.error((Object)(" generate OTLimit transaction\uff1aholiday_policy-" + policySetInfo.getName().toString() + "\uff0c totalCount-" + totalCount + " page/totalPage(200 per page)-" + page + "/" + pages_one));
                        IRowSet rs = TakeWorkLimitUtils.paging(calPersonByPolicySetSQL.toString(), rows_one, page, totalCount, ctx);
                        EntityViewInfo evi = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("holidayPolicySet.id", (Object)policySetId));
                        filterInfo.getFilterItems().add(new FilterItemInfo("holidayType.id", (Object)TakeWorkLimitUtils.takeWorkTypeID));
                        evi.setFilter(filterInfo);
                        evi.getSelector().add(new SelectorItemInfo("takeWorkingRule.id"));
                        evi.getSelector().add(new SelectorItemInfo("takeWorkingRule.taskWorkingType"));
                        HolidayPolicyCollection policyColl = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(evi);
                        String personIdsStr = TakeWorkLimitUtils.combinePersonIds(rs);
                        if (!StringUtils.isEmpty((String)personIdsStr)) {
                            param.put("proposers", personIdsStr);
                            if (policyColl != null && policyColl.size() > 0 && policyColl.get(0).getTakeWorkingRule() != null) {
                                cycleDates = this.getCycleDates(forwardDay, policyColl.get(0).getTakeWorkingRule().getTaskWorkingType(), cycleDate);
                                logger.error((Object)("generateTakeWorkLimitBackGround cycleDates: " + cycleDates.toString()));
                                for (String date : cycleDates) {
                                    param.put("cycleDate", date);
                                    this.generateTakeWorkLimit(ctx, param);
                                }
                            } else {
                                this.generateTakeWorkLimit(ctx, param);
                            }
                        }
                        System.out.println("back job ot trans takeWork\uff1aholiday policy-" + policySetInfo.getName().toString() + "\uff0ctotal successTimes ==== " + this.successTimes + " failTimes ==== " + this.failTimes);
                    }
                }
            }
            this.writeLogPrimary(ctx, personSum, 1, this.successTimes, this.failTimes, 2);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("---back job ot trans takeWork end---");
    }

    public static HolidayPolicySetCollection getDisableFormulaHolidayPolicySet(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select hpolicySet.fid from T_HR_ATS_HolidayPolicySet hpolicySet");
        sql.append(" join T_HR_ATS_HolidayPolicy hpolicy on hpolicy.FHolidayPolicySetID=hpolicySet.fid");
        sql.append(" join T_HR_ATS_TakeWorking takeWorking on hpolicy.FTakeWorkingRuleID=takeWorking.fid");
        sql.append(" where takeWorking.fenableFormula=0");
        Set<String> enableFormulaHolidayPolicySet = AtsSqlUtile.getOneField(ctx, sql.toString());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", enableFormulaHolidayPolicySet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        return HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetCollection(evi);
    }

    private List<String> getCycleDates(int forwardDay, TakeWoring cycleType, String cycleDate) {
        List<String> cycleDates = new ArrayList<String>();
        Date today = new Date();
        String todayStr = cycleDate;
        if (forwardDay <= 0) {
            cycleDates.add(todayStr);
            return cycleDates;
        }
        String prePerDay = "";
        if (cycleType.equals((Object)TakeWoring.day)) {
            cycleDates = AtsDateUtils.getDateList(todayStr, -forwardDay);
        } else if (cycleType.equals((Object)TakeWoring.month)) {
            prePerDay = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(AtsDateUtils.getMonthFirstDay(today)));
            cycleDates.add(prePerDay);
            cycleDates.add(todayStr);
        } else if (cycleType.equals((Object)TakeWoring.season)) {
            prePerDay = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(AtsDateUtils.getSeasonFirstDay(today)));
            cycleDates.add(prePerDay);
            cycleDates.add(todayStr);
        } else if (cycleType.equals((Object)TakeWoring.year)) {
            prePerDay = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(AtsDateUtils.getYearFirstDay(today)));
            cycleDates.add(prePerDay);
            cycleDates.add(todayStr);
        } else if (cycleType.equals((Object)TakeWoring.attenceCycle)) {
            prePerDay = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(AtsDateUtils.getMonthsAgo(today, 1)));
            cycleDates.add(prePerDay);
            cycleDates.add(todayStr);
        }
        return cycleDates;
    }

    public Map<String, String> generateTakeWorkLimit(Context ctx, Map param) {
        Map rtinfoMap;
        block10: {
            rtinfoMap = null;
            try {
                String proposers = (String)param.get("proposers");
                if (StringUtils.isEmpty((String)proposers)) break block10;
                this.prepareInitClearData();
                try {
                    this.preparePageData(ctx, param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.print("ot trans takework limit\uff0catt policy-" + ((HolidayPolicySetInfo)param.get("policySet")).getName() + " prepare data error......");
                    logger.error((Object)("ot limit \uff0catt policy-" + ((HolidayPolicySetInfo)param.get("policySet")).getName() + " prepare data error......"));
                    return rtinfoMap;
                }
                if (this.twRule.isEnableFormula()) {
                    return rtinfoMap;
                }
                rtinfoMap = this.genLimit(ctx, ctx, param);
                Set resultInfoSet = rtinfoMap.keySet();
                for (String msg : resultInfoSet) {
                    logger.error((Object)("ot limit result (" + msg + ":" + rtinfoMap.get(msg).toString() + ")"));
                }
                this.prepareInitClearData();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rtinfoMap;
    }

    public Map<String, String> generateTakeWorkLimit(Context ctx, IRowSet rs, Map param) {
        Map rtinfoMap;
        block9: {
            rtinfoMap = null;
            try {
                if (rs.size() <= 0) break block9;
                StringBuffer personStr = new StringBuffer();
                TakeWorkLimitUtils.combineMapInfo(rs, personStr);
                param.put("proposers", personStr.toString());
                System.out.println("generateTakeWorkLimit person ids: " + personStr.toString());
                this.prepareInitClearData();
                try {
                    this.preparePageData(ctx, param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.print("ot trans takework limit\uff0catt policy-" + ((HolidayPolicySetInfo)param.get("policySet")).getName() + " prepare data error......");
                    return rtinfoMap;
                }
                if (this.twRule.isEnableFormula()) {
                    return rtinfoMap;
                }
                rtinfoMap = this.genLimit(ctx, ctx, param);
                this.prepareInitClearData();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rtinfoMap;
    }

    public void prepareInitClearData() {
        this.personIdSet.clear();
        this.attendanceFileMap.clear();
        this.atsHolidayFileHisMap.clear();
        this.personPositionMap.clear();
        this.existedLimitMap.clear();
        this.preLimitMap.clear();
        this.existedDetailMap.clear();
        this.ruleBasedDataMap.clear();
        this.otEntryMap.clear();
        this.resultMap.clear();
        this.stdHourMap.clear();
        this.twRule = null;
        this.policyInfo = null;
        this.attfileNotHaveHldply = 0;
    }

    public Date[] getMonthFirstAndLastDate(String currentDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(currentDate));
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        calendar.add(2, 0);
        calendar.set(5, 1);
        String firstday = format.format(calendar.getTime());
        calendar = Calendar.getInstance();
        calendar.add(2, 1);
        calendar.set(5, 0);
        String lastday = format.format(calendar.getTime());
        try {
            return new Date[]{format.parse(firstday), format.parse(lastday)};
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void preparePageData(Context ctx, Map param) throws Exception {
        int i;
        String adminOrgUnit = StringUtils.cnulls(param.get("adminOrgUnit"));
        String proposers = StringUtils.cnulls(param.get("proposers"));
        HolidayPolicySetInfo policySetInfo = (HolidayPolicySetInfo)param.get("policySet");
        String cycleDate = StringUtils.cnulls(param.get("cycleDate"));
        logger.error((Object)("generate take work detail proposers: " + proposers + " cycleDate: " + cycleDate + " policySet id: " + policySetInfo.getId().toString()));
        try {
            this.policyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo(" select *, takeWorkingRule.* where holidayPolicySet.id = '" + policySetInfo.getId().toString() + "' and holidayType.id = '" + "+ZM5jTmrS0KHCjDSYGcFLf0tUpg=" + "' ");
            this.twRule = this.policyInfo.getTakeWorkingRule();
        }
        catch (Exception e) {
            throw new AtsBizLimitBizException(AtsBizLimitBizException.LEAKHPOLICYINLEAVEENTRY);
        }
        AttendanceFileCollection atsFileColl = TakeWorkLimitUtils.getAttendanceFileColByPersonOrAdminOrg(ctx, proposers, adminOrgUnit);
        if (atsFileColl.size() > 10000) {
            throw new AtsCountLimitBizException(AtsCountLimitBizException.PERSONLIMIT, new Object[]{10000});
        }
        HashSet<String> billPerson = new HashSet<String>();
        HashSet<String> resultPerson = new HashSet<String>();
        if (TakeWorkSourceType.attendRes.equals((Object)this.twRule.getTakeWorkSource())) {
            for (i = 0; i < atsFileColl.size(); ++i) {
                if (atsFileColl.get(i).getProposer() == null) continue;
                this.personIdSet.add(atsFileColl.get(i).getProposer().getId().toString());
                this.attendanceFileMap.put(atsFileColl.get(i).getProposer().getId().toString(), atsFileColl.get(i));
                resultPerson.add(atsFileColl.get(i).getProposer().getId().toString());
            }
        } else {
            for (i = 0; i < atsFileColl.size(); ++i) {
                if (atsFileColl.get(i).getProposer() == null) continue;
                this.personIdSet.add(atsFileColl.get(i).getProposer().getId().toString());
                this.attendanceFileMap.put(atsFileColl.get(i).getProposer().getId().toString(), atsFileColl.get(i));
                billPerson.add(atsFileColl.get(i).getProposer().getId().toString());
            }
        }
        PersonPositionCollection allpersonPositionCollection = TakeWorkLimitUtils.getPersonPositionCollection(ctx, this.personIdSet);
        for (int i2 = 0; i2 < allpersonPositionCollection.size(); ++i2) {
            PersonPositionInfo personPositionInfo = allpersonPositionCollection.get(i2);
            this.personPositionMap.put(personPositionInfo.getPerson().getId().toString(), personPositionInfo);
        }
        HolidayLimitCollection existedLimitColl = TakeWorkLimitUtils.getExistedLimitColl(ctx, this.personIdSet, cycleDate);
        if (existedLimitColl != null && existedLimitColl.size() > 0) {
            for (int i3 = 0; i3 < existedLimitColl.size(); ++i3) {
                AtsHolidayFileHisCollection fileHisCollection;
                PersonInfo personInfo = existedLimitColl.get(i3).getProposer();
                if (personInfo == null || (fileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection(" where proposer.id='" + personInfo.getId().toString() + "' and attendFileState=1 and  Effdt <= {ts '" + cycleDate + "'} and Leffdt >= {ts '" + cycleDate + "'} order by effdt desc")).size() <= 0) continue;
                String holidayLimitId = existedLimitColl.get(i3).getId().toString();
                HolidayLimitInfo limitInfo = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitInfo((IObjectPK)new ObjectUuidPK(holidayLimitId));
                if (!fileHisCollection.get(0).getHrOrgUnit().getId().toString().equals(limitInfo.getHrOrgUnit().getId().toString()) || this.existedLimitMap.put(personInfo.getId().toString(), existedLimitColl.get(i3)) == null) continue;
                logger.error((Object)("person " + personInfo.getName().toString() + " has multi limit record in cur attcycle!"));
            }
        }
        this.ruleBasedDataMap = TakeWorkLimitUtils.ruleBasedInfo(ctx, cycleDate, this.twRule, this.personPositionMap);
        for (Map.Entry<String, Object> entry : this.ruleBasedDataMap.entrySet()) {
            String person = entry.getKey();
            Map mapValue = (Map)entry.getValue();
            String beginTime = HRTimeWebUtils.dateLongToString((Date)mapValue.get("cycleBeginDate"));
            String endTime = HRTimeWebUtils.dateLongToString((Date)mapValue.get("cycleEndDate"));
            if (param.get("bizChangeDate") != null) {
                String date = param.get("bizChangeDate").toString();
                mapValue.put("cycleEndDate", HRTimeWebUtils.stringToShortDate(date));
                this.ruleBasedDataMap.put(person, mapValue);
                continue;
            }
            String changeDate = GenHolidayLimitUtil.isOrgChange(ctx, person, beginTime, endTime);
            if (param.get("calBaseDate") != null || changeDate != null) {
                String date;
                String string = date = param.get("calBaseDate") == null ? changeDate : (String)param.get("calBaseDate");
                if (date.compareTo(endTime) <= 0 && date.compareTo(beginTime) >= 0) {
                    if (cycleDate.compareTo(date) >= 0) {
                        mapValue.put("cycleBeginDate", HRTimeWebUtils.stringToShortDate(date));
                    } else if (cycleDate.compareTo(date) < 0) {
                        mapValue.put("cycleEndDate", HRTimeWebUtils.stringToShortDate(AtsDateUtils.getPreDay(date)));
                        mapValue.put("delayDate", HRTimeWebUtils.stringToShortDate(AtsDateUtils.getPreDay(date)));
                        HolidayLimitInfo holidayLimitInfo = this.existedLimitMap.get(person);
                        if (holidayLimitInfo != null) {
                            holidayLimitInfo.setDelayDate(HRTimeWebUtils.stringToShortDate(AtsDateUtils.getPreDay(date)));
                            holidayLimitInfo.setCycleEndDate(HRTimeWebUtils.stringToShortDate(AtsDateUtils.getPreDay(date)));
                            this.existedLimitMap.put(person, holidayLimitInfo);
                        }
                    }
                }
            }
            this.ruleBasedDataMap.put(person, mapValue);
        }
        AtsHolidayFileHisCollection atsFilehisColl = TakeWorkLimitUtils.getAtsHolidayFileHisColl(ctx, proposers, adminOrgUnit);
        if (null != atsFilehisColl && atsFilehisColl.size() > 0) {
            for (int i4 = 0; i4 < atsFilehisColl.size(); ++i4) {
                AtsHolidayFileHisInfo holidayFileHisInfo = atsFilehisColl.get(i4);
                if (null == holidayFileHisInfo || holidayFileHisInfo.getProposer() == null) continue;
                List<AtsHolidayFileHisInfo> holidayFileHisList = this.atsHolidayFileHisMap.get(holidayFileHisInfo.getProposer().getId().toString());
                if (null == holidayFileHisList) {
                    holidayFileHisList = new ArrayList<AtsHolidayFileHisInfo>();
                    holidayFileHisList.add(holidayFileHisInfo);
                    this.atsHolidayFileHisMap.put(holidayFileHisInfo.getProposer().getId().toString(), holidayFileHisList);
                    continue;
                }
                holidayFileHisList.add(holidayFileHisInfo);
                this.atsHolidayFileHisMap.put(holidayFileHisInfo.getProposer().getId().toString(), holidayFileHisList);
            }
        }
        this.empPosOrgRelationMap = InitHolidayLimitData.getEmpPosOrgRelationMap(ctx, proposers);
        this.empLaborRelationMap = InitHolidayLimitData.getEmpLaborRelationInfoMap(ctx, proposers);
        this.dealCycleDateMap(cycleDate);
        if (this.policyInfo.isIsOverAutoSub()) {
            HolidayLimitCollection prePeriodLimitColl = null;
            try {
                prePeriodLimitColl = TakeWorkLimitUtils.getPrePeriodLimitColl(ctx, this.personIdSet, cycleDate, this.twRule);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (prePeriodLimitColl != null && prePeriodLimitColl.size() > 0) {
                for (int i5 = 0; i5 < prePeriodLimitColl.size(); ++i5) {
                    PersonInfo personInfo = prePeriodLimitColl.get(i5).getProposer();
                    if (personInfo == null) continue;
                    this.preLimitMap.put(personInfo.getId().toString(), prePeriodLimitColl.get(i5));
                }
            }
        }
        this.existedDetailMap = TakeWorkLimitUtils.getExistedDetailColl(ctx, this.personIdSet, this.ruleBasedDataMap);
        if (billPerson.size() > 0) {
            this.prepareOTBill(ctx, cycleDate, billPerson, param);
        }
        if (resultPerson.size() > 0) {
            this.prepareAtsResult(ctx, cycleDate, resultPerson, param);
        }
        HashMap<String, Set<String>> personDateMap = new HashMap<String, Set<String>>();
        HashSet<String> personDateSet = new HashSet<String>();
        HashSet<String> dateSet = new HashSet<String>();
        if (this.twRule.getUnitConvertRule().equals((Object)TakeWorkUnitConvertRule.standarHour)) {
            Set<String> persons;
            if (this.otEntryMap != null && this.otEntryMap.size() > 0) {
                persons = this.otEntryMap.keySet();
                for (String person : persons) {
                    List<AtsOverTimeBillInfo> bills = this.otEntryMap.get(person);
                    if (bills == null || bills.size() <= 0) continue;
                    for (int i6 = 0; i6 < bills.size(); ++i6) {
                        if (personDateMap.get(person) == null) {
                            HashSet personDate = new HashSet();
                            personDateMap.put(person, personDate);
                        }
                        ((Set)personDateMap.get(person)).add(person + "_" + AtsDateUtils.dateShortToString(bills.get(i6).getEntries().get(0).getOtDate()));
                        personDateSet.add(person + "_" + AtsDateUtils.dateShortToString(bills.get(i6).getEntries().get(0).getOtDate()));
                        dateSet.add(AtsDateUtils.dateShortToString(bills.get(i6).getEntries().get(0).getOtDate()));
                    }
                }
            } else if (this.resultMap != null && this.resultMap.size() > 0) {
                persons = this.resultMap.keySet();
                for (String person : persons) {
                    Set<HashMap<String, Object>> ress = this.resultMap.get(person);
                    Iterator<HashMap<String, Object>> it0 = ress.iterator();
                    while (it0.hasNext()) {
                        Date atsDate = (Date)it0.next().get("atsDate");
                        if (personDateMap.get(person) == null) {
                            HashSet personDate = new HashSet();
                            personDateMap.put(person, personDate);
                        }
                        ((Set)personDateMap.get(person)).add(person + "_" + AtsDateUtils.dateShortToString(atsDate));
                        personDateSet.add(person + "_" + AtsDateUtils.dateShortToString(atsDate));
                        dateSet.add(AtsDateUtils.dateShortToString(atsDate));
                    }
                }
            }
            TakeWorkLimitUtils.preStdHour(ctx, cycleDate, this.twRule, param, personDateMap, personDateSet, dateSet, this.attendanceFileMap, this.stdHourMap);
        }
    }

    public Map genLimit(Context ctx, Context jobctx, Map param) throws BOSException, EASBizException, UuidException, SQLException {
        Map<String, HolidayLimitInfo> oldLimitMap = this.cloneExistsLimitMap(this.existedLimitMap);
        param.put("oldHolidayLimitMap", oldLimitMap);
        HashMap<String, Serializable> rtinfoMap = new HashMap<String, Serializable>();
        StringBuffer errorString = new StringBuffer();
        String cycleDate = StringUtils.cnulls(param.get("cycleDate"));
        String year = cycleDate.substring(0, 4);
        String holidayTypeID = "+ZM5jTmrS0KHCjDSYGcFLf0tUpg=";
        HolidayTypeInfo holidayTypeInfo = HolidayTypeFactory.getLocalInstance(ctx).getHolidayTypeInfo(" where id = '" + holidayTypeID + "'");
        if (holidayTypeInfo == null) {
            logger.error((Object)"can not find the holiday type \"vacation leave\"");
        }
        HashMap<String, String> haveExistedPersonMap = new HashMap<String, String>();
        HashSet<String> existedLimitPersonSet = new HashSet<String>();
        for (Map.Entry<String, HolidayLimitInfo> existedLimit : this.existedLimitMap.entrySet()) {
            existedLimitPersonSet.add(existedLimit.getKey());
            haveExistedPersonMap.put(existedLimit.getKey(), existedLimit.getValue().getProposer().getName());
        }
        CoreBaseCollection allLimitColl = new CoreBaseCollection();
        CoreBaseCollection validateFailColl = new CoreBaseCollection();
        int modifedAmt = this.existedLimitMap.size();
        param.put("policyInfo", this.policyInfo);
        param.put("twRule", this.twRule);
        param.put("allLimitColl", allLimitColl);
        param.put("validateFail", validateFailColl);
        this.doGenLimit(ctx, jobctx, errorString, param);
        Map map = (Map)param.get("oldHolidayLimitMap");
        for (Map.Entry entry : map.entrySet()) {
            HolidayLimitInfo info = (HolidayLimitInfo)entry.getValue();
            if (allLimitColl.contains(info.get("id"))) continue;
            allLimitColl.add((CoreBaseInfo)info);
        }
        modifedAmt -= validateFailColl.size();
        rtinfoMap.put("totalAmt", Integer.valueOf(this.personIdSet.size()));
        rtinfoMap.put("existedAmt", Integer.valueOf(existedLimitPersonSet.size()));
        rtinfoMap.put("haveExistedPersonMap", haveExistedPersonMap);
        this.personIdSet.removeAll(existedLimitPersonSet);
        rtinfoMap.put("modifiedAmt", Integer.valueOf(modifedAmt));
        rtinfoMap.put("attfileNotHaveHldply", Integer.valueOf(this.attfileNotHaveHldply));
        rtinfoMap.put("errorString", errorString);
        int generatedAmt = allLimitColl.size() - modifedAmt;
        rtinfoMap.put("generatedAmt", Integer.valueOf(generatedAmt));
        DataSaver saver = new DataSaver();
        saver.setCtx(ctx);
        saver.save(allLimitColl);
        this.calUsedAndFreezedLimit(ctx, allLimitColl, param);
        param.put("NEWLIMIT", allLimitColl);
        this.recordLog(ctx, param);
        return rtinfoMap;
    }

    public void calUsedAndFreezedLimit(Context ctx, CoreBaseCollection allLimitColl, Map param) {
        this.calUsedLimit(ctx, allLimitColl, param);
        this.calFreezedLimit(ctx, allLimitColl, param);
        HashSet<String> personIdSet = new HashSet<String>();
        if (allLimitColl != null && allLimitColl.size() > 0) {
            for (int i = 0; i < allLimitColl.size(); ++i) {
                HolidayLimitInfo limit = (HolidayLimitInfo)allLimitColl.get(i);
                personIdSet.add(limit.getProposer().getId().toString());
            }
        } else {
            return;
        }
        HolidayPolicyInfo policyInfo = (HolidayPolicyInfo)param.get("policyInfo");
        String cycleDate = (String)param.get("cycleDate");
        AtsTakeWorkingInfo twRule = (AtsTakeWorkingInfo)param.get("twRule");
        if (allLimitColl != null && allLimitColl.size() > 0) {
            HolidayLimitCollection holidayLimitCollection = new HolidayLimitCollection();
            for (int i = 0; i < allLimitColl.size(); ++i) {
                HolidayLimitInfo prePeriodLimitInfo;
                HolidayLimitInfo limitInfo = (HolidayLimitInfo)allLimitColl.get(i);
                boolean isPrePeriodSub = false;
                if (policyInfo.isIsOver() && policyInfo.isIsOverAutoSub() && (prePeriodLimitInfo = this.preLimitMap.get(limitInfo.getProposer().getId().toString())) != null && prePeriodLimitInfo.getRemainLimit().doubleValue() < 0.0) {
                    limitInfo.setRemainLimit(limitInfo.getRealLimit().subtract(limitInfo.getUsedLimit()).subtract(limitInfo.getFreezeLimit()).add(prePeriodLimitInfo.getRemainLimit()));
                    limitInfo.setPreOverdraftLimit(prePeriodLimitInfo.getRemainLimit().abs());
                    isPrePeriodSub = true;
                }
                if (!isPrePeriodSub) {
                    limitInfo.setRemainLimit(limitInfo.getRealLimit().subtract(limitInfo.getUsedLimit()).subtract(limitInfo.getFreezeLimit()));
                    limitInfo.setPreOverdraftLimit(BigDecimal.valueOf(0.0));
                }
                holidayLimitCollection.add(limitInfo);
            }
            logger.debug((Object)"execute shiftTotalRemainLimit and remainLimit update ");
            GenHolidayLimitManager genHolidayLimitManager = new GenHolidayLimitManager();
            genHolidayLimitManager.addShiftTotalRemainLimit(holidayLimitCollection, (boolean)Boolean.FALSE, ctx);
        }
        try {
            DataSaver saver = new DataSaver();
            saver.setCtx(ctx);
            saver.save(allLimitColl);
            this.mergeHolidayLimitDetail(ctx, allLimitColl);
            this.dealOverdraftLimitDetail(ctx, allLimitColl);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public void calUsedLimit(Context ctx, CoreBaseCollection allLimitColl, Map param) {
        HashMap<String, HolidayLimitInfo> holidayLimitInfoMap = new HashMap<String, HolidayLimitInfo>();
        StringBuffer limitIds = new StringBuffer();
        HashMap<String, HolidayLimitInfo> unExistUsedLimitMap = new HashMap<String, HolidayLimitInfo>(holidayLimitInfoMap);
        if (allLimitColl != null) {
            for (int i = 0; i < allLimitColl.size(); ++i) {
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)allLimitColl.get(i);
                limitIds.append(",'" + holidayLimitInfo.getId().toString() + "'");
                holidayLimitInfoMap.put(holidayLimitInfo.getId().toString(), holidayLimitInfo);
                unExistUsedLimitMap.put(holidayLimitInfo.getId().toString(), holidayLimitInfo);
            }
        }
        if (holidayLimitInfoMap.size() < 1) {
            return;
        }
        String limitIdsStr = limitIds.toString().substring(1);
        StringBuffer sql = new StringBuffer();
        try {
            HolidayLimitInfo holidayLimitInfo;
            sql.append(" select fholidayLimitid,sum(fChangeValue) as usedLeaveLength \n").append("   from ( \n").append(" select distinct L.Fid as fholidaylimitid,hld.fid holidayLimitDetailId,hld.fChangeValue ").append("        FROM T_HR_ATS_LeaveBillEntry E \n").append("        left join t_hr_ats_holidaypolicy P on E.fpolicyid=P.fid \n").append("        INNER JOIN T_HR_ATS_LeaveBill  M ON E.FBILLID=M.FID \n").append("        INNER JOIN T_HR_ATS_HolidayLimitDetail  hld ON hld.FLEAVEBILLID=m.fid and E.fpersonId = hld.Fproposerid \n").append("        INNER JOIN t_Hr_Ats_Holidaylimit L on hld.FHOLIDAYLIMITID=L.FID and L.Fproposerid=E.Fpersonid \n").append("        where M.FBILLSTATE in (3) \n").append("        and P.fholidaytypeid = '+ZM5jTmrS0KHCjDSYGcFLf0tUpg=' \n").append("        and L.Fid in(" + limitIdsStr + ") \n").append("        and ( L.fCycleBeginDate<=E.FRealBeginTime and E.FRealBeginTime< dateadd(day,1,L.FDelayDate))  \n").append("        and hld.FCancelLeaveBillID is null and hld.FChangeType = 4").append("     )  tt group by  fholidaylimitid \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String limitId = rs.getString("fholidaylimitid");
                holidayLimitInfo = (HolidayLimitInfo)holidayLimitInfoMap.get(limitId);
                if (holidayLimitInfo == null) continue;
                holidayLimitInfo.setUsedLimit(rs.getBigDecimal("usedleavelength"));
                unExistUsedLimitMap.remove(limitId);
            }
            sql = new StringBuffer();
            sql.append("  select fholidaytypeid,fyear,fproposerid,fholidaylimitid,sum(FREALLEAVELENGTH) as usedleavelength \n").append("   from ( \n").append("   select  distinct L.Fid as fholidaylimitid, L.Fproposerid, L.Fyear, \n").append("    E.FRealLeaveLength, M.fid, P.fholidaytypeid,E.FID entryID \n").append("        FROM T_HR_ATS_LeaveBillEntry E \n").append("        left join t_hr_ats_holidaypolicy P on E.fpolicyid=P.fid \n").append("        INNER JOIN T_HR_ATS_LeaveBill  M ON E.FBillID=M.FID \n").append("        INNER JOIN T_HR_ATS_HolidayLimitDetail  hld ON hld.FLEAVEBILLID=m.fid and E.fpersonId = hld.Fproposerid\n").append("        INNER JOIN t_Hr_Ats_Holidaylimit L on L.Fproposerid=E.Fpersonid \n").append("        where M.FBillState in(3) \n").append("        and P.fholidaytypeid='+ZM5jTmrS0KHCjDSYGcFLf0tUpg='  \n").append("        and ( L.fCycleBeginDate<=E.FRealBeginTime and E.FRealBeginTime<=L.FDelayDate)  \n").append("        and L.Fid in(" + limitIdsStr + ") \n").append("        and hld.FCancelLeaveBillID is null and hld.FHolidayLimitID is null  and hld.FChangeType = 4").append("     )  tt group by fholidaytypeid,Fyear,Fproposerid , fholidaylimitid \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String fholidaylimitid = rs.getString("fholidaylimitid");
                holidayLimitInfo = (HolidayLimitInfo)holidayLimitInfoMap.get(fholidaylimitid);
                if (holidayLimitInfo == null) continue;
                holidayLimitInfo.setUsedLimit(holidayLimitInfo.getUsedLimit().add(rs.getBigDecimal("usedleavelength")));
                unExistUsedLimitMap.remove(fholidaylimitid);
            }
            sql = new StringBuffer();
            sql.append("  select P.fholidaytypeid,L.Fyear,L.Fproposerid,hld.FLEAVEBILLID,L.Fid as fholidaylimitid,hld.fid holidayLimitDetailId \n").append("        FROM T_HR_ATS_LeaveBillEntry E \n").append("        left join t_hr_ats_holidaypolicy P on E.fpolicyid=P.fid \n").append("        INNER JOIN T_HR_ATS_LeaveBill  M ON E.FBILLID=M.FID \n").append("        INNER JOIN T_HR_ATS_HolidayLimitDetail  hld ON hld.FLEAVEBILLID=m.fid and E.fpersonId = hld.Fproposerid \n").append("        INNER JOIN t_Hr_Ats_Holidaylimit L on L.Fproposerid=E.Fpersonid ").append("\t     INNER JOIN t_hr_ats_holidaypolicy Lhp ON Lhp.fid = L.FHOLIDAYPOLICYID ").append("        and L.Fproposerid=E.Fpersonid \tAND Lhp.fholidaytypeid =p.fholidaytypeid \n ").append("        where M.FBILLSTATE in(3) \n").append("        and P.fholidaytypeid='+ZM5jTmrS0KHCjDSYGcFLf0tUpg='  \n").append("        and ( L.fcyclebegindate<=E.Frealbegintime and E.Frealbegintime<=L.FDELAYDATE )  \n").append("        and L.Fid in(" + limitIdsStr + ") \n").append("        and hld.FCANCELLEAVEBILLID is null and hld.FHOLIDAYLIMITID is null and hld.FCHANGETYPE = 4");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashMap<String, String> map = new HashMap<String, String>();
            HashSet<String> holidayLimitDetailIdSet = new HashSet<String>();
            while (rs.next()) {
                map.put(rs.getString("holidayLimitDetailId"), rs.getString("fholidaylimitid"));
                holidayLimitDetailIdSet.add(rs.getString("holidayLimitDetailId"));
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", holidayLimitDetailIdSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            IHolidayLimitDetail holidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            HolidayLimitDetailCollection holidayLimitDetailCollection = holidayLimitDetail.getHolidayLimitDetailCollection(evi);
            CoreBaseCollection limitDetailColl = new CoreBaseCollection();
            for (int i = 0; i < holidayLimitDetailCollection.size(); ++i) {
                HolidayLimitDetailInfo imitDetailI = holidayLimitDetailCollection.get(i);
                HolidayLimitInfo li = new HolidayLimitInfo();
                li.setId(BOSUuid.read((String)((String)map.get(imitDetailI.getId().toString()))));
                imitDetailI.setHolidayLimit(li);
                limitDetailColl.add((CoreBaseInfo)imitDetailI);
            }
            DataSaver saver = new DataSaver();
            saver.setCtx(ctx);
            saver.save(limitDetailColl);
            Set unExistUsedLimitColl = unExistUsedLimitMap.entrySet();
            for (Map.Entry entry : unExistUsedLimitColl) {
                HolidayLimitInfo unExistUsedLimitInfo = (HolidayLimitInfo)entry.getValue();
                unExistUsedLimitInfo.setUsedLimit(BigDecimal.ZERO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void calFreezedLimit(Context ctx, CoreBaseCollection allLimitColl, Map param) {
        StringBuilder limitIds = new StringBuilder();
        HashMap<String, HolidayLimitInfo> holidayLimitInfoMap = new HashMap<String, HolidayLimitInfo>();
        HashMap<String, HolidayLimitInfo> unExistFreezedLimitMap = new HashMap<String, HolidayLimitInfo>();
        if (allLimitColl != null) {
            for (int i = 0; i < allLimitColl.size(); ++i) {
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)allLimitColl.get(i);
                limitIds.append(",'" + holidayLimitInfo.getId().toString() + "'");
                holidayLimitInfoMap.put(holidayLimitInfo.getId().toString(), holidayLimitInfo);
                unExistFreezedLimitMap.put(holidayLimitInfo.getId().toString(), holidayLimitInfo);
            }
        }
        if (holidayLimitInfoMap.size() < 1) {
            return;
        }
        String limitIdStr = limitIds.toString().substring(1);
        try {
            HolidayLimitInfo holidayLimitInfo;
            String fholidaylimitid;
            StringBuilder sql = new StringBuilder();
            sql.append("  select fholidaylimitid,sum(FCHANGEVALUE) as freezedlimitlength \n").append("   from ( \n").append(" select distinct L.Fid as fholidaylimitid,hld.fid holidayLimitDetailId,hld.fChangeValue ").append("        FROM T_HR_ATS_LeaveBillEntry E \n").append("        left join t_hr_ats_holidaypolicy P on E.fpolicyid=P.fid \n").append("        INNER JOIN T_HR_ATS_LeaveBill  M ON E.FBILLID=M.FID \n").append("        INNER JOIN T_HR_ATS_HolidayLimitDetail  hld ON hld.FLEAVEBILLID=m.fid and E.fpersonId = hld.Fproposerid \n").append("        INNER JOIN t_Hr_Ats_Holidaylimit L on hld.FHOLIDAYLIMITID=L.FID and L.Fproposerid=E.Fpersonid \n").append("        where M.FBILLSTATE in(1,2) \n").append("        and P.fholidaytypeid='+ZM5jTmrS0KHCjDSYGcFLf0tUpg='  \n").append("        and L.Fid in(" + limitIdStr + ") \n").append("        and ( L.fCycleBeginDate<=E.FRealBeginTime and E.FRealBeginTime<=L.FDelayDate)  \n").append("        and hld.FCANCELLEAVEBILLID is null and hld.FCHANGETYPE = 6").append("     )  tt group by  fholidaylimitid \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                fholidaylimitid = rs.getString("fholidaylimitid");
                holidayLimitInfo = (HolidayLimitInfo)holidayLimitInfoMap.get(fholidaylimitid);
                if (holidayLimitInfo == null) continue;
                holidayLimitInfo.setFreezeLimit(rs.getBigDecimal("freezedlimitlength"));
                unExistFreezedLimitMap.remove(fholidaylimitid);
            }
            sql = new StringBuilder();
            sql.append("  select fholidaytypeid,fyear,fproposerid,fholidaylimitid,sum(FREALLEAVELENGTH) as freezedlimitlength \n").append("   from ( \n").append("   select  distinct L.Fid as fholidaylimitid,L.Fproposerid,L.Fyear, \n").append("    E.FREALLEAVELENGTH,P.fholidaytypeid,M.fid billId,E.FID entryId \n").append("        FROM T_HR_ATS_LeaveBillEntry E \n").append("        left join t_hr_ats_holidaypolicy P on E.fpolicyid=P.fid \n").append("        INNER JOIN T_HR_ATS_LeaveBill  M ON E.FBILLID=M.FID \n").append("        INNER JOIN T_HR_ATS_HolidayLimitDetail  hld ON hld.FLEAVEBILLID=m.fid and E.fpersonId = hld.Fproposerid \n").append("        INNER JOIN t_Hr_Ats_Holidaylimit L on L.Fproposerid=E.Fpersonid \n").append("        where M.FBILLSTATE in(1,2) \n").append("        and P.fholidaytypeid='+ZM5jTmrS0KHCjDSYGcFLf0tUpg='  \n").append("        and ( L.fcyclebegindate<=E.Frealbegintime and E.Frealbegintime<=L.FDELAYDATE)  \n").append("        and L.Fid in(" + limitIdStr + ") \n").append("        and hld.FCANCELLEAVEBILLID is null and hld.FHOLIDAYLIMITID is null  and hld.FCHANGETYPE = 6").append("     )  tt group by fholidaytypeid,Fyear,Fproposerid , fholidaylimitid \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                fholidaylimitid = rs.getString("fholidaylimitid");
                holidayLimitInfo = (HolidayLimitInfo)holidayLimitInfoMap.get(fholidaylimitid);
                if (holidayLimitInfo == null) continue;
                holidayLimitInfo.setFreezeLimit(holidayLimitInfo.getFreezeLimit().add(rs.getBigDecimal("freezedlimitlength")));
                unExistFreezedLimitMap.remove(fholidaylimitid);
            }
            sql = new StringBuilder();
            sql.append("  select    P.fholidaytypeid,L.Fyear,L.Fproposerid,hld.FLEAVEBILLID,L.Fid as fholidaylimitid,hld.fid holidayLimitDetailId \n").append("        FROM T_HR_ATS_LeaveBillEntry E \n").append("        left join t_hr_ats_holidaypolicy P on E.fpolicyid=P.fid \n").append("        INNER JOIN T_HR_ATS_LeaveBill  M ON E.FBILLID=M.FID \n").append("        INNER JOIN T_HR_ATS_HolidayLimitDetail  hld ON hld.FLEAVEBILLID=m.fid and E.fpersonId = hld.Fproposerid \n").append("        INNER JOIN t_Hr_Ats_Holidaylimit L on L.Fproposerid=E.Fpersonid  and  hld.Fproposerid = L.Fproposerid \n").append("        where M.FBILLSTATE in(1,2) \n").append("        and P.fholidaytypeid='+ZM5jTmrS0KHCjDSYGcFLf0tUpg='  \n").append("        and ( L.fcyclebegindate<=E.Frealbegintime and E.Frealbegintime<=L.FDELAYDATE)  \n").append("        and L.Fid in(" + limitIdStr + ") \n").append("        and hld.FCANCELLEAVEBILLID is null  and hld.FHOLIDAYLIMITID is null and hld.FCHANGETYPE  = 6");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashMap<String, String> map = new HashMap<String, String>();
            HashSet<String> holidayLimitDetailIdSet = new HashSet<String>();
            while (rs.next()) {
                map.put(rs.getString("holidayLimitDetailId"), rs.getString("fholidaylimitid"));
                holidayLimitDetailIdSet.add(rs.getString("holidayLimitDetailId"));
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", holidayLimitDetailIdSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            IHolidayLimitDetail holidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            HolidayLimitDetailCollection limitDetailColl = holidayLimitDetail.getHolidayLimitDetailCollection(evi);
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            for (int i = 0; i < limitDetailColl.size(); ++i) {
                HolidayLimitDetailInfo limitDetail = limitDetailColl.get(i);
                HolidayLimitInfo limit = new HolidayLimitInfo();
                limit.setId(BOSUuid.read((String)((String)map.get(limitDetail.getId().toString()))));
                limitDetail.setHolidayLimit(limit);
                coreBaseColl.add((CoreBaseInfo)limitDetail);
            }
            DataSaver saver = new DataSaver();
            saver.setCtx(ctx);
            saver.save(coreBaseColl);
            Set unExistFreezedLimitColl = unExistFreezedLimitMap.entrySet();
            for (Map.Entry entry : unExistFreezedLimitColl) {
                HolidayLimitInfo unExistFreezedLimitInfo = (HolidayLimitInfo)entry.getValue();
                unExistFreezedLimitInfo.setFreezeLimit(BigDecimal.ZERO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGenLimit(Context ctx, Context jobctx, StringBuffer errorString, Map param) throws EASBizException, BOSException, UuidException, SQLException {
        Set<String> personIDs = this.personPositionMap.keySet();
        if (personIDs != null && personIDs.size() > 0) {
            Iterator<String> it = personIDs.iterator();
            while (it.hasNext()) {
                String proposerID = "";
                try {
                    String errorMsg;
                    HolidayLimitInfo limitInfo;
                    proposerID = it.next();
                    System.out.println(" ot trans takeWork person\uff1a" + proposerID);
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    boolean exit = false;
                    HolidayPolicyInfo policyInfo = (HolidayPolicyInfo)param.get("policyInfo");
                    PersonPositionInfo personPosition = this.personPositionMap.get(proposerID);
                    String hrOrgUnitId = (String)param.get("hrOrgUnit");
                    if (!exit && !((HolidayPolicyInfo)param.get("policyInfo")).isIsCtrlLimit()) {
                        errorString = errorString.append(personPosition.getPerson().getName()).append(MLUtile.getRes(AtsHolidayResEnum.GenerateLimitFail15, ctx)).append("<br/>");
                        exit = true;
                    }
                    if (!exit && param.get("twRule") == null) {
                        errorString = errorString.append(personPosition.getPerson().getName()).append(MLUtile.getRes(AtsHolidayResEnum.GenerateLimitFail16, ctx));
                        exit = true;
                    }
                    if (this.twRule.getState().getValue() == 2) {
                        errorString = errorString.append(this.personPositionMap.get(proposerID).getPerson().getName()).append(MLUtile.getRes(AtsHolidayResEnum.NoAtsTakeWorking, ctx));
                        exit = true;
                    }
                    if ((limitInfo = this.existedLimitMap.get(proposerID)) != null && param.get("bizChangeDate") != null) {
                        limitInfo.setCycleEndDate(AtsDateUtils.stringToShortDate(param.get("bizChangeDate").toString()));
                    }
                    Map ruleBasedData = (Map)this.ruleBasedDataMap.get(proposerID);
                    Date ruleCycleBeginDate = (Date)ruleBasedData.get("cycleBeginDate");
                    Date ruleCycleEndDate = (Date)ruleBasedData.get("cycleEndDate");
                    AtsHolidayFileHisInfo holidayFileHis = null;
                    List<AtsHolidayFileHisInfo> holidayFileHisList = this.atsHolidayFileHisMap.get(proposerID);
                    if (null != holidayFileHisList && holidayFileHisList.size() > 0) {
                        holidayFileHis = this.getAtsHolidayFileHisInfo(proposerID, hrOrgUnitId, holidayFileHisList);
                        if (StringUtils.isEmpty((String)((String)param.get("hrOrgUnit"))) && holidayFileHis != null && holidayFileHis.getHrOrgUnit() != null && holidayFileHis.getHrOrgUnit().getId() != null) {
                            hrOrgUnitId = holidayFileHis.getHrOrgUnit().getId().toString();
                        }
                    }
                    if (!(limitInfo != null && limitInfo.getId() != null || StringUtils.isEmpty((String)(errorMsg = GenHolidayLimitUtil.isHolidayLimitIntersect(ctx, proposerID, policyInfo.getId().toString(), personPosition.getPerson().getName(), policyInfo.getName(), ruleCycleBeginDate, ruleCycleEndDate, hrOrgUnitId))))) {
                        errorString = errorString.append(errorMsg);
                        exit = true;
                    }
                    if (!exit && limitInfo != null) {
                        Date cycleBeginDate = limitInfo.getCycleBeginDate();
                        Date cycleEndDate = limitInfo.getCycleEndDate();
                        if (ruleCycleBeginDate.compareTo(cycleEndDate) < 0 && ruleCycleEndDate.compareTo(cycleBeginDate) > 0 && ruleCycleBeginDate.compareTo(cycleBeginDate) != 0 && ruleCycleEndDate.compareTo(cycleEndDate) != 0) {
                            errorString = errorString.append(MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.GenreateLimitFailForCrossInCycle, ctx, this.personPositionMap.get(proposerID).getPerson().getName(), AtsDateUtils.dateShortToString(limitInfo.getCycleBeginDate()) + "~" + AtsDateUtils.dateShortToString(limitInfo.getCycleEndDate()), AtsDateUtils.dateShortToString((Date)ruleBasedData.get("cycleBeginDate")) + "~" + AtsDateUtils.dateShortToString((Date)ruleBasedData.get("cycleEndDate"))));
                            exit = true;
                        }
                    }
                    if (exit) {
                        dataMap.put("success", 0);
                        ((CoreBaseCollection)param.get("validateFail")).add((CoreBaseInfo)limitInfo);
                    } else if (null != holidayFileHis) {
                        dataMap.putAll(param);
                        dataMap.put("proposerID", proposerID);
                        dataMap.put("atsFile", this.attendanceFileMap.get(proposerID));
                        dataMap.put("atsHolidayFileHis", holidayFileHis);
                        dataMap.put("personPosition", this.personPositionMap.get(proposerID));
                        dataMap.put("existedLimit", limitInfo);
                        dataMap.put("preLimit", this.preLimitMap.get(proposerID));
                        dataMap.put("existedDetail", this.existedDetailMap.get(proposerID));
                        dataMap.put("ruleBasedData", this.ruleBasedDataMap.get(proposerID));
                        dataMap.put("bill", this.otEntryMap.get(proposerID));
                        dataMap.put("res", this.resultMap.get(proposerID));
                        dataMap.put("stdHour", this.stdHourMap);
                        dataMap.put("success", 0);
                        CoreCalTakeWorkLimit calLimitService = TakeWorkLimitFactory.getInstance(ctx, this.twRule, dataMap);
                        calLimitService.generateTakeWorkLimit(ctx, dataMap);
                    }
                    if (null == dataMap.get("success")) continue;
                    if ((Integer)dataMap.get("success") == 1) {
                        ++this.successTimes;
                        continue;
                    }
                    ++this.failTimes;
                    if (dataMap.get("errorStr") == null) continue;
                    errorString = errorString.append(this.personPositionMap.get(proposerID).getPerson().getName()).append(dataMap.get("errorStr"));
                }
                catch (Exception e) {
                    System.out.println("ot trans takeWork fail\uff1a" + proposerID);
                    e.printStackTrace();
                }
            }
        }
    }

    private AtsHolidayFileHisInfo getAtsHolidayFileHisInfo(String proposerID, String hrOrgUnitId, List<AtsHolidayFileHisInfo> holidayFileHisList) {
        AtsHolidayFileHisInfo holidayFileHis = null;
        for (int i = 0; i < holidayFileHisList.size(); ++i) {
            Map ruleBasedMap;
            AtsHolidayFileHisInfo holidayFileHisInfo = holidayFileHisList.get(i);
            if (null == holidayFileHisInfo || null == (ruleBasedMap = (Map)this.ruleBasedDataMap.get(proposerID))) continue;
            Date cycleBeginDate = (Date)ruleBasedMap.get("cycleBeginDate");
            Date cycleEndDate = (Date)ruleBasedMap.get("cycleEndDate");
            Date effdt = holidayFileHisInfo.getEFFDT();
            Date leffdt = holidayFileHisInfo.getLEFFDT();
            if (cycleBeginDate.getTime() > leffdt.getTime() || cycleEndDate.getTime() < effdt.getTime()) continue;
            if (!StringUtils.isEmpty((String)hrOrgUnitId)) {
                if (!hrOrgUnitId.equals(holidayFileHisInfo.getHrOrgUnit().getId().toString())) continue;
                holidayFileHis = holidayFileHisInfo;
                break;
            }
            holidayFileHis = holidayFileHisInfo;
            break;
        }
        return holidayFileHis;
    }

    private void mergeHolidayLimitDetail(Context ctx, CoreBaseCollection colls) {
        if (colls != null && colls.size() > 0) {
            int i;
            HashSet<String> holidayLimitIdSet = new HashSet<String>();
            for (int i2 = 0; i2 < colls.size(); ++i2) {
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)colls.get(i2);
                holidayLimitIdSet.add(holidayLimitInfo.getId().toString());
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("holidayLimit.id", holidayLimitIdSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("changeType", (Object)HolidayLimitChangeType.init.getValue(), CompareType.EQUALS));
            evi.setFilter(fi);
            HashMap<String, HolidayLimitDetailInfo> holidayLimitDetailMap = new HashMap<String, HolidayLimitDetailInfo>();
            try {
                IHolidayLimitDetail holidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
                HolidayLimitDetailCollection holidayLimitDetailCollection = holidayLimitDetail.getHolidayLimitDetailCollection(evi);
                for (i = 0; i < holidayLimitDetailCollection.size(); ++i) {
                    holidayLimitDetailMap.put(holidayLimitDetailCollection.get(i).getHolidayLimit().getId().toString(), holidayLimitDetailCollection.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Timestamp nowTimestamp = new Timestamp(new Date().getTime());
            CoreBaseCollection newHolidayLimitDetailCollection = new CoreBaseCollection();
            for (i = 0; i < colls.size(); ++i) {
                HolidayLimitDetailInfo holidayLimitDetailInfo;
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)colls.get(i);
                if (holidayLimitDetailMap.containsKey(holidayLimitInfo.getId().toString())) {
                    holidayLimitDetailInfo = (HolidayLimitDetailInfo)holidayLimitDetailMap.get(holidayLimitInfo.getId().toString());
                    holidayLimitDetailInfo.setChangeDate(nowTimestamp);
                    holidayLimitDetailInfo.setChangeType(HolidayLimitChangeType.init);
                    holidayLimitDetailInfo.setChangeValue(holidayLimitInfo.getRemainLimit());
                    newHolidayLimitDetailCollection.add((CoreBaseInfo)holidayLimitDetailInfo);
                    continue;
                }
                holidayLimitDetailInfo = new HolidayLimitDetailInfo();
                holidayLimitDetailInfo.setYear(holidayLimitInfo.getYear());
                holidayLimitDetailInfo.setChangeDate(nowTimestamp);
                holidayLimitDetailInfo.setChangeType(HolidayLimitChangeType.init);
                holidayLimitDetailInfo.setHolidayLimit(holidayLimitInfo);
                holidayLimitDetailInfo.setChangeValue(holidayLimitInfo.getRemainLimit());
                holidayLimitDetailInfo.setChangeUnit(holidayLimitInfo.getHolidayUnit());
                holidayLimitDetailInfo.setStatus(HolidayLimitDetailStatusEnum.valid);
                holidayLimitDetailInfo.setProposer(holidayLimitInfo.getProposer());
                holidayLimitDetailInfo.setAdminOrgUnit(holidayLimitInfo.getAdminOrgUnit());
                holidayLimitDetailInfo.setHrOrgUnit(holidayLimitInfo.getHrOrgUnit());
                holidayLimitDetailInfo.setPosition(holidayLimitInfo.getPosition());
                newHolidayLimitDetailCollection.add((CoreBaseInfo)holidayLimitDetailInfo);
            }
            try {
                DataSaver saver = new DataSaver();
                saver.setCtx(ctx);
                saver.save(newHolidayLimitDetailCollection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void dealOverdraftLimitDetail(Context ctx, CoreBaseCollection colls) {
        if (colls == null || colls.size() < 1) {
            return;
        }
        StringBuilder holidayLimitIdSB_L0 = new StringBuilder("''");
        StringBuilder holidayLimitIdSB_GE0 = new StringBuilder("''");
        StringBuilder allHolidayLimitIdSB = new StringBuilder("''");
        HashMap<String, HolidayLimitInfo> holidayLimit_L0_Map = new HashMap<String, HolidayLimitInfo>();
        HashSet<String> holidayLimit_L0_Set = new HashSet<String>();
        try {
            int size = colls.size();
            int k = 0;
            int j = 0;
            while (k < size) {
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)colls.get(k);
                if (holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == -1) {
                    holidayLimitIdSB_L0.append(",'" + holidayLimitInfo.getId().toString() + "'");
                    allHolidayLimitIdSB.append(",'" + holidayLimitInfo.getId().toString() + "'");
                    holidayLimit_L0_Map.put(holidayLimitInfo.getId().toString(), holidayLimitInfo);
                    holidayLimit_L0_Set.add(holidayLimitInfo.getId().toString());
                } else {
                    holidayLimitIdSB_GE0.append(",'" + holidayLimitInfo.getId().toString() + "'");
                }
                if (j > 100) {
                    String sql = " delete  from T_HR_ATS_HolidayLimitDetail where FHOLIDAYLIMITID in(?) and FCHANGETYPE =  7";
                    Object[] params1_GE0 = new Object[]{holidayLimitIdSB_GE0.toString()};
                    Object[] params2_L0 = new Object[]{holidayLimitIdSB_L0.toString()};
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])params1_GE0);
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])params2_L0);
                    j = 0;
                    holidayLimitIdSB_GE0.setLength(0);
                    holidayLimitIdSB_GE0.append("''");
                    holidayLimitIdSB_L0.setLength(0);
                    holidayLimitIdSB_L0.append("''");
                }
                ++k;
                ++j;
            }
            IHolidayLimitDetail holidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            HolidayLimitDetailCollection holidayLimitDetailCollection_FR_DE = holidayLimitDetail.getHolidayLimitDetailCollection(" where holidayLimit.id in(" + allHolidayLimitIdSB.toString() + ") and changeType in(" + 4 + "," + 6 + ")  order by holidayLimit.id asc, changeDate asc ");
            String FHOLIDAYLIMITID_Temp = "";
            BigDecimal FCHANGEVALUE_SUM = BigDecimal.valueOf(0.0);
            BigDecimal FHolidayLimitValue_avaluable = BigDecimal.valueOf(0.0);
            CoreBaseCollection detailColls = new CoreBaseCollection();
            HolidayLimitDetailInfo holidayLimitDetailInfo_H1 = new HolidayLimitDetailInfo();
            for (int i = 0; i < holidayLimitDetailCollection_FR_DE.size(); ++i) {
                HolidayLimitDetailInfo holidayLimitDetailInfo = holidayLimitDetailCollection_FR_DE.get(i);
                String FHOLIDAYLIMITID = holidayLimitDetailInfo.getHolidayLimit().getId().toString();
                BigDecimal FCHANGEVALUE = holidayLimitDetailInfo.getChangeValue();
                if (!FHOLIDAYLIMITID_Temp.equals(FHOLIDAYLIMITID)) {
                    FHOLIDAYLIMITID_Temp = FHOLIDAYLIMITID;
                    FHolidayLimitValue_avaluable = ((HolidayLimitInfo)holidayLimit_L0_Map.get(FHOLIDAYLIMITID)).getStandardLimit().subtract(((HolidayLimitInfo)holidayLimit_L0_Map.get(FHOLIDAYLIMITID)).getPreOverdraftLimit());
                    FCHANGEVALUE_SUM = FCHANGEVALUE;
                    holidayLimitDetailInfo_H1 = holidayLimitDetailInfo;
                } else {
                    FCHANGEVALUE_SUM = FCHANGEVALUE_SUM.add(FCHANGEVALUE);
                }
                if (FCHANGEVALUE_SUM.compareTo(FHolidayLimitValue_avaluable) != 1) continue;
                HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
                detailInfo.setProposer(holidayLimitDetailInfo_H1.getProposer());
                detailInfo.setAdminOrgUnit(holidayLimitDetailInfo_H1.getAdminOrgUnit());
                detailInfo.setPosition(holidayLimitDetailInfo_H1.getPosition());
                detailInfo.setHrOrgUnit(holidayLimitDetailInfo_H1.getHrOrgUnit());
                detailInfo.setYear(holidayLimitDetailInfo_H1.getYear());
                detailInfo.setChangeDate(HRTimeWebUtils.dateToTimestamp(new Date()));
                detailInfo.setCreateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
                detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
                detailInfo.setLeaveBill(holidayLimitDetailInfo_H1.getLeaveBill());
                detailInfo.setLeaveBillNumber(holidayLimitDetailInfo_H1.getLeaveBill().getNumber());
                detailInfo.setHolidayLimit(holidayLimitDetailInfo_H1.getHolidayLimit());
                detailInfo.setChangeType(HolidayLimitChangeType.overdraft);
                if (FCHANGEVALUE_SUM.compareTo(FHolidayLimitValue_avaluable.add(FCHANGEVALUE)) >= 0) {
                    detailInfo.setChangeValue(FCHANGEVALUE);
                } else {
                    detailInfo.setChangeValue(FCHANGEVALUE_SUM.subtract(FHolidayLimitValue_avaluable));
                }
                detailInfo.setChangeUnit(holidayLimitDetailInfo_H1.getChangeUnit());
                detailColls.add((CoreBaseInfo)detailInfo);
            }
            DataSaver saver = new DataSaver();
            saver.setCtx(ctx);
            saver.save(detailColls);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareOTBill(Context ctx, String cycleDate, HashSet<String> billPerson, Map param) {
        AtsOverTimeBillCollection otBillColl = new AtsOverTimeBillCollection();
        for (String personID : billPerson) {
            HolidayLimitInfo limitInfo = null;
            String cycleBeginDate = null;
            String cycleEndDate = null;
            if (null != this.existedLimitMap && this.existedLimitMap.size() > 0) {
                limitInfo = this.existedLimitMap.get(personID);
            }
            Map ruleBasedData = (Map)this.ruleBasedDataMap.get(personID);
            if (param.get("bizChangeDate") != null) {
                cycleBeginDate = AtsDateUtils.tsDateStr((Date)ruleBasedData.get("cycleBeginDate"));
                cycleEndDate = AtsDateUtils.tsDateStr((Date)ruleBasedData.get("cycleEndDate"));
            } else if (limitInfo != null && limitInfo.getCycleBeginDate() != null) {
                cycleBeginDate = AtsDateUtils.tsDateStr(limitInfo.getCycleBeginDate());
                cycleEndDate = AtsDateUtils.tsDateStr(limitInfo.getCycleEndDate());
            } else {
                cycleBeginDate = AtsDateUtils.tsDateStr((Date)ruleBasedData.get("cycleBeginDate"));
                cycleEndDate = AtsDateUtils.tsDateStr((Date)ruleBasedData.get("cycleEndDate"));
            }
            String sql = " select entry.fid entryID, entry.fBillId billID  from t_hr_ats_overTimeBillEntry entry  inner join t_hr_ats_overTimeBill otBill on entry.fBillID = otBill.fID  where entry.fpersonId = '" + personID + "'  and entry.fCalculateState = 1  and otBill.fBillState = " + 3 + " and entry.fOTCompensID = '" + "AERg0TIcSnaM40EKvJCdRKlrTmA=" + "' and entry.fOTDate >= " + cycleBeginDate + " and entry.fOTDate <= " + cycleEndDate + "";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    String entryID = rs.getString("entryID");
                    String billID = rs.getString("billID");
                    AtsOverTimeBillEntryInfo entry = AtsOverTimeBillEntryFactory.getLocalInstance(ctx).getAtsOverTimeBillEntryInfo("where id = '" + entryID + "'");
                    AtsOverTimeBillInfo bill = AtsOverTimeBillFactory.getLocalInstance(ctx).getAtsOverTimeBillInfo("where id = '" + billID + "'");
                    bill.getEntries().clear();
                    bill.getEntries().add(entry);
                    String proposerID = entry.getPerson().getId().toString();
                    if (this.otEntryMap.containsKey(proposerID) && this.otEntryMap.get(proposerID) != null) {
                        this.otEntryMap.get(proposerID).add(bill);
                        continue;
                    }
                    ArrayList<AtsOverTimeBillInfo> bills = new ArrayList<AtsOverTimeBillInfo>();
                    bills.add(bill);
                    this.otEntryMap.put(proposerID, bills);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    private void prepareAtsResult(Context ctx, String cycleDate, Set resultPerson, Map map) {
        OTtoTakeWorkDetailCollection detailColl = new OTtoTakeWorkDetailCollection();
        for (String personID : resultPerson) {
            AbstractHolidayLimitInfo limitInfo = null;
            String cycleBeginDate = null;
            String cycleEndDate = null;
            if (null != this.existedLimitMap && this.existedLimitMap.size() > 0) {
                limitInfo = this.existedLimitMap.get(this.personPositionMap.get(personID));
            }
            Map ruleBasedData = (Map)this.ruleBasedDataMap.get(personID);
            if (limitInfo != null && limitInfo.getCycleBeginDate() != null) {
                cycleBeginDate = AtsDateUtils.tsDateStr(limitInfo.getCycleBeginDate());
                cycleEndDate = AtsDateUtils.tsDateStr(limitInfo.getCycleEndDate());
            } else {
                cycleBeginDate = AtsDateUtils.tsDateStr((Date)ruleBasedData.get("cycleBeginDate"));
                cycleEndDate = AtsDateUtils.tsDateStr((Date)ruleBasedData.get("cycleEndDate"));
            }
            String sql = " select result.fproposerID proposerID, result.fid resultID, result.s32 ot1, result.s33 ot2, result.s34 ot3, result.fattenceDate atsDate  from t_hr_ats_attendanceResult result  where result.fProposerID = '" + personID + "'  \tand result.fAttenceDate >= " + cycleBeginDate + " and result.fAttenceDate <= " + cycleEndDate + " \tand (result.s32 <> 0 or result.s33 <> 0 or result.s34 <> 0 )";
            IRowSet rs = null;
            String resultIDs = "";
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                HashSet results = new HashSet();
                while (rs.next()) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    String proposerID = rs.getString("proposerID");
                    String resultID = rs.getString("resultID");
                    BigDecimal ot1 = rs.getBigDecimal("ot1");
                    BigDecimal ot2 = rs.getBigDecimal("ot2");
                    BigDecimal ot3 = rs.getBigDecimal("ot3");
                    java.sql.Date atsDate = rs.getDate("atsDate");
                    result.put("proposerID", proposerID);
                    result.put("resultID", resultID);
                    result.put("ot1", ot1);
                    result.put("ot2", ot2);
                    result.put("ot3", ot3);
                    result.put("atsDate", atsDate);
                    results.add(result);
                }
                this.resultMap.put(personID, results);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeLogPrimary(Context ctx, int sumPerson, int holidayTypeNum, int attendLogStatus) {
        this.writeLogPrimary(ctx, sumPerson, holidayTypeNum, 0, 0, attendLogStatus);
    }

    private void writeLogPrimary(Context ctx, int sumPerson, int holidayTypeNum, int sucessTimes, int failTimes, int attendLogStatus) {
        String jobid;
        if (ctx != null && ctx.get((Object)"jobInstId") != null && !(jobid = (String)ctx.get((Object)"jobInstId")).equals("") && jobid != null) {
            HashMap<String, Object> paraMap = new HashMap<String, Object>();
            AttendanceLogCollection attlogColl = new AttendanceLogCollection();
            int sumDays = holidayTypeNum;
            paraMap.put("jobid", jobid);
            paraMap.put("logType", 2);
            paraMap.put("sumPerson", sumPerson);
            paraMap.put("sumDays", sumDays);
            paraMap.put("sucessTimes", sucessTimes);
            paraMap.put("failTimes", failTimes);
            AttendanceLogInfo logInfo = LoggerAtsJobInst.setAttendanceLogInfo(paraMap);
            attlogColl.add(logInfo);
            LoggerAtsJobInst.operatorAttendanceLogInfo(ctx, attlogColl);
            if (attendLogStatus == 2) {
                LoggerAtsJobInst.updateAttendLogInfo(ctx, logInfo);
            }
        }
    }

    private Map<String, HolidayLimitInfo> cloneExistsLimitMap(Map existsLimitMap) {
        HashMap<String, HolidayLimitInfo> oldLimitMap = new HashMap<String, HolidayLimitInfo>();
        if (null != existsLimitMap) {
            for (HolidayLimitInfo entry : existsLimitMap.values()) {
                oldLimitMap.put(entry.getId().toString(), (HolidayLimitInfo)entry.clone());
            }
        }
        return oldLimitMap;
    }

    public void recordLog(Context ctx, Map paramMap) {
        long startTime = System.currentTimeMillis();
        DataLogUtil.recordLimitLog(ctx, paramMap);
        logger.error((Object)("Recordlog one batch person's takework limit ,cost\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
    }

    public void dealCycleDateMap(String cycleDate) {
        try {
            Iterator<Map.Entry<String, PersonPositionInfo>> iter = this.personPositionMap.entrySet().iterator();
            EmpPosOrgRelationInfo empPosOrgReLaInfo = null;
            EmpPosOrgRelationInfo empPosOrgReLaParent = null;
            HolidayLimitInfo limitInfo = null;
            EmpLaborRelationInfo laborInfo = null;
            PersonPositionInfo personPositinInfo = null;
            Map ruleBasedData = null;
            Map.Entry<String, PersonPositionInfo> entry = null;
            String personId = null;
            while (iter.hasNext()) {
                entry = iter.next();
                personId = entry.getKey();
                personPositinInfo = entry.getValue();
                ruleBasedData = (Map)this.ruleBasedDataMap.get(personId);
                limitInfo = this.existedLimitMap.get(personId);
                empPosOrgReLaInfo = this.empPosOrgRelationMap.get(personId);
                Date leftDate = personPositinInfo.getLeftDate();
                if (leftDate != null) {
                    this.dealCycleEndDate(limitInfo, ruleBasedData, leftDate);
                    continue;
                }
                if (empPosOrgReLaInfo == null || empPosOrgReLaInfo.getId() == null) continue;
                laborInfo = this.empLaborRelationMap.get(personId);
                if (AtsDateUtils.stringToShortDate(cycleDate).compareTo(laborInfo.getEnterDate()) >= 0) {
                    this.dealCycleBeginDate(limitInfo, ruleBasedData, laborInfo.getEnterDate());
                    continue;
                }
                empPosOrgReLaParent = empPosOrgReLaInfo.getParent();
                if (null == empPosOrgReLaParent || null == empPosOrgReLaParent.getAction() || !empPosOrgReLaParent.getAction().getId().toString().equals("DawAAAApViXmaL7Z")) continue;
                leftDate = AtsDateUtils.getPreDay(empPosOrgReLaParent.getEFFDT());
                this.dealCycleEndDate(limitInfo, ruleBasedData, leftDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dealCycleBeginDate(HolidayLimitInfo limitInfo, Map<String, Object> ruleBasedData, Date enterDate) {
        if (limitInfo != null && limitInfo.getCycleBeginDate() != null && limitInfo.getCycleEndDate() != null && enterDate.compareTo(limitInfo.getCycleBeginDate()) >= 0 && enterDate.compareTo(limitInfo.getCycleEndDate()) <= 0) {
            limitInfo.setCycleBeginDate(enterDate);
            limitInfo.setEffectDate(enterDate);
            ruleBasedData.put("cycleBeginDate", enterDate);
        } else if (null != ruleBasedData) {
            Date ruleBeginDate = (Date)ruleBasedData.get("cycleBeginDate");
            Date ruleEndDate = (Date)ruleBasedData.get("cycleEndDate");
            if (null != ruleBeginDate && null != ruleEndDate && enterDate.compareTo(ruleBeginDate) >= 0 && enterDate.compareTo(ruleEndDate) <= 0) {
                ruleBasedData.put("cycleBeginDate", enterDate);
            }
        }
    }

    private void dealCycleEndDate(HolidayLimitInfo limitInfo, Map<String, Object> ruleBasedData, Date leftDate) {
        if (limitInfo != null && limitInfo.getCycleBeginDate() != null && limitInfo.getCycleEndDate() != null && leftDate.compareTo(limitInfo.getCycleBeginDate()) >= 0 && leftDate.compareTo(limitInfo.getCycleEndDate()) <= 0) {
            limitInfo.setCycleEndDate(leftDate);
            limitInfo.setDelayDate(leftDate);
            ruleBasedData.put("cycleEndDate", leftDate);
        } else if (null != ruleBasedData) {
            Date ruleBeginDate = (Date)ruleBasedData.get("cycleBeginDate");
            Date ruleEndDate = (Date)ruleBasedData.get("cycleEndDate");
            if (null != ruleBeginDate && null != ruleEndDate && leftDate.compareTo(ruleBeginDate) >= 0 && leftDate.compareTo(ruleEndDate) <= 0) {
                ruleBasedData.put("cycleEndDate", leftDate);
                ruleBasedData.put("delayDate", leftDate);
            }
        }
    }
}

