/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.thread.ExecutorService.TaskPool;
import com.kingdee.eas.hr.ats.thread.executor.TaskExecutorABS;
import com.kingdee.eas.hr.ats.thread.executor.TaskExecutorBase;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.ats.vo.common.Dependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

public class DataAutoSaver
extends Dependency {
    private boolean async = false;
    private List<Future<Object>> futures;
    private int batchMount = AtsConstants.SIZE_COMMON_BATCH;
    private List<CoreBaseInfo> dataContianer;
    private Object lock = new Object();
    private List<CoreBaseInfo> dataContianerTemp;
    private StringBuffer exceptionMsg;
    private Exception globalException;
    private DataSaver dataSaver;

    public DataAutoSaver() {
        this.init();
    }

    public DataAutoSaver(Context ctx) {
        super(ctx);
        this.init();
    }

    public DataAutoSaver(DataSaver dataSaver) {
        this.dataSaver = dataSaver;
        this.init();
    }

    public DataAutoSaver(Context ctx, DataSaver dataSaver) {
        super(ctx);
        this.dataSaver = dataSaver;
        this.init();
    }

    protected void init() {
        this.dataContianer = new ArrayList<CoreBaseInfo>();
        if (this.dataSaver == null) {
            this.dataSaver = new DataSaver(this.ctx);
        }
    }

    public DataAutoSaver add(CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo == null) {
            return this;
        }
        this.dataContianer.add(coreBaseInfo);
        try {
            this.afterAdd();
        }
        catch (BOSException e) {
            this.globalException = e;
            this.exceptionMsg = this.exceptionMsg == null ? new StringBuffer() : this.exceptionMsg;
            this.exceptionMsg.append(AtsCommonUtile.getExciptionInfo(e));
        }
        return this;
    }

    public DataAutoSaver add(IObjectCollection iObjectCollection) {
        if (iObjectCollection == null) {
            return this;
        }
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            this.add((CoreBaseInfo)iObjectCollection.getObject(i));
        }
        return this;
    }

    public DataAutoSaver add(Collection<? extends CoreBaseInfo> collection) {
        if (collection == null) {
            return this;
        }
        Iterator<? extends CoreBaseInfo> it = collection.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return this;
    }

    public DataAutoSaver addWithExp(CoreBaseInfo coreBaseInfo) throws BOSException {
        if (coreBaseInfo == null) {
            return this;
        }
        this.dataContianer.add(coreBaseInfo);
        this.afterAdd();
        return this;
    }

    public DataAutoSaver addWithExp(IObjectCollection iObjectCollection) throws BOSException {
        if (iObjectCollection == null) {
            return this;
        }
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            this.addWithExp((CoreBaseInfo)iObjectCollection.getObject(i));
        }
        return this;
    }

    public DataAutoSaver addWithExp(Collection<? extends CoreBaseInfo> collection) throws BOSException {
        if (collection == null) {
            return this;
        }
        Iterator<? extends CoreBaseInfo> it = collection.iterator();
        while (it.hasNext()) {
            this.addWithExp(it.next());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterAdd() throws BOSException {
        Object object = this.lock;
        synchronized (object) {
            if (this.dataContianer.size() < this.batchMount) {
                return;
            }
            this.dataContianerTemp = new ArrayList<CoreBaseInfo>(this.dataContianer);
            this.dataContianer.clear();
        }
        if (this.dataContianerTemp.size() > 0) {
            this.complete(this.dataContianerTemp);
        }
    }

    public void complete() throws BOSException {
        this.complete(this.dataContianer);
    }

    private void complete(final List<CoreBaseInfo> list) throws BOSException {
        if (AtsCollectionUtile.isEmpty(list)) {
            return;
        }
        if (this.dataSaver.getCtx() == null) {
            this.dataSaver.setCtx(this.ctx);
        }
        this.dataSaver.setBatchMount(this.batchMount);
        if (!this.async) {
            try {
                this.beforSave(list);
                this.dataSaver.save(list);
            }
            finally {
                this.afterSave(list);
                list.clear();
            }
            return;
        }
        this.futures = this.futures == null ? new ArrayList() : this.futures;
        this.futures.add(TaskPool.submit(((TaskExecutorABS)new TaskExecutorBase<Object>(){

            @Override
            protected Object executeInner() throws Exception {
                try {
                    DataAutoSaver.this.beforSave(list);
                    DataAutoSaver.this.getDataSaver().clone().save(list);
                }
                catch (Exception e) {
                    DataAutoSaver.this.setGlobalException(e);
                    StringBuffer exceptionMsg = DataAutoSaver.this.getExceptionMsg();
                    exceptionMsg = exceptionMsg == null ? new StringBuffer() : exceptionMsg;
                    exceptionMsg.append(AtsCommonUtile.getExciptionInfo(e));
                    DataAutoSaver.this.setExceptionMsg(exceptionMsg);
                }
                finally {
                    DataAutoSaver.this.afterSave(list);
                    list.clear();
                }
                return null;
            }
        }.setCtx(this.ctx)).toCallable()));
    }

    protected void beforSave(List<CoreBaseInfo> curList) {
    }

    protected void afterSave(List<CoreBaseInfo> curList) {
    }

    public boolean hasComplete() {
        if (this.futures == null) {
            return true;
        }
        try {
            for (Future<Object> future : this.futures) {
                future.get();
            }
            return true;
        }
        catch (Exception e) {
            this.globalException = e;
            this.exceptionMsg = this.exceptionMsg == null ? new StringBuffer() : this.exceptionMsg;
            this.exceptionMsg.append(AtsCommonUtile.getExciptionInfo(e));
            return true;
        }
    }

    public void afterComplete() {
    }

    public Exception getCurException() {
        return this.globalException;
    }

    public String getCurExMsg() {
        return this.exceptionMsg.toString();
    }

    public Exception getException() {
        this.hasComplete();
        return this.globalException;
    }

    public String getExMsg() {
        this.hasComplete();
        return this.exceptionMsg == null ? null : this.exceptionMsg.toString();
    }

    public List<Future<Object>> getFutures() {
        return this.futures;
    }

    public void setFuture(List<Future<Object>> futures) {
        this.futures = futures;
    }

    public boolean isAsync() {
        return this.async;
    }

    public DataAutoSaver setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public StringBuffer getExceptionMsg() {
        return this.exceptionMsg;
    }

    public DataAutoSaver setExceptionMsg(StringBuffer exceptionMsg) {
        this.exceptionMsg = exceptionMsg;
        return this;
    }

    public Exception getGlobalException() {
        return this.globalException;
    }

    public DataAutoSaver setGlobalException(Exception globalException) {
        this.globalException = globalException;
        return this;
    }

    public DataSaver getDataSaver() {
        return this.dataSaver;
    }

    public DataAutoSaver setDataSaver(DataSaver dataSaver) {
        this.dataSaver = dataSaver;
        return this;
    }

    public int getBatchMount() {
        return this.batchMount;
    }

    public DataAutoSaver setBatchMount(int batchMount) {
        this.batchMount = batchMount;
        return this;
    }

    @Override
    public DataAutoSaver setDependency(Object dependency) {
        super.setDependency(dependency);
        return this;
    }

    @Override
    public DataAutoSaver setCtx(Context ctx) {
        super.setCtx(ctx);
        return this;
    }
}

