/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class DbUtile
extends DbUtil {
    private static Pattern PATTERN_ADD_ALIAS = Pattern.compile("(,\\s*|select\\s+)([\\w_]+\\.)?([\\w_]+_[lL][1-3])(\\s*,|\\s+from)", 2);
    private static Pattern PATTERN_REPLACE_ML = Pattern.compile("(?<![\\w_]+[lL][1-3])(\\s+[\\w\\._]+)(_[lL][1-3])\\b");

    public static List<PropertyContainer> executeBatchQuery(Context ctx, String sql, List paramsList) throws Exception {
        if (paramsList == null || paramsList.size() == 0) {
            return paramsList;
        }
        int orderByIndex = sql.toLowerCase().lastIndexOf(" order by ");
        String orderBySql = orderByIndex < 0 ? "" : sql.substring(orderByIndex);
        sql = orderByIndex < 0 ? sql : sql.substring(0, orderByIndex + 1);
        String tempTableName = null;
        StringBuffer selectSql = new StringBuffer();
        Object[] paramArray = new Object[]{};
        String union = " union all ";
        List groupParam = AtsCollectionUtile.group(paramsList, AtsConstants.SIZE_COMMON_BATCH);
        int originalSize = ((Object[])groupParam.get(0).get(0)).length;
        int size = groupParam.size();
        for (int i = 0; i < size; ++i) {
            for (Object[] params : groupParam.get(i)) {
                selectSql.append(sql).append(union);
                int oldSize = paramArray.length;
                paramArray = Arrays.copyOf(paramArray, paramArray.length + params.length);
                System.arraycopy(params, 0, paramArray, oldSize, originalSize);
            }
            selectSql.setLength(selectSql.length() - union.length());
            if (size == 1) continue;
            if (StringUtils.isBlank(tempTableName)) {
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                DbUtile.execute(ctx, MessageFormat.format("select * into {0} from ({1}) T", tempTableName, sql), paramArray);
            } else {
                DbUtile.execute(ctx, MessageFormat.format("insert into {0} {1}", tempTableName, sql), paramArray);
            }
            selectSql.setLength(0);
            paramArray = new Object[]{};
        }
        sql = StringUtils.isNotBlank(tempTableName) ? MessageFormat.format("select * from {0} {1}", tempTableName, orderBySql) : MessageFormat.format("select * from ({0}) temp0 {1}", selectSql, orderBySql);
        IRowSet rowSet = DbUtile.executeQuery(ctx, sql, paramArray);
        ArrayList<PropertyContainer> res = new ArrayList<PropertyContainer>(rowSet.size());
        int colCount = rowSet.getRowSetMetaData().getColumnCount() + 1;
        while (rowSet.next()) {
            PropertyContainer curRowData = new PropertyContainer();
            for (int i = 1; i < colCount; ++i) {
                curRowData.put(rowSet.getMetaData().getColumnLabel(i), rowSet.getObject(i));
            }
            res.add(curRowData);
        }
        if (StringUtils.isNotBlank((String)tempTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        return res;
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        DbUtile.executeBatchAndReturn(ctx, sql, paramsList);
    }

    public static int[] executeBatchAndReturn(Context ctx, String sql, List paramsList) throws BOSException {
        PreparedStatement ps;
        Connection conn;
        block9: {
            int[] nArray;
            sql = DbUtile.transSqlWithMl(ctx, sql);
            conn = null;
            ps = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql);
                Object[] params = null;
                int k = 1;
                boolean flag = false;
                for (int i = 0; i < paramsList.size(); ++i) {
                    params = (Object[])paramsList.get(i);
                    for (int j = 0; j < params.length; ++j) {
                        if (params[j] instanceof SQLType) {
                            ps.setNull(j + 1, ((SQLType)params[j]).getSQLType());
                            continue;
                        }
                        if (params[j] != null) {
                            ps.setObject(j + 1, params[j]);
                            continue;
                        }
                        ps.setNull(j + 1, SQLType.NVARCHAR.getSQLType());
                    }
                    ps.addBatch();
                    if (i == k * 8000) {
                        flag = true;
                    }
                    if (i <= k * 8000 || !flag) continue;
                    ps.executeBatch();
                    ++k;
                    flag = false;
                    ps.clearBatch();
                }
                if (flag) break block9;
                nArray = ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException("Sql222 execute exception : " + sql, (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return nArray;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return new int[0];
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        sql = DbUtile.transSqlWithMl(ctx, sql);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        sql = DbUtile.transSqlWithMl(ctx, sql);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        sql = DbUtile.transSqlWithMl(ctx, sql);
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        sql = DbUtile.transSqlWithMl(ctx, sql);
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static IRowSet executeQuery(Context ctx, String sql, int start, int rows) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)sql, (int)start, (int)rows);
    }

    public static IRowSet executeQueryNoTx(Context ctx, String sql) throws BOSException {
        sql = DbUtile.transSqlWithMl(ctx, sql);
        return DbUtil.executeQueryNoTx((Context)ctx, (String)sql);
    }

    public static IRowSet executeQueryNoTx(Context ctx, String sql, Object[] params) throws BOSException {
        sql = DbUtile.transSqlWithMl(ctx, sql);
        return DbUtil.executeQueryNoTx((Context)ctx, (String)sql, (Object[])params);
    }

    public static String transSqlWithMl(Context ctx, String sql) {
        boolean disableMl = true;
        if (disableMl) {
            return sql;
        }
        if (StringUtils.isBlank((String)sql) || !sql.toLowerCase().contains(MLUtile.getMlFlag(ctx))) {
            return sql;
        }
        Matcher matcher = PATTERN_ADD_ALIAS.matcher(sql);
        sql = matcher.replaceAll("$1$2$3 $3$4");
        matcher = PATTERN_REPLACE_ML.matcher(sql);
        String mlFlag = MLUtile.getMlFlag(ctx);
        sql = sql.replaceAll(",", ", ");
        sql = matcher.replaceAll("$1" + mlFlag);
        return sql;
    }
}

