/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.hr.ats.util.common.AtsContextUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MutexUtile {
    protected static Logger logger = AtsLog.getLogger("mutex", "mutexUtile", null);

    public static final boolean requestObjIDForUpdate(Context ctx, String id) throws BOSException {
        ctx = MutexUtile.getContext(ctx);
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String userName = ctx.getUserName();
        boolean flag = mutexService.requestObjIDForUpdate(ctx, id, userName);
        logger.info((Object)("MutexUtile........dataId :" + id + ";userName," + userName + " request net ctrl " + flag));
        return flag;
    }

    public static final Map batchRequestObjIDForUpdate(Context ctx, List<String> idList) throws BOSException {
        ctx = MutexUtile.getContext(ctx);
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String userName = ctx.getUserName();
        Map map = mutexService.batchRequestObjIDForUpdate(ctx, idList);
        logger.info((Object)("MutexUtile........dataId :" + idList.toString() + ";userName," + userName + " request net ctrl " + map.toString()));
        return map;
    }

    public static final void releaseObjIDForUpdate(Context ctx, String objId) throws BOSException {
        ctx = MutexUtile.getContext(ctx);
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.releaseObjIDForUpdate(ctx, objId);
    }

    public static final void batchReleaseObjIDForUpdate(Context ctx, List<String> idList) throws BOSException {
        ctx = MutexUtile.getContext(ctx);
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.batchReleaseObjIDForUpdate(ctx, idList);
    }

    public static final void releaseAllMutexBySessionID(Context ctx) throws BOSException {
        ctx = MutexUtile.getContext(ctx);
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.releaseAllFuncMutexAndObjLocks(ctx.getContextID());
    }

    public static Context getContext(Context ctx) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)ctx);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = null;
        try {
            objectOut = new ObjectOutputStream(out);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        if (objectOut == null) {
            return AtsContextUtile.copyCtx(ctx);
        }
        Exception serialiseExp = null;
        for (Object key : ctx.getUserDefineFieldKeySet()) {
            try {
                objectOut.writeObject(ctx.get(key));
            }
            catch (Exception e) {
                serialiseExp = e;
                String errorMsg = "NotSerializableException!\r\nkey:{0};\r\nvalue_class:{1};\r\nvalue:{2};";
                logger.error((Object)MessageFormat.format(errorMsg, key, ctx.get(key).getClass(), ctx.get(key)));
            }
        }
        if (serialiseExp == null) {
            try {
                objectOut.writeObject(ctx);
            }
            catch (Exception e) {
                serialiseExp = e;
                logger.error((Object)e);
            }
        }
        if (serialiseExp != null) {
            logger.error((Object)ctx);
            logger.info((Object)serialiseExp);
        }
        return serialiseExp == null ? ctx : AtsContextUtile.copyCtx(ctx);
    }
}

