/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.AtsOffsiteEntryInfo;
import com.kingdee.eas.hr.ats.AtsOffsiteInfo;
import com.kingdee.eas.hr.ats.factory.BillValidatorFactroy;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BillValidator;
import com.kingdee.eas.hr.ats.validator.OffsiteHelper;
import com.kingdee.eas.hr.ats.validator.PlateformType;
import java.math.BigDecimal;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class OffsiteBillValidator
extends BillValidator<AtsOffsiteInfo> {
    protected OffsiteHelper offsiteBillHelper;

    @Override
    protected void beforeValidate() throws Exception {
        super.beforeValidate();
        this.offsiteBillHelper = OffsiteHelper.getInstance();
        this.offsiteBillHelper.setCtx(this.getValidateCtx().getBosCtx());
    }

    @Override
    protected String doValidate(AtsOffsiteInfo target) throws Exception {
        BillValidator validator = BillValidatorFactroy.createValidator(target.getEntries().get(0).getTeleOfficeType().getId().toString());
        validator.setValidateCtx(this.getValidateCtx());
        validator.beforeValidate();
        String errorStr = validator.validateDAC(target);
        errorStr = StringUtils.isBlank((CharSequence)errorStr) && this.getValidateCtx().isNeedValidateBiz(target) ? validator.validateBiz(target) : errorStr;
        return StringUtils.isBlank((CharSequence)errorStr) ? validator.validateField(target, "entries") : errorStr;
    }

    @Override
    public String validateDAC(AtsOffsiteInfo target) throws Exception {
        if (PlateformType.isSelf(this.getValidateCtx().getPlateformType())) {
            return this.isCurrentPerson(target.getEntries().get(0).getPerson()) ? null : MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NOT_SELF", this.getValidateCtx().getBosCtx());
        }
        if (PlateformType.isTeam(this.getValidateCtx().getPlateformType()) && !this.getValidateCtx().isUpdateMethod()) {
            return null;
        }
        Set<String> hrOrgRange = this.getValidateCtx().getHrOrgRange();
        if (target.getHrOrgUnit() != null && hrOrgRange.contains(target.getHrOrgUnit().getString("id"))) {
            return null;
        }
        return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_BILL_PERM_HRO", this.getValidateCtx().getBosCtx());
    }

    protected String validateCustom(AtsOffsiteInfo atsOffsiteInfo) {
        return null;
    }

    protected String validateSpecial(AtsOffsiteInfo atsOffsiteInfo) {
        return null;
    }

    @Override
    protected String validateBiz(AtsOffsiteInfo target) throws Exception {
        String errorMsg = super.validateBiz(target);
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? this.validateSpecial(target) : errorMsg;
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? this.offsiteBillHelper.validateFill(this.getValidateCtx().getBosCtx(), target) : errorMsg;
        System.out.println("1-----" + errorMsg);
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? this.offsiteBillHelper.doDateInterleaveVerify(target.getEntries()) : errorMsg;
        System.out.println("2-----" + errorMsg);
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? this.offsiteBillHelper.offsiteMinMaxVerify(this.getValidateCtx().getBosCtx(), target.getEntries()) : errorMsg;
        System.out.println("3-----" + errorMsg);
        this.offsiteBillHelper.getDateOverlappingData(target);
        System.out.println("4-----" + errorMsg);
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? this.validateCustom(target) : errorMsg;
        System.out.println("OffsiteBillValidator.validateBiz.end");
        return errorMsg;
    }

    @Override
    protected String validateEntryBiz(String field, AtsAffairEntryBaseInfo entryBillInfo, AtsOffsiteInfo billInfo) throws Exception {
        String errorMsg = super.validateEntryBiz(field, entryBillInfo, billInfo);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        AtsOffsiteEntryInfo atsOffsiteEntryInfo = (AtsOffsiteEntryInfo)entryBillInfo;
        if (!atsOffsiteEntryInfo.getRealStartTime().before(atsOffsiteEntryInfo.getRealEndTime())) {
            return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "BEGIN_LAGER_END", this.getValidateCtx().getBosCtx());
        }
        if (atsOffsiteEntryInfo.getDays().compareTo(BigDecimal.ZERO) < 0) {
            return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "LEN_POSI", this.getValidateCtx().getBosCtx());
        }
        System.out.println("OffsiteBillValidator.validateEntryBiz.end");
        return errorMsg;
    }
}

