/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.matchSchedule;

import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.BaseMatchRuleAnalysor;
import java.util.Date;
import java.util.List;

public class BaseBillMatchRuleAnalysor
extends BaseMatchRuleAnalysor {
    protected int sign = 1;

    public BaseBillMatchRuleAnalysor() {
    }

    public BaseBillMatchRuleAnalysor(BaseMatchRuleAnalysor nextAnalysor) {
        super(nextAnalysor);
    }

    @Override
    public void doAnalyze() {
        super.doAnalyze();
        List<? extends AtsAffairEntryBaseInfo> billRecords = this.getBillRecords();
        if (!AtsCollectionUtile.isEmpty(billRecords)) {
            Date attendDate = (Date)this.matchShiftEnv.getAttendRange().getLowBound();
            for (AtsAffairEntryBaseInfo atsAffairEntryBaseInfo : billRecords) {
                RangeDate billRange = this.getRangeDateFromBill(atsAffairEntryBaseInfo);
                if (billRange.include(attendDate) && billRange.include(attendDate)) {
                    this.matchShiftEnv.setAllShiftValid(true);
                    return;
                }
                if (this.sign > 0) {
                    this.addToPunchCard(billRange);
                    continue;
                }
                if (this.sign >= 0) continue;
                this.minusPunchCard(billRange);
            }
        }
    }

    protected List<? extends AtsAffairEntryBaseInfo> getBillRecords() {
        return null;
    }

    protected RangeDate getRangeDateFromBill(AtsAffairEntryBaseInfo entry) {
        return null;
    }

    protected void addToPunchCard(RangeDate billRange) {
        RangeDate attendRange = this.matchShiftEnv.getAttendRange();
        List<Date> punchcardSimutlate = this.matchShiftEnv.getPunchcardSimulate();
        if (billRange.isValid()) {
            if (attendRange.include(billRange.getLowBound())) {
                punchcardSimutlate.add((Date)billRange.getLowBound());
            }
            if (attendRange.include(billRange.getUpBound())) {
                punchcardSimutlate.add((Date)billRange.getUpBound());
            }
        }
    }

    protected void minusPunchCard(RangeDate billRange) {
        RangeDate interSec = billRange.retainAll(this.matchShiftEnv.getAttendRange());
        List<Date> punchcard = this.matchShiftEnv.getPunchcards();
        if (interSec.isValid() && punchcard != null) {
            for (int i = 0; i < punchcard.size(); ++i) {
                if (!interSec.include(punchcard.get(i))) continue;
                punchcard.remove(i);
                --i;
            }
        }
    }

    public int getSign() {
        return this.sign;
    }

    public void setSign(int sign) {
        this.sign = sign;
    }
}

