/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AttendLogStatus;
import com.kingdee.eas.hr.ats.AttendanceLogEntryFactory;
import com.kingdee.eas.hr.ats.AttendanceLogEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceLogFactory;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AttendanceLogUtil {
    public static AttendanceLogInfo initAttendanceLogInfo(Context ctx, String jobId) {
        AttendanceLogInfo attendanceLogInfo = new AttendanceLogInfo();
        attendanceLogInfo.setJobid(jobId);
        attendanceLogInfo.setSumDays(BigDecimal.valueOf(0L));
        attendanceLogInfo.setSumPerson(BigDecimal.valueOf(0L));
        attendanceLogInfo.setSucessTimes(BigDecimal.valueOf(0L));
        attendanceLogInfo.setFailTimes(BigDecimal.valueOf(0L));
        try {
            AttendanceLogFactory.getLocalInstance(ctx).addnew(attendanceLogInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return attendanceLogInfo;
    }

    public static void generateAttendanceLogInfo(AttendanceLogInfo attendanceLogInfo, int personnums) {
        BigDecimal sumPerson = BigDecimal.valueOf(personnums);
        attendanceLogInfo.setSumPerson(attendanceLogInfo.getSumPerson().add(sumPerson));
        attendanceLogInfo.setCalStatus(AttendLogStatus.calmiddle);
    }

    public static HashMap<String, PersonInfo> generatePersonMap(Context ctx, Collection<String> rows) {
        String personNumber = AtsCollectionUtile.joinForSqlWithBrackets(rows);
        PersonCollection personCollection = null;
        HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
        if (StringUtils.isEmpty((String)personNumber)) {
            return personMap;
        }
        try {
            personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where number in " + personNumber);
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)("select personInfo error because personNumber is error " + e.getMessage()), (Throwable)e);
        }
        if (personCollection == null || personCollection.size() == 0) {
            return personMap;
        }
        for (int i = 0; i < personCollection.size(); ++i) {
            PersonInfo personInfo = personCollection.get(i);
            personMap.put(personInfo.getNumber(), personInfo);
        }
        return personMap;
    }

    public static PersonCollection generatePersonColl(Context ctx, Collection<String> rows) {
        String personNumber = AtsCollectionUtile.joinForSqlWithBrackets(rows);
        PersonCollection personCollection = new PersonCollection();
        try {
            personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where number in " + personNumber);
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)("select personInfo error because personNumber is error " + e.getMessage()), (Throwable)e);
        }
        return personCollection;
    }

    public static void updateAttendanceLogAndEntry(Context ctx, AttendanceLogInfo attendanceLogInfo, CoreBaseCollection attendanceLogEntryCollection) {
        try {
            new DataSaver().setCtx(ctx).save(attendanceLogInfo);
            if (attendanceLogEntryCollection != null) {
                AttendanceLogEntryFactory.getLocalInstance(ctx).addnew(attendanceLogEntryCollection);
            }
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)("update synLog error,detail:" + e.getMessage()), (Throwable)e);
        }
    }

    public static CoreBaseCollection generateAttendanceLogInfoEntry(Context ctx, AttendanceLogInfo attendanceLogInfo, HashMap<String, PersonInfo> personMap, HashMap<String, List<String>> inffectFileMap, HashMap<String, List<String>> scheduleOrderMap) {
        String dateStr;
        List<String> dateList;
        AttendanceLogEntryInfo attendanceLogEntryInfo;
        CoreBaseCollection attendanceLogEntryColl = new CoreBaseCollection();
        attendanceLogInfo.setId(attendanceLogInfo.getId());
        if (AtsCollectionUtile.isEmpty(inffectFileMap) && AtsCollectionUtile.isEmpty(scheduleOrderMap)) {
            return attendanceLogEntryColl;
        }
        if (!inffectFileMap.isEmpty()) {
            for (String inffectFilePersonNum : inffectFileMap.keySet()) {
                for (String personNum : personMap.keySet()) {
                    if (!inffectFilePersonNum.equalsIgnoreCase(personNum)) continue;
                    attendanceLogEntryInfo = new AttendanceLogEntryInfo();
                    attendanceLogEntryInfo.setPerson(personMap.get(personNum));
                    attendanceLogEntryInfo.setGroup(attendanceLogInfo);
                    dateList = inffectFileMap.get(personNum);
                    dateStr = AtsCollectionUtile.join(dateList, ",");
                    attendanceLogEntryInfo.setExcepMsg(MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.InffectFile, ctx, dateStr));
                    attendanceLogEntryColl.add((CoreBaseInfo)attendanceLogEntryInfo);
                }
            }
        }
        if (!scheduleOrderMap.isEmpty()) {
            for (String scheduleOrderPersonNum : scheduleOrderMap.keySet()) {
                for (String personNum : personMap.keySet()) {
                    if (!scheduleOrderPersonNum.equalsIgnoreCase(personNum)) continue;
                    attendanceLogEntryInfo = new AttendanceLogEntryInfo();
                    attendanceLogEntryInfo.setPerson(personMap.get(personNum));
                    attendanceLogEntryInfo.setGroup(attendanceLogInfo);
                    dateList = scheduleOrderMap.get(personNum);
                    dateStr = AtsCollectionUtile.join(dateList, ",");
                    attendanceLogEntryInfo.setExcepMsg(MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.ScheduleOrder, ctx, dateStr));
                    attendanceLogEntryColl.add((CoreBaseInfo)attendanceLogEntryInfo);
                }
            }
        }
        return attendanceLogEntryColl;
    }

    public static void generateLogMsgtoMap(Context ctx, String date, String personNum, HashMap<String, List<String>> map) {
        if (!StringUtils.isEmpty((String)((String)ctx.get((Object)"jobInstId")))) {
            if (!map.containsKey(personNum)) {
                ArrayList<String> dateList = new ArrayList<String>();
                dateList.add(date);
                map.put(personNum, dateList);
            } else {
                List<String> dateList = map.get(personNum);
                dateList.add(date);
            }
        }
    }
}

