/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.save;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractScheduleShiftInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.IScheduleShift;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.Util.AtsIntelligentUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsStoreToPlaceUtil;
import com.kingdee.eas.hr.ats.util.AtsWaitCalUtil;
import com.kingdee.eas.hr.ats.util.ScheduleSaveHelper;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsErrorMsg;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.WorkShiftUtile;
import com.kingdee.eas.hr.ats.workShift.plan.util.AttendanceLogUtil;
import com.kingdee.eas.hr.ats.workShift.save.ISaveShift;
import com.kingdee.eas.hr.ats.workShift.save.SaveShiftUtile;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class BaseSaveShift
implements ISaveShift {
    private Context ctx;
    IScheduleShift iScheduleShift;
    private String userInfo;
    private String CtrlUnitInfo;
    private String hrOrgUnitId;
    private String permItemId;
    private boolean includeNonAttendance;
    private static final String[] CONFIG_FIELD = new String[]{"schedule.enableCMPOnUpdate", "schedule.cmpUpateFields", "schedule.cmpUpateItemFields"};
    private List<String> cmpUpdateFields = Collections.emptyList();
    private String[] cmpUpateItemFields = new String[0];
    private boolean enableCMPOnUpdate = true;
    private boolean matchModel;
    private boolean updateAttendancePlaceTable;
    private int defaultAdvcValue = 1;
    private SchlShiftSrcTypeEnum defaultScheduleSrcType = SchlShiftSrcTypeEnum.sysSchlShift;
    private ScheduleShiftCollection toBeSavedShift;
    private Map<String, ScheduleShiftInfo> existsSchedules;
    private AtsErrorMsg errorMsg = new AtsErrorMsg();
    private Map<String, RangeMap<Date, ScheduleShiftInfo>> scheduleShiftFromAttHis;
    public HashMap<String, List<String>> inffectFileMap = new HashMap();
    public HashMap<String, List<String>> scheduleOrderMap = new HashMap();
    private ScheduleSaveHelper scheduleSaveHelper = new ScheduleSaveHelper();
    CoreBaseCollection insertColl = new CoreBaseCollection();
    CoreBaseCollection updateColl = new CoreBaseCollection();
    CoreBaseCollection updateCollBefore = new CoreBaseCollection();
    List<Object[]> updateShiftParams = new ArrayList<Object[]>();
    List<Object[]> updateShiftItemParams = new ArrayList<Object[]>();
    List<String> deleteShiftItemParams = new ArrayList<String>();
    private AttendanceLogInfo attendanceLogInfo;

    public BaseSaveShift() {
        Map<String, String> scheduleConfig = ConfigAts.getPropertyFromConfigs(CONFIG_FIELD);
        if (StringUtils.isNotBlank((String)scheduleConfig.get(CONFIG_FIELD[0]))) {
            this.enableCMPOnUpdate = Boolean.valueOf(scheduleConfig.get(CONFIG_FIELD[0]));
        }
        if (!this.enableCMPOnUpdate) {
            return;
        }
        String configCmpUpateFields = scheduleConfig.get(CONFIG_FIELD[1]);
        if (StringUtils.isBlank((String)configCmpUpateFields)) {
            configCmpUpateFields = "dayType,otCompens,shiftType,cardRule,isHalfDay,isElastic,elasticType,elasticValue,defaultShift,adminorgunit,hrorgunit,srcType";
        }
        this.cmpUpdateFields = Arrays.asList(configCmpUpateFields.split(","));
        String configCmpUpateItemFields = scheduleConfig.get(CONFIG_FIELD[2]);
        if (StringUtils.isBlank((String)scheduleConfig.get("schedule.cmpUpateItemFields"))) {
            configCmpUpateItemFields = "segment,attendanceType,preTimeDayType,preTime,preIsPunchCard,preFloatAdjusted,nextTimeDayType,nextTime,nextIsPunchCard,nextFloatAdjusted,restPreTime,restNextTime,segmentInRest,attAdminOrgUnit,itemSrcType";
        }
        this.cmpUpateItemFields = configCmpUpateItemFields.split(",");
    }

    public BaseSaveShift(Context ctx) {
        this();
        this.ctx = ctx;
        try {
            this.iScheduleShift = ScheduleShiftFactory.getLocalInstance(this.ctx);
            UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
            this.userInfo = currentUserInfo != null && currentUserInfo.getId() != null ? currentUserInfo.getId().toString() : "";
            CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
            this.CtrlUnitInfo = cu != null && cu.getId() != null ? cu.getId().toString() : "";
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static BaseSaveShift getManualInstance() {
        BaseSaveShift baseSaveShift = new BaseSaveShift();
        baseSaveShift.setDefaultAdvcValue(2);
        baseSaveShift.setDefaultScheduleSrcType(SchlShiftSrcTypeEnum.manSchlShift);
        baseSaveShift.updateAttendancePlaceTable = true;
        return baseSaveShift;
    }

    public static BaseSaveShift getManualInstance(Context ctx, String hrOrgUnitId) {
        BaseSaveShift baseSaveShift = new BaseSaveShift(ctx);
        baseSaveShift.setDefaultAdvcValue(2);
        baseSaveShift.setDefaultScheduleSrcType(SchlShiftSrcTypeEnum.manSchlShift);
        baseSaveShift.setHrOrgUnitId(hrOrgUnitId);
        baseSaveShift.updateAttendancePlaceTable = true;
        return baseSaveShift;
    }

    public static BaseSaveShift getAutoInstance() {
        return new BaseSaveShift();
    }

    public static BaseSaveShift getAutoInstance(Context ctx, String hrOrgUnitId) {
        BaseSaveShift baseSaveShift = new BaseSaveShift(ctx);
        baseSaveShift.setHrOrgUnitId(hrOrgUnitId);
        return baseSaveShift;
    }

    public void save(Map<String, List<JSONObject>> schedules) {
        List<List<String>> groupedPersonNums = AtsCollectionUtile.group(schedules.keySet(), AtsConstants.SIZE_COMMON_BATCH);
        Iterator<List<String>> personNumIterator = groupedPersonNums.iterator();
        this.toBeSavedShift = new ScheduleShiftCollection();
        while (personNumIterator.hasNext()) {
            ArrayList<JSONObject> relateSchedules = new ArrayList<JSONObject>();
            List<String> personNums = personNumIterator.next();
            for (String personNum : personNums) {
                relateSchedules.addAll((Collection<JSONObject>)schedules.get(personNum));
            }
            List<String> realteShiftName = SaveShiftUtile.getShiftNameFromJson(relateSchedules);
            Map<String, AtsShiftInfo> atsShifts = SaveShiftUtile.getAtsShiftByNames(this.ctx, new HashSet<String>(realteShiftName));
            for (String personNum : personNums) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setNumber(personNum);
                this.toBeSavedShift.addCollection(SaveShiftUtile.resolveToScheduleShift(this.ctx, personInfo, schedules.get(personNum), atsShifts));
            }
        }
        this.save(this.toBeSavedShift);
    }

    public void save(ScheduleShiftCollection toBeSavedShift) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)toBeSavedShift)) {
            return;
        }
        this.includeNonAttendance = AtsIntelligentUtil.isEnableATS_MDKPB(this.ctx);
        this.scheduleSaveHelper.setDefaultScheduleSrcType(this.defaultScheduleSrcType).setCtx(this.ctx);
        HashMap<String, ScheduleShiftInfo> noRe_matchResults = new HashMap<String, ScheduleShiftInfo>();
        for (int i = 0; i < toBeSavedShift.size(); ++i) {
            ScheduleShiftInfo schedule = toBeSavedShift.get(i);
            if (!this.matchModel && schedule.getDefaultShift() == null && schedule.getDayType() == DayTypeEnum.workDay || this.matchModel && schedule.getMatchDaytype() == DayTypeEnum.workDay && schedule.getMatchShift() == null) {
                AtsLog.getWSLog().error((Object)("save faile becaues workday has no shift,,attNum" + schedule.getProposer().getNumber() + ",schedule date" + schedule.getAttendDate() + (this.matchModel ? "cur schedule model is match" : ",cur schedule model is match schedule ") + ",the schedule:" + schedule));
                continue;
            }
            String personNum = schedule.getProposer().getNumber();
            personNum = StringUtils.isNotBlank((String)personNum) ? personNum : CoreBaseUtile.getId(schedule.getProposer());
            String attendDate = AtsCommonUtile.formateDate(schedule.getAttendDate());
            noRe_matchResults.put(personNum + "_" + attendDate, schedule);
        }
        ScheduleShiftCollection copy = new ScheduleShiftCollection();
        for (ScheduleShiftInfo noreSchedule : noRe_matchResults.values()) {
            copy.add(noreSchedule);
        }
        this.toBeSavedShift = copy;
        if (this.attendanceLogInfo != null) {
            this.attendanceLogInfo.setSumDays(this.attendanceLogInfo.getSumDays().add(BigDecimal.valueOf(toBeSavedShift.size())));
        }
        List<List<Object>> scheduleGroup = AtsCollectionUtile.group((IObjectCollection)toBeSavedShift, AtsConstants.SIZE_COMMON_BATCH);
        for (List<Object> groupTemp : scheduleGroup) {
            ArrayList<ScheduleShiftInfo> groupedSchedule = new ArrayList<ScheduleShiftInfo>(groupTemp.size());
            for (Object o : groupTemp) {
                groupedSchedule.add((ScheduleShiftInfo)o);
            }
            this.doSave(groupedSchedule);
        }
        this.scheduleSaveHelper.doDelete();
    }

    protected void doSave(List<ScheduleShiftInfo> schedules) {
        this.completeScheduleShift(schedules, true);
        try {
            this.beforeSaveOrUpdateEntity();
            this.saveOrUpdateEntity();
            this.afterSaveOrUpdateEntity();
        }
        catch (EASBizException e) {
            AtsLog.getWSLog().error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)"", (Throwable)e);
        }
        finally {
            this.resetSaveOrUpdateCollection();
        }
    }

    protected void initExistSchedule(Set<String> personNums, RangeDate dateRange, boolean saveAction) {
        ArrayList<String> existsScheduleSelector = new ArrayList<String>();
        if (this.enableCMPOnUpdate) {
            existsScheduleSelector.addAll(this.cmpUpdateFields);
            for (String field : this.cmpUpateItemFields) {
                existsScheduleSelector.add("items." + field);
            }
        }
        if (!saveAction) {
            existsScheduleSelector.add("matchDaytype");
            existsScheduleSelector.add("matchPlan");
            existsScheduleSelector.add("matchRule");
            existsScheduleSelector.add("matchShift");
        }
        this.existsSchedules = SaveShiftUtile.getExistsSchedule(this.ctx, personNums, (Date)dateRange.getLowBound(), (Date)dateRange.getUpBound(), existsScheduleSelector);
    }

    protected void afterSaveOrUpdateEntity() {
    }

    protected void beforeSaveOrUpdateEntity() {
    }

    protected void resetSaveOrUpdateCollection() {
        this.insertColl.clear();
        this.updateColl.clear();
        this.updateShiftParams.clear();
        this.updateShiftItemParams.clear();
        this.deleteShiftItemParams.clear();
    }

    protected void completeScheduleShift(List<ScheduleShiftInfo> schedules, boolean saveAction) {
        this.doCompleteScheduleShift(schedules, saveAction);
    }

    public String doCompleteScheduleShift(List<ScheduleShiftInfo> schedules, boolean saveAction) {
        this.beforeCompleteScheduleShift(schedules, saveAction);
        AbstractScheduleShiftInfo defaultSchedle = null;
        int successPerson = 0;
        for (int i = 0; i < schedules.size(); ++i) {
            String date;
            defaultSchedle = null;
            ScheduleShiftInfo schedule = schedules.get(i);
            String personNum = schedule.getProposer().getNumber();
            if (schedule.getAttendDate() != null) {
                schedule.setAttendDate(AtsCommonUtile.getDayStart(schedule.getAttendDate()));
            }
            if (this.scheduleShiftFromAttHis.get(personNum) != null) {
                defaultSchedle = this.scheduleShiftFromAttHis.get(personNum).get(schedule.getAttendDate());
            }
            if (defaultSchedle == null || !this.includeNonAttendance && defaultSchedle.getAttendFile().getIsAttendance().getValue().equals("0")) {
                String msg = MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.InffectFileAtsCode, this.ctx, personNum);
                if (!saveAction) {
                    return msg;
                }
                AtsLog.getWSLog().error((Object)("attNum" + personNum + ",attFile not satisfy schedule condition!,schedule date" + schedule.getAttendDate()));
                this.errorMsg.add(msg);
                date = AtsDateUtils.dateShortToString(schedule.getAttendDate());
                AttendanceLogUtil.generateLogMsgtoMap(this.ctx, date, personNum, this.inffectFileMap);
                continue;
            }
            ScheduleShiftInfo existsSchedule = this.existsSchedules.get(personNum + "_" + AtsCommonUtile.getDateFormat().format(schedule.getAttendDate()));
            if (schedule.getAdvcValue() == 0) {
                schedule.setAdvcValue(this.defaultAdvcValue);
            }
            if (schedule.getSrcType() == null || !this.matchModel) {
                schedule.setSrcType(this.defaultScheduleSrcType);
            }
            if (existsSchedule != null) {
                SchlShiftSrcTypeEnum schlShiftSrcTypeEnum;
                SchlShiftSrcTypeEnum schlShiftSrcTypeEnum2 = schlShiftSrcTypeEnum = existsSchedule.getSrcType() == null ? SchlShiftSrcTypeEnum.manSchlShift : existsSchedule.getSrcType();
                if (saveAction && Integer.valueOf(schlShiftSrcTypeEnum.getValue()) > Integer.valueOf(schedule.getSrcType().getValue())) {
                    AtsLog.getWSLog().error((Object)("attNum" + personNum + ",schedule date" + schedule.getAttendDate() + MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.ScheduleShiftOrder1, this.ctx, schedule, existsSchedule)));
                    date = AtsDateUtils.dateShortToString(schedule.getAttendDate());
                    AttendanceLogUtil.generateLogMsgtoMap(this.ctx, date, personNum, this.scheduleOrderMap);
                    continue;
                }
                schedule.setId(existsSchedule.getId());
                schedule.setProposer(existsSchedule.getProposer());
                schedule.setAdminOrgUnit(defaultSchedle.getAdminOrgUnit());
                schedule.setHrOrgUnit(defaultSchedle.getHrOrgUnit());
                schedule.setPosition(defaultSchedle.getPosition());
                schedule.setAttendPolicy(defaultSchedle.getAttendPolicy());
                schedule.setOtCompens(defaultSchedle.getOtCompens());
                schedule.setMatchDaytype(existsSchedule.getMatchDaytype());
                schedule.setMatchPlan(existsSchedule.getMatchPlan());
                schedule.setMatchRule(existsSchedule.getMatchRule());
                schedule.setMatchShift(existsSchedule.getMatchShift());
                this.setShiftRealteParam(schedule, (ScheduleShiftInfo)defaultSchedle);
                if (saveAction && !this.needUpdate(schedule, existsSchedule)) {
                    ++successPerson;
                    continue;
                }
                this.updateColl.add((CoreBaseInfo)schedule);
                this.updateCollBefore.add((CoreBaseInfo)existsSchedule);
            } else {
                BeanUtils.copyProperties((Object)defaultSchedle, (Object)schedule, (String[])new String[]{"attendDate", "dayType", "defaultShift", "shiftByTurnSegment", "atsTurnShift", "advcValue", "srcType", "matchShift", "matchPlan", "matchDaytype", "matchRule"});
                this.insertColl.add((CoreBaseInfo)schedule);
                this.setShiftRealteParam(schedule, (ScheduleShiftInfo)defaultSchedle);
            }
            schedule.setAttendFile(defaultSchedle.getAttendFile());
            if (saveAction && existsSchedule != null) {
                this.buildUpdateParam(schedule);
            }
            ++successPerson;
        }
        if (saveAction && this.attendanceLogInfo != null) {
            this.attendanceLogInfo.setSucessTimes(this.attendanceLogInfo.getSucessTimes().add(BigDecimal.valueOf(successPerson)));
            this.attendanceLogInfo.setFailTimes(this.attendanceLogInfo.getFailTimes().add(BigDecimal.valueOf(schedules.size() - successPerson)));
        }
        return null;
    }

    private void beforeCompleteScheduleShift(List<ScheduleShiftInfo> schedules, boolean saveAction) {
        HashSet<String> personNums = new HashSet<String>(AtsCollectionUtile.map(schedules, new AtsMapFn<ScheduleShiftInfo, String>(){

            @Override
            public String map(ScheduleShiftInfo t) {
                return t.getProposer().getNumber();
            }
        }));
        RangeDate scheduleDateRange = SaveShiftUtile.getRangeDate(schedules);
        this.scheduleSaveHelper.setSchedulePersonNumbers(personNums);
        this.scheduleSaveHelper.setScheduleDateRange(scheduleDateRange);
        this.initExistSchedule(personNums, scheduleDateRange, saveAction);
        this.scheduleShiftFromAttHis = SaveShiftUtile.getDefaultScheduleShiftFromHIS(this.ctx, personNums, AtsCommonUtile.getDateFormat().format((Date)scheduleDateRange.getLowBound()), AtsCommonUtile.getDateFormat().format((Date)scheduleDateRange.getUpBound()), this.hrOrgUnitId);
    }

    protected void buildUpdateParam(ScheduleShiftInfo schedule) {
        Object[] updateShiftParamsArr = SaveShiftUtile.getScheduleShiftParams(schedule, this.userInfo, this.CtrlUnitInfo);
        this.updateShiftParams.add(updateShiftParamsArr);
        if (!this.matchModel && schedule.getDefaultShift() != null && !AtsCollectionUtile.isEmpty((IObjectCollection)schedule.getDefaultShift().getItems())) {
            List<Object[]> updateShiftItemParamsArr = SaveShiftUtile.getScheduleShiftItemParams(schedule);
            this.updateShiftItemParams.addAll(updateShiftItemParamsArr);
        }
        if (schedule.getId() != null) {
            this.deleteShiftItemParams.add(schedule.getId().toString());
        }
    }

    protected void setShiftRealteParam(ScheduleShiftInfo schedule, ScheduleShiftInfo defaultSchedle) {
        AtsShiftInfo shift;
        AtsShiftInfo atsShiftInfo = shift = this.matchModel ? schedule.getMatchShift() : schedule.getDefaultShift();
        if (shift == null) {
            schedule.setShiftType(null);
            schedule.setIsElastic(false);
            schedule.setIsHalfDay(false);
            schedule.setOtCompens(defaultSchedle.getOtCompens());
            schedule.setStandardHour(defaultSchedle.getStandardHour());
            schedule.setCardRule(defaultSchedle.getCardRule());
            return;
        }
        for (String field : WorkShiftUtile.getShiftRelateFields()) {
            schedule.put(field, shift.get(field));
        }
    }

    public void saveOrUpdateEntity() throws BOSException, EASBizException {
        HashMap<ScheduleShiftInfo, Object> itemMap = new HashMap<ScheduleShiftInfo, Object>();
        ScheduleShiftInfo schedule2 = null;
        if (!this.insertColl.isEmpty()) {
            int size = this.insertColl.size();
            for (int i = 0; i < size; ++i) {
                schedule2 = (ScheduleShiftInfo)this.insertColl.get(i);
                itemMap.put(schedule2, schedule2.remove("items"));
            }
            this.iScheduleShift.addnew(this.insertColl);
            AtsWaitCalUtil.atsScheduleShitCollWaitCal(this.ctx, this.insertColl);
        }
        if (!this.updateColl.isEmpty()) {
            AtsSqlUtile.deleteByIds(this.ctx, "t_hr_ats_scheduleshiftItem", "fgroupId", this.deleteShiftItemParams);
            StringBuffer updateShiftSql = new StringBuffer("");
            updateShiftSql.append(" update t_hr_ats_scheduleshift set fdayType = ?,FDefaultShiftID = ?,FAttendFileID = ?,FAttendPolicyID = ?,\n");
            updateShiftSql.append(" FCardRuleID = ?,FSrcType = ?,FAdvcValue = ?,FStandardHour = ?,FProposerId = ?,FPositionId = ?,");
            updateShiftSql.append(" FLastUpdateUserId = ?,FLastUpdateTime = Now(),FAdminOrgUnitId = ?,FHldPlcSetID = ?,");
            updateShiftSql.append(" FShiftTypeID = ?,FOtCompensID = ?,FAttendDate = ?,FControlUnitID = ?,FHrOrgUnitID = ?,");
            updateShiftSql.append(" FshiftByTurnSegment = ?,FatsTurnShift = ?, FIsHalfDay= ?,fisElastic=?,felasticType=?,felasticDirection=? ,felasticValue=?  where Fid = ?");
            DbUtile.executeBatch(this.ctx, updateShiftSql.toString(), this.updateShiftParams);
            AtsWaitCalUtil.atsScheduleShitCollWaitCal(this.ctx, this.updateColl);
        }
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        if (this.insertColl != null && this.insertColl.size() > 0) {
            AtsShiftInfo atsShiftInfo = null;
            for (ScheduleShiftInfo schedule2 : this.insertColl) {
                schedule2.put("items", itemMap.remove(schedule2));
                atsShiftInfo = this.matchModel ? schedule2.getMatchShift() : schedule2.getDefaultShift();
                if (atsShiftInfo == null || AtsCollectionUtile.isEmpty((IObjectCollection)atsShiftInfo.getItems())) continue;
                insertParamList.addAll(SaveShiftUtile.getScheduleShiftItemParams(schedule2));
            }
            itemMap.clear();
        }
        if (this.updateColl != null && this.updateColl.size() > 0) {
            SaveShiftUtile.insertScheduleShiftItemsBatch(this.ctx, this.updateShiftItemParams);
        }
        if (insertParamList != null && insertParamList.size() > 0) {
            SaveShiftUtile.insertScheduleShiftItemsBatch(this.ctx, insertParamList);
        }
        this.scheduleSaveHelper.snapShotRepeatSchedule();
        this.updateAttendancePlaceData(insertParamList);
    }

    protected void updateAttendancePlaceData(List<Object[]> insertParamList) {
        if (!this.updateAttendancePlaceTable) {
            return;
        }
        ArrayList<String> scheduleList = new ArrayList<String>(this.deleteShiftItemParams);
        if (!AtsCollectionUtile.isEmpty(insertParamList)) {
            int i;
            int len = insertParamList.get(0).length;
            int n = i = insertParamList == null ? 0 : insertParamList.size();
            while (i-- > 0) {
                scheduleList.add((String)insertParamList.get(i)[len - 2]);
            }
        }
        if (!AtsCollectionUtile.isEmpty(scheduleList)) {
            try {
                AtsStoreToPlaceUtil.dealScheduleToPlace(this.ctx, scheduleList);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean needUpdate(ScheduleShiftInfo schedule, ScheduleShiftInfo existsSchedule) {
        if (!this.enableCMPOnUpdate || this.defaultScheduleSrcType == SchlShiftSrcTypeEnum.manSchlShift) {
            return true;
        }
        for (String field : this.cmpUpdateFields) {
            if (BaseSaveShift.objEqual((CoreBaseInfo)schedule, (CoreBaseInfo)existsSchedule, field)) continue;
            return true;
        }
        AtsShiftItemCollection itmes = schedule.getDefaultShift() == null ? null : schedule.getDefaultShift().getItems();
        ScheduleShiftItemCollection existItmes = existsSchedule.getItems();
        itmes = itmes == null || itmes.size() == 0 ? null : itmes;
        ScheduleShiftItemCollection scheduleShiftItemCollection = existItmes = existItmes == null || existItmes.size() == 0 ? null : existItmes;
        if (itmes == null || existItmes == null) {
            return itmes != existItmes;
        }
        if (itmes.size() != existItmes.size()) {
            return true;
        }
        itmes.sort("segment");
        existItmes.sort("segment");
        int size = itmes.size();
        for (int i = 0; i < size; ++i) {
            for (String field : this.cmpUpateItemFields) {
                if (BaseSaveShift.objEqual(itmes.get(i), existItmes.get(i), field)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean objEqual(CoreBaseInfo scheduleItem, CoreBaseInfo existItem, String filed) {
        if (scheduleItem == null || existItem == null) {
            return scheduleItem == existItem;
        }
        Object sa = scheduleItem.get(filed);
        Object sb = existItem.get(filed);
        if (sa == null) {
            if (sb instanceof String) {
                return StringUtils.isBlank((String)sb.toString());
            }
            if (sb instanceof Number) {
                return Double.valueOf(String.valueOf(sb)) == 0.0;
            }
            return sb == null;
        }
        if (sa instanceof CoreBaseInfo) {
            sa = ((CoreBaseInfo)sa).getId();
        }
        if (sb instanceof CoreBaseInfo) {
            sb = ((CoreBaseInfo)sb).getId();
        }
        return sa == sb || sa != null && sa.equals(sb);
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getCtrlUnitInfo() {
        return this.CtrlUnitInfo;
    }

    public void setCtrlUnitInfo(String ctrlUnitInfo) {
        this.CtrlUnitInfo = ctrlUnitInfo;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getHrOrgUnitId() {
        return this.hrOrgUnitId;
    }

    public void setHrOrgUnitId(String hrOrgUnitId) {
        this.hrOrgUnitId = hrOrgUnitId;
    }

    public int getDefaultAdvcValue() {
        return this.defaultAdvcValue;
    }

    public void setDefaultAdvcValue(int defaultAdvcValue) {
        this.defaultAdvcValue = defaultAdvcValue;
    }

    public SchlShiftSrcTypeEnum getDefaultScheduleSrcType() {
        return this.defaultScheduleSrcType;
    }

    public void setDefaultScheduleSrcType(SchlShiftSrcTypeEnum defaultScheduleSrcType) {
        this.defaultScheduleSrcType = defaultScheduleSrcType;
    }

    public boolean isMatchModel() {
        return this.matchModel;
    }

    public void setMatchModel(boolean matchModel) {
        this.matchModel = matchModel;
    }

    public AtsErrorMsg getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(AtsErrorMsg errorMsg) {
        this.errorMsg = errorMsg;
    }

    public AttendanceLogInfo getAttendanceLogInfo() {
        return this.attendanceLogInfo;
    }

    public void setAttendanceLogInfo(AttendanceLogInfo attendanceLogInfo) {
        this.attendanceLogInfo = attendanceLogInfo;
    }

    public String getPermItemId() {
        return this.permItemId;
    }

    public BaseSaveShift setPermItemId(String permItemId) {
        this.permItemId = permItemId;
        return this;
    }
}

