/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.biz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsFileChangeSource;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttencePolicyCollection;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.FileChangeStatus;
import com.kingdee.eas.hr.ats.IAttendanceFile;
import com.kingdee.eas.hr.ats.IAttendanceFileHIS;
import com.kingdee.eas.hr.ats.biz.impl.AtsBizManageBacthCreateBaseFile;
import com.kingdee.eas.hr.ats.biz.util.AtsBizUtil;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.Util.AtsDealMsgConfirmTool;
import com.kingdee.eas.hr.ats.lightapp.util.NumberCodeRule;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsFileLogUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class AtsBizManageBacthCreateAttenceFile
extends AtsBizManageBacthCreateBaseFile {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.biz.impl.AtsBizManageBacthCreateAttenceFile");
    private AttendanceFileCollection colls = null;

    public AtsBizManageBacthCreateAttenceFile(Context ctx, String hql) {
        try {
            this.colls = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(hql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int updateOrIngoreAttendFileInfo(Context ctx, Map map, ArrayList<PersonBURelationInfo> transInfoList) throws BOSException, EASBizException {
        IAttendanceFileHIS iAttendanceFileHIS = AttendanceFileHISFactory.getLocalInstance(ctx);
        IAttendanceFile iAttendanceFile = AttendanceFileFactory.getLocalInstance(ctx);
        Map<String, EmpPosOrgRelationInfo> empMap = this.tranEmpPosOrgRelationInfoMap(ctx, transInfoList);
        AttencePolicyInfo attencePolicyInfo = null;
        AtsShiftInfo atsShiftInfo = null;
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        AttendanceFileInfo attendanceOldFileInfo = null;
        for (int i = 0; i < transInfoList.size(); ++i) {
            String billNumber;
            String hrOrgUnit = transInfoList.get(0).getHrOrgUnit().getId().toString();
            AttencePolicyCollection attencePolicyColls = AtsBizUtil.getDefaultAttencePolicyCol(ctx, hrOrgUnit);
            AtsShiftCollection atsShiftColls = AtsBizUtil.getDefaultHrUnitAtsShiftCol(ctx, hrOrgUnit);
            PersonBURelationInfo personBURelationInfo = transInfoList.get(i);
            String personId = personBURelationInfo.getPerson().getId().toString();
            AttendanceFileInfo newFileInfo = (AttendanceFileInfo)map.get(personId);
            empPosOrgRelationInfo = empMap.get(personBURelationInfo.getEmpOrgRelation().getId().toString());
            if (newFileInfo == null) {
                attencePolicyInfo = (AttencePolicyInfo)AtsBizUtil.getDefaultBasicItemInfo(attencePolicyColls, empPosOrgRelationInfo.getAdminOrg().getLongNumber());
                atsShiftInfo = (AtsShiftInfo)AtsBizUtil.getDefaultBasicItemInfo(atsShiftColls, empPosOrgRelationInfo.getAdminOrg().getLongNumber());
            } else {
                attencePolicyInfo = newFileInfo.getAttencePolicy();
                atsShiftInfo = newFileInfo.getAtsShift();
            }
            attendanceOldFileInfo = (AttendanceFileInfo)this.findCurrentFileInfo(personId, this.colls);
            if (attendanceOldFileInfo != null) {
                HashMap unvalidaMap;
                Date effedDate = personBURelationInfo.getEFFDT();
                CoreBaseCollection toChangeFileHisCol = new CoreBaseCollection();
                CoreBaseCollection neededChangeFileHisCol = new CoreBaseCollection();
                AttendanceFileHISCollection attendanceFileHISCollection = AtsBizUtil.getAfterDateAttendanceFileHISCollection(personId, iAttendanceFileHIS, effedDate);
                if (attendanceFileHISCollection == null || attendanceFileHISCollection.size() == 0) {
                    HashMap unvalidaMap2 = (HashMap)ctx.get((Object)"unValidPersonMap");
                    if (unvalidaMap2 == null) continue;
                    unvalidaMap2.put(personId, MLUtile.getRes(AtsFileResEnum.NoAtsFile, ctx));
                    continue;
                }
                AttendanceFileHISCollection beforeChangeFileHis = AtsBizUtil.copyHisCollection(attendanceFileHISCollection);
                AtsBizUtil.spiltFile(ctx, effedDate, AtsDateUtils.stringToShortDate("2099-12-31"), attendanceFileHISCollection, toChangeFileHisCol, neededChangeFileHisCol);
                if ((neededChangeFileHisCol == null || neededChangeFileHisCol.size() == 0) && (unvalidaMap = (HashMap)ctx.get((Object)"unValidPersonMap")) != null) {
                    unvalidaMap.put(personId, MLUtile.getRes(AtsFileResEnum.NoAtsFile, ctx));
                    continue;
                }
                AttendanceFileHISInfo currentFileHisInfo = (AttendanceFileHISInfo)neededChangeFileHisCol.get(0);
                HROrgUnitInfo beforeHrOrgUnit = currentFileHisInfo.getHrOrgUnit();
                AtsBizUtil.assembleAttendanceFileInfoHisFromNew(ctx, currentFileHisInfo, personBURelationInfo, empPosOrgRelationInfo, attencePolicyInfo, atsShiftInfo, newFileInfo);
                if (neededChangeFileHisCol.size() > 1) {
                    AtsBizManageBacthCreateAttenceFile.assaginForAttendanceFileHis(empPosOrgRelationInfo, neededChangeFileHisCol, beforeHrOrgUnit);
                }
                Integer maxVersionNum = AtsFileLogUtils.recordAttendFileHisChangeFromBatchChange(ctx, personId, MLUtile.getRes(AtsAttenceResEnum.BatchAssignValue, ctx), null, attendanceFileHISCollection, FileChangeStatus.before, null, null);
                maxVersionNum = AtsFileLogUtils.recordAttendFileHisChangeFromBatchChange(ctx, personId, MLUtile.getRes(AtsAttenceResEnum.BatchAssignValue, ctx), null, toChangeFileHisCol, FileChangeStatus.after, maxVersionNum, beforeChangeFileHis);
                iAttendanceFileHIS.saveBatchData(toChangeFileHisCol);
                AtsBizUtil.syncAttendanceFileAndHis(ctx, personId, iAttendanceFileHIS, null, maxVersionNum, MLUtile.getRes(AtsAttenceResEnum.BatchAssignValue, ctx), AtsFileChangeSource.batchChange, null, null);
                continue;
            }
            if (newFileInfo != null) {
                newFileInfo.setAttendFileState(AttendFileStateEnum.enable);
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(billNumber = AtsDealMsgConfirmTool.getAttendanceFileRuleNumber(ctx, personId))) && newFileInfo != null) {
                newFileInfo.setNumber(billNumber);
                newFileInfo.setAttendanceNum(billNumber);
            }
            AttendanceFileHISInfo attendanceFileHISInfo = AtsBizUtil.generateHis(ctx, newFileInfo);
            iAttendanceFileHIS.addnew(attendanceFileHISInfo);
            iAttendanceFile.save((CoreBaseInfo)newFileInfo);
            AtsFileLogUtils.newCreateAtsFileLog(ctx, AtsFileChangeSource.batchChange, personBURelationInfo.getPerson().getId(), MLUtile.getRes(AtsAttenceResEnum.BatchAssignValue, ctx), newFileInfo, attendanceFileHISInfo);
        }
        int success = transInfoList.size();
        return success;
    }

    public static void assaginForAttendanceFileHis(EmpPosOrgRelationInfo empPosOrgRelationInfo, CoreBaseCollection neededChangeFileHisCol, HROrgUnitInfo beforeHrOrgUnit) {
        for (int j = 1; j < neededChangeFileHisCol.size(); ++j) {
            AttendanceFileHISInfo currentFileHisInfoT = (AttendanceFileHISInfo)neededChangeFileHisCol.get(j);
            if (!beforeHrOrgUnit.getId().equals((Object)currentFileHisInfoT.getHrOrgUnit().getId())) break;
            currentFileHisInfoT.setAdminOrgUnit(empPosOrgRelationInfo.getAdminOrg());
            currentFileHisInfoT.setPosition(empPosOrgRelationInfo.getPosition());
            if (currentFileHisInfoT.getAttAdminOrgUnit() == null || currentFileHisInfoT.getAttAdminOrgUnit().equals((Object)currentFileHisInfoT.getAdminOrgUnit())) {
                currentFileHisInfoT.setAttAdminOrgUnit(empPosOrgRelationInfo.getAdminOrg());
            }
            if (currentFileHisInfoT.getAttPosition() != null && !currentFileHisInfoT.getAttPosition().equals((Object)currentFileHisInfoT.getPosition())) continue;
            currentFileHisInfoT.setAttPosition(empPosOrgRelationInfo.getPosition());
        }
    }

    private void logFileChange(Context ctx, String personId) {
    }

    private void beforeInsertAttendFile(Context ctx, CoreBaseCollection insertBaseCollection, AttendanceFileInfo newFileInfo) throws EASBizException, BOSException {
        newFileInfo.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
        String attendanceNum = newFileInfo.getAttendanceNum();
        if (StringUtils.isEmpty((Object)attendanceNum) && org.apache.commons.lang.StringUtils.isNotEmpty((String)(attendanceNum = NumberCodeRule.readCodeRuleNumber((IObjectValue)newFileInfo, NumberCodeRule.getMainOrgByCu(ctx), ctx)))) {
            newFileInfo.setAttendanceNum(attendanceNum);
            newFileInfo.setNumber(attendanceNum);
        }
        insertBaseCollection.add((CoreBaseInfo)newFileInfo);
        IAttendanceFileHIS iAttendanceFileHIS = AttendanceFileHISFactory.getLocalInstance(ctx);
        iAttendanceFileHIS.addnew(AtsBizUtil.generateHis(ctx, newFileInfo));
    }

    private AttendanceFileHISInfo findCurrentFileHisInfo(Context ctx, String personId, AttendanceFileCollection colls) {
        AttendanceFileHISInfo atsHolidayFileHisInfo = null;
        for (int j = 0; j < colls.size(); ++j) {
            AttendanceFileInfo tempfileInfo = colls.get(j);
            if (!personId.equals(tempfileInfo.getProposer().getId().toString())) continue;
            try {
                AttendanceFileHISCollection atsHolidayFileHisColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(" where proposer.id ='" + personId + "' ");
                atsHolidayFileHisInfo = atsHolidayFileHisColl.get(0);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            break;
        }
        return atsHolidayFileHisInfo;
    }
}

