/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.backCal.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.sum.backCal.util.AtsSumBackCalHelper;
import com.kingdee.eas.hr.ats.sum.backCal.vo.AtsSumBackCalVO;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AtsSumBackCalPersonHelper {
    private static Logger logger = Logger.getLogger(AtsSumBackCalPersonHelper.class);

    public static String createSumBackCalTempTableByPerson(Context ctx, AtsSumBackCalVO backCalVO) throws Exception {
        String sql = AtsSumBackCalPersonHelper.getAttendResultSumSqlByPerson(ctx, backCalVO);
        String tempTableName = AtsSumBackCalHelper.getAttenceResultTempTable(ctx, backCalVO.getSession(), sql);
        backCalVO.setSumSql(sql);
        logger.error((Object)("Sum Back Cal GROUP SQL:getGridSumBackCalDataSql SumBackCal dynamicSql: " + sql.toString()));
        return tempTableName;
    }

    public static String getAttendResultSumSqlByPerson(Context ctx, AtsSumBackCalVO backCalVO) throws Exception {
        String beginDate = AtsDateUtils.dateShortToString(backCalVO.getStartDate());
        String endDate = AtsDateUtils.dateShortToString(backCalVO.getEndDate());
        StringBuffer sumSql = new StringBuffer();
        sumSql.append(" SELECT FHIS.FHrOrgUnitID,FHIS.FAdminOrgUnitID,FHIS.FProposerID ");
        sumSql.append(" FROM T_HR_ATS_AttendanceFileHIS FHIS ");
        sumSql.append(" inner join ( SELECT fproposerid,MAX(fleffdt) fleffdt,MAX(FEFFDT) FEFFDT FROM t_hr_ats_attendancefilehis ");
        sumSql.append(" WHERE fleffdt >= {ts '" + beginDate + "'} AND FEFFDT <= {ts '" + endDate + "'}  ");
        sumSql.append(" group by fproposerid ");
        sumSql.append(" )hisMax on FHIS.fproposerid= hisMax.fproposerid and FHIS.FEFFDT = hisMax.FEFFDT and FHIS.fleffdt = hisMax.fleffdt ");
        sumSql.append(" INNER JOIN T_BD_Person person on FHIS.FProposerID = person.FID ");
        sumSql.append(" WHERE FHIS.FLEFFDT >= {ts '" + beginDate + "'}");
        sumSql.append(" AND FHIS.FEFFDT <= {ts '" + endDate + "'} ");
        String personJson = backCalVO.getPersonJson();
        if (!(StringUtils.isEmpty((String)personJson) || "\"\"".equals(personJson) || "All".equalsIgnoreCase(personJson))) {
            Set<String> personKeys = AtsSumBackCalHelper.getSelectPersonKey(personJson);
            sumSql.append(" and concat(FHIS.fhrOrgUnitId,concat(FHIS.fproposerid,FHIS.fadminorgunitid)) in (" + AtsUtil.convertSetToString(personKeys) + ")");
        } else {
            String filterItem = backCalVO.getFilterItems();
            if (!StringUtils.isEmpty((String)filterItem)) {
                if (filterItem.indexOf("name") != -1) {
                    filterItem = filterItem.replaceAll("name", "fname" + MLUtile.getMlFlag(ctx));
                }
                if (filterItem.indexOf("number") != -1) {
                    filterItem = filterItem.replaceAll("number", "fnumber");
                }
                sumSql.append(" and " + filterItem);
            }
            sumSql.append(backCalVO.getOrgRangSql());
        }
        String backCalPeriod = backCalVO.getBackCalPeriod();
        String sumPeriod = backCalVO.getSumCalPeriod();
        sumSql.append(" AND NOT EXISTS (SELECT 1 FROM T_HR_ATS_ATTENDANCESUMBACKCAL BACKCAL  ").append("WHERE BACKCAL.FHRORGUNITID =FHIS.FHRORGUNITID  ").append("AND BACKCAL.FADMINORGUNITID= FHIS.FADMINORGUNITID  ").append("AND BACKCAL.FPROPOSERID = FHIS.FPROPOSERID ").append("WHERE BACKCAL.FSUMCALPERIOD = '" + sumPeriod + "' ").append("AND BACKCAL.FBACKCALPERIOD ='" + backCalPeriod + "' AND BACKCAL.FSALARYSTATUS NOT IN (1,2) ) ");
        sumSql.append(" GROUP BY FHIS.FHrOrgUnitID,FHIS.FAdminOrgUnitID,FHIS.FProposerID ");
        return sumSql.toString();
    }

    public static void setGridAttendResultSumInfoByPerson(Context ctx, String keyTmpTableName, AtsSumBackCalVO backCalVO, List<LinkedHashMap<String, Object>> rowList, Map<String, String> columnMap) {
        try {
            String beginDate = AtsDateUtils.dateShortToString(backCalVO.getStartDate());
            String endDate = AtsDateUtils.dateShortToString(backCalVO.getEndDate());
            String attendPeriodId = backCalVO.getBackCalPeriodId();
            String attendPeriodName = backCalVO.getBackCalPeriod();
            int sumSize = rowList.size();
            int decimalPlacesSystem = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
            IRowSet rowSet = AtsSumBackCalPersonHelper.getAttendDetailDataGridByPerson(ctx, keyTmpTableName, beginDate, endDate);
            for (int i = 0; i < sumSize; ++i) {
                Map rowListMap = rowList.get(i);
                String sumKey = (String)rowListMap.get("key");
                rowListMap.put("beginDate", beginDate);
                rowListMap.put("endDate", endDate);
                rowListMap.put("attendPeriodId", attendPeriodId);
                rowListMap.put("attendPeriodName", attendPeriodName);
                while (rowSet.next()) {
                    String positionId = rowSet.getString("fpositionID");
                    String currentKey = rowSet.getString("fproposerid");
                    String resultId = rowSet.getString("FID");
                    try {
                        if (!sumKey.contains(currentKey)) continue;
                        rowListMap.put("fpositionID", positionId);
                        rowListMap.put("resultId", resultId);
                        AtsSumBackCalHelper.setAttendResultSumData(ctx, rowSet, rowListMap, columnMap, decimalPlacesSystem);
                    }
                    catch (Exception e) {
                        logger.error((Object)("PAGE: SumBackCal call setGridAttendResultSumInfoByPerson error,gather/gather to salary prepare detail data error,sumKey:" + sumKey));
                        e.printStackTrace();
                    }
                }
                rowSet.beforeFirst();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IRowSet getAttendDetailDataGridByPerson(Context ctx, String keyTmpTableName, String beginDate, String endDate) {
        IRowSet rowSet = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select RESULT.* from T_HR_ATS_ATTENDANCERESULT RESULT   ");
        sb.append("  WHERE EXISTS (SELECT 1 FROM  " + keyTmpTableName + " ATS_TMP WHERE ATS_TMP.fproposerid = RESULT.fproposerid )");
        sb.append("  AND RESULT.FATTENCEDATE >= {ts '" + beginDate + "' }");
        sb.append("  AND RESULT.FATTENCEDATE <=  {ts '" + endDate + "' }");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)("PAGE: SumBackCal call getAttendDetailDataGridByPerson error: " + sb.toString()));
            e.printStackTrace();
        }
        return rowSet;
    }
}

