/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.sum.util.AtsSumSalaryUtil;
import com.kingdee.eas.hr.ats.thread.ExecutorService.TaskPool;
import com.kingdee.eas.hr.ats.thread.executor.Callable;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsSumSalaryDeleteUtil {
    private static Logger logger = Logger.getLogger(AtsSumSalaryDeleteUtil.class);

    public static boolean deleteOutDatedResSum(Context ctx, String attendPeriodId) {
        if (StringUtils.isEmpty((CharSequence)attendPeriodId)) {
            return false;
        }
        int sumType = AtsSumSalaryUtil.getSystemParamIntValue(ctx, "3qBV2X0Zi0KK2Aaru9d9YaiB8+c=");
        switch (sumType) {
            case 1: {
                AtsSumSalaryDeleteUtil.deleteSumDataUnMatchByPerson(ctx, attendPeriodId);
                break;
            }
            case 0: {
                AtsSumSalaryDeleteUtil.deleteSumDataUnMatchByOrg(ctx, attendPeriodId);
                break;
            }
            case 2: {
                AtsSumSalaryDeleteUtil.deleteSumDataUnMatchByHRPerson(ctx, attendPeriodId);
                break;
            }
            case 3: {
                AtsSumSalaryDeleteUtil.deleteSumDataUnMatchByHRPersonAtt(ctx, attendPeriodId);
                break;
            }
        }
        AtsSumSalaryDeleteUtil.deleteSumDataDuplicate(ctx, attendPeriodId);
        return true;
    }

    public static void dealSumErrorData(Context ctx, String attendPeriodId) {
        try {
            ThreadPoolExecutor pool = TaskPool.getFixedInstance("dealSumErrorData", 1, 100L);
            pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String attendPeriodId = (String)this.getDependency();
                    AtsSumSalaryDeleteUtil.deleteOutDatedResSum(this.ctx, attendPeriodId);
                    return null;
                }
            }.setDependency(attendPeriodId).setCtx(ctx));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteSumDataDuplicate(Context ctx, String attendPeriodId) {
        try {
            int sumRepeatCount;
            int salaryRepeatCount;
            StringBuilder mdStr = new StringBuilder();
            mdStr.append(" SELECT COUNT(*) CNT FROM T_HR_ATS_ATTENDANCERESUMMD ").append(" WHERE FATTENDANCEPERIODID = ? GROUP BY FPROPOSERID,FADMINORGUNITID ,FHRORGUNITID ,FATTENDANCEPERIODID ").append(" HAVING COUNT(*) > 1");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)mdStr.toString(), (Object[])new Object[]{attendPeriodId});
            if (rs.next() && (salaryRepeatCount = rs.getInt("CNT")) > 0) {
                StringBuilder mdDelStr = new StringBuilder();
                mdDelStr.append(" DELETE FROM T_HR_ATS_ATTENDANCERESUMMD A WHERE A.FID < (SELECT MAX(B.FID) FROM T_HR_ATS_ATTENDANCERESUMMD B ").append(" WHERE A.FPROPOSERID = B.FPROPOSERID ").append(" AND A.FADMINORGUNITID=B.FADMINORGUNITID ").append(" AND A.FHRORGUNITID =B.FHRORGUNITID ").append(" AND A.FATTENDANCEPERIODID = B.FATTENDANCEPERIODID ) ").append(" AND A.FATTENDANCEPERIODID = ? ");
                DbUtil.execute((Context)ctx, (String)mdDelStr.toString(), (Object[])new Object[]{attendPeriodId});
            }
            StringBuilder sumStr = new StringBuilder();
            sumStr.append(" SELECT COUNT(*) CNT FROM T_HR_ATS_ATTENDANCERESULTSUM ").append(" WHERE FATTENDANCEPERIODID = ? GROUP BY FPROPOSERID,FADMINORGUNITID ,FHRORGUNITID ,FATTENDANCEPERIODID ").append(" HAVING COUNT(*) > 1");
            rs = DbUtil.executeQuery((Context)ctx, (String)mdStr.toString(), (Object[])new Object[]{attendPeriodId});
            if (rs.next() && (sumRepeatCount = rs.getInt("CNT")) > 0) {
                StringBuilder sumDelStr = new StringBuilder();
                sumDelStr.append(" DELETE FROM T_HR_ATS_ATTENDANCERESULTSUM A WHERE A.FID < (SELECT MAX(B.FID) FROM T_HR_ATS_ATTENDANCERESULTSUM B ").append(" WHERE A.FPROPOSERID = B.FPROPOSERID ").append(" AND A.FADMINORGUNITID=B.FADMINORGUNITID ").append(" AND A.FHRORGUNITID =B.FHRORGUNITID ").append(" AND A.FATTENDANCEPERIODID = B.FATTENDANCEPERIODID ) ").append(" AND A.FATTENDANCEPERIODID = ? ");
                DbUtil.execute((Context)ctx, (String)sumDelStr.toString(), (Object[])new Object[]{attendPeriodId});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteSumDataUnMatchByOrg(Context ctx, String attendPeriodId) {
        try {
            StringBuilder queryStr = new StringBuilder();
            queryStr.append(" select resSum.fid,resSum.FHrOrgUnitID, resSum.FAdminOrgUnitId,resSum.fproposerid from T_HR_ATS_AttendanceResultSum resSum where fid in ( ").append(" select resSum.fid from T_HR_ATS_AttendanceResultSum resSum  ").append(" inner join T_HR_ATS_AttendancePeriod atsPer on resSum.FAttendancePeriodID = atsPer.FID ").append(" left join T_HR_ATS_ATTENDANCEFILEHIS FHIS  on FHIS.FPROPOSERID=resSum.FProposerID  ").append(" and FHIS.FhrOrgUnitId = resSum.FhrOrgUnitId ").append(" and FHIS.FAdminOrgUnitId = resSum.FAdminOrgUnitId ").append(" and  FHIS.FLEFFDT >= atsPer.FStartDate and FHIS.FEFFDT <= atsPer.FEndDate ").append(" where resSum.FAttendancePeriodID = ? ").append(" and resSum.FSalaryStatus <> 1 ").append(" group by resSum.fid having count(FHIS.fid) = 0 ").append(" ) ");
            IRowSet queryRs = DbUtil.executeQuery((Context)ctx, (String)queryStr.toString(), (Object[])new Object[]{attendPeriodId});
            AtsSumSalaryDeleteUtil.deleteDataAndRecordLog(ctx, attendPeriodId, queryRs, queryStr.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteSumDataUnMatchByPerson(Context ctx, String attendPeriodId) {
        try {
            AttendancePeriodInfo atsPeriod = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodInfo("select startDate,endDate,name where id='" + attendPeriodId + "'");
            if (null != atsPeriod && atsPeriod.getStartDate() != null) {
                Date startDate = atsPeriod.getStartDate();
                Date endDate = atsPeriod.getEndDate();
                StringBuilder queryStr = new StringBuilder();
                queryStr.append(" select resSum.fid,resSum.FHrOrgUnitID, resSum.FAdminOrgUnitId,resSum.fproposerid from T_HR_ATS_AttendanceResultSum resSum where fid in ( ").append(" select resSum.fid from T_HR_ATS_AttendanceResultSum resSum  ").append(" inner join T_HR_ATS_AttendancePeriod atsPer on resSum.FAttendancePeriodID = atsPer.FID ").append(" left join (select FHIS.FHrOrgUnitID,fHis.fproposerid,fHis.FAdminOrgUnitId  ").append(" from t_hr_ats_attendancefilehis  fHis ").append(" inner join ( SELECT fh.fproposerid,MAX(fh.fleffdt) fleffdt,MAX(fh.FEFFDT) FEFFDT FROM t_hr_ats_attendancefilehis fh ").append(" WHERE fh.FLEFFDT >= ? and fh.FEFFDT <= ? ").append(" GROUP BY fh.fproposerid )hisMax on fHis.fproposerid = hisMax.fproposerid and fHis.FEFFDT = hisMax.FEFFDT and fHis.FEFFDT = hisMax.FEFFDT ").append(" where FHIS.FLEFFDT >= ? and FHIS.FEFFDT <= ? ").append(" )T on resSum.FAdminOrgUnitId = t.FAdminOrgUnitId and resSum.fproposerid = t.fproposerid and resSum.FHrOrgUnitID = t.FHrOrgUnitID ").append(" where resSum.FAttendancePeriodID = ?  ").append(" and resSum.FSalaryStatus <> 1  and t.fproposerid is null ").append(" ) ");
                IRowSet queryRs = DbUtil.executeQuery((Context)ctx, (String)queryStr.toString(), (Object[])new Object[]{new Timestamp(startDate.getTime()), new Timestamp(endDate.getTime()), new Timestamp(startDate.getTime()), new Timestamp(endDate.getTime()), attendPeriodId});
                AtsSumSalaryDeleteUtil.deleteDataAndRecordLog(ctx, attendPeriodId, queryRs, queryStr.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteSumDataUnMatchByHRPerson(Context ctx, String attendPeriodId) {
        try {
            AttendancePeriodInfo atsPeriod = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodInfo("select startDate,endDate,name where id='" + attendPeriodId + "'");
            if (null != atsPeriod && atsPeriod.getStartDate() != null) {
                Date startDate = atsPeriod.getStartDate();
                Date endDate = atsPeriod.getEndDate();
                StringBuilder queryStr = new StringBuilder();
                queryStr.append(" select resSum.fid,resSum.FHrOrgUnitID, resSum.FAdminOrgUnitId,resSum.fproposerid from T_HR_ATS_AttendanceResultSum resSum where fid in ( ").append(" select resSum.fid from T_HR_ATS_AttendanceResultSum resSum  ").append(" inner join T_HR_ATS_AttendancePeriod atsPer on resSum.FAttendancePeriodID = atsPer.FID ").append(" left join (select FHIS.FHrOrgUnitID,fHis.fproposerid,fHis.FAdminOrgUnitId  ").append(" from t_hr_ats_attendancefilehis  fHis ").append(" inner join ( SELECT fh.fproposerid,Fh.FHrOrgUnitID,MAX(fh.fleffdt) fleffdt,MAX(fh.FEFFDT) FEFFDT FROM t_hr_ats_attendancefilehis fh ").append(" WHERE fh.FLEFFDT >= ? and fh.FEFFDT <= ? ").append(" GROUP BY fh.fproposerid ,Fh.FHrOrgUnitID)hisMax on fHis.fproposerid = hisMax.fproposerid and fHis.FHrOrgUnitID = hisMax.FHrOrgUnitID and fHis.FEFFDT = hisMax.FEFFDT and fHis.FEFFDT = hisMax.FEFFDT ").append(" where FHIS.FLEFFDT >= ? and FHIS.FEFFDT <= ? ").append(" )T on resSum.FAdminOrgUnitId = t.FAdminOrgUnitId and resSum.fproposerid = t.fproposerid and resSum.FHrOrgUnitID = t.FHrOrgUnitID ").append(" where resSum.FAttendancePeriodID = ? ").append(" and resSum.FSalaryStatus <> 1  and t.fproposerid is null ").append(" ) ");
                IRowSet queryRs = DbUtil.executeQuery((Context)ctx, (String)queryStr.toString(), (Object[])new Object[]{new Timestamp(startDate.getTime()), new Timestamp(endDate.getTime()), new Timestamp(startDate.getTime()), new Timestamp(endDate.getTime()), attendPeriodId});
                AtsSumSalaryDeleteUtil.deleteDataAndRecordLog(ctx, attendPeriodId, queryRs, queryStr.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteSumDataUnMatchByHRPersonAtt(Context ctx, String attendPeriodId) {
        try {
            StringBuilder queryStr = new StringBuilder();
            queryStr.append(" select resSum.fid,resSum.FHrOrgUnitID, resSum.FAdminOrgUnitId,resSum.fproposerid from T_HR_ATS_AttendanceResultSum resSum where fid in ( ").append(" select resSum.fid from T_HR_ATS_AttendanceResultSum resSum  ").append(" inner join T_HR_ATS_AttendancePeriod atsPer on resSum.FAttendancePeriodID = atsPer.FID ").append(" left join T_HR_ATS_ATTENDANCEFILEHIS FHIS  on FHIS.FPROPOSERID=resSum.FProposerID  ").append(" and FHIS.FhrOrgUnitId = resSum.FhrOrgUnitId ").append(" and FHIS.FATTAdminOrgUnitId = resSum.FAdminOrgUnitId ").append(" and  FHIS.FLEFFDT >= atsPer.FStartDate and FHIS.FEFFDT <= atsPer.FEndDate ").append(" where resSum.FAttendancePeriodID = ? ").append(" and resSum.FSalaryStatus <> 1 ").append(" group by resSum.fid having count(FHIS.fid) = 0 ").append(" ) ");
            IRowSet queryRs = DbUtil.executeQuery((Context)ctx, (String)queryStr.toString(), (Object[])new Object[]{attendPeriodId});
            AtsSumSalaryDeleteUtil.deleteDataAndRecordLog(ctx, attendPeriodId, queryRs, queryStr.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteDataAndRecordLog(Context ctx, String attendPeriodId, IRowSet queryRs, String querySql) throws SQLException, BOSException, EASBizException {
        StringBuilder logResult = new StringBuilder();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        String fid = null;
        while (queryRs.next()) {
            logResult.append(queryRs.getString("fid") + ":");
            logResult.append(queryRs.getString("FHrOrgUnitID") + ",");
            logResult.append(queryRs.getString("FAdminOrgUnitId") + ",");
            logResult.append(queryRs.getString("fproposerid") + ";");
            params.add(new Object[]{queryRs.getString("fid")});
            fid = queryRs.getString("fid");
        }
        if (params.size() > 0) {
            AttendancePeriodInfo atsPeriod = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodInfo("select startDate,endDate,name where id='" + attendPeriodId + "'");
            String deleteStr = " delete from T_HR_ATS_AttendanceResultSum where fid = ? ";
            int[] count = DbUtil.executeBatchAndReturn((Context)ctx, (String)deleteStr.toString(), params);
            logResult.insert(0, "totalCount:\u3010" + count.length + "\u3011");
            querySql = " delete from T_HR_ATS_AttendanceResultSum where fid in ( " + querySql + ")";
            DataLogUtil.saveSumDataLogBySalary(ctx, attendPeriodId, atsPeriod.getName(), querySql.toString(), logResult.toString(), fid, OperActionEnum.deleteInvalidData);
        }
    }
}

