/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.BizDataOAuthFactory;
import com.kingdee.eas.hr.ats.BizDataOAuthInfo;
import com.kingdee.eas.hr.ats.CloudHubSignServiceConfigCollection;
import com.kingdee.eas.hr.ats.CloudHubSignServiceConfigFactory;
import com.kingdee.eas.hr.ats.CloudHubSignServiceConfigInfo;
import com.kingdee.eas.hr.ats.IBizDataOAuth;
import com.kingdee.eas.hr.ats.syn.SynchUtil;
import com.kingdee.eas.hr.ats.syn.SynchronizationContext;
import com.kingdee.eas.hr.ats.syn.httpclient.MyHttpClient;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.portal.biz.common.exception.BizException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.StringUtils;

public class CloudHubSignServiceManager {
    private static final String dataType = "kdweibo";

    public CloudHubSignServiceConfigCollection getCloudHubSignServiceConfigCollection(Context ctx) throws BOSException {
        CloudHubSignServiceConfigCollection collections = CloudHubSignServiceConfigFactory.getLocalInstance(ctx).getCloudHubSignServiceConfigCollection();
        return collections;
    }

    public String detectCloudHubServiceAble(CloudHubSignServiceConfigCollection collections) {
        if (this.detectSignServiceAble(collections) && this.detectSignAttendServiceAble(collections)) {
            return "111";
        }
        if (!(this.detectSignServiceAble(collections) || this.detectSignAttendServiceAble(collections) || this.detectSignAttendNewServiceAble(collections))) {
            return "100";
        }
        if ((this.detectSignAttendServiceAble(collections) || this.detectSignAttendNewServiceAble(collections)) && !this.detectAttendConfirmServiceAble(collections)) {
            return "110";
        }
        return "200";
    }

    public String detectCloudHubService(Context ctx, CloudHubSignServiceConfigCollection collections) throws EASBizException, BOSException, HttpException, IOException, BizException {
        if (SynchUtil.isPrivteCloud()) {
            return this.detectCloudHubPrivateService(ctx, collections);
        }
        String statusAble = this.detectCloudHubServiceAble(collections);
        if ("200".equals(statusAble)) {
            if (this.detectSignServiceAble(collections)) {
                int status = this.detectSignService(ctx, collections);
                return "1" + status;
            }
            if (this.detectSignAttendServiceAble(collections) && this.detectAttendConfirmServiceAble(collections)) {
                int statusAttend = this.detectSignAttendService(ctx, collections);
                if (statusAttend == 204 || statusAttend == 200) {
                    String statusConfirm = this.detectAttendConfirmService(ctx, collections);
                    return statusConfirm;
                }
                return "2" + statusAttend;
            }
            if (this.detectSignAttendNewServiceAble(collections) && this.detectAttendConfirmServiceAble(collections)) {
                int statusAttend = this.detectSignAttendNewService(ctx, collections);
                if (statusAttend == 204 || statusAttend == 200) {
                    String statusConfirm = this.detectAttendConfirmService(ctx, collections);
                    return statusConfirm;
                }
                return "2" + statusAttend;
            }
            return "abnormal";
        }
        return statusAble;
    }

    public String detectCloudHubPrivateService(Context ctx, CloudHubSignServiceConfigCollection collections) throws EASBizException, BOSException, HttpException, IOException, BizException {
        if (this.detectSignAttendServiceAble(collections)) {
            int statusAttend = this.detectSignAttendService(ctx, collections);
            if (statusAttend == 204 || statusAttend == 200) {
                return "3200";
            }
            return "2" + statusAttend;
        }
        return "2900";
    }

    public int detectService(Context ctx, String url, Map<String, Object> urlParamMap) throws BOSException, EASBizException, HttpException, IOException {
        int status;
        SynchronizationContext synContext = new SynchronizationContext();
        synContext.setBosCtx(ctx);
        BizDataOAuthInfo bizDataOAuthInfo = null;
        IBizDataOAuth bizDataOAuth = BizDataOAuthFactory.getLocalInstance(synContext.getBosCtx());
        if (!bizDataOAuth.exists(" where key='kdweibo' ")) {
            throw new BOSException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.NOYUNZHIJIAAUTH)));
        }
        bizDataOAuthInfo = bizDataOAuth.getBizDataOAuthInfo(" where key='kdweibo' ");
        MyHttpClient myHttpClient = new MyHttpClient();
        url = SynchUtil.GetCloudHubDNS(ctx) + url;
        try {
            status = myHttpClient.accessWeiboUrlByGetAndDetect(url, urlParamMap, bizDataOAuthInfo, ctx);
        }
        catch (BizException e) {
            e.printStackTrace();
            status = 500;
        }
        return status;
    }

    public String detectAttendConfirm(Context ctx, String url, Map<String, Object> urlParamMap) throws BOSException, EASBizException, HttpException, IOException, BizException {
        boolean isOutWorkFeedbackOn;
        JSONObject rootJSONObject;
        JSONObject data;
        SynchronizationContext synContext = new SynchronizationContext();
        synContext.setBosCtx(ctx);
        BizDataOAuthInfo bizDataOAuthInfo = null;
        IBizDataOAuth bizDataOAuth = BizDataOAuthFactory.getLocalInstance(synContext.getBosCtx());
        if (!bizDataOAuth.exists(" where key='kdweibo' ")) {
            throw new BOSException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.NOYUNZHIJIAAUTH)));
        }
        bizDataOAuthInfo = bizDataOAuth.getBizDataOAuthInfo(" where key='kdweibo' ");
        MyHttpClient myHttpClient = new MyHttpClient();
        url = SynchUtil.GetCloudHubDNS(ctx) + url;
        String jsonString = "";
        try {
            jsonString = myHttpClient.accessWeiboUrlByGet(url, urlParamMap, bizDataOAuthInfo, ctx);
        }
        catch (BizException e) {
            e.printStackTrace();
            return "3404";
        }
        if (StringUtils.isNotEmpty((String)jsonString) && (data = (JSONObject)(rootJSONObject = JSONObject.fromObject((Object)jsonString)).get("data")) != null && (isOutWorkFeedbackOn = ((Boolean)data.get("isOutWorkFeedbackOn")).booleanValue())) {
            return "3200";
        }
        return "3500";
    }

    public int detectSignService(Context ctx, CloudHubSignServiceConfigCollection collections) throws EASBizException, BOSException, HttpException, IOException, BizException {
        AtsDateUtils.dateShortToString(new Date());
        HashMap<String, Object> paramMapGet = new HashMap<String, Object>();
        long start = 0L;
        long limit = 150L;
        paramMapGet.put("beginDate", AtsDateUtils.dateShortToString(new Date()) + " 00:00:00");
        paramMapGet.put("endDate", AtsDateUtils.dateShortToString(new Date()) + " 23:59:59");
        paramMapGet.put("start", start);
        paramMapGet.put("limit", limit);
        return this.detectService(ctx, this.getSignServiceConfigInfo(collections, "T9UAAAAchMhQ1Wlg").getDetectAddress(), paramMapGet);
    }

    protected int detectSignAttendService(Context ctx, CloudHubSignServiceConfigCollection collections) throws EASBizException, BOSException, HttpException, IOException, BizException {
        HashMap<String, Object> paramMapGet = new HashMap<String, Object>();
        int start = 1;
        int limit = 150;
        paramMapGet.put("workDateFrom", AtsDateUtils.dateShortToString(new Date()) + " 00:00:00");
        paramMapGet.put("workDateTo", AtsDateUtils.dateShortToString(new Date()) + " 23:59:59");
        paramMapGet.put("start", start);
        paramMapGet.put("limit", limit);
        return this.detectService(ctx, this.getSignServiceConfigInfo(collections, "T9UAAAAcimFQ1Wlg").getDetectAddress(), paramMapGet);
    }

    protected int detectSignAttendNewService(Context ctx, CloudHubSignServiceConfigCollection collections) throws EASBizException, BOSException, HttpException, IOException, BizException {
        HashMap<String, Object> paramMapGet = new HashMap<String, Object>();
        paramMapGet.put("workDate", AtsDateUtils.dateShortToString(new Date()));
        return this.detectService(ctx, this.getSignServiceConfigInfo(collections, "qr2nHQaT4Eanw3TTFGqGCFDVaWA=").getDetectAddress(), paramMapGet);
    }

    protected String detectAttendConfirmService(Context ctx, CloudHubSignServiceConfigCollection collections) throws EASBizException, BOSException, HttpException, IOException, BizException {
        if (this.notDetcetOutConfirm()) {
            return "3200";
        }
        return this.detectAttendConfirm(ctx, this.getSignServiceConfigInfo(collections, "T9UAAAAcimJQ1Wlg").getDetectAddress(), null);
    }

    public boolean detectServiceAble(CloudHubSignServiceConfigInfo info) {
        int status;
        return info != null && 1 == (status = info.getState().getValue());
    }

    public boolean detectSignServiceAble(CloudHubSignServiceConfigCollection collections) {
        CloudHubSignServiceConfigInfo info = this.getSignServiceConfigInfo(collections, "T9UAAAAchMhQ1Wlg");
        return this.detectServiceAble(info);
    }

    public boolean detectSignAttendServiceAble(CloudHubSignServiceConfigCollection collections) {
        CloudHubSignServiceConfigInfo info = this.getSignServiceConfigInfo(collections, "T9UAAAAcimFQ1Wlg");
        return this.detectServiceAble(info);
    }

    protected boolean detectAttendConfirmServiceAble(CloudHubSignServiceConfigCollection collections) {
        if (this.notDetcetOutConfirm()) {
            return true;
        }
        CloudHubSignServiceConfigInfo info = this.getSignServiceConfigInfo(collections, "T9UAAAAcimJQ1Wlg");
        return this.detectServiceAble(info);
    }

    protected boolean notDetcetOutConfirm() {
        return true;
    }

    public boolean detectSignAttendNewServiceAble(CloudHubSignServiceConfigCollection collections) {
        CloudHubSignServiceConfigInfo info = this.getSignServiceConfigInfo(collections, "qr2nHQaT4Eanw3TTFGqGCFDVaWA=");
        return this.detectServiceAble(info);
    }

    public CloudHubSignServiceConfigInfo getSignServiceConfigInfo(CloudHubSignServiceConfigCollection collections, String id) {
        CloudHubSignServiceConfigInfo cloudHubSignServiceConfigInfo = null;
        if (collections != null && collections.size() != 0) {
            for (int i = 0; i < collections.size(); ++i) {
                if (collections.get(i) == null || !id.equals(collections.get(i).getId().toString())) continue;
                cloudHubSignServiceConfigInfo = collections.get(i);
            }
        }
        return cloudHubSignServiceConfigInfo;
    }

    public CloudHubSignServiceConfigInfo getAbleSignServiceConfigInfo(CloudHubSignServiceConfigCollection collections) {
        CloudHubSignServiceConfigInfo cloudHubSignServiceConfigInfo = null;
        cloudHubSignServiceConfigInfo = this.getSignServiceConfigInfo(collections, "T9UAAAAchMhQ1Wlg");
        if (1 == cloudHubSignServiceConfigInfo.getState().getValue()) {
            return cloudHubSignServiceConfigInfo;
        }
        cloudHubSignServiceConfigInfo = this.getSignServiceConfigInfo(collections, "T9UAAAAcimFQ1Wlg");
        if (1 == cloudHubSignServiceConfigInfo.getState().getValue()) {
            return cloudHubSignServiceConfigInfo;
        }
        cloudHubSignServiceConfigInfo = this.getSignServiceConfigInfo(collections, "qr2nHQaT4Eanw3TTFGqGCFDVaWA=");
        if (1 == cloudHubSignServiceConfigInfo.getState().getValue()) {
            return cloudHubSignServiceConfigInfo;
        }
        return null;
    }
}

