/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.synch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsTimeCommonResEnum;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AuditOpinionEnum;
import com.kingdee.eas.hr.ats.BizDataOAuthInfo;
import com.kingdee.eas.hr.ats.IPunchCardRecord;
import com.kingdee.eas.hr.ats.ISignRecord;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.PunchCardSourceEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.SignRecordCollection;
import com.kingdee.eas.hr.ats.SignRecordFactory;
import com.kingdee.eas.hr.ats.SignRecordInfo;
import com.kingdee.eas.hr.ats.syn.SynchUtil;
import com.kingdee.eas.hr.ats.syn.httpclient.MyHttpClient;
import com.kingdee.eas.hr.ats.syn.punchcard.PunchcardHttpExecutor;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynUtile;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsManageLoggerUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.portal.biz.common.exception.BizException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PunchCardByOpenIdSynchroniztion {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.syn.synch.PunchCardByOpenIdSynchroniztion");
    private Logger loggerSignSyn = AtsManageLoggerUtil.getLogger("shr_ats_punchcard_log", "getkdcloudpunchcard");
    private Context ctx;
    private Map<String, PersonInfo> pMap = null;
    private Map<String, PersonPositionInfo> ppMap = null;
    private Map<String, PersonInfo> allOpenID2PersonMap = null;
    private Map<String, String> allPerson2OpenIdMap = null;
    private Map<String, AttendanceFileInfo> allOpenID2AttFileMap = null;
    private Timestamp nowTimestamp = new Timestamp(System.currentTimeMillis());
    private PunchcardHttpExecutor httpExecutor = new PunchcardHttpExecutor();

    public PunchCardByOpenIdSynchroniztion(Context ctx) {
        this.ctx = ctx;
        this.pMap = SynchUtil.GetAllPersonInfo(ctx);
        this.ppMap = SynchUtil.GetAllPersonPositionInfo(ctx);
        this.allOpenID2PersonMap = SynchUtil.GetAllOpenID2Person(ctx);
        this.allPerson2OpenIdMap = SynchUtil.GetPerson2OpenId(ctx);
        this.allOpenID2AttFileMap = SynchUtil.GetAllOpenID2AttendanceFile(ctx);
    }

    public PunchCardByOpenIdSynchroniztion(Context ctx, String personIds) {
        this.ctx = ctx;
        this.pMap = SynchUtil.GetAllPersonInfo(ctx, personIds);
        this.ppMap = SynchUtil.GetAllPersonPositionInfo(ctx, personIds);
        this.allOpenID2PersonMap = SynchUtil.GetAllOpenID2Person(ctx, personIds);
        this.allPerson2OpenIdMap = SynchUtil.GetPerson2OpenId(ctx, personIds);
        this.allOpenID2AttFileMap = SynchUtil.GetAllOpenID2AttendanceFile(ctx, personIds);
    }

    public String synchronizatioin(Map<String, Object> paramMap) throws EASBizException, BOSException {
        String dataErrorString = "";
        boolean haveMore = true;
        int start = 1;
        int limit = 150;
        String openIds = "";
        String personIds = (String)paramMap.get("personIds");
        String[] personIdArr = personIds.split(",");
        ArrayList openIdList = new ArrayList();
        for (String s : personIdArr) {
            if (this.allPerson2OpenIdMap.get(s) == null) continue;
            openIds = openIds + this.allPerson2OpenIdMap.get(s) + ",";
        }
        if (StringUtils.isNotEmpty((String)openIds)) {
            openIds = openIds.substring(0, openIds.length() - 1);
        }
        paramMap.put("limit", limit);
        paramMap.put("openIds", openIds);
        String applicationForMark = (String)paramMap.get("applicationForMark");
        String openapikey = (String)paramMap.get("openapikey");
        String workDateFrom = (String)paramMap.get("workDateFrom");
        String workDateTo = (String)paramMap.get("workDateTo");
        Timestamp beginTime = AtsDateUtils.stringToTimestamp(workDateFrom);
        Timestamp endTime = AtsDateUtils.stringToTimestamp(workDateTo);
        IPunchCardRecord punchCardRecord = PunchCardRecordFactory.getLocalInstance(this.ctx);
        ISignRecord signRecord = SignRecordFactory.getLocalInstance(this.ctx);
        CoreBaseCollection crdColl = new CoreBaseCollection();
        CoreBaseCollection signRcdColl = new CoreBaseCollection();
        CoreBaseCollection signRcdCollAgree = new CoreBaseCollection();
        int cannotfindMapPerson = 0;
        this.loggerSignSyn.info((Object)MLUtile.getRes((ResourceEnum)AtsTimeCommonResEnum.SyncTimeRangeManual, this.ctx, workDateFrom, " \u2014\u2014 ", workDateTo, " "));
        long totalSize = 0L;
        long successSize = 0L;
        long batchNumber = 1L;
        String batchStartDateString = AtsDateUtils.timestampToString(new Timestamp(System.currentTimeMillis()));
        if (StringUtils.isNotEmpty((String)openIds)) {
            while (haveMore) {
                String positionResult;
                long punchTime;
                long approveTime;
                JSONObject approveResult;
                JSONObject json;
                int i;
                SignRecordInfo signRecordInfo;
                PunchCardRecordInfo crdInfo;
                paramMap.put("start", start);
                this.loggerSignSyn.info((Object)(batchStartDateString + "start_cur_batch:" + batchNumber++));
                JSONArray recordsJsonArr = null;
                if (paramMap.get("url").toString().endsWith("clockInlist")) {
                    this.httpExecutor.setUrl(paramMap.get("url").toString());
                    this.httpExecutor.setBizDataOAuthInfo((BizDataOAuthInfo)paramMap.get("bizDataOAuthInfo"));
                    HashMap<String, Object> clientMap = new HashMap<String, Object>();
                    clientMap.put("workDateFrom", paramMap.get("workDateFrom"));
                    clientMap.put("workDateTo", paramMap.get("workDateTo"));
                    clientMap.put("start", paramMap.get("start"));
                    clientMap.put("limit", paramMap.get("limit"));
                    if (paramMap.get("openIds") != null && StringUtils.isNotBlank((String)paramMap.get("openIds").toString())) {
                        clientMap.put("openIds", paramMap.get("openIds"));
                    }
                    this.httpExecutor.setParams(clientMap);
                    try {
                        this.httpExecutor.processRequest();
                        if (!this.httpExecutor.isSuccess()) {
                            throw new BOSException("success is false");
                        }
                        recordsJsonArr = this.httpExecutor.getResult();
                    }
                    catch (BizException e) {
                        throw new BOSException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.QUERYFAIL, e)));
                    }
                } else {
                    recordsJsonArr = (JSONArray)this.getOuterData(this.ctx, paramMap);
                }
                this.loggerSignSyn.info((Object)("fetched data:\r\n" + recordsJsonArr == null ? "" : recordsJsonArr.join("\r\n")));
                if (recordsJsonArr != null && recordsJsonArr.size() > 0) {
                    totalSize += (long)recordsJsonArr.size();
                }
                StringBuilder records = new StringBuilder();
                if (applicationForMark.equals("punchCardNew")) {
                    cannotfindMapPerson = 0;
                    if (recordsJsonArr != null && recordsJsonArr.size() > 0) {
                        this.loggerSignSyn.info((Object)("Synch total data size====" + recordsJsonArr.size()));
                        crdInfo = null;
                        signRecordInfo = null;
                        for (i = 0; i < recordsJsonArr.size(); ++i) {
                            json = recordsJsonArr.getJSONObject(i);
                            approveResult = new JSONObject();
                            if (!json.getString("approveResult").equals("")) {
                                approveResult = json.getJSONObject("approveResult");
                            }
                            approveTime = 0L;
                            if (!approveResult.isEmpty() && !approveResult.getString("approveTime").equals("null")) {
                                approveTime = approveResult.getLong("approveTime");
                            }
                            if ((punchTime = json.getLong("time")) < beginTime.getTime() || punchTime > endTime.getTime()) continue;
                            positionResult = json.getString("positionResult");
                            if ("Normal".equalsIgnoreCase(positionResult)) {
                                crdInfo = PunchCardSynUtile.assemblePunchCardRecordInfo(json, openapikey, this.nowTimestamp, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap);
                                if (crdInfo.getProposer() != null) {
                                    crdColl.add((CoreBaseInfo)crdInfo);
                                    continue;
                                }
                                ++cannotfindMapPerson;
                                continue;
                            }
                            if (approveResult.isEmpty()) {
                                String photoId = "";
                                if (json.containsKey((Object)"photoId")) {
                                    photoId = json.getString("photoId");
                                }
                                if (!photoId.equals("")) {
                                    crdInfo = PunchCardSynUtile.assemblePunchCardRecordInfo(json, openapikey, this.nowTimestamp, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap);
                                    if (crdInfo.getProposer() != null) {
                                        crdColl.add((CoreBaseInfo)crdInfo);
                                        continue;
                                    }
                                    ++cannotfindMapPerson;
                                    continue;
                                }
                                signRecordInfo = PunchCardSynUtile.assembleSignRecordInfo(json, openapikey, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap);
                                if (signRecordInfo.getPerson() != null) {
                                    signRcdColl.add((CoreBaseInfo)signRecordInfo);
                                    continue;
                                }
                                ++cannotfindMapPerson;
                                continue;
                            }
                            if ("HANDLED".equalsIgnoreCase(approveResult.getString("approveStatus"))) {
                                crdInfo = PunchCardSynUtile.assemblePunchCardRecordInfo(json, openapikey, this.nowTimestamp, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap);
                                if (crdInfo.getProposer() != null) {
                                    crdColl.add((CoreBaseInfo)crdInfo);
                                } else {
                                    ++cannotfindMapPerson;
                                }
                                signRecordInfo = PunchCardSynUtile.assembleSignRecordInfo(json, openapikey, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap);
                                if (signRecordInfo.getPerson() == null) continue;
                                signRcdCollAgree.add((CoreBaseInfo)signRecordInfo);
                                continue;
                            }
                            if (!"UNHANDLED".equalsIgnoreCase(approveResult.getString("approveStatus"))) continue;
                            signRecordInfo = PunchCardSynUtile.assembleSignRecordInfo(json, openapikey, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap);
                            if (signRecordInfo.getPerson() != null) {
                                signRcdColl.add((CoreBaseInfo)signRecordInfo);
                                continue;
                            }
                            ++cannotfindMapPerson;
                        }
                        this.loggerSignSyn.info((Object)records.toString());
                    }
                } else if (applicationForMark.equals("punchCard")) {
                    cannotfindMapPerson = 0;
                    if (recordsJsonArr != null && recordsJsonArr.size() > 0) {
                        System.out.println("Synch total data size====" + recordsJsonArr.size());
                        crdInfo = null;
                        signRecordInfo = null;
                        for (i = 0; i < recordsJsonArr.size(); ++i) {
                            json = recordsJsonArr.getJSONObject(i);
                            this.resolverRecords(json, records);
                            approveResult = new JSONObject();
                            if (!json.getString("approveResult").equals("")) {
                                approveResult = json.getJSONObject("approveResult");
                            }
                            approveTime = 0L;
                            if (!approveResult.isEmpty() && !approveResult.getString("approveTime").equals("null")) {
                                approveTime = approveResult.getLong("approveTime");
                            }
                            if ((punchTime = json.getLong("time")) < beginTime.getTime() || punchTime > endTime.getTime()) continue;
                            positionResult = json.getString("positionResult");
                            if ("Normal".equalsIgnoreCase(positionResult)) {
                                crdInfo = PunchCardSynUtile.assemblePunchCardRecordInfo(json, openapikey, this.nowTimestamp, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap);
                                if (crdInfo.getProposer() != null) {
                                    crdColl.add((CoreBaseInfo)crdInfo);
                                    continue;
                                }
                                ++cannotfindMapPerson;
                                continue;
                            }
                            signRecordInfo = PunchCardSynUtile.assembleSignRecordInfo(json, openapikey, this.ppMap, this.allOpenID2PersonMap, this.allOpenID2AttFileMap);
                            if (signRecordInfo.getPerson() != null) {
                                signRcdColl.add((CoreBaseInfo)signRecordInfo);
                                continue;
                            }
                            ++cannotfindMapPerson;
                        }
                        this.loggerSignSyn.info((Object)records.toString());
                    }
                }
                if (recordsJsonArr == null || recordsJsonArr.size() < 150) {
                    haveMore = false;
                    break;
                }
                ++start;
            }
        }
        if (!crdColl.isEmpty()) {
            PunchCardByOpenIdSynchroniztion.removePunchCardData(this.ctx, PunchCardSourceEnum.openapisynch.getValue(), openapikey, beginTime, endTime, personIds);
            punchCardRecord.save(crdColl);
            successSize += (long)crdColl.size();
        }
        successSize += (long)signRcdColl.size();
        signRcdColl.addCollection(signRcdCollAgree);
        signRcdCollAgree.clear();
        if (signRcdColl.size() > 0) {
            signRcdColl = PunchCardSynUtile.compareSignRcdColl(signRecord, signRcdColl, beginTime, endTime);
        }
        if (!signRcdColl.isEmpty()) {
            signRecord.save(signRcdColl);
        }
        if (!signRcdCollAgree.isEmpty()) {
            signRecord.save(signRcdCollAgree);
        }
        this.deleteSignRecordRepeat(this.ctx, workDateFrom, workDateTo);
        String batchEndDateString = AtsDateUtils.timestampToString(new Timestamp(System.currentTimeMillis()));
        this.loggerSignSyn.info((Object)(batchStartDateString + " end\uff08end time\uff1a" + batchEndDateString + "\uff0ctotal size" + totalSize + "\uff09"));
        dataErrorString = MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item16, this.ctx, workDateFrom, workDateTo, totalSize, successSize);
        return dataErrorString;
    }

    private void deleteSignRecordRepeat(Context ctx, String beginDateStr, String endDateStr) {
        StringBuilder sb = new StringBuilder();
        sb.append(" delete from T_HR_SIGNRECORD where fid in (");
        sb.append(" select fid ");
        sb.append(" FROM ");
        sb.append(" \tT_HR_SIGNRECORD t1 ");
        sb.append(" WHERE ");
        sb.append(" \tFAUDITOPINION = 0 ");
        sb.append(" AND FSIGNDATE >={ ts '" + beginDateStr + "' } AND FSIGNDATE <={ ts '" + endDateStr + "' } ");
        sb.append(" AND EXISTS ( ");
        sb.append(" \tSELECT ");
        sb.append(" \t\t1 ");
        sb.append(" \tFROM ");
        sb.append(" \t\tT_HR_SIGNRECORD t2 ");
        sb.append(" \tWHERE ");
        sb.append(" \t\tt1.FPERSONID = t2.FPERSONID ");
        sb.append(" \tAND t1.FSIGNTIME = t2.FSIGNTIME ");
        sb.append(" \tAND ( ");
        sb.append(" \t\tt2.FAUDITOPINION = 1 ");
        sb.append(" \tOR t2.FAUDITOPINION = 2 ");
        sb.append(" \t) ");
        sb.append(" )) ");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public Object getOuterData(Context ctx, Map<String, Object> paramMap) throws EASBizException, BOSException {
        String url = (String)paramMap.get("url");
        MyHttpClient myHttpClient = new MyHttpClient();
        try {
            HashMap<String, Object> urlParamMap = new HashMap<String, Object>();
            urlParamMap.put("workDateFrom", paramMap.get("workDateFrom"));
            urlParamMap.put("workDateTo", paramMap.get("workDateTo"));
            urlParamMap.put("start", paramMap.get("start"));
            urlParamMap.put("limit", paramMap.get("limit"));
            urlParamMap.put("openIds", paramMap.get("openIds"));
            BizDataOAuthInfo bizDataOAuthInfo = (BizDataOAuthInfo)paramMap.get("bizDataOAuthInfo");
            String jsonString = myHttpClient.accessWeiboUrlByGet(url, urlParamMap, bizDataOAuthInfo, ctx);
            this.logger.info((Object)("call openapi punchcard data:" + jsonString));
            if (jsonString == null || jsonString.trim().length() < 1) {
                return null;
            }
            JSONObject rootJSONObject = JSONObject.fromObject((Object)jsonString);
            if (rootJSONObject.get("data").equals("null")) {
                return null;
            }
            JSONArray recordsJsonArr = rootJSONObject.getJSONArray("data");
            return recordsJsonArr;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    private static void removePunchCardData(Context ctx, String type, String openapikey, Timestamp beginDate, Timestamp enddate, String personIds) throws BOSException {
        System.out.println("Delete punchcard data beginDate====" + AtsDateUtils.timestampToString(beginDate));
        System.out.println("Delete punchcard data endDate====" + AtsDateUtils.timestampToString(enddate));
        Object[] params1 = new Object[]{type, openapikey, beginDate, enddate};
        String sql1 = " delete  from T_HR_ATS_PunchCardRecord where FPUNCHCARDSOURCE= ? and FEQUIPMENTNUM = ? and FPUNCHCARDTIME >=? and FPUNCHCARDTIME <=? and FPunchCardState is Null and FProposerID in ('" + personIds.replaceAll(",", "','") + "')";
        DbUtil.execute((Context)ctx, (String)sql1, (Object[])params1);
    }

    public PunchCardRecordInfo assemblePunchCardRecordInfo(JSONObject json, String openapikey) {
        PunchCardRecordInfo crdInfo = new PunchCardRecordInfo();
        String openID = json.getString("openId");
        crdInfo.setEquipmentNum(openapikey);
        crdInfo.setPunchCardDate(AtsDateUtils.stringToShortDate(json.getString("day")));
        crdInfo.setPunchCardTime(new Timestamp(json.getLong("time")));
        crdInfo.setPunchCardPlace(json.getString("position"));
        crdInfo.setPunchCardSource(PunchCardSourceEnum.openapisynch);
        if (this.allOpenID2PersonMap != null && this.allOpenID2PersonMap.containsKey(openID)) {
            PersonPositionInfo ppInfo;
            crdInfo.setProposer(this.allOpenID2PersonMap.get(openID));
            if (crdInfo.getProposer() != null && this.ppMap != null && (ppInfo = this.ppMap.get(crdInfo.getProposer().getId().toString())) != null) {
                crdInfo.setHrOrgUnit(ppInfo.getHrOrgUnit());
                crdInfo.setAdminOrgUnit(ppInfo.getPersonDep());
            }
            if (this.allOpenID2AttFileMap != null && this.allOpenID2AttFileMap.containsKey(openID) && this.allOpenID2AttFileMap.get(openID).getAttendanceNum() != null) {
                crdInfo.setAttendanceNum(this.allOpenID2AttFileMap.get(openID).getAttendanceNum());
                crdInfo.setHrOrgUnit(this.allOpenID2AttFileMap.get(openID).getHrOrgUnit());
                crdInfo.setAdminOrgUnit(this.allOpenID2AttFileMap.get(openID).getAdminOrgUnit());
                crdInfo.setAttAdminOrgUnit(this.allOpenID2AttFileMap.get(openID).getAttAdminOrgUnit());
            } else {
                crdInfo.setAttendanceNum(crdInfo.getProposer().getNumber());
            }
        }
        crdInfo.setCreateTime(this.nowTimestamp);
        crdInfo.setLastUpdateTime(this.nowTimestamp);
        return crdInfo;
    }

    public SignRecordInfo assembleSignRecordInfo(JSONObject json, String openapikey) {
        SignRecordInfo crdInfo = new SignRecordInfo();
        String openID = json.getString("openId");
        crdInfo.setSignDate(AtsDateUtils.stringToShortDate(json.getString("day")));
        crdInfo.setSignTime(new Timestamp(json.getLong("time")));
        crdInfo.setAddress(json.getString("position"));
        if (this.allOpenID2PersonMap != null && this.allOpenID2PersonMap.containsKey(openID)) {
            crdInfo.setPerson(this.allOpenID2PersonMap.get(openID));
        }
        if (crdInfo.getPerson() != null) {
            PersonPositionInfo ppInfo;
            if (this.ppMap != null && (ppInfo = this.ppMap.get(crdInfo.getPerson().getId().toString())) != null) {
                crdInfo.setHrOrgUnit(ppInfo.getHrOrgUnit());
                crdInfo.setAdminOrg(ppInfo.getPersonDep());
            }
            if (this.allOpenID2AttFileMap != null && this.allOpenID2AttFileMap.containsKey(openID)) {
                crdInfo.setHrOrgUnit(this.allOpenID2AttFileMap.get(openID).getHrOrgUnit());
                crdInfo.setAdminOrg(this.allOpenID2AttFileMap.get(openID).getAdminOrgUnit());
                crdInfo.setAttAdminOrgUnit(this.allOpenID2AttFileMap.get(openID).getAttAdminOrgUnit());
            }
        }
        crdInfo.setAuditOpinion(AuditOpinionEnum.unaudited);
        crdInfo.setSignType(1);
        return crdInfo;
    }

    public CoreBaseCollection removeRepeatSignRecords(ISignRecord signRecord, CoreBaseCollection signRcdColl, Timestamp beginDate, Timestamp endDate) {
        beginDate = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(beginDate)).getTime());
        endDate = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(endDate)).getTime() + 86400000L - 1L);
        CoreBaseCollection col = new CoreBaseCollection();
        if (signRcdColl == null || signRcdColl.isEmpty()) {
            return col;
        }
        HashSet<String> pidSet = new HashSet<String>();
        Iterator iterator = signRcdColl.iterator();
        boolean havePersonNull = false;
        while (iterator.hasNext()) {
            SignRecordInfo signRecordInfo = (SignRecordInfo)iterator.next();
            if (signRecordInfo.getPerson() != null && signRecordInfo.getPerson().getId() != null) {
                pidSet.add(signRecordInfo.getPerson().getId().toString());
                continue;
            }
            havePersonNull = true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("signTime"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        FilterInfo fi = new FilterInfo();
        if (pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
        } else if (!pidSet.isEmpty() && !havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
        } else if (!pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
            FilterInfo fi2 = new FilterInfo();
            fi2.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
            try {
                fi.mergeFilter(fi2, "OR");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            return col;
        }
        FilterInfo fi3 = new FilterInfo();
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)endDate, CompareType.LESS_EQUALS));
        try {
            fi.mergeFilter(fi3, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        evi.setFilter(fi);
        try {
            SignRecordCollection signRecordCollection = signRecord.getSignRecordCollection(evi);
            for (SignRecordInfo signRecordInfo : signRcdColl) {
                if (signRecordCollection.contains(signRecordInfo)) continue;
                col.add((CoreBaseInfo)signRecordInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    public CoreBaseCollection compareSignRcdColl(ISignRecord signRecord, CoreBaseCollection signRcdColl, Timestamp beginDate, Timestamp endDate, AuditOpinionEnum auditOpinionEnum) {
        beginDate = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(beginDate)).getTime());
        endDate = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(endDate)).getTime() + 86400000L - 1L);
        CoreBaseCollection col = new CoreBaseCollection();
        if (signRcdColl == null || signRcdColl.isEmpty()) {
            return col;
        }
        HashSet<String> pidSet = new HashSet<String>();
        Iterator iterator = signRcdColl.iterator();
        boolean havePersonNull = false;
        while (iterator.hasNext()) {
            SignRecordInfo signRecordInfo = (SignRecordInfo)iterator.next();
            if (signRecordInfo.getPerson() != null && signRecordInfo.getPerson().getId() != null) {
                pidSet.add(signRecordInfo.getPerson().getId().toString());
                continue;
            }
            havePersonNull = true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("signTime"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("auditOpinion"));
        evi.getSelector().add(new SelectorItemInfo("cardState"));
        FilterInfo fi = new FilterInfo();
        if (pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
        } else if (!pidSet.isEmpty() && !havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
        } else if (!pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
            FilterInfo fi2 = new FilterInfo();
            fi2.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
            try {
                fi.mergeFilter(fi2, "OR");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            return col;
        }
        FilterInfo fi3 = new FilterInfo();
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)endDate, CompareType.LESS_EQUALS));
        try {
            fi.mergeFilter(fi3, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        evi.setFilter(fi);
        try {
            SignRecordCollection signRecordCollection = signRecord.getSignRecordCollection(evi);
            for (SignRecordInfo signRecordInfo : signRcdColl) {
                if (signRecordCollection.contains(signRecordInfo)) continue;
                signRecordInfo.setAuditOpinion(auditOpinionEnum);
                col.add((CoreBaseInfo)signRecordInfo);
            }
            iterator = signRecordCollection.iterator();
            while (iterator.hasNext()) {
                SignRecordInfo signRecordInfo;
                signRecordInfo = (SignRecordInfo)iterator.next();
                if (!signRcdColl.contains((CoreBaseInfo)signRecordInfo) || signRecordInfo.getAuditOpinion().equals((Object)auditOpinionEnum)) continue;
                signRecordInfo.setAuditOpinion(auditOpinionEnum);
                col.add((CoreBaseInfo)signRecordInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    public StringBuilder resolverRecords(JSONObject json, StringBuilder records) {
        records.append("userName:" + json.get("userName") + ",");
        records.append("openId:" + json.get("openId") + ",");
        if (json.get("time") != null && StringUtils.isNotEmpty((String)json.get("time").toString())) {
            records.append("time:" + AtsDateUtils.timestampToString(new Timestamp(Long.valueOf(json.get("time").toString()))) + ",");
        } else {
            records.append("time: ,");
        }
        records.append("position:" + json.get("position") + ",");
        records.append("approveResult:" + json.get("approveResult") + "\n");
        return records;
    }
}

