/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.takeWorkLimit.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsTakeWorkingInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodCollection;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.GetValueMtdAmtEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.IHolidayLimit;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailCollection;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailFactory;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.TakeWoring;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationLimit;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsBaseUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TakeWorkLimitUtils {
    public static String takeWorkTypeID = "+ZM5jTmrS0KHCjDSYGcFLf0tUpg=";

    public static void insertTakeWorkLimitDetail() {
    }

    public static Map<String, PersonInfo> getPersonInfoMap(Context ctx, Map param) {
        return null;
    }

    public static int getAllCount(Context ctx, StringBuffer sql) {
        int row = 0;
        try {
            String querySql = "Select count(*) as count from ( " + sql.toString() + " ) tt ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
            while (rowSet.next()) {
                row = rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return row;
    }

    public static IRowSet paging(String sql, int rows, int page, int totalCount, Context ctx) throws BOSException {
        int dbType = AtsBaseUtils.getDbType(ctx);
        String afterPagingSql = "";
        try {
            PagingHelper pageHelper = new PagingHelper();
            int length = rows;
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            afterPagingSql = pageHelper.getPagingSqlNoOptmize(dbType, sql, (page - 1) * rows, length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("tran takeWork page sql\uff1a" + afterPagingSql);
        return DbUtil.executeQuery((Context)ctx, (String)afterPagingSql);
    }

    public static void combineMapInfo(IRowSet rs, StringBuffer personStr) {
        try {
            while (rs.next()) {
                String personId = rs.getString("personId");
                if (personStr.length() > 0) {
                    personStr.append("," + personId + "");
                    continue;
                }
                personStr.append("" + personId + "");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> ruleBasedInfo(Context ctx, String cycleDate, AtsTakeWorkingInfo twRule, Map<String, PersonPositionInfo> personPositionMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (personPositionMap != null && personPositionMap.size() > 0) {
            Set<String> personIDs = personPositionMap.keySet();
            for (String personID : personIDs) {
                PersonPositionInfo personPosition = personPositionMap.get(personID);
                map.put(personID, TakeWorkLimitUtils.ruleBasedInfo(ctx, cycleDate, twRule, personPosition));
            }
        }
        return map;
    }

    public static Map<String, Object> ruleBasedInfo(Context ctx, String cycleDate, AtsTakeWorkingInfo twRule, PersonPositionInfo personPosition) {
        Map<Object, Object> map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        try {
            date = sdf.parse(cycleDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        TakeWoring periodType = twRule.getTaskWorkingType();
        map = "2".equals(periodType.getValue()) ? TakeWorkLimitUtils.attenceCycleDate(ctx, twRule, date) : ("1".equals(periodType.getValue()) ? TakeWorkLimitUtils.getSeasonAttenceCycleDate(twRule, date, personPosition) : TakeWorkLimitUtils.getNotAttenceCycleDate(twRule, date));
        return map;
    }

    private static Map<String, Object> attenceCycleDate(Context ctx, AtsTakeWorkingInfo twRule, Date cycleDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        AttendancePeriodCollection periodColls = null;
        try {
            String oql = "select startDate,endDate where group.id = '" + twRule.getAttenceCycle().getId().toString() + "'";
            periodColls = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (periodColls != null && periodColls.size() > 0) {
            for (int i = 0; i < periodColls.size(); ++i) {
                AttendancePeriodInfo periodInfo = periodColls.get(i);
                Date startDate = periodInfo.getStartDate();
                Date endDate = periodInfo.getEndDate();
                if (startDate.getTime() > cycleDate.getTime() || endDate.getTime() < cycleDate.getTime()) continue;
                resultMap.put("cycleDate", startDate);
                resultMap.put("cycleBeginDate", startDate);
                resultMap.put("year", AtsDateUtils.getCurrentYear(startDate));
                resultMap.put("cycleEndDate", endDate);
                resultMap.put("delayDate", TakeWorkLimitUtils.getDelayDate(twRule, endDate));
                break;
            }
        }
        return resultMap;
    }

    public static Date getDelayDate(AtsTakeWorkingInfo twRule, Date endDate) {
        if ("3".equals(twRule.getTaskWorkingType().getValue())) {
            return TakeWorkLimitUtils.getDelayDateOfDateType(twRule, endDate);
        }
        int delayLength = twRule.getDelayLength().intValue();
        Date delayDate = null;
        if (delayLength == 0) {
            delayDate = endDate;
        } else {
            int type;
            boolean flag = false;
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDate);
            if (cal.getActualMaximum(5) == endDate.getDate()) {
                flag = true;
            }
            if ((type = twRule.getDelayLengthUnit().getValue() + 1) == 2) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                calendar.add(2, delayLength);
                if (flag) {
                    calendar.set(5, calendar.getActualMaximum(5));
                }
                delayDate = calendar.getTime();
            } else {
                delayDate = AtsDateUtils.dateAdd(endDate, type, delayLength);
            }
        }
        return delayDate;
    }

    public static Date getDelayDateOfDateType(AtsTakeWorkingInfo twRule, Date endDate) {
        int delayLength = twRule.getDelayLength().intValue();
        int type = twRule.getDelayLengthUnit().getValue() + 1;
        Calendar calendar = Calendar.getInstance();
        if (endDate == null) {
            endDate = new Date();
        }
        calendar.setTime(endDate);
        if (1 == type) {
            calendar.add(1, delayLength);
        } else if (2 == type) {
            calendar.add(2, delayLength);
        } else if (3 == type) {
            calendar.add(5, delayLength);
        }
        return calendar.getTime();
    }

    private static Map getSeasonAttenceCycleDate(AtsTakeWorkingInfo twRule, Date otDate, PersonPositionInfo personPosition) {
        HashMap<String, Comparable<Date>> resultMap = new HashMap<String, Comparable<Date>>();
        Date enterDate = personPosition.getEnterDate();
        int year = AtsDateUtils.getCurrentYear(otDate);
        Map<String, Object> dateMap = AtsDateUtils.generateSDateAndEDateBySeason(AtsDateUtils.getSeason(otDate), Integer.toString(year));
        Date cycleBeginDate = (Date)dateMap.get("startDate");
        Date cycleEndDate = (Date)dateMap.get("endDate");
        Date EffectDate = cycleBeginDate;
        if (enterDate != null && enterDate.getTime() >= cycleBeginDate.getTime() && enterDate.getTime() <= cycleEndDate.getTime()) {
            EffectDate = enterDate;
        }
        resultMap.put("cycleDate", cycleBeginDate);
        resultMap.put("cycleBeginDate", cycleBeginDate);
        resultMap.put("cycleEndDate", cycleEndDate);
        resultMap.put("year", Integer.valueOf(year));
        resultMap.put("effectDate", EffectDate);
        resultMap.put("delayDate", TakeWorkLimitUtils.getDelayDate(twRule, cycleEndDate));
        return resultMap;
    }

    private static Map<String, Object> getNotAttenceCycleDate(AtsTakeWorkingInfo twRule, Date cycleDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Date cycleBeginDate = AtsDateUtils.getCurrentFirstDay(cycleDate);
        if ("3".equals(twRule.getTaskWorkingType().getValue())) {
            cycleBeginDate = cycleDate;
        }
        if ("4".equals(twRule.getTaskWorkingType().getValue())) {
            cycleBeginDate = AtsDateUtils.getYearFirstDay(cycleDate);
        }
        int year = AtsDateUtils.getCurrentYear(cycleBeginDate);
        resultMap.put("cycleDate", cycleBeginDate);
        resultMap.put("year", year);
        resultMap.put("cycleBeginDate", cycleBeginDate);
        Date cycleEndDate = TakeWorkLimitUtils.getCycleEndDate(cycleBeginDate, twRule.getTaskWorkingType().getValue());
        resultMap.put("cycleEndDate", cycleEndDate);
        resultMap.put("delayDate", TakeWorkLimitUtils.getDelayDate(twRule, cycleEndDate));
        return resultMap;
    }

    private static Date getCycleEndDate(Date beginDate, String type) {
        int dateType = 2;
        int add = 0;
        if ("0".equals(type)) {
            dateType = 2;
            add = 1;
        } else if ("1".equals(type)) {
            dateType = 2;
            add = 3;
        } else if ("4".equals(type)) {
            dateType = 2;
            add = 12;
        } else if ("3".equals(type)) {
            return beginDate;
        }
        return AtsDateUtils.dateAdd(beginDate, dateType, add, true);
    }

    public static BigDecimal getConvRate(String otType, AtsTakeWorkingInfo twRule) {
        if ("rBy0u1YgQ9C1OxcM85mxyY6C/nU=".equals(otType)) {
            return new BigDecimal(twRule.getWorkDayRate());
        }
        if ("zr+ur5D4RA+2bdVZ2VPqp46C/nU=".equals(otType)) {
            return new BigDecimal(twRule.getRestDayRate());
        }
        if ("sRWUOt7sRpOY0TCo6NMqGY6C/nU=".equals(otType)) {
            return new BigDecimal(twRule.getLegalHolidayRate());
        }
        return new BigDecimal(0);
    }

    public static BigDecimal getConvValue(String otType, AtsTakeWorkingInfo twRule, BigDecimal sourceValue) {
        BigDecimal convRate = TakeWorkLimitUtils.getConvRate(otType, twRule);
        BigDecimal convValue = convRate.multiply(sourceValue);
        return convValue;
    }

    public static BigDecimal transHourToDay(BigDecimal beforeTransLimit, BigDecimal standardHour) {
        return beforeTransLimit.divide(standardHour, DecimalPlaceUtil.getDefaultDecimalPlacesCal(), RoundingMode.HALF_UP);
    }

    public static AtsHolidayFileHisCollection getAtsHolidayFileHisColl(Context ctx, String proposers, String adminOrgUnit) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(TakeWorkLimitUtils.getAtsHolidayFileHisSelector());
        FilterInfo fi = new FilterInfo();
        if (!StringUtils.isEmpty((String)proposers)) {
            fi.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)proposers, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            evi.setFilter(fi);
        } else if (!"".equals(adminOrgUnit)) {
            AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnit));
            fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            evi.setFilter(fi);
        } else {
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            evi.setFilter(fi);
        }
        SorterItemInfo dateSort = new SorterItemInfo("leffdt");
        dateSort.setSortType(SortType.DESCEND);
        evi.getSorter().add(dateSort);
        AtsHolidayFileHisCollection atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection(evi);
        return atsHolidayFileHisCollection;
    }

    private static SelectorItemCollection getAtsHolidayFileHisSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("attendFileState"));
        selectors.add(new SelectorItemInfo("hrOrgUnit.id"));
        selectors.add(new SelectorItemInfo("adminOrgUnit.id"));
        selectors.add(new SelectorItemInfo("EFFDT"));
        selectors.add(new SelectorItemInfo("LEFFDT"));
        selectors.add(new SelectorItemInfo("proposer.id"));
        selectors.add(new SelectorItemInfo("proposer.number"));
        selectors.add(new SelectorItemInfo("proposer.name"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.id"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.number"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.name"));
        return selectors;
    }

    public static AttendanceFileCollection getAttendanceFileColByPersonOrAdminOrg(Context ctx, String proposers, String adminOrgUnit) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(TakeWorkLimitUtils.getAttendanceFileSelector());
        FilterInfo fi = new FilterInfo();
        if (!StringUtils.isEmpty((String)proposers)) {
            fi.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)proposers, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            evi.setFilter(fi);
        } else if (!StringUtils.isEmpty((String)adminOrgUnit)) {
            AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnit));
            fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            evi.setFilter(fi);
        } else {
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            evi.setFilter(fi);
        }
        AttendanceFileCollection attendanceFileCollection = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(evi);
        return attendanceFileCollection;
    }

    private static SelectorItemCollection getAttendanceFileSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("attendanceNum"));
        selectors.add(new SelectorItemInfo("attendFileState"));
        selectors.add(new SelectorItemInfo("proposer.id"));
        selectors.add(new SelectorItemInfo("proposer.number"));
        selectors.add(new SelectorItemInfo("proposer.name"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.id"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.number"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.name"));
        selectors.add(new SelectorItemInfo("atsShift.standardHour"));
        return selectors;
    }

    public static String getInConditionSql(HashSet<String> set) {
        String personIDs = "";
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            personIDs = personIDs + ",'" + it.next() + "'";
        }
        personIDs = personIDs.substring(1, personIDs.length());
        return personIDs;
    }

    public static HolidayLimitCollection getExistedLimitColl(Context ctx, Set<String> personIdSet, String cycleDate) throws BOSException {
        EntityViewInfo evi = null;
        FilterInfo fi = null;
        evi = new EntityViewInfo();
        fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("proposer.id", personIdSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("cycleBeginDate", (Object)HRTimeWebUtils.stringToShortDate(cycleDate), CompareType.LESS_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("cycleEndDate", (Object)HRTimeWebUtils.stringToShortDate(cycleDate), CompareType.GREATER_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("holidayPolicy.holidayType.id", (Object)takeWorkTypeID, CompareType.EQUALS));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("proposer.id"));
        evi.getSelector().add(new SelectorItemInfo("proposer.number"));
        evi.getSelector().add(new SelectorItemInfo("proposer.name"));
        evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.number"));
        evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
        evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.longNumber"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("cycleBeginDate"));
        evi.getSelector().add(new SelectorItemInfo("cycleEndDate"));
        evi.getSelector().add(new SelectorItemInfo("cycleDate"));
        evi.getSelector().add(new SelectorItemInfo("delayDate"));
        evi.getSelector().add(new SelectorItemInfo("effectDate"));
        evi.getSelector().add(new SelectorItemInfo("invalidDate"));
        evi.getSelector().add(new SelectorItemInfo("standardLimit"));
        evi.getSelector().add(new SelectorItemInfo("realLimit"));
        evi.getSelector().add(new SelectorItemInfo("addOrSubLimit"));
        evi.getSelector().add(new SelectorItemInfo("usedLimit"));
        evi.getSelector().add(new SelectorItemInfo("freezeLimit"));
        evi.getSelector().add(new SelectorItemInfo("remainLimit"));
        evi.getSelector().add(new SelectorItemInfo("preOverdraftLimit"));
        evi.getSelector().add(new SelectorItemInfo("status"));
        evi.getSelector().add(new SelectorItemInfo("holidayUnit"));
        evi.getSelector().add(new SelectorItemInfo("cycleType"));
        evi.getSelector().add(new SelectorItemInfo("year"));
        IHolidayLimit holidayLimit = HolidayLimitFactory.getLocalInstance(ctx);
        HolidayLimitCollection existsHolidayLimitCollection = holidayLimit.getHolidayLimitCollection(evi);
        return existsHolidayLimitCollection;
    }

    public static HolidayLimitCollection getPrePeriodLimitColl(Context ctx, Set<String> personIdSet, String cycleDate, AtsTakeWorkingInfo twRule) throws BOSException {
        String preCycleLastDate = TakeWorkLimitUtils.getPreCycleLastDate(ctx, cycleDate, twRule);
        return TakeWorkLimitUtils.getExistedLimitColl(ctx, personIdSet, preCycleLastDate);
    }

    public static String getPreCycleLastDate(Context ctx, String cycleDate, AtsTakeWorkingInfo twRule) {
        Map<String, Object> map = TakeWorkLimitUtils.ruleBasedInfo(ctx, cycleDate, twRule, new PersonPositionInfo());
        Date cycleBeginDate = (Date)map.get("cycleBeginDate");
        Date preCycleLastDate = AtsDateUtils.getPreDay(cycleBeginDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String preCycleLastDateStr = sdf.format(preCycleLastDate);
        return preCycleLastDateStr;
    }

    public static Map<String, Set<OTtoTakeWorkDetailInfo>> getExistedDetailColl(Context ctx, Set<String> personIdSet, Map<String, Object> ruleBasedDataMap) {
        HashMap<String, Set<OTtoTakeWorkDetailInfo>> detailMap = new HashMap<String, Set<OTtoTakeWorkDetailInfo>>();
        for (String personID : personIdSet) {
            Map ruleBasedData = (Map)ruleBasedDataMap.get(personID);
            Date cycleBeginDate = (Date)ruleBasedData.get("cycleBeginDate");
            Date cycleEndDate = (Date)ruleBasedData.get("cycleEndDate");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)personID, CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("periodStart", (Object)cycleEndDate, CompareType.LESS_EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("periodEnd", (Object)cycleBeginDate, CompareType.GREATER_EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
            evi.setFilter(fi);
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.number"));
            evi.getSelector().add(new SelectorItemInfo("proposer.name"));
            evi.getSelector().add(new SelectorItemInfo("periodStart"));
            evi.getSelector().add(new SelectorItemInfo("periodEnd"));
            evi.getSelector().add(new SelectorItemInfo("periodDelay"));
            evi.getSelector().add(new SelectorItemInfo("limit"));
            evi.getSelector().add(new SelectorItemInfo("limitValue"));
            evi.getSelector().add(new SelectorItemInfo("limitUnit"));
            evi.getSelector().add(new SelectorItemInfo("convertDate"));
            evi.getSelector().add(new SelectorItemInfo("OTType"));
            evi.getSelector().add(new SelectorItemInfo("convertRate"));
            evi.getSelector().add(new SelectorItemInfo("source"));
            evi.getSelector().add(new SelectorItemInfo("sourceValue"));
            evi.getSelector().add(new SelectorItemInfo("sourceUnit"));
            evi.getSelector().add(new SelectorItemInfo("sourceBillId"));
            evi.getSelector().add(new SelectorItemInfo("state"));
            evi.getSelector().add(new SelectorItemInfo("unitConvertRule"));
            evi.getSelector().add(new SelectorItemInfo("fixedHour"));
            evi.getSelector().add(new SelectorItemInfo("enableMinAmt"));
            evi.getSelector().add(new SelectorItemInfo("MinAmt"));
            evi.getSelector().add(new SelectorItemInfo("MinAmtValueMtd"));
            OTtoTakeWorkDetailCollection detailColl = null;
            try {
                detailColl = OTtoTakeWorkDetailFactory.getLocalInstance(ctx).getOTtoTakeWorkDetailCollection(evi);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (detailColl == null || detailColl.size() <= 0) continue;
            for (int i = 0; i < detailColl.size(); ++i) {
                OTtoTakeWorkDetailInfo detail = detailColl.get(i);
                if (detailMap.get(detail.getProposer().getId().toString()) == null) {
                    detailMap.put(detail.getProposer().getId().toString(), new HashSet());
                }
                ((Set)detailMap.get(detail.getProposer().getId().toString())).add(detail);
            }
        }
        return detailMap;
    }

    public static void getCalPerson(Context ctx, StringBuffer allCalPersonSql, Map param) {
        block10: {
            String cycleDate = (String)param.get("cycleDate");
            allCalPersonSql.append(" SELECT distinct person.fid as personId ");
            allCalPersonSql.append(" from t_bd_person person ");
            allCalPersonSql.append(" inner join t_hr_ats_atsHolidayFileHis atsFile on atsFile.fProposerID = person.fId ");
            allCalPersonSql.append(" inner join t_hr_personposition position on person.fid = position.FPersonID ");
            allCalPersonSql.append(" inner join t_org_admin org on  ORG.fid = position.FPersonDep");
            allCalPersonSql.append(" left join t_hr_BDemployeeType employeeType on person.femployeeTypeId = employeeType.fid ");
            allCalPersonSql.append(" where atsFile.FEFFDT <= {ts '" + cycleDate + "'} and atsFile.FLEFFDT >= {ts '" + cycleDate + "'} ");
            String personNums = (String)param.get("personNum");
            String personSql = "";
            if (!StringUtils.isEmpty((String)personNums)) {
                personSql = " and ( person.fnumber in ('" + personNums.replaceAll(",", "','") + "') or person.fid in ('" + personNums.replaceAll(",", "','") + "') )";
            } else if (param.get("isrecalculate") != null) {
                personSql = " and employeeType.fisIncount = 0";
            }
            allCalPersonSql.append(personSql);
            String adminOrgUnitNum = (String)param.get("adminOrgUnitNum");
            if (!StringUtils.isEmpty((String)adminOrgUnitNum)) {
                try {
                    AdminOrgUnitCollection admingOrgUnitColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select id,longnumber where number ='" + adminOrgUnitNum + "'");
                    if (admingOrgUnitColl.size() > 0) {
                        String orgLongNum = "";
                        for (int i = 0; admingOrgUnitColl.size() > i; ++i) {
                            String longNumber = admingOrgUnitColl.get(i).getLongNumber();
                            orgLongNum = orgLongNum.equals("") ? longNumber : orgLongNum + "@" + longNumber;
                        }
                        PersonInfo person = null;
                        try {
                            person = SHRBillServerUtil.getCurrPersonInfo(ctx);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        HashMap<String, String> filterItems = new HashMap<String, String>();
                        filterItems.put("proposerId", person != null ? person.getId().toString() : "");
                        filterItems.put("orgLongNum", orgLongNum);
                        String adminSql = TakeWorkLimitUtils.getOrgSubSql(filterItems);
                        allCalPersonSql.append(adminSql);
                        break block10;
                    }
                    allCalPersonSql.append(" and 1=2");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void getCalPersonByPolicySet(StringBuffer allPersonByPolicySetSql, String policySetId) {
        allPersonByPolicySetSql.append(" and atsFile.fHolidayPolicySetId = '" + policySetId + "'");
    }

    public static BigDecimal getMinAmtRealLimit(Context ctx, BigDecimal realLimit, HolidayPolicyInfo policyInfo) {
        GetValueMtdAmtEnum getMinAmtValueMtd;
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if (policyInfo.isEnableMinAmt() && null != (getMinAmtValueMtd = policyInfo.getMinAmtValueMtd())) {
            int getMinAmtValueMtdInt = getMinAmtValueMtd.getValue();
            switch (getMinAmtValueMtdInt) {
                case 1: {
                    roundingMode = RoundingMode.FLOOR;
                    break;
                }
                case 2: {
                    roundingMode = RoundingMode.CEILING;
                    break;
                }
                case 3: {
                    roundingMode = RoundingMode.HALF_UP;
                }
            }
        }
        DecimalPlaceOperationLimit operationLimit = new DecimalPlaceOperationLimit();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("standardLimit", realLimit);
        map.put("holidayPolicyInfo", policyInfo);
        map.put("roundingMode", (Object)roundingMode);
        return operationLimit.precisionConvert(ctx, map);
    }

    public static void setRuleBasedData(HolidayLimitInfo limitInfo, Map ruleBasedData) {
        if (limitInfo != null && ruleBasedData != null) {
            Date cycleDate = (Date)ruleBasedData.get("cycleDate");
            Date cycleBeginDate = (Date)ruleBasedData.get("cycleBeginDate");
            int year = (Integer)ruleBasedData.get("year");
            Date cycleEndDate = (Date)ruleBasedData.get("cycleEndDate");
            Date delayDate = (Date)ruleBasedData.get("delayDate");
            limitInfo.setCycleDate(cycleDate);
            limitInfo.setCycleBeginDate(cycleBeginDate);
            limitInfo.setCycleEndDate(cycleEndDate);
            limitInfo.setEffectDate(cycleBeginDate);
            limitInfo.setYear(year);
            limitInfo.setDelayDate(delayDate);
        }
    }

    public static void preStdHour(Context ctx, String cycleDate, AtsTakeWorkingInfo twRule, Map<String, PersonPositionInfo> personPositionMap, Map<String, Set<String>> personDateMap, Set<String> personDateSet, Set<String> dateSet, Map<String, AttendanceFileInfo> attendanceFileMap, Map<String, BigDecimal> stdHourMap) {
        if (dateSet == null || dateSet.size() == 0) {
            return;
        }
        String maxDate = (String)Collections.max(dateSet);
        String minDate = (String)Collections.min(dateSet);
        ScheduleShiftCollection scheduleShifts = AtsScheduleShiftUtil.getScheduleShiftCollByPriority(ctx, AtsUtil.convertSetToString(personDateMap.keySet()), minDate, maxDate);
        if (scheduleShifts != null && scheduleShifts.size() > 0) {
            for (int i = 0; i < scheduleShifts.size(); ++i) {
                ScheduleShiftInfo shift = scheduleShifts.get(i);
                if (shift.getProposer().getId() == null || shift.getAttendDate() == null) continue;
                stdHourMap.put(shift.getProposer().getId().toString() + "_" + AtsDateUtils.dateShortToString(shift.getAttendDate()), shift.getStandardHour());
            }
        }
        if (personDateSet != null && personDateSet.size() > 0) {
            for (String personDate : personDateSet) {
                String person;
                AttendanceFileInfo file;
                AtsShiftInfo defaultShift;
                if (stdHourMap.get(personDate) != null || (defaultShift = (file = attendanceFileMap.get(person = personDate.split("_")[0])).getAtsShift()) == null) continue;
                stdHourMap.put(personDate, defaultShift.getStandardHour());
            }
        }
    }

    public static PersonPositionCollection getPersonPositionCollection(Context ctx, Set<String> validatPersonIdSet) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("person.number"));
        evi.getSelector().add(new SelectorItemInfo("person.name"));
        evi.getSelector().add(new SelectorItemInfo("personDep.id"));
        evi.getSelector().add(new SelectorItemInfo("personDep.number"));
        evi.getSelector().add(new SelectorItemInfo("personDep.name"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.id"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.number"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.number"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
        evi.getSelector().add(new SelectorItemInfo("joinGroupDate"));
        evi.getSelector().add(new SelectorItemInfo("joinDate"));
        evi.getSelector().add(new SelectorItemInfo("leftDate"));
        evi.getSelector().add(new SelectorItemInfo("entryDate"));
        evi.getSelector().add(new SelectorItemInfo("tryoutMonth"));
        evi.getSelector().add(new SelectorItemInfo("formalDate"));
        evi.getSelector().add(new SelectorItemInfo("enterDate"));
        evi.getSelector().add(new SelectorItemInfo("jobStartDate"));
        evi.getSelector().add(new SelectorItemInfo("workTime"));
        evi.getSelector().add(new SelectorItemInfo("newWorkTime"));
        evi.getSelector().add(new SelectorItemInfo("person.employeeType.isInCount"));
        fi.getFilterItems().add(new FilterItemInfo("person.id", validatPersonIdSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        PersonPositionCollection personPositionCollection = null;
        try {
            IPersonPosition personPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
            personPositionCollection = personPosition.getPersonPositionCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return personPositionCollection;
    }

    public static String getOrgSubSql(Map<String, String> filterItems) {
        StringBuffer orgSql = new StringBuffer();
        if (!StringUtils.isEmpty((String)filterItems.get("orgLongNum"))) {
            String longNum = filterItems.get("orgLongNum");
            orgSql.append("  AND ");
            StringBuffer sqlinner = new StringBuffer();
            sqlinner.append(" ( ");
            String[] longnumArr = longNum.split("@");
            for (int i = 0; i < longnumArr.length; ++i) {
                sqlinner.append("  ORG.FLONGNUMBER = '" + longnumArr[i] + "' or ");
                sqlinner.append("  ORG.FLONGNUMBER LIKE '" + longnumArr[i] + "!%' or ");
            }
            if (sqlinner.length() > 0 && sqlinner.toString().trim().endsWith("or")) {
                sqlinner.delete(sqlinner.lastIndexOf("or"), sqlinner.length());
            }
            sqlinner.append(" ) ");
            orgSql.append(sqlinner.toString());
            String personId = filterItems.get("proposerId");
            if (!StringUtils.isEmpty((String)personId)) {
                orgSql.append("  AND ORG.FISSTARTSHR = 1 \n");
                orgSql.append("  AND ORG.FID IN  \n");
                orgSql.append("  ( SELECT  rangeats.FOrgID   \n");
                orgSql.append("    FROM T_PM_OrgRange rangeats  \n");
                orgSql.append("    INNER JOIN T_PM_USER PMUSER  \n");
                orgSql.append("    ON PMUSER.FID = rangeats.FUSERID \n");
                orgSql.append("    WHERE rangeats.FType = 20  \n");
                orgSql.append("    AND PMUSER.FPERSONID = '" + personId + "' \n");
                orgSql.append("  ) \n");
            }
        }
        return orgSql.toString();
    }

    public static String combinePersonIds(IRowSet rs) {
        StringBuffer personStr = new StringBuffer();
        try {
            while (rs.next()) {
                String personId = rs.getString("personId");
                if (personStr.length() > 0) {
                    personStr.append("," + personId + "");
                    continue;
                }
                personStr.append("" + personId + "");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return personStr.toString();
    }
}

