/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsCommonUtile {
    private static Logger logger = Logger.getLogger(AtsCommonUtile.class);

    public static EntityViewInfo getViewBySelector(List<String> selectors) {
        return AtsCommonUtile.getViewBySelector(selectors, null);
    }

    public static EntityViewInfo getViewBySelector(String[] selectors) {
        return AtsCommonUtile.getViewBySelector(selectors, null);
    }

    public static EntityViewInfo getViewBySelector(List<String> selectors, EntityViewInfo entityViewInfo) {
        return AtsCommonUtile.getViewBySelector(selectors.toArray(new String[selectors.size()]), entityViewInfo);
    }

    public static EntityViewInfo getViewBySelector(String[] selectors, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        SelectorItemCollection sic = returnViewInfo.getSelector();
        for (String selector : selectors) {
            sic.add(new SelectorItemInfo(selector));
        }
        return returnViewInfo;
    }

    public static EntityViewInfo getViewByFilterString(String compareExpr, Object compareValue, CompareType compareType) {
        return AtsCommonUtile.getViewByFilterString(compareExpr, compareValue, compareType, null);
    }

    public static EntityViewInfo getViewByFilterString(String compareExpr, Object compareValue, CompareType compareType, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        FilterInfo filterInfo = returnViewInfo.getFilter();
        filterInfo = filterInfo == null ? new FilterInfo() : filterInfo;
        filterInfo.getFilterItems().add(new FilterItemInfo(compareExpr, compareValue, compareType));
        returnViewInfo.setFilter(filterInfo);
        return returnViewInfo;
    }

    public static EntityViewInfo getViewByExistFilterInfo(FilterInfo filterInfo, EntityViewInfo entityViewInfo) {
        EntityViewInfo returnViewInfo = entityViewInfo == null ? new EntityViewInfo() : entityViewInfo;
        returnViewInfo.setFilter(filterInfo);
        return returnViewInfo;
    }

    public static Set<String> getStringPropertyCollection(JSONArray items, String property) {
        return AtsCommonUtile.getStringPropertyCollection(items, property, false);
    }

    public static Set<String> getStringPropertyCollection(JSONArray items, String property, boolean strictModel) {
        HashSet<String> propertySet = new HashSet<String>();
        for (Object item : items) {
            JSONObject itemTemp = (JSONObject)item;
            if (!itemTemp.containsKey((Object)property) || strictModel && (!strictModel || !StringUtils.isNotBlank((String)itemTemp.getString(property)))) continue;
            propertySet.add(itemTemp.getString(property));
        }
        return propertySet;
    }

    public static String join(Collection<? extends Object> collection) {
        return AtsCommonUtile.join(collection, null);
    }

    public static String join(Collection<? extends Object> collection, String separator) {
        separator = separator == null ? "," : separator;
        StringBuffer strBuffer = new StringBuffer();
        for (Object object : collection) {
            strBuffer.append(object);
            strBuffer.append(separator);
        }
        return strBuffer.substring(0, strBuffer.length() - 1);
    }

    public static String conectProperty(JSONArray items, String property) {
        Set<String> set = AtsCommonUtile.getStringPropertyCollection(items, property);
        return AtsCommonUtile.join(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deepClone(T obj) {
        if (obj == null) {
            return null;
        }
        ObjectOutputStream oo = null;
        ObjectInputStream oi = null;
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
            oi = new ObjectInputStream(bi);
            Object object = oi.readObject();
            return (T)object;
        }
        catch (Exception e) {
            logger.error((Object)"catch a exception", (Throwable)e);
            T t = null;
            return t;
        }
        finally {
            if (oo != null) {
                try {
                    oo.close();
                }
                catch (IOException e) {
                    logger.error((Object)"catch a exception", (Throwable)e);
                }
            }
            if (oi != null) {
                try {
                    oi.close();
                }
                catch (IOException e) {
                    logger.error((Object)"catch a exception", (Throwable)e);
                }
            }
        }
    }
}

