/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportFactory;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptEntryInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsCollection;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSptsInfo;
import com.kingdee.eas.hr.ats.AtsAttendancePlaceCollection;
import com.kingdee.eas.hr.ats.AtsAttendancePlaceFactory;
import com.kingdee.eas.hr.ats.AtsAttendancePlaceInfo;
import com.kingdee.eas.hr.ats.AtsPlaceSourceEnum;
import com.kingdee.eas.hr.ats.AtsPlaceStatusEnum;
import com.kingdee.eas.hr.ats.IAtsAttendancePlace;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AtsStoreToPlaceUtil {
    public static final String INSERT_ATSPLACE_SCHEDULE = " INSERT INTO T_ATS_AtsAttendancePlace (FAdminOrgUnitId, FHrorgUnitId,FAttendanceDate,FPersonId,FPositionId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID,FStatus, FSource, FAttAdOrg, FStartTime, FEndTime, FWorkTime, FRestStartTime, FRestEndTime, FRestTime, FSourceId,FID,FIsDefaultManage ) select attFile.FAdminOrgUnitID,t0.FHrOrgUnitID,t0.FAttendDate,t0.FProposerID,attFile.FPositionID, ?,now(),?,now(),'00000000-0000-0000-0000-000000000000CCE7AED4',0,1, entry.FAttAdminOrgUnitID, entry.FPreDateTime,entry.FNextDateTime, 24*60*(datediff(day, entry.FPreDateTime, entry.FNextDateTime) - 0) + (Hour(FNextDateTime)-Hour(FPreDateTime))*60 + minute(FNextDateTime)-minute(FPreDateTime) - isnull(entry.FSegmentInRest,0) workTime, entry.FRestPreDateTime,entry.FRestNextDateTime,entry.FSegmentInRest,t0.fid,newbosid('D21B1738'),attFile.FIsDefaultManage from T_HR_ATS_ScheduleShift t0 join T_HR_ATS_ScheduleShiftItem entry on entry.FGroupID=t0.FID join T_HR_ATS_AttendanceFileHIS attFile on attFile.FProposerID=t0.FProposerID and attFile.FEFFDT<=t0.FAttendDate and attFile.FLEFFDT>=t0.FAttendDate and attFile.FAdminOrgUnitID <> entry.FAttAdminOrgUnitID where t0.FID in (?)";

    public static void dealStoreToPlace(Context ctx, AtsAcrossStoreSopportInfo billInfo) throws BOSException, EASBizException {
        AtsStoreToPlaceUtil.dealStoreToPlace(ctx, billInfo.getId().toString());
    }

    public static void dealStoreToPlace(Context ctx, String billId) throws BOSException, EASBizException {
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        AtsAcrossStoreSopportInfo billInfo = AtsAcrossStoreSopportFactory.getLocalInstance(ctx).getAtsAcrossStoreSopportInfo("where id = '" + billId + "'");
        String inString = AtsStoreToPlaceUtil.getInString(ctx, billInfo);
        if (StringUtils.isBlank((CharSequence)inString)) {
            return;
        }
        IAtsAttendancePlace localInstance = AtsAttendancePlaceFactory.getLocalInstance(ctx);
        AtsAttendancePlaceCollection atsAttendancePlaceCollection = localInstance.getAtsAttendancePlaceCollection("where sourceId in " + inString);
        if (atsAttendancePlaceCollection.size() == 0) {
            CoreBaseCollection places = new CoreBaseCollection();
            for (int index = 0; index < billInfo.getEntries().size(); ++index) {
                AtsAcrossStoreSptEntryInfo entryInfo = billInfo.getEntries().get(index);
                places.addCollection(AtsStoreToPlaceUtil.createPlaces(ctx, billInfo, entryInfo));
            }
            localInstance.addnewBatchData(places);
        } else {
            int index;
            CoreBaseCollection allSpls = AtsStoreToPlaceUtil.getAllSpls(billInfo);
            CoreBaseCollection adds = new CoreBaseCollection();
            CoreBaseCollection updates = new CoreBaseCollection();
            IObjectPK[] deletes = new IObjectPK[atsAttendancePlaceCollection.size()];
            for (index = 0; index < atsAttendancePlaceCollection.size(); ++index) {
                AtsAttendancePlaceInfo placeInfo = atsAttendancePlaceCollection.get(index);
                CoreBaseInfo sols = AtsStoreToPlaceUtil.findSols(allSpls, placeInfo);
                if (sols == null) {
                    deletes[index] = new ObjectUuidPK(placeInfo.getId());
                    continue;
                }
                AtsAcrossStoreSptsInfo storeSptsInfo = (AtsAcrossStoreSptsInfo)sols;
                AtsAttendancePlaceInfo place = AtsStoreToPlaceUtil.createPlace(ctx, billInfo, storeSptsInfo.getEntryBill(), storeSptsInfo);
                place.setId(placeInfo.getId());
                place.setCreator(placeInfo.getCreator());
                place.setCreateTime(placeInfo.getCreateTime());
                updates.add((CoreBaseInfo)place);
            }
            for (index = 0; index < allSpls.size(); ++index) {
                CoreBaseInfo coreBaseInfo = allSpls.get(index);
                AtsAcrossStoreSptsInfo storeSptsInfo = (AtsAcrossStoreSptsInfo)coreBaseInfo;
                CoreBaseInfo sols = AtsStoreToPlaceUtil.findSols(updates, storeSptsInfo);
                if (sols != null) continue;
                adds.add((CoreBaseInfo)AtsStoreToPlaceUtil.createPlace(ctx, billInfo, storeSptsInfo.getEntryBill(), storeSptsInfo));
            }
            localInstance.addnewBatchData(adds);
            localInstance.updateBatchData(updates);
            localInstance.deleteBatchData(deletes);
        }
    }

    public static CoreBaseInfo findSols(CoreBaseCollection updates, AtsAcrossStoreSptsInfo storeSptsInfo) {
        for (int num = 0; num < updates.size(); ++num) {
            AtsAttendancePlaceInfo place = (AtsAttendancePlaceInfo)updates.get(num);
            if (!storeSptsInfo.getId().toString().equalsIgnoreCase(place.getSourceId())) continue;
            return place;
        }
        return null;
    }

    public static CoreBaseInfo findSols(CoreBaseCollection allSpls, AtsAttendancePlaceInfo placeInfo) {
        for (int num = 0; num < allSpls.size(); ++num) {
            CoreBaseInfo coreBaseInfo = allSpls.get(num);
            if (!placeInfo.getSourceId().equalsIgnoreCase(coreBaseInfo.getId().toString())) continue;
            return coreBaseInfo;
        }
        return null;
    }

    public static CoreBaseCollection getAllSpls(AtsAcrossStoreSopportInfo billInfo) {
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        AtsAcrossStoreSptEntryCollection entries = billInfo.getEntries();
        AtsAcrossStoreSptsCollection spts = billInfo.getSpts();
        for (int i = 0; i < spts.size(); ++i) {
            for (int j = 0; j < entries.size(); ++j) {
                if (!spts.get(i).getEntryBill().getId().equals((Object)entries.get(j).getId())) continue;
                spts.get(i).setEntryBill(entries.get(j));
                coreBaseCollection.add((CoreBaseInfo)spts.get(i));
            }
        }
        return coreBaseCollection;
    }

    public static CoreBaseCollection createPlaces(Context ctx, AtsAcrossStoreSopportInfo billInfo, AtsAcrossStoreSptEntryInfo entryInfo) {
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        AtsAcrossStoreSptsCollection spts = billInfo.getSpts();
        for (int index = 0; index < spts.size(); ++index) {
            AtsAcrossStoreSptsInfo storeSptsInfo = spts.get(index);
            if (!storeSptsInfo.getEntryBill().getId().equals((Object)entryInfo.getId())) continue;
            coreBaseCollection.add((CoreBaseInfo)AtsStoreToPlaceUtil.createPlace(ctx, billInfo, entryInfo, storeSptsInfo));
        }
        return coreBaseCollection;
    }

    public static AtsAttendancePlaceInfo createPlace(Context ctx, AtsAcrossStoreSopportInfo billInfo, AtsAcrossStoreSptEntryInfo entryInfo, AtsAcrossStoreSptsInfo storeSptsInfo) {
        Date date = new Date();
        AtsAttendancePlaceInfo placeInfo = new AtsAttendancePlaceInfo();
        placeInfo.setAdminOrgUnit(storeSptsInfo.getAdminOrgUnit());
        placeInfo.setAttAdOrg(billInfo.getAdminOrg());
        placeInfo.setAttendanceDate(storeSptsInfo.getAttendanceDate());
        placeInfo.setEndTime(storeSptsInfo.getEndTime());
        placeInfo.setHrOrgUnit(billInfo.getHrOrgUnit());
        placeInfo.setPerson(storeSptsInfo.getPerson());
        placeInfo.setRestEndTime(entryInfo.getRestPreDateTime());
        placeInfo.setRestStartTime(entryInfo.getRestNextDateTime());
        placeInfo.setRestTime(storeSptsInfo.getRestTime());
        placeInfo.setStartTime(storeSptsInfo.getStartTime());
        placeInfo.setStatus(AtsPlaceStatusEnum.normal);
        placeInfo.setWorkTime(storeSptsInfo.getWorkTime());
        placeInfo.setCreateTime(new Timestamp(date.getTime()));
        placeInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        placeInfo.setLastUpdateTime(new Timestamp(date.getTime()));
        placeInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        placeInfo.setSourceId(storeSptsInfo.getId().toString());
        placeInfo.setSource(AtsPlaceSourceEnum.AcrossSpt);
        placeInfo.setPosition(entryInfo.getAttPosition());
        placeInfo.setIsDefaultManage(storeSptsInfo.isIsDefaultManage());
        return placeInfo;
    }

    public static void dealScheduleToPlace(Context ctx, List<String> scheduleIds) throws EASBizException, BOSException {
        if (AtsCollectionUtile.isEmpty(scheduleIds)) {
            return;
        }
        AtsStoreToPlaceUtil.deletePlaceBySource(ctx, scheduleIds);
        String insertSql = AtsSqlUtile.processSqlInParam(INSERT_ATSPLACE_SCHEDULE, scheduleIds);
        ArrayList<String> scheduleIdTemp = new ArrayList<String>(scheduleIds);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getString("id");
        scheduleIdTemp.add(0, userId);
        scheduleIdTemp.add(0, userId);
        DbUtil.execute((Context)ctx, (String)insertSql, (Object[])scheduleIdTemp.toArray());
    }

    public static void deletePlaceBySource(Context ctx, List<String> sourceIds) throws BOSException, EASBizException {
        AtsSqlUtile.deleteByIds(ctx, "T_ATS_AtsAttendancePlace", "fsourceId", sourceIds);
    }

    public static String getInString(Context ctx, AtsAcrossStoreSopportInfo billInfo) {
        AtsAcrossStoreSptEntryCollection entries = billInfo.getEntries();
        if (entries == null || entries.size() == 0) {
            return null;
        }
        boolean haveId = false;
        StringBuilder ids = new StringBuilder();
        ids.append("(");
        for (int index = 0; index < entries.size(); ++index) {
            AtsAcrossStoreSptEntryInfo entryInfo = entries.get(index);
            AtsAcrossStoreSptsCollection spts = billInfo.getSpts();
            if (spts == null || spts.size() == 0) continue;
            haveId = true;
            for (int num = 0; num < spts.size(); ++num) {
                AtsAcrossStoreSptsInfo storeSptsInfo = spts.get(num);
                ids.append("'" + storeSptsInfo.getId().toString() + "',");
            }
        }
        if (!haveId) {
            return null;
        }
        String substring = ids.substring(0, ids.length() - 1);
        substring = substring + ")";
        return substring;
    }

    public static void dealDelete(Context ctx, AtsAcrossStoreSopportInfo billInfo) throws BOSException, EASBizException {
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        String inString = AtsStoreToPlaceUtil.getInString(ctx, billInfo);
        IAtsAttendancePlace localInstance = AtsAttendancePlaceFactory.getLocalInstance(ctx);
        AtsAttendancePlaceCollection atsAttendancePlaceCollection = localInstance.getAtsAttendancePlaceCollection("where sourceId in " + inString);
        if (atsAttendancePlaceCollection == null || atsAttendancePlaceCollection.size() == 0) {
            return;
        }
        IObjectPK[] ids = new IObjectPK[atsAttendancePlaceCollection.size()];
        for (int index = 0; index < atsAttendancePlaceCollection.size(); ++index) {
            AtsAttendancePlaceInfo placeInfo = atsAttendancePlaceCollection.get(index);
            ids[index] = new ObjectUuidPK(placeInfo.getId());
        }
        localInstance.deleteBatchData(ids);
    }
}

