/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.log4j.AtsLogger;
import com.kingdee.eas.hr.ats.util.AdminOrgUnitForAtsHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.CacheWorkUnitCardRule;
import com.kingdee.eas.hr.ats.util.CardRuleResult;
import com.kingdee.eas.hr.ats.util.CardRuleResultInfo;
import com.kingdee.eas.hr.ats.util.CardRuleServer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CardRuleParent {
    public void getFetchCardInfoByBeginAndEndTime(Context ctx, String beginDate, String endDate) throws BOSException, EASBizException, UuidException, SQLException, ParseException {
        AtsLogger.getInstance().setCtx(ctx);
        String sql = "select  scheduleshift.*  from  t_hr_ats_scheduleshift  scheduleshift  where to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') >= '" + beginDate + "'    and   to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') <= '" + endDate + "'     order by scheduleshift.fattenddate asc ";
        List<ScheduleShiftInfo> scheduleShiftList = this.getscheduleShiftInfo(ctx, sql);
        String personIds = AtsServerCalUtils.getPersonIdsBySchedule(scheduleShiftList);
        CacheWorkUnitCardRule cache = new CacheWorkUnitCardRule();
        Map<Object, Object> globalMap = cache.initPrepareData(ctx, personIds, beginDate, endDate);
        CardRuleResult cardResult = new CardRuleResult();
        cardResult.fetchCardInfoByScheduleShift(ctx, globalMap, 1);
    }

    public Map<String, List<CardRuleResultInfo>> getFetchCardInfoByAdminOrgPersonAndDate(Context ctx, String beginDate, String endDate, String adminOrgUnitId, String personId, Integer isContainSubOrg) throws BOSException, EASBizException, UuidException, SQLException, ParseException {
        Object ids;
        AtsLogger.getInstance().setCtx(ctx);
        Map<String, List<CardRuleResultInfo>> resMap = new HashMap<String, List<CardRuleResultInfo>>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select  scheduleshift.*  from  t_hr_ats_scheduleshift  scheduleshift  where to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') >= '" + beginDate + "'    and   to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') <= '" + endDate + "'   ");
        if (StringUtils.isNotBlank((String)personId)) {
            ids = AdminOrgUnitForAtsHelper.convertToString(personId);
            sqlBuffer.append(" and  scheduleshift.fproposerid  in(" + (String)ids + ") ");
        }
        if (StringUtils.isNotBlank((String)adminOrgUnitId)) {
            ids = new HashSet();
            ids.add(adminOrgUnitId);
            Set<String> adminOrgUnitIds = AdminOrgUnitForAtsHelper.getAllAdminOrgUnitIdsIsContainSub(ctx, (Set<String>)ids, isContainSubOrg, new FilterInfo());
            if (!adminOrgUnitIds.isEmpty()) {
                String adminOrgUnits = AdminOrgUnitForAtsHelper.convertSetToString(adminOrgUnitIds);
                sqlBuffer.append(" and  scheduleshift.FAdminOrgUnitID  in(" + adminOrgUnits + ") ");
            }
        }
        sqlBuffer.append(" order by scheduleshift.fattenddate asc ");
        List<ScheduleShiftInfo> scheduleShiftList = this.getscheduleShiftInfo(ctx, sqlBuffer.toString());
        List<ScheduleShiftInfo> scheduleShiftPersonList = AtsServerUtils.getScheduleShiftInfoList(ctx, scheduleShiftList);
        String personIds = AtsServerCalUtils.getPersonIdsBySchedule(scheduleShiftPersonList);
        if (StringUtils.isNotBlank((String)personIds)) {
            CacheWorkUnitCardRule cache = new CacheWorkUnitCardRule();
            Map<Object, Object> global_Map = cache.initPrepareData(ctx, personIds, beginDate, endDate);
            CardRuleResult cardResult = new CardRuleResult();
            resMap = cardResult.fetchCardInfoByScheduleShift(ctx, global_Map, 1);
        }
        return resMap;
    }

    public void getFetchCardInfoByAdminOrgPersonAndDateV2(Context ctx, String beginDate, String endDate, String adminOrgUnitId, String personId, Integer isContainSubOrg, Map<Object, Object> globalMap) throws BOSException, EASBizException, UuidException, SQLException, ParseException {
        AtsLogger.getInstance().setCtx(ctx);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select  scheduleshift.*  from  t_hr_ats_scheduleshift  scheduleshift  where to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') >= '" + beginDate + "'    and   to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') <= '" + endDate + "'   ");
        if (StringUtils.isNotBlank((String)personId)) {
            String ids = AdminOrgUnitForAtsHelper.convertToString(personId);
            sqlBuffer.append(" and  scheduleshift.fproposerid  in(" + ids + ") ");
        }
        sqlBuffer.append(" order by scheduleshift.fattenddate asc ");
        List<ScheduleShiftInfo> scheduleShiftList = this.getscheduleShiftInfo(ctx, sqlBuffer.toString());
        List<ScheduleShiftInfo> scheduleShiftPersonList = AtsServerUtils.getScheduleShiftInfoListV2(ctx, scheduleShiftList, globalMap);
        String personIds = AtsServerCalUtils.getPersonIdsBySchedule(scheduleShiftPersonList);
        if (StringUtils.isNotBlank((String)personIds)) {
            CacheWorkUnitCardRule cache = new CacheWorkUnitCardRule();
            Map<Object, Object> global_Map = cache.initPrepareData(ctx, personIds, beginDate, endDate);
            CardRuleResult cardResult = new CardRuleResult();
            cardResult.fetchCardInfoByScheduleShift(ctx, global_Map, 1);
            Map scheduleShiftMainMap = (Map)global_Map.get("cardRuleScheduleShiftMainInfoMap");
            scheduleShiftMainMap = null;
            global_Map.put("cardRuleScheduleShiftMainInfoMap", null);
            Map cardRuleSingleInfoMap = (Map)global_Map.get("cardRuleSingleInfoMap");
            cardRuleSingleInfoMap = null;
            global_Map.put("cardRuleSingleInfoMap", null);
            Map defaultShiftInfoInFileMap = (Map)global_Map.get("defaultShiftInfoMap");
            defaultShiftInfoInFileMap = null;
            global_Map.put("defaultShiftInfoMap", null);
            Map allShiftInfoMap = (Map)global_Map.get("atsShiftInfoMap");
            allShiftInfoMap = null;
            global_Map.put("atsShiftInfoMap", null);
            List scheduleShiftListCardRule = (List)global_Map.get("cardRuleShceduleShiftList");
            scheduleShiftListCardRule = null;
            global_Map.put("cardRuleShceduleShiftList", null);
            Map attendanceResultInfosMap = (Map)global_Map.get("attendanceResultInfosMap");
            attendanceResultInfosMap = null;
            global_Map.put("attendanceResultInfosMap", null);
            List punchCardRecordInfosList = (List)global_Map.get("punchCardRecordInfosList");
            punchCardRecordInfosList = null;
            global_Map.put("punchCardRecordInfosList", null);
            global_Map = null;
        }
    }

    public Map<String, List<CardRuleResultInfo>> getOnePersonFetchCardInfoByBeginAndEndTime(Context ctx, String personid, String beginDate, String endDate) throws BOSException, EASBizException, UuidException, SQLException, ParseException {
        AtsLogger.getInstance().setCtx(ctx);
        Map<String, List<CardRuleResultInfo>> resMap = new HashMap<String, List<CardRuleResultInfo>>();
        String sql = "select  scheduleshift.*  from  t_hr_ats_scheduleshift  scheduleshift  where to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') >= '" + beginDate + "'    and   to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') <= '" + endDate + "'    and \tscheduleshift.fproposerid='" + personid + "'  order by scheduleshift.fattenddate asc ";
        List<ScheduleShiftInfo> scheduleShiftList = this.getscheduleShiftInfo(ctx, sql);
        String personIds = AtsServerCalUtils.getPersonIdsBySchedule(scheduleShiftList);
        if (!StringUtils.isEmpty((String)personIds)) {
            CacheWorkUnitCardRule cache = new CacheWorkUnitCardRule();
            Map<Object, Object> globalMap = cache.initPrepareData(ctx, personIds, beginDate, endDate);
            CardRuleResult cardResult = new CardRuleResult();
            resMap = cardResult.fetchCardInfoByScheduleShift(ctx, globalMap, 1);
        }
        return resMap;
    }

    public Map<String, List<CardRuleResultInfo>> getOnePersonFetchCardInfoByBeginAndEndTimeNoContinuous(Context ctx, String personid, List attendDateList) throws BOSException, EASBizException, UuidException, SQLException, ParseException {
        AtsLogger.getInstance().setCtx(ctx);
        Map<String, List<CardRuleResultInfo>> resMap = new HashMap<String, List<CardRuleResultInfo>>();
        StringBuffer sBuffer = new StringBuffer();
        int size = attendDateList.size();
        for (int i = 0; i < size; ++i) {
            sBuffer.append("'" + AtsDateUtils.getDateFromLongString((String)attendDateList.get(i)) + "'");
            sBuffer.append(",");
        }
        sBuffer = sBuffer.delete(sBuffer.length() - 1, sBuffer.length());
        String sql = "select  scheduleshift.*  from  t_hr_ats_scheduleshift  scheduleshift  where  to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') in (" + sBuffer.toString() + ")  and \tscheduleshift.fproposerid='" + personid + "'  order by scheduleshift.fattenddate asc ";
        List<ScheduleShiftInfo> scheduleShiftList = this.getscheduleShiftInfo(ctx, sql);
        if (scheduleShiftList.size() == 0) {
            System.out.println("bill trigger result, no scheduleShift ; personid: " + personid + "; date: " + sBuffer.toString());
        }
        if (scheduleShiftList.size() > 0) {
            CardRuleServer server = new CardRuleServer();
            String beginDate = server.getMinDataShort(attendDateList);
            String endDate = server.getMinDataShort(attendDateList);
            String personIds = AtsServerCalUtils.getPersonIdsBySchedule(scheduleShiftList);
            CacheWorkUnitCardRule cache = new CacheWorkUnitCardRule();
            Map<Object, Object> globalMap = cache.initPrepareData(ctx, personIds, beginDate, endDate);
            CardRuleResult cardResult = new CardRuleResult();
            resMap = cardResult.fetchCardInfoByScheduleShift(ctx, globalMap, 1);
        }
        return resMap;
    }

    public Map<String, List<CardRuleResultInfo>> getMorePersonFetchCardInfoByBeginAndEndTimeNoContinuous(Context ctx, String personids, List attendDateList) throws BOSException, EASBizException, UuidException, SQLException, ParseException {
        AtsLogger.getInstance().setCtx(ctx);
        Map<String, List<CardRuleResultInfo>> resMap = new HashMap<String, List<CardRuleResultInfo>>();
        StringBuffer sBuffer = new StringBuffer();
        int size = attendDateList.size();
        for (int i = 0; i < size; ++i) {
            sBuffer.append("'" + AtsDateUtils.getDateFromLongString((String)attendDateList.get(i)) + "'");
            sBuffer.append(",");
        }
        sBuffer = sBuffer.delete(sBuffer.length() - 1, sBuffer.length());
        String sql = "select  scheduleshift.*  from  t_hr_ats_scheduleshift  scheduleshift  where  to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') in (" + sBuffer.toString() + ")  and \tscheduleshift.fproposerid  in  (" + personids + ")   order by scheduleshift.fattenddate asc ";
        List<ScheduleShiftInfo> scheduleShiftList = this.getscheduleShiftInfo(ctx, sql);
        if (scheduleShiftList.size() == 0) {
            System.out.println("bill trigger result, no scheduleShift ; personids: " + personids + "; date: " + sBuffer.toString());
        }
        if (scheduleShiftList.size() > 0) {
            CardRuleServer server = new CardRuleServer();
            String beginDate = server.getMinDataShort(attendDateList);
            String endDate = server.getMaxDataShort(attendDateList);
            if (beginDate.length() > 10) {
                beginDate = AtsDateUtils.getDateFromLongString(beginDate);
            }
            if (endDate.length() > 10) {
                endDate = AtsDateUtils.getDateFromLongString(endDate);
            }
            String personIds = AtsServerCalUtils.getPersonIdsBySchedule(scheduleShiftList);
            CacheWorkUnitCardRule cache = new CacheWorkUnitCardRule();
            Map<Object, Object> globalMap = cache.initPrepareData(ctx, personIds, beginDate, endDate);
            CardRuleResult cardResult = new CardRuleResult();
            resMap = cardResult.fetchCardInfoByScheduleShift(ctx, globalMap, 1);
        }
        return resMap;
    }

    public Map<String, List<CardRuleResultInfo>> getMorePersonFetchCardInfoByBeginAndEndTimeNoContinuous(Context ctx, String personids, String signDates) throws BOSException, EASBizException, UuidException, SQLException, ParseException {
        AtsLogger.getInstance().setCtx(ctx);
        Map<String, List<CardRuleResultInfo>> resMap = new HashMap<String, List<CardRuleResultInfo>>();
        String sql = "select  scheduleshift.*  from  t_hr_ats_scheduleshift  scheduleshift  where  to_Char(scheduleshift.FattendDate,'yyyy-MM-dd') in (" + signDates + ")  and \tscheduleshift.fproposerid in  (" + personids + ")   order by scheduleshift.fattenddate asc ";
        List<ScheduleShiftInfo> scheduleShiftList = this.getscheduleShiftInfo(ctx, sql);
        if (scheduleShiftList.size() == 0) {
            System.out.println("sign record trigger result, no scheduleShift ; personid: " + personids + "; date: " + signDates);
        }
        ArrayList<String> dateList = new ArrayList<String>();
        String[] signDate = signDates.split(",");
        for (int i = 0; i < signDate.length; ++i) {
            String dateStr = signDate[i].trim();
            dateStr = dateStr.substring(1, dateStr.length() - 1);
            dateList.add(dateStr);
        }
        if (scheduleShiftList.size() > 0) {
            CardRuleServer server = new CardRuleServer();
            String beginDate = server.getMinDataShort(dateList);
            String endDate = server.getMaxDataShort(dateList);
            String personIds = AtsServerCalUtils.getPersonIdsBySchedule(scheduleShiftList);
            CacheWorkUnitCardRule cache = new CacheWorkUnitCardRule();
            Map<Object, Object> globalMap = cache.initPrepareData(ctx, personIds, beginDate, endDate);
            CardRuleResult cardResult = new CardRuleResult();
            resMap = cardResult.fetchCardInfoByScheduleShift(ctx, globalMap, 1);
        }
        return resMap;
    }

    public List<ScheduleShiftInfo> getscheduleShiftInfo(Context ctx, String sql) throws BOSException, UuidException, SQLException {
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<ScheduleShiftInfo> scheduleShiftList = new ArrayList<ScheduleShiftInfo>();
        while (row.next()) {
            ScheduleShiftInfo info = new ScheduleShiftInfo();
            info.setId(BOSUuid.read((String)row.getString("FID")));
            info.setAttendDate(row.getDate("FAttendDate"));
            AtsShiftInfo shiftInfo = new AtsShiftInfo();
            if (StringUtils.isNotBlank((String)row.getString("FDefaultShiftID"))) {
                shiftInfo.setId(BOSUuid.read((String)row.getString("FDefaultShiftID")));
            }
            info.setDefaultShift(shiftInfo);
            CardRuleInfo cardRuleInfo = new CardRuleInfo();
            if (StringUtils.isNotBlank((String)row.getString("FCardRuleID"))) {
                cardRuleInfo.setId(BOSUuid.read((String)row.getString("FCardRuleID")));
            }
            info.setCardRule(cardRuleInfo);
            AttencePolicyInfo policyInfo = new AttencePolicyInfo();
            if (StringUtils.isNotBlank((String)row.getString("FAttendPolicyID"))) {
                String policyid = row.getString("FAttendPolicyID");
                policyInfo.setId(BOSUuid.read((String)policyid));
            } else {
                policyInfo.setId(null);
            }
            info.setAttendPolicy(policyInfo);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)row.getString("FProposerID")));
            info.setProposer(personInfo);
            AdminOrgUnitInfo org = new AdminOrgUnitInfo();
            PositionInfo positionInfo = new PositionInfo();
            HROrgUnitInfo hrinfo = new HROrgUnitInfo();
            if (StringUtils.isNotBlank((String)row.getString("FAdminOrgUnitID"))) {
                org.setId(BOSUuid.read((String)row.getString("FAdminOrgUnitID")));
            }
            if (StringUtils.isNotBlank((String)row.getString("FPositionID"))) {
                positionInfo.setId(BOSUuid.read((String)row.getString("FPositionID")));
            }
            if (StringUtils.isNotBlank((String)row.getString("FHrOrgUnitID"))) {
                hrinfo.setId(BOSUuid.read((String)row.getString("FHrOrgUnitID")));
            }
            info.setAdminOrgUnit(org);
            info.setPosition(positionInfo);
            info.setHrOrgUnit(hrinfo);
            scheduleShiftList.add(info);
        }
        return scheduleShiftList;
    }

    public static void main(String[] args) {
        String signDates = "    '2015-01-01','2015-01-02','2015-01-03'      ";
        ArrayList<String> dateList = new ArrayList<String>();
        String[] signDate = signDates.split(",");
        for (int i = 0; i < signDate.length; ++i) {
            String dateStr = signDate[i].trim();
            dateStr = dateStr.substring(1, dateStr.length() - 1);
            dateList.add(dateStr);
        }
        System.out.println(dateList);
    }
}

