/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.DateTimeConstant;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.NumericException;
import com.kingdee.util.enums.Enum;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public abstract class MLUtile {
    private static final String MISS_RES = "Missing Resource";

    public static String getRes(NumericException numericException) {
        return MLUtile.getRes(numericException, (Object[])null);
    }

    public static String getRes(NumericException numericException, Object ... params) {
        return numericException == null ? "" : AtsCommonUtile.formatStr(numericException.getMessage(), params);
    }

    public static String getRes(ResourceEnum resourceEnum, Context ctx) {
        return MLUtile.getRes(resourceEnum, ctx, (Object[])null);
    }

    public static String getRes(ResourceEnum resourceEnum, Context ctx, Object ... params) {
        return MLUtile.getRes(resourceEnum.getClass().getName(), resourceEnum.toString(), ctx, params);
    }

    public static String getRes(ResourceEnum resourceEnum, Locale locale, Object ... params) {
        return MLUtile.getRes(resourceEnum.getClass().getName(), resourceEnum.toString(), locale, params);
    }

    public static void setMultiResWithJoin(CoreBaseInfo corebaseinfo, String fieldName, String separator, ResourceEnum resourceEnum, Object ... params) {
        int i = 0;
        for (Locale locale : new Locale[]{LocaleUtils.locale_l1, LocaleUtils.locale_l2, LocaleUtils.locale_l3}) {
            String res = MLUtile.getRes(resourceEnum, locale, null == params ? null : params[i]);
            corebaseinfo.put(fieldName, (Object)StringUtils.join((Object[])new Object[]{corebaseinfo.get(fieldName, locale), res}, (String)separator), locale);
            ++i;
        }
    }

    public static Object getMultiResWithName(CoreBaseInfo corebaseinfo, String fieldName) {
        Locale[] params = new Locale[]{LocaleUtils.locale_l1, LocaleUtils.locale_l2, LocaleUtils.locale_l3};
        Object[] nameAll = new Object[3];
        for (int j = 0; j < params.length; ++j) {
            if (!(fieldName instanceof String)) continue;
            nameAll[j] = corebaseinfo.get(fieldName.toString(), params[j]);
        }
        return nameAll;
    }

    public static void setMultiRes(CoreBaseInfo corebaseinfo, String fieldName, ResourceEnum resourceEnum, Object ... params) {
        for (Locale locale : new Locale[]{LocaleUtils.locale_l1, LocaleUtils.locale_l2, LocaleUtils.locale_l3}) {
            String res = MLUtile.getRes(resourceEnum, locale, params);
            corebaseinfo.put(fieldName, (Object)res, locale);
        }
    }

    public static String getRes(Enum easEnum, Context ctx) {
        return easEnum == null ? "" : (ctx == null ? easEnum.getAlias() : easEnum.getAlias(ctx.getLocale()));
    }

    public static String getRes(Enum easEnum, Context ctx, Object ... params) {
        String res = MLUtile.getRes(easEnum, ctx);
        return AtsCommonUtile.formatStr(res, params);
    }

    public static String getRes(String resClassName, String resName, Context ctx) {
        return MLUtile.getRes(resClassName, resName, ctx, (Object[])null);
    }

    public static String getRes(String resClassName, String resName, Context ctx, Object ... params) {
        String res = EASResource.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
        if (res == null || MISS_RES.equalsIgnoreCase(res.trim())) {
            return "";
        }
        return AtsCommonUtile.formatStr(res, params);
    }

    public static String getRes(String resClassName, String resName, Locale locale, Object ... params) {
        String res = EASResource.getString((String)resClassName, (String)resName, (Locale)locale);
        if (res == null || MISS_RES.equalsIgnoreCase(res.trim())) {
            return "";
        }
        return AtsCommonUtile.formatStr(res, params);
    }

    public static String getMlFlag(Context ctx) {
        Locale locale;
        Locale locale2 = locale = ctx == null ? null : ctx.getLocale();
        if (locale == null) {
            locale = LocaleUtils.getDefaultLocale();
        }
        return "_" + LocaleUtils.getShortCode((Locale)locale);
    }

    public static String getMultiFlag(Context ctx) {
        Locale locale;
        Locale locale2 = locale = ctx == null ? null : ctx.getLocale();
        if (locale == null) {
            locale = LocaleUtils.getDefaultLocale();
        }
        return LocaleUtils.getShortCode((Locale)locale);
    }

    public static String getMonth(Object month) {
        int m = MLUtile.getInt(month, -1);
        return m == -1 ? null : DateTimeConstant.MONTH[m];
    }

    public static String getMonthZeroPrefix(Object month) {
        int m = MLUtile.getInt(month, -1);
        return m == -1 ? null : DateTimeConstant.MONTH_ZERO_PREFIX[m];
    }

    public static String getWeekDay(Object week) {
        int w = MLUtile.getInt(week, -1);
        return w == -1 ? null : DateTimeConstant.WEEK[w];
    }

    private static int getInt(Object intObj, int defaultVAl) {
        try {
            return Integer.valueOf(String.valueOf(intObj));
        }
        catch (Exception e) {
            return defaultVAl;
        }
    }
}

