/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.eas.hr.ats.util.common.SystemClock;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class Timing {
    private Timestamp beginTime;
    private StringBuffer prefix;
    private StringBuffer suffix;
    private boolean recordStack = true;

    public static Timing getInst() {
        return new Timing();
    }

    public Timing() {
        this.reset();
    }

    public Timing(long beginTime) {
        if (beginTime == 0L) {
            this.reset();
        } else {
            this.beginTime = new Timestamp(beginTime);
        }
    }

    public Timing(Date beginTime) {
        this(beginTime == null ? 0L : beginTime.getTime());
    }

    public Timing(Timing timing) {
        if (timing == null) {
            this.reset();
        } else {
            this.beginTime = (Timestamp)timing.getBeginTime().clone();
        }
    }

    public void reset() {
        this.beginTime = SystemClock.nowSqlTimestamp();
        if (this.prefix != null) {
            this.prefix.setLength(0);
        }
        if (this.suffix != null) {
            this.suffix.setLength(0);
        }
    }

    public long msValue() {
        return SystemClock.now() - this.beginTime.getTime();
    }

    public long value() {
        return this.msValue() / 1000L;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toSecString() {
        return this.toString(false);
    }

    private int reachePrintPosition(StackTraceElement trace) {
        if (trace == null) {
            return -1;
        }
        if (StringUtils.equals((String)trace.getClassName(), (String)Category.class.getName()) && StringUtils.contains((String)trace.getMethodName(), (String)"forcedLog")) {
            return 2;
        }
        if (StringUtils.equals((String)trace.getClassName(), (String)PrintStream.class.getName()) && StringUtils.contains((String)trace.getMethodName(), (String)"print")) {
            return 1;
        }
        return -1;
    }

    private StackTraceElement getPrintStackEle() {
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        StackTraceElement printTrace = null;
        for (int i = 0; i < traces.length; ++i) {
            printTrace = traces[i];
            int printPostion = this.reachePrintPosition(printTrace);
            if (printPostion < 0) continue;
            if (i + printPostion >= traces.length) break;
            printTrace = traces[i + printPostion];
            break;
        }
        return printTrace;
    }

    private String toString(boolean isMillSecond) {
        StackTraceElement printTrace = this.getPrintStackEle();
        if (printTrace != null && this.recordStack) {
            this.append(" ");
            this.append(printTrace.getClassName());
            this.prefix = new StringBuffer().append(printTrace.getMethodName()).append(":").append(printTrace.getLineNumber()).append(" ").append(this.prefix == null ? "" : this.prefix);
        }
        if (this.prefix == null || this.prefix.length() == 0) {
            this.prepend("Timing");
        }
        String str = this.prefix.append("[costTime=").append(isMillSecond ? this.msValue() : this.value()).append(isMillSecond ? "ms" : "s").append(";beginTime=").append(this.beginTime).append(";curTime=").append(SystemClock.nowSqlTimestamp()).append(this.suffix == null ? "" : this.suffix).append("]").toString();
        this.reset();
        return str;
    }

    public Timestamp getBeginTime() {
        return this.beginTime;
    }

    public Timing setBeginTime(Timestamp beginTime) {
        this.beginTime = beginTime;
        return this;
    }

    public Timing prepend(Object msg) {
        if (msg == null) {
            return this;
        }
        if (this.prefix == null) {
            this.prefix = new StringBuffer(msg.toString());
        } else {
            this.prefix.append(msg);
        }
        return this;
    }

    public Timing append(Object msg) {
        if (msg == null) {
            return this;
        }
        if (this.suffix == null) {
            this.suffix = new StringBuffer(msg.toString());
        } else {
            this.suffix.append(msg);
        }
        return this;
    }

    public StringBuffer getPrefix() {
        return this.prefix;
    }

    public Timing setPrefix(StringBuffer prefix) {
        this.prefix = prefix;
        return this;
    }

    public StringBuffer getSuffix() {
        return this.suffix;
    }

    public Timing setSuffix(StringBuffer suffix) {
        this.suffix = suffix;
        return this;
    }

    public boolean isRecordStack() {
        return this.recordStack;
    }

    public Timing setRecordStack(boolean recordStack) {
        this.recordStack = recordStack;
        return this;
    }
}

