/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsOrgBizException;
import com.kingdee.eas.hr.ats.AtsTripBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillFactory;
import com.kingdee.eas.hr.ats.AtsTripBillResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.CanTripBillEntryCollection;
import com.kingdee.eas.hr.ats.CanTripBillEntryFactory;
import com.kingdee.eas.hr.ats.CanTripBillEntryInfo;
import com.kingdee.eas.hr.ats.CanTripBillInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.fillControl.CanTripBillFillControl;
import com.kingdee.eas.hr.ats.fillControl.dto.FillControlDto;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsAttendanceFileUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.Assert;
import com.kingdee.eas.hr.ats.util.common.AtsBillAssist;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CanTripBillHelper
extends BillHelper {
    public CanTripBillInfo storefields(Context ctx, CanTripBillInfo billInfo) throws BOSException, EASBizException {
        billInfo.setIsMultiEntry(Boolean.FALSE);
        HROrgUnitInfo hrInfo = billInfo.getHrOrgUnit();
        if (hrInfo == null) {
            billInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            if (billInfo.getHrOrgUnit() == null) {
                throw new AtsOrgBizException(AtsOrgBizException.REQUIREHRORG);
            }
        }
        String tripBillEntryId = billInfo.getEntries().get(0).getTripEntryBill().getId().toString();
        billInfo = this.forStorefields(ctx, billInfo, tripBillEntryId);
        return billInfo;
    }

    public CanTripBillInfo forStorefields(Context ctx, CanTripBillInfo billInfo, String tripBillEntryId) throws BOSException, EASBizException {
        CanTripBillEntryInfo entryInfo = billInfo.getEntries().get(0);
        AtsTripBillEntryInfo tripBillEntryInfo = new AtsTripBillEntryInfo();
        try {
            tripBillEntryInfo = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryInfo((IObjectPK)new ObjectUuidPK(tripBillEntryId));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String personId = tripBillEntryInfo.getPerson().getId().toString();
        AttendanceFileHISInfo fileHisInfo = AtsAttendanceFileUtils.getAttendanceFileHISInfoByAttenceDate(ctx, billInfo.getEntries().get(0).getRealStartTime(), billInfo.getEntries().get(0).getRealEndTime(), personId);
        if (fileHisInfo == null) {
            throw new AtsFileBizException(AtsFileBizException.NOTEXISTFILEHIS);
        }
        if (billInfo.getAdminOrg() == null) {
            PersonPositionInfo personPositionInfo_main = SHRBillUtil.getAdminOrgUnit(personId, ctx);
            billInfo.setAdminOrg(personPositionInfo_main.getPersonDep());
            billInfo.setProposer(personPositionInfo_main.getPerson());
            entryInfo.setPerson(personPositionInfo_main.getPerson());
            entryInfo.setPosition(personPositionInfo_main.getPrimaryPosition());
        }
        entryInfo.setIsDefaultManage(fileHisInfo.isIsDefaultManage());
        if (entryInfo.getAdminOrgUnit() == null) {
            entryInfo.setAdminOrgUnit(fileHisInfo.getAdminOrgUnit());
        }
        if (entryInfo.getAttAdminOrgUnit() == null) {
            entryInfo.setAttAdminOrgUnit(fileHisInfo.getAttAdminOrgUnit());
        }
        if (entryInfo.getRealStartTime() == null) {
            entryInfo.setRealStartTime(billInfo.getEntries().get(0).getRealStartTime());
        }
        if (entryInfo.getRealEndTime() == null) {
            entryInfo.setRealEndTime(billInfo.getEntries().get(0).getRealEndTime());
        }
        if (entryInfo.getRealTripDays() == null) {
            entryInfo.setRealTripDays(this.getBillLength(ctx, entryInfo));
        }
        entryInfo.setTripBill(billInfo.getEntries().get(0).getTripBill());
        if (entryInfo.getTripReason() == null) {
            entryInfo.setTripReason(billInfo.getEntries().get(0).getTripReason());
        }
        billInfo.getEntries().clear();
        billInfo.getEntries().add(entryInfo);
        return billInfo;
    }

    public String doVerifyModel(Context ctx, CanTripBillInfo model) throws EASBizException {
        String errorString;
        CanTripBillInfo billInfo = model;
        AtsTripBillEntryInfo tripBillEntryInfo = new AtsTripBillEntryInfo();
        CanTripBillEntryInfo firstEntry = billInfo.getEntries().get(0);
        String tripBillId = firstEntry.getTripEntryBill().getId().toString();
        Calendar applyCal = Calendar.getInstance();
        try {
            tripBillEntryInfo = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryInfo((IObjectPK)new ObjectUuidPK(tripBillId));
            if (billInfo.getId() != null && AtsWebUtils.isInWorkFlow(ctx, billInfo.getId().toString())) {
                AtsAffairBaseInfo actBillInfo = billInfo;
                if (billInfo.getApplyDate() == null) {
                    actBillInfo = AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo((IObjectPK)new ObjectUuidPK(billInfo.getId().toString()));
                }
                if (actBillInfo.getApplyDate() != null) {
                    applyCal.setTime(actBillInfo.getApplyDate());
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String personId = tripBillEntryInfo.getPerson().getId().toString();
        AttencePolicyInfo attencePolicyInfo = AttencePolicyFillUtil.getAttencePolicyInfo(ctx, null, personId, firstEntry.getRealEndTime());
        if (attencePolicyInfo == null) {
            errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
        } else {
            CanTripBillFillControl fillControlCommon = new CanTripBillFillControl(ctx);
            FillControlDto dto = new FillControlDto();
            dto.setAttencePolicy(attencePolicyInfo);
            dto.setApplyDate(applyCal.getTime());
            dto.setStartTime(firstEntry.getRealStartTime());
            dto.setEndTime(firstEntry.getRealEndTime());
            fillControlCommon.buildParam(dto);
            fillControlCommon.control();
            errorString = fillControlCommon.getResult().getMessage();
        }
        return errorString;
    }

    public String validateBatch(Context ctx, CanTripBillInfo model) {
        CanTripBillEntryInfo entry = (CanTripBillEntryInfo)AtsBillAssist.getFirstBillEntry((CoreBaseInfo)model);
        try {
            Assert.fieldNotNull((CoreBaseInfo)entry, "tripEntryBill");
        }
        catch (EASBizException e) {
            return e.getMessage();
        }
        String personId = AtsBillAssist.getPersonId((CoreBaseInfo)entry);
        String beginTime = HRTimeWebUtils.timestampToString(AtsBillAssist.getRealBeginTime((CoreBaseInfo)entry));
        String endTime = HRTimeWebUtils.timestampToString(AtsBillAssist.getRealEndTime((CoreBaseInfo)entry));
        String tripEntryId = CoreBaseUtile.getId(entry.getTripEntryBill());
        String errorMsg = this.validateBatch(ctx, personId, tripEntryId, beginTime, endTime, CoreBaseUtile.getId(model));
        return errorMsg;
    }

    public String validateBatch(Context ctx, String personId, String tripBillId, String begin_Time, String end_Time, String billId) {
        StringBuffer errorBuffer = new StringBuffer("");
        try {
            Map<String, Object> res = this.getCanTripBillInfoByPersonIdAndTripBillTime(ctx, personId, tripBillId, begin_Time, end_Time, billId);
            int isOverRange = (Integer)res.get("isOverRange");
            int addFlag = (Integer)res.get("addFlag");
            boolean tripBillExist = (Boolean)res.get("tripBillExist");
            int currentFix = (Integer)res.get("currentFix");
            String isOverRangeMsg = (String)res.get("isOverRangeMsg");
            if (currentFix == 0) {
                errorBuffer.append(MLUtile.getRes(AtsTripBillResEnum.NoIntsectionTimeInBills, ctx));
                return errorBuffer.toString();
            }
            if (addFlag == 1) {
                errorBuffer.append(MLUtile.getRes(AtsTripBillResEnum.OverlapCanTripBill, ctx));
                return errorBuffer.toString();
            }
            if (isOverRange == 1) {
                errorBuffer.append(isOverRangeMsg);
                return errorBuffer.toString();
            }
            if (tripBillExist) {
                errorBuffer.append(MLUtile.getRes(AtsTripBillResEnum.RepeatConfirmTripBill, ctx));
                return errorBuffer.toString();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return errorBuffer.toString();
    }

    public Map<String, Object> getCanTripBillInfoByPersonIdAndTripBillTime(Context ctx, String personId, String tripBillId, String begin_Time, String end_Time, String billId) throws BOSException, UuidException, SQLException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Timestamp beginDate = AtsDateUtils.stringToTimestamp(begin_Time);
        Timestamp endDate = AtsDateUtils.stringToTimestamp(end_Time);
        res.put("currentFix", this.hasIntersectionWithSelfTripBill(ctx, personId, tripBillId, beginDate, endDate));
        String isOverRangeMsg = this.noIntersectionWithOtherTripBill(ctx, personId, tripBillId, beginDate, endDate);
        res.put("isOverRange", "".equals(isOverRangeMsg) ? 0 : 1);
        res.put("isOverRangeMsg", isOverRangeMsg);
        res.put("tripBillExist", this.existCanTripBill(ctx, tripBillId, billId));
        res.put("addFlag", this.hasIntersectionWithOtherCanTripBill(ctx, personId, billId, beginDate, endDate));
        return res;
    }

    public int hasIntersectionWithSelfTripBill(Context ctx, String personId, String tripBillId, Timestamp beginDate, Timestamp endDate) throws BOSException, SQLException {
        String currentTripSql = "select tripBill.fid  from T_HR_ATS_TripBill tripBill left join T_HR_ATS_TripBillEntry entry on tripBill.fid = entry.FBillID  where entry.fid = ?  and entry.FPERSONID = ? and (entry.FRealTripStartTime <= ? and entry.FRealTripEndTime >= ?)  and tripBill.fbillstate != 0 and tripBill.fbillstate != 4";
        Object[] curTripParams = new Object[]{tripBillId, personId, endDate, beginDate};
        IRowSet curTripRow = DbUtil.executeQuery((Context)ctx, (String)currentTripSql, (Object[])curTripParams);
        return curTripRow.next() ? 1 : 0;
    }

    public String noIntersectionWithOtherTripBill(Context ctx, String personId, String tripBillId, Timestamp beginDate, Timestamp endDate) throws BOSException, SQLException {
        String tripSql = "select tripBill.fid,tripBill.fNumber,entry.FRealTripStartTime,entry.FRealTripEndTime,person.fname" + MLUtile.getMlFlag(ctx) + " name  from T_HR_ATS_TripBill tripBill left join T_HR_ATS_TripBillEntry entry on tripBill.fid = entry.FBillID inner join T_BD_PERSON person on person.fid = entry.fpersonId where entry.fid != ? and entry.FPERSONID = ? and (entry.FRealTripStartTime < ? and entry.FRealTripEndTime > ?)  and tripBill.fbillstate != 0 and tripBill.fbillstate != 4";
        Object[] tripParams = new Object[]{tripBillId, personId, endDate, beginDate};
        IRowSet tripRow = DbUtil.executeQuery((Context)ctx, (String)tripSql, (Object[])tripParams);
        if (tripRow.next()) {
            String number = tripRow.getString("fNumber");
            String personName = tripRow.getString("name");
            String realBeginDate = AtsDateUtils.dateLongToString(tripRow.getDate("FRealTripStartTime"));
            String realEndDate = AtsDateUtils.dateLongToString(tripRow.getDate("FRealTripEndTime"));
            return MLUtile.getRes((ResourceEnum)AtsTripBillResEnum.OverlapRealTimeRecordInBill, ctx, number, personName, realBeginDate, realEndDate);
        }
        return "";
    }

    public boolean existCanTripBill(Context ctx, String tripBillId, String billId) throws BOSException {
        CanTripBillEntryCollection hasCanTripBillCollection;
        boolean exist = false;
        if (StringUtils.isBlank((String)billId) && (hasCanTripBillCollection = CanTripBillEntryFactory.getLocalInstance(ctx).getCanTripBillEntryCollection(" where  bill.billstate != 0 and bill.billstate != 4 and tripEntryBill = '" + tripBillId + "'")).size() > 0) {
            exist = true;
        }
        if (StringUtils.isNotBlank((String)billId) && (hasCanTripBillCollection = CanTripBillEntryFactory.getLocalInstance(ctx).getCanTripBillEntryCollection(" where bill.billstate != 0 and bill.billstate != 4 and tripEntryBill = '" + tripBillId + "' and bill.id != '" + billId + "'")).size() > 0) {
            exist = true;
        }
        return exist;
    }

    public int hasIntersectionWithOtherCanTripBill(Context ctx, String personId, String billId, Timestamp beginDate, Timestamp endDate) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 from T_ATS_CanTripBill  bill \n");
        sql.append(" left join T_ATS_CanTripBillEntry entry on bill.fid = entry.fbillid \n");
        sql.append(" where entry.fpersonid=?");
        if (StringUtils.isNotBlank((String)billId)) {
            sql.append(" and bill.fid != ?");
        }
        sql.append(" and bill.fbillstate != 0");
        sql.append(" and bill.fbillstate != 4");
        sql.append(" and entry.FRealStartTime < ? and entry.FRealEndTime > ?");
        sql.append(" order by bill.fapplydate desc ");
        Object[] params = StringUtils.isNotBlank((String)billId) ? new Object[]{personId, billId, endDate, beginDate} : new Object[]{personId, endDate, beginDate};
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        return row.next() ? 1 : 0;
    }
}

