/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.arrange;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryInfo;
import com.kingdee.eas.hr.ats.AtsTurnShiftInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftUtile;
import com.kingdee.eas.hr.ats.workShift.arrange.BaseArrangeShift;
import com.kingdee.eas.hr.ats.workShift.arrange.EArrangeState;
import java.util.Date;
import java.util.Map;

public class ArrangeShiftByTurns
extends BaseArrangeShift
implements Cloneable {
    private int startSegment;
    private int currentSegment;
    private String turnShiftId;
    private Map<Integer, AtsTurnShiftEntryInfo> turnShiftEntrys;

    public ArrangeShiftByTurns() {
    }

    public ArrangeShiftByTurns(Context ctx) {
        super(ctx);
    }

    @Override
    void beforeArrangeShift() {
        super.beforeArrangeShift();
        if (this.turnShiftEntrys == null) {
            this.turnShiftEntrys = ArrangeShiftUtile.getTurnShiftEntrys(this.ctx, this.turnShiftId);
        }
        if (!AtsCollectionUtile.isEmpty(this.turnShiftEntrys)) {
            this.startSegment %= this.turnShiftEntrys.size();
            int n = this.startSegment = this.startSegment <= 0 ? this.startSegment + this.turnShiftEntrys.size() : this.startSegment;
        }
        if (AtsCollectionUtile.isEmpty(this.turnShiftEntrys)) {
            this.setContinueArrangeShift(false);
        }
        this.currentSegment = this.startSegment;
    }

    @Override
    public void afterArrangeShift() {
        super.afterArrangeShift();
    }

    @Override
    public void holidayProcss() {
        switch (this.holidayProcessWay.getValue()) {
            case 1: {
                this.holidayProcssByTurn();
                break;
            }
            case 2: {
                this.holidayProcssByTurn();
                this.incrementSegment();
                break;
            }
            case 4: {
                this.holidayProcssWithShift();
                this.incrementSegment();
                break;
            }
            default: {
                this.workDayProcess();
            }
        }
    }

    private void holidayProcssWithShift() {
        this.getCurentArrangingSchedule().setDayType(DayTypeEnum.legalHoliday);
        AtsTurnShiftEntryInfo atsTurnShift = this.turnShiftEntrys.get(this.currentSegment);
        if (atsTurnShift.getDefaultShift() != null) {
            this.getCurentArrangingSchedule().setDefaultShift(atsTurnShift.getDefaultShift());
        } else {
            RangeMap<Date, ScheduleShiftInfo> scheduleShiftMap = this.getScheduleShiftMap();
            ScheduleShiftInfo hisScheduleShiftInfo = scheduleShiftMap.get(this.currentShiftDate);
            if (hisScheduleShiftInfo != null) {
                this.getCurentArrangingSchedule().setDefaultShift(hisScheduleShiftInfo.getDefaultShift());
            }
        }
        if (this.getArrangeState() == EArrangeState.SHOW_RESULT) {
            return;
        }
    }

    @Override
    public void workDayProcess() {
        AtsTurnShiftEntryInfo atsTurnShift = this.turnShiftEntrys.get(this.currentSegment);
        this.getCurentArrangingSchedule().setDefaultShift(atsTurnShift.getDefaultShift());
        this.getCurentArrangingSchedule().setDayType(atsTurnShift.getDateType());
        this.incrementSegment();
        if (this.getArrangeState() == EArrangeState.SHOW_RESULT) {
            return;
        }
    }

    private void holidayProcssByTurn() {
        this.getCurentArrangingSchedule().setDayType(DayTypeEnum.legalHoliday);
        this.getCurentArrangingSchedule().setDefaultShift(null);
        if (this.getArrangeState() == EArrangeState.SHOW_RESULT) {
            return;
        }
    }

    @Override
    protected void setBasicScheduleInfo() {
        super.setBasicScheduleInfo();
        AtsTurnShiftInfo atsTurnShift = new AtsTurnShiftInfo();
        atsTurnShift.setId(BOSUuid.read((String)this.turnShiftId));
        this.getCurentArrangingSchedule().setAtsTurnShift(atsTurnShift);
        this.getCurentArrangingSchedule().setShiftByTurnSegment(this.getCurrentSegment());
    }

    @Override
    public void weekendProcess() {
        this.workDayProcess();
    }

    private void incrementSegment() {
        if (this.turnShiftEntrys != null && this.currentSegment >= this.turnShiftEntrys.size()) {
            this.currentSegment = 0;
        }
        ++this.currentSegment;
    }

    public int getStartSegment() {
        return this.startSegment;
    }

    public void setStartSegment(int startSegment) {
        this.startSegment = startSegment;
    }

    public int getCurrentSegment() {
        return this.currentSegment;
    }

    public void setCurrentSegment(int currentSegment) {
        this.currentSegment = currentSegment;
    }

    public String getTurnShiftId() {
        return this.turnShiftId;
    }

    public void setTurnShiftId(String turnShiftId) {
        this.turnShiftId = turnShiftId;
    }

    public Map<Integer, AtsTurnShiftEntryInfo> getTurnShiftEntrys() {
        return this.turnShiftEntrys;
    }

    public void setTurnShiftEntrys(Map<Integer, AtsTurnShiftEntryInfo> turnShiftEntrys) {
        this.turnShiftEntrys = turnShiftEntrys;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "ArrangeShiftByTurns [startSegment=" + this.startSegment + ", currentSegment=" + this.currentSegment + ", turnShiftId=" + this.turnShiftId + ", personInfo=" + this.personInfo + ", beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", currentShiftDate=" + this.currentShiftDate + ", operationType=" + (Object)((Object)this.operationType) + ", arrangeWay=" + (Object)((Object)this.arrangeWay) + ", holidayProcessWay=" + (Object)((Object)this.holidayProcessWay) + ", arrangeState=" + (Object)((Object)this.arrangeState) + ", continueArrangeShift=" + this.continueArrangeShift + ", curentArrangingSchedule=" + this.curentArrangingSchedule + ", holidayMap=" + this.holidayMap + ", errorMsg=" + this.errorMsg + ", ctx=" + this.ctx + "]";
    }
}

