/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.arrange;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftResEnum;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.EArrangeWay;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.arrange.AbstractArrangeShiftManager;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByCopy;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByShift;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByTurns;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftUtile;
import com.kingdee.eas.hr.ats.workShift.arrange.BaseArrangeShift;
import com.kingdee.eas.hr.ats.workShift.arrange.IArrangeShift;
import com.kingdee.eas.hr.ats.workShift.save.SaveShiftUtile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ArrangeShiftManager
implements AbstractArrangeShiftManager {
    protected Context ctx;
    protected List<BaseArrangeShift> allScheduleShift = new ArrayList<BaseArrangeShift>();
    protected Set<String> errorMsg = new HashSet<String>();

    public ArrangeShiftManager() {
    }

    public ArrangeShiftManager(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void arangeShift(Collection<String> personNums, IArrangeShift iArrangeShift) throws Exception {
        if (AtsCollectionUtile.isEmpty(personNums)) {
            AtsLog.getWSLog().error((Object)"no select person!");
            this.errorMsg.add(MLUtile.getRes(AtsFileResEnum.NotChooseEmployee, this.ctx));
            return;
        }
        List<List<String>> batchPersonNums = AtsCollectionUtile.group(personNums, AtsConstants.SIZE_COMMON_BATCH);
        Iterator<List<String>> batchPersonIterator = batchPersonNums.iterator();
        block7: while (batchPersonIterator.hasNext()) {
            switch (iArrangeShift.getArrangeWay().getValue()) {
                case 4: 
                case 5: {
                    this.arrangShiftByCopy((Collection<String>)batchPersonIterator.next(), (ArrangeShiftByCopy)iArrangeShift);
                    continue block7;
                }
                case 1: {
                    this.arrangeByTurns((Collection<String>)batchPersonIterator.next(), (ArrangeShiftByTurns)iArrangeShift);
                    continue block7;
                }
                case 2: {
                    this.arrangeByPostoneTurns((Collection<String>)batchPersonIterator.next(), (ArrangeShiftByTurns)iArrangeShift);
                    continue block7;
                }
                case 3: {
                    this.arrangeByAppointedShift((Collection<String>)batchPersonIterator.next(), (ArrangeShiftByShift)iArrangeShift);
                    continue block7;
                }
                case 6: {
                    this.arrangeByUserDefined((Collection<String>)batchPersonIterator.next(), iArrangeShift);
                    continue block7;
                }
            }
        }
        this.doArrange();
    }

    public void doArrange() {
        if (this.allScheduleShift.size() > 0) {
            Map<String, Map<String, Integer>> holidayMap = this.getRelateHoliday();
            Map<String, RangeMap<Date, ScheduleShiftInfo>> scheduleMap = this.getHisSchedule();
            for (BaseArrangeShift o : this.allScheduleShift) {
                ArrangeShiftByCopy copy;
                o.setHolidayMap(holidayMap.get(o.getPersonInfo().getNumber()));
                o.setScheduleShiftMap(scheduleMap.get(o.getPersonInfo().getNumber()));
                if (o.getClass() == ArrangeShiftByCopy.class && (copy = (ArrangeShiftByCopy)o).getSource() != null && copy.getSource().getNumber() != null) {
                    copy.setSourceHolidayMap(holidayMap.get(copy.getSource().getNumber()));
                }
                o.arrangeShift();
                this.errorMsg.addAll(o.getErrorMsg());
            }
        }
    }

    private Map<String, RangeMap<Date, ScheduleShiftInfo>> getHisSchedule() {
        HashSet<String> personNums = new HashSet<String>();
        Date minDate = null;
        Date maxDate = null;
        for (BaseArrangeShift arrangeShift : this.allScheduleShift) {
            personNums.add(arrangeShift.getPersonInfo().getNumber());
            if (minDate == null) {
                minDate = arrangeShift.getBeginDate();
                maxDate = arrangeShift.getEndDate();
            }
            if (minDate.after(arrangeShift.getBeginDate())) {
                minDate = arrangeShift.getBeginDate();
            }
            if (maxDate == null || maxDate.before(arrangeShift.getEndDate())) {
                maxDate = arrangeShift.getEndDate();
            }
            if (arrangeShift.getArrangeWay() != EArrangeWay.arrangeByCopyAppoint && arrangeShift.getArrangeWay() != EArrangeWay.arrangeByCopySelf) continue;
            ArrangeShiftByCopy copy = (ArrangeShiftByCopy)arrangeShift;
            if (minDate == null || minDate.after(copy.getSourceBeginDate())) {
                minDate = copy.getSourceBeginDate();
            }
            if (maxDate == null || maxDate.before(copy.getSourceEndDate())) {
                maxDate = copy.getSourceEndDate();
            }
            if (copy.getSource() == null || copy.getSource().getNumber() == null) continue;
            personNums.add(copy.getSource().getNumber());
        }
        return SaveShiftUtile.getDefaultScheduleShiftFromHIS(this.ctx, new HashSet<String>(personNums), AtsCommonUtile.getDateFormat().format(minDate), AtsCommonUtile.getDateFormat().format(maxDate), null);
    }

    private Map<String, Map<String, Integer>> getRelateHoliday() {
        HashSet<String> personNums = new HashSet<String>();
        Date minDate = null;
        Date maxDate = null;
        for (BaseArrangeShift arrangeShift : this.allScheduleShift) {
            personNums.add(arrangeShift.getPersonInfo().getNumber());
            if (minDate == null) {
                minDate = arrangeShift.getBeginDate();
                maxDate = arrangeShift.getEndDate();
            }
            if (minDate.after(arrangeShift.getBeginDate())) {
                minDate = arrangeShift.getBeginDate();
            }
            if (maxDate == null || maxDate.before(arrangeShift.getEndDate())) {
                maxDate = arrangeShift.getEndDate();
            }
            if (arrangeShift.getArrangeWay() != EArrangeWay.arrangeByCopyAppoint && arrangeShift.getArrangeWay() != EArrangeWay.arrangeByCopySelf) continue;
            ArrangeShiftByCopy copy = (ArrangeShiftByCopy)arrangeShift;
            if (minDate == null || minDate.after(copy.getSourceBeginDate())) {
                minDate = copy.getSourceBeginDate();
            }
            if (maxDate == null || maxDate.before(copy.getSourceEndDate())) {
                maxDate = copy.getSourceEndDate();
            }
            if (copy.getSource() == null || copy.getSource().getNumber() == null) continue;
            personNums.add(copy.getSource().getNumber());
        }
        return ArrangeShiftUtile.getPersonHoliday(this.ctx, personNums, AtsCommonUtile.getDateFormat().format(minDate), AtsCommonUtile.getDateFormat().format(maxDate));
    }

    @Override
    public List<JSONObject> showShiftResult() {
        HashMap<String, JSONArray> shiftResult = new HashMap<String, JSONArray>(this.allScheduleShift.size());
        int noPersonNumCount = 1;
        if (this.allScheduleShift.size() > 0) {
            for (BaseArrangeShift arrangeShift : this.allScheduleShift) {
                String personNum;
                String string = personNum = arrangeShift.getPersonInfo() != null ? arrangeShift.getPersonInfo().getNumber() : "";
                if (StringUtils.isNotEmpty((String)personNum)) {
                    if (shiftResult.get(personNum) != null) {
                        ((JSONArray)shiftResult.get(personNum)).addAll((Collection)arrangeShift.showArrangeResult());
                        continue;
                    }
                    shiftResult.put(personNum, arrangeShift.showArrangeResult());
                    continue;
                }
                shiftResult.put("noNumS" + noPersonNumCount, arrangeShift.showArrangeResult());
                ++noPersonNumCount;
            }
        }
        ArrayList<JSONObject> results = new ArrayList<JSONObject>(shiftResult.size());
        for (String person : shiftResult.keySet()) {
            JSONObject personSchedule = new JSONObject(2);
            personSchedule.put("personNum", (Object)person);
            personSchedule.put("scheduleData", shiftResult.get(person));
            results.add(personSchedule);
        }
        return results;
    }

    @Override
    public ScheduleShiftCollection getArrangeResult() {
        ScheduleShiftCollection returnData = new ScheduleShiftCollection();
        if (this.allScheduleShift.size() > 0) {
            for (BaseArrangeShift arrangeShift : this.allScheduleShift) {
                returnData.addCollection(arrangeShift.getArrangeResult());
            }
        }
        return returnData;
    }

    @Override
    public void arrangeByAppointedShift(Collection<String> personNums, ArrangeShiftByShift arrangeShiftByShift) throws CloneNotSupportedException {
        if (StringUtils.isEmpty((String)arrangeShiftByShift.getAtsShiftId())) {
            this.arrangeByDefaultShift(personNums, arrangeShiftByShift);
            return;
        }
        AtsShiftInfo atsShiftInfo = null;
        try {
            atsShiftInfo = AtsShiftFactory.getLocalInstance(this.ctx).getAtsShiftInfo((IObjectPK)new ObjectUuidPK(arrangeShiftByShift.getAtsShiftId()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (atsShiftInfo != null) {
            ScheduleShiftInfo scheduleShiftInfo = new ScheduleShiftInfo();
            scheduleShiftInfo.setDefaultShift(atsShiftInfo);
            RangeMap<Date, ScheduleShiftInfo> scheduleMap = new RangeMap<Date, ScheduleShiftInfo>(1);
            scheduleMap.put(new RangeDate(arrangeShiftByShift.getBeginDate(), arrangeShiftByShift.getEndDate()), scheduleShiftInfo);
            for (String personNum : personNums) {
                this.assembleArrangeByShifParam(personNum, scheduleMap, arrangeShiftByShift);
            }
        }
    }

    public void arrangeByDefaultShift(Collection<String> personNums, ArrangeShiftByShift arrangeShiftByShift) throws CloneNotSupportedException {
        Map<String, RangeMap<Date, ScheduleShiftInfo>> scheduleMap = SaveShiftUtile.getDefaultScheduleShiftFromHIS(this.ctx, new HashSet<String>(personNums), AtsCommonUtile.formateDate(arrangeShiftByShift.getBeginDate()), AtsCommonUtile.formateDate(arrangeShiftByShift.getEndDate()), null);
        for (String personNum : personNums) {
            this.assembleArrangeByShifParam(personNum, scheduleMap.get(personNum), arrangeShiftByShift);
        }
    }

    private void assembleArrangeByShifParam(String personNum, RangeMap<Date, ScheduleShiftInfo> scheduleShiftMap, ArrangeShiftByShift arrangeShiftByShift) throws CloneNotSupportedException {
        if (scheduleShiftMap == null) {
            AtsLog.getWSLog().error((Object)"no find point schedule shift!");
            return;
        }
        AtsLog.getWSLog().error((Object)("point shift schedule personNum:" + personNum));
        ArrangeShiftByShift arrange = (ArrangeShiftByShift)arrangeShiftByShift.clone();
        PersonInfo personInfo = new PersonInfo();
        personInfo.setNumber(personNum);
        arrange.setPersonInfo(personInfo);
        arrange.setAppointedScheduleShift(scheduleShiftMap);
        this.allScheduleShift.add(arrange);
    }

    @Override
    public void arrangeByTurns(Collection<String> personNums, ArrangeShiftByTurns arrangeShitByTurns) throws CloneNotSupportedException {
        Map<Integer, AtsTurnShiftEntryInfo> turnShiftEntry = ArrangeShiftUtile.getTurnShiftEntrys(this.ctx, arrangeShitByTurns.getTurnShiftId());
        for (String personNum : personNums) {
            ArrangeShiftByTurns temp = (ArrangeShiftByTurns)arrangeShitByTurns.clone();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setNumber(personNum);
            temp.setPersonInfo(personInfo);
            temp.setTurnShiftId(arrangeShitByTurns.getTurnShiftId());
            temp.setTurnShiftEntrys(turnShiftEntry);
            this.allScheduleShift.add(temp);
        }
    }

    @Override
    public void arrangeByPostoneTurns(Collection<String> personNums, ArrangeShiftByTurns arrangeShitByTurns) throws CloneNotSupportedException {
        Map<String, JSONObject> personNumToLatestSheduleTurn = ArrangeShiftUtile.getshiftTurnFromSchedule(this.ctx, personNums, arrangeShitByTurns.getEndDate());
        HashSet<String> turnShiftIds = new HashSet<String>();
        for (JSONObject segmentAndTurnId : personNumToLatestSheduleTurn.values()) {
            if (!StringUtils.isNotEmpty((String)segmentAndTurnId.getString("turnShiftId"))) continue;
            turnShiftIds.add(segmentAndTurnId.getString("turnShiftId"));
        }
        if (AtsCollectionUtile.isEmpty(personNumToLatestSheduleTurn)) {
            AtsLog.getWSLog().error((Object)"find no person while postpone turnshift schedule!");
            this.errorMsg.add(MLUtile.getRes(AtsScheduleShiftResEnum.ScheduleShiftOrder5, this.ctx));
            return;
        }
        Map<String, Map<Integer, AtsTurnShiftEntryInfo>> turnShiftEntrys = ArrangeShiftUtile.getTurnShiftEntrys(this.ctx, turnShiftIds);
        for (String personNum : personNums) {
            String turnShiftId;
            if (StringUtils.isNotEmpty((String)personNum) && personNumToLatestSheduleTurn.get(personNum) != null && turnShiftEntrys.get(turnShiftId = personNumToLatestSheduleTurn.get(personNum).getString("turnShiftId")) != null) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setNumber(personNum);
                ArrangeShiftByTurns copy = (ArrangeShiftByTurns)arrangeShitByTurns.clone();
                copy.setPersonInfo(personInfo);
                Date beignDate = personNumToLatestSheduleTurn.get(personNum).getDate("attendDate");
                if (!beignDate.before(arrangeShitByTurns.getEndDate())) {
                    AtsLog.getWSLog().error((Object)("person number:" + personNum + "already has schedule while while postpone turnshift schedule"));
                    this.errorMsg.add(MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.ScheduleShiftOrder4, this.ctx, personNum));
                    continue;
                }
                copy.setBeginDate(AtsDateUtils.getNextDay(beignDate));
                copy.setTurnShiftEntrys(turnShiftEntrys.get(turnShiftId));
                copy.setTurnShiftId(turnShiftId);
                copy.setStartSegment(personNumToLatestSheduleTurn.get(personNum).getIntValue("currentSegment") + 1);
                this.allScheduleShift.add(copy);
                continue;
            }
            AtsLog.getWSLog().error((Object)("person number:" + personNum + "find no turnShift or already schedule while while postpone turnshift schedule"));
            this.errorMsg.add(MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.ScheduleShiftOrder3, this.ctx, personNum));
        }
    }

    @Override
    public void arrangeByUserDefined(Collection<String> personNums, IArrangeShift iArrangeShift) throws Exception {
    }

    @Override
    public void arrangShiftByCopy(Collection<String> personNums, ArrangeShiftByCopy arrangeShiftByCopy) throws CloneNotSupportedException {
        boolean isCopySpecificMan;
        boolean bl = isCopySpecificMan = arrangeShiftByCopy.getSource() != null && !StringUtils.isEmpty((String)arrangeShiftByCopy.getSource().getId().toString());
        if (isCopySpecificMan && !this.updateSourcePersonInfo(arrangeShiftByCopy)) {
            return;
        }
        Collection<String> source = isCopySpecificMan ? Collections.singleton(arrangeShiftByCopy.getSource().getNumber()) : personNums;
        this.updateCopySourceEndDate(arrangeShiftByCopy);
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"defaultShift.*", "defaultShift.items.*"});
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)arrangeShiftByCopy.getHrOrgUnitIdD()));
        filterInfo.getFilterItems().add(new FilterItemInfo("dayType", (Object)2, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("dayType", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("defaultShift", null, CompareType.NOTEQUALS));
        filterInfo.setMaskString(" #0 and (#1 or #2 or #3 ) ");
        evi.setFilter(filterInfo);
        Map<String, Map<String, ScheduleShiftInfo>> scheduleShifts = ArrangeShiftUtile.getScheduleShifts(this.ctx, source, AtsCommonUtile.getDateFormat().format(arrangeShiftByCopy.getSourceBeginDate()), AtsCommonUtile.getDateFormat().format(arrangeShiftByCopy.getSourceEndDate()), evi);
        if (AtsCollectionUtile.isEmpty(scheduleShifts)) {
            AtsLog.getWSLog().error((Object)"find no copy source shift!");
            this.errorMsg.add(MLUtile.getRes(AtsShiftResEnum.NoShiftFromCopySource, this.ctx));
            return;
        }
        HashSet<String> needSearchPre7DayPerson = this.updateLatestSourceSchedule(scheduleShifts, arrangeShiftByCopy);
        needSearchPre7DayPerson = needSearchPre7DayPerson.size() == 0 ? null : (isCopySpecificMan ? new HashSet<String>(personNums) : needSearchPre7DayPerson);
        Map<Object, Object> latest7daySchedule = new HashMap();
        if (!AtsCollectionUtile.isEmpty(needSearchPre7DayPerson)) {
            latest7daySchedule = this.getAheadSchedule(arrangeShiftByCopy, needSearchPre7DayPerson);
        }
        for (String personNum : personNums) {
            Map<String, ScheduleShiftInfo> sourceSchedule = scheduleShifts.get(isCopySpecificMan ? arrangeShiftByCopy.getSource().getNumber() : personNum);
            if (sourceSchedule != null) {
                ArrangeShiftByCopy arrangeShifTemp = (ArrangeShiftByCopy)arrangeShiftByCopy.clone();
                PersonInfo personInfo = new PersonInfo();
                personInfo.setNumber(personNum);
                arrangeShifTemp.setPersonInfo(personInfo);
                arrangeShifTemp.setSourceScheduleShifts(sourceSchedule);
                if (latest7daySchedule.get(personNum) != null) {
                    arrangeShifTemp.setLatestSchedule((ScheduleShiftInfo)latest7daySchedule.get(personNum));
                }
                this.allScheduleShift.add(arrangeShifTemp);
                continue;
            }
            AtsLog.getWSLog().error((Object)("while copy schedule ,person number:" + personNum + "can not find source schedule!"));
            this.errorMsg.add(MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.CopyShiftFailWithoutShift, this.ctx, personNum));
        }
    }

    private boolean updateSourcePersonInfo(ArrangeShiftByCopy arrangeShiftByCopy) {
        try {
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)this.ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(arrangeShiftByCopy.getSource().getId().toString()));
            if (personInfo == null || StringUtils.isEmpty((String)personInfo.getNumber())) {
                AtsLog.getWSLog().error((Object)"find no person while copu schedule !please confirm the person exist");
                this.errorMsg.add(MLUtile.getRes(AtsHolidayResEnum.NoEmployeeAndCheck, this.ctx));
                return false;
            }
            arrangeShiftByCopy.setSource(personInfo);
        }
        catch (Exception e) {
            AtsLog.getWSLog().error((Object)"system error ,please try again");
            this.errorMsg.add(MLUtile.getRes(AtsCommonResEnum.ServerError, this.ctx));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void updateCopySourceEndDate(ArrangeShiftByCopy arrangeShiftByCopy) {
        Calendar calendar;
        long scheduleInterval = arrangeShiftByCopy.getEndDate().getTime() - arrangeShiftByCopy.getBeginDate().getTime();
        long sourceScheduleInterval = arrangeShiftByCopy.getSourceEndDate().getTime() - arrangeShiftByCopy.getSourceBeginDate().getTime();
        long absoutDiff = Math.abs(sourceScheduleInterval - scheduleInterval);
        if (scheduleInterval < sourceScheduleInterval) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(arrangeShiftByCopy.getSourceEndDate().getTime() - absoutDiff);
            arrangeShiftByCopy.setSourceEndDate(calendar.getTime());
        }
        if (scheduleInterval > sourceScheduleInterval) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(arrangeShiftByCopy.getEndDate().getTime() - absoutDiff);
            arrangeShiftByCopy.setEndDate(calendar.getTime());
        }
    }

    private Set<String> updateLatestSourceSchedule(Map<String, Map<String, ScheduleShiftInfo>> scheduleShifts, ArrangeShiftByCopy arrangeShiftByCopy) {
        if (!arrangeShiftByCopy.isHolidayWithWorkDayUnshift()) {
            return new HashSet<String>(0);
        }
        HashSet<String> personNums = new HashSet<String>();
        for (String personNum : scheduleShifts.keySet()) {
            boolean hasShift = false;
            boolean hasHolidayNoShift = false;
            for (ScheduleShiftInfo currentSchedule : scheduleShifts.get(personNum).values()) {
                if (currentSchedule.getDefaultShift() != null) {
                    hasShift = true;
                }
                if (currentSchedule.getDayType() != DayTypeEnum.legalHoliday || currentSchedule.getDefaultShift() != null) continue;
                hasHolidayNoShift = true;
            }
            if (!hasHolidayNoShift || hasShift) continue;
            personNums.add(personNum);
        }
        return personNums;
    }

    private Map<String, ScheduleShiftInfo> getAheadSchedule(ArrangeShiftByCopy arrangeShiftByCopy, Set<String> personNums) {
        String endDate = AtsCommonUtile.getPreDayStr(arrangeShiftByCopy.getBeginDate());
        String beginDate = AtsCommonUtile.dateAddStr(endDate, 5, -7);
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"defaultShift.*", "defaultShift.items.*"});
        AtsViewUtile.getViewByFilter("hrOrgUnit", (Object)arrangeShiftByCopy.getHrOrgUnitIdD(), evi);
        AtsViewUtile.getViewByFilter("defaultShift", null, CompareType.NOTEQUALS, evi);
        Map<String, Map<String, ScheduleShiftInfo>> latest7daySchedule = ArrangeShiftUtile.getScheduleShifts(this.ctx, personNums, beginDate, endDate, evi);
        HashMap<String, ScheduleShiftInfo> personLatestSchedule = new HashMap<String, ScheduleShiftInfo>(latest7daySchedule.size());
        ScheduleShiftInfo currentSchedule = null;
        Iterator<String> it = latest7daySchedule.keySet().iterator();
        while (it.hasNext()) {
            currentSchedule = null;
            String personNum = it.next();
            for (ScheduleShiftInfo tempSchedule : latest7daySchedule.get(personNum).values()) {
                if (currentSchedule != null && !tempSchedule.getAttendDate().after(currentSchedule.getAttendDate())) continue;
                currentSchedule = tempSchedule;
            }
            personLatestSchedule.put(personNum, currentSchedule);
        }
        return personLatestSchedule;
    }

    public List<BaseArrangeShift> getAllScheduleShift() {
        return this.allScheduleShift;
    }

    public void setAllScheduleShift(List<BaseArrangeShift> allScheduleShift) {
        this.allScheduleShift = allScheduleShift;
    }

    public Set<String> getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(Set<String> errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }
}

