/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.matchSchedule;

import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.AtsScheduleIntelInfo;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.BackJob.BackJobUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.OneFieldProcessor;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.plan.BasePlanManager;
import com.kingdee.eas.hr.ats.workShift.plan.RangeSettingAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.MatchAnalysorManager;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.MatchDataInfo;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.MatchScheduleUtile;
import com.kingdee.eas.hr.ats.workShift.plan.util.AttendanceLogUtil;
import com.kingdee.eas.hr.ats.workShift.save.SaveShiftUtile;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class MatchScheduleManager
extends BasePlanManager {
    private static ThreadLocal<AttendanceLogInfo> ThreadLocalAttendanceLogInfo = new ThreadLocal();

    public MatchScheduleManager() {
    }

    public MatchScheduleManager(Context ctx) {
        super(ctx);
    }

    @Override
    public void execPlaneInner(String idOrNumberColls) throws Exception {
        super.execPlaneInner(idOrNumberColls);
        StringBuffer sql = new StringBuffer();
        sql.append(" select entry.fid fid from T_ATS_AtsScheduleIntelSet planeSet ");
        sql.append(" inner join T_ATS_AtsScheduleIntel entry on planeSet.fid = entry.FAtsScheduleIntelSetID");
        sql.append(" where 1=1");
        if (StringUtils.isNotEmpty((String)idOrNumberColls)) {
            String appointedSet = AtsCollectionUtile.joinForSqlWithBrackets(Arrays.asList(idOrNumberColls.split(",|\uff0c")));
            sql.append(" and ( planeSet.fid in ").append(appointedSet);
            sql.append(" or planeSet.fnumber in ").append(appointedSet).append(")");
        } else {
            sql.append(" and planeSet.fautomatic = 1 and planeSet.fstate = 1");
        }
        sql.append(" order by planeSet.fnumber , entry.fschedulePriority");
        String jobId = (String)this.ctx.get((Object)"jobInstId");
        AttendanceLogInfo attendanceLog = AttendanceLogUtil.initAttendanceLogInfo(this.ctx, jobId);
        ThreadLocalAttendanceLogInfo.set(attendanceLog);
        long startTime = System.currentTimeMillis();
        new OneFieldProcessor<String>(sql.toString(), this.ctx){

            @Override
            protected void afterGetAllRow(Context ctx, List<String> rows) {
                MatchScheduleManager.this.doSchedulePlane(MatchScheduleUtile.getPlanes(ctx, rows, true));
            }
        }.process();
        String updateSql = "update T_HR_ATS_AttendanceLog set FCostSumTime=? ,FCostTime=? , FRemainTime=? ,fcalstatus=?  where FJobid = ? ";
        Object[] params = new Object[]{BigDecimal.valueOf(System.currentTimeMillis() - startTime), BigDecimal.valueOf(System.currentTimeMillis() - startTime), BigDecimal.valueOf(0L), 2, jobId};
        DbUtil.execute((Context)this.ctx, (String)updateSql, (Object[])params);
        ThreadLocalAttendanceLogInfo.remove();
    }

    @Override
    protected void beforeExecPlane(String ids) throws Exception {
        super.beforeExecPlane(ids);
        if (BackJobUtile.hasRunningJob(this.ctx, "com.kingdee.eas.hr.ats.ScheduleShiftFunction", "matchSchedule")) {
            String msg = MLUtile.getRes(AtsNounCommonResEnum.WaitForRuningMission, this.ctx);
            this.ctx.put((Object)"exception", (Object)msg);
            BackJobUtile.reStartJob(this.ctx, 5000L);
            AtsLog.getWSLog().error((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    @Override
    public Set<String> rangSettingCheck(Collection<String> ids) {
        List<AtsScheduleIntelInfo> schedulePlanes = MatchScheduleUtile.getPlanes(this.ctx, ids, false);
        if (AtsCollectionUtile.isEmpty(schedulePlanes)) {
            this.errorMsg.add(MLUtile.getRes(AtsAttenceResEnum.FileWithoutItem, this.ctx));
            AtsLog.getWSLog().error((Object)"no entry in plan!");
            return new LinkedHashSet<String>(this.errorMsg);
        }
        return this.rangSettingCheck(schedulePlanes, schedulePlanes.get(0).getAtsScheduleIntelSet());
    }

    protected void doSchedulePlane(List<AtsScheduleIntelInfo> schedulePlanes) {
        if (AtsCollectionUtile.isEmpty(schedulePlanes)) {
            return;
        }
        for (AtsScheduleIntelInfo entry : schedulePlanes) {
            AtsLog.getWSLog().error((Object)("prepare plan enviroment\uff1a" + entry));
            MatchDataInfo matchDataInfo = new MatchDataInfo();
            matchDataInfo.setMatchPlan(entry);
            this.beforeMatch(matchDataInfo);
            matchDataInfo.setCtx(this.ctx);
            RangeSettingAnalysor rangeSettingAnalysor = this.createRangeSettingAnalysor(entry, this.ctx);
            rangeSettingAnalysor.setHrOrgUnit(entry.getAtsScheduleIntelSet().getHrOrgUnit());
            rangeSettingAnalysor.setBeginDate(AtsCommonUtile.formateTime(matchDataInfo.getBeginDate()));
            rangeSettingAnalysor.setEndDate(AtsCommonUtile.formateTime(matchDataInfo.getEndDate()));
            rangeSettingAnalysor.analyze();
            this.doSchedulePlaneByPage(matchDataInfo, rangeSettingAnalysor);
        }
    }

    protected void doSchedulePlaneByPage(MatchDataInfo matchDataInfo, RangeSettingAnalysor rangeSettingAnalysor) {
        AtsLog.getWSLog().error((Object)"execute match plan by page...");
        new OneFieldProcessor<String>(rangeSettingAnalysor.getRangeSettingSql().toString(), this.ctx){

            @Override
            protected void afterGetAllRow(Context ctx, List<String> rows) {
                AtsLog.getWSLog().info((Object)"cur match person");
                AtsLog.getWSLog().info(rows);
                MatchDataInfo matchDataInfo = (MatchDataInfo)this.outData;
                Map<String, RangeMap<Date, ScheduleShiftInfo>> scheduleMap = SaveShiftUtile.getDefaultScheduleShiftFromHIS(ctx, new HashSet<String>(rows), AtsDateUtils.dateShortToString(matchDataInfo.getBeginDate()), AtsDateUtils.dateShortToString(matchDataInfo.getEndDate()), null);
                matchDataInfo.setScheduleMap(scheduleMap);
                String machManagerClass = matchDataInfo.getMatchPlan().getMachAnalyzeClass();
                matchDataInfo.setPersonNums(rows);
                if (StringUtils.isEmpty((String)machManagerClass)) {
                    machManagerClass = MatchAnalysorManager.class.getName();
                } else {
                    AtsLog.getWSLog().error((Object)("match executor is not default:" + machManagerClass));
                }
                if (StringUtils.isNotEmpty((String)machManagerClass)) {
                    MatchAnalysorManager matchManger = AtsCommonUtile.getInstance(machManagerClass, MatchAnalysorManager.class);
                    if (matchManger != null) {
                        AttendanceLogUtil.generateAttendanceLogInfo((AttendanceLogInfo)ThreadLocalAttendanceLogInfo.get(), rows.size());
                        matchManger.setCtx(ctx);
                        matchManger.setAttendanceLogInfo((AttendanceLogInfo)ThreadLocalAttendanceLogInfo.get());
                        matchManger.doMatch(matchDataInfo);
                        ThreadLocalAttendanceLogInfo.set(matchManger.getAttendanceLogInfo());
                        CoreBaseCollection attendanceLogEntryCollection = matchManger.getAttendanceLogEntryCollection();
                        AttendanceLogUtil.updateAttendanceLogAndEntry(ctx, (AttendanceLogInfo)ThreadLocalAttendanceLogInfo.get(), attendanceLogEntryCollection);
                    } else {
                        AtsLog.getWSLog().error((Object)("instance executor error" + machManagerClass));
                    }
                }
            }
        }.setOutData(matchDataInfo).process();
    }

    private void beforeMatch(MatchDataInfo matchDataInfo) {
        int frontDate = matchDataInfo.getMatchPlan().getAtsScheduleIntelSet().getFrontDate();
        Date taskBegin = AtsCommonUtile.getDayEnd(((Calendar)this.getTaskStartTime().clone()).getTime());
        Date matchBegin = AtsCommonUtile.dateAdd(taskBegin, 6, -frontDate);
        matchDataInfo.setEndDate(taskBegin);
        matchDataInfo.setBeginDate(AtsCommonUtile.getDayStart(matchBegin));
    }

    public void updateMatchShchedulToSchedule() {
    }
}

