/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.PersonBUBrowseCollection;
import com.kingdee.shr.base.bizmanage.PersonBUBrowseFactory;
import com.kingdee.shr.base.bizmanage.PersonBUBrowseInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.bizmanage.PersonBizManageFacadeFactory;
import com.kingdee.shr.base.bizmanage.app.AbstractPersonBUBrowseToBURelationControllerBean;
import com.kingdee.shr.base.bizmanage.impl.SHRPersonBizManageImpl;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageHelpUtil;
import com.kingdee.shr.base.bizmanage.util.SHREmpPosOrgRelationUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PersonBUBrowseToBURelationControllerBean
extends AbstractPersonBUBrowseToBURelationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.bizmanage.app.PersonBUBrowseToBURelationControllerBean");

    @Override
    protected void _generatePersonBUBrowseReport(Context ctx, List empPosRelationIdsListArray, Map bizManageTypeHROrgMap, String UserID, String effectDate) throws BOSException, EASBizException {
        if (empPosRelationIdsListArray.size() == 0 || bizManageTypeHROrgMap.size() == 0) {
            this._clearBrowserData(ctx, UserID);
        } else {
            this._clearBrowserDataByBuRelation(ctx, empPosRelationIdsListArray, bizManageTypeHROrgMap, UserID, effectDate);
        }
        this.doGeneratingPersonBUBrowseReport(ctx, empPosRelationIdsListArray, bizManageTypeHROrgMap, UserID, effectDate);
    }

    @Override
    protected void _clearBrowserData(Context ctx, String UserID) throws BOSException, EASBizException {
        String deleteSql = "delete from T_HR_PersonBUBrowse where fCreatorId = '" + UserID + "' and FIPAddress = '" + ctx.getClientHostIP() + "'";
        DbUtil.execute((Context)ctx, (String)deleteSql);
    }

    protected void _clearBrowserDataByBuRelation(Context ctx, List empPosRelationIdsListArray, Map bizManageTypeHROrgMap, String UserID, String effectDate) throws BOSException, EASBizException {
        String empOrgIds = "";
        for (int i = 0; i < empPosRelationIdsListArray.size(); ++i) {
            String empPosRelationID = (String)empPosRelationIdsListArray.get(i);
            empOrgIds = empOrgIds + ",'" + empPosRelationID + "'";
        }
        if (!empOrgIds.equals("")) {
            for (Map.Entry entry : bizManageTypeHROrgMap.entrySet()) {
                String bizManageTypeID = (String)entry.getKey();
                String deleteSql = "DELETE FROM T_HR_PersonBUBrowse WHERE FPersonID IN (SELECT FPERSONID FROM T_HR_EmpOrgRelation WHERE FID IN (" + empOrgIds.substring(1) + ")) AND FbizManageTypeID = '" + bizManageTypeID + "' AND FCreatorId = '" + UserID + "' AND FIPAddress = '" + ctx.getClientHostIP() + "'";
                DbUtil.execute((Context)ctx, (String)deleteSql);
            }
        }
    }

    protected void doGeneratingPersonBUBrowseReport(Context ctx, List empPosRelationIdsListArray, Map bizManageTypeHROrgMap, String UserID, String effectDate) throws BOSException {
        Map ORMap = bizManageTypeHROrgMap;
        Set bizManageTypeSet = ORMap.keySet();
        String personID = null;
        String positionID = null;
        String empPosOrgRelationID = null;
        String empPostExpHisID = null;
        String oldHROrgUnitID = null;
        ArrayList<String> batchInsertSql = new ArrayList<String>();
        for (int i = 0; i < empPosRelationIdsListArray.size(); ++i) {
            empPosOrgRelationID = (String)empPosRelationIdsListArray.get(i);
            EmpPosOrgRelationInfo info = new EmpPosOrgRelationInfo();
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(SHREmpPosOrgRelationUtils.getSelectorCollection());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)empPosOrgRelationID));
            view.setFilter(filter);
            EmpPosOrgRelationCollection coll = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
            if (coll.size() <= 0) continue;
            info = coll.get(0);
            personID = info.getPerson().getId().toString();
            positionID = info.getPosition().getId().toString();
            if (empPosOrgRelationID == null) continue;
            for (String bizManageTypeItem : bizManageTypeSet) {
                try {
                    oldHROrgUnitID = this.getExistsPersonBURealtionHROrgUnitID(ctx, personID, empPosOrgRelationID, bizManageTypeItem);
                    empPostExpHisID = this.getEmpPostExpHisID(ctx, personID, positionID);
                    batchInsertSql.add(this.getFullInsertSqlOfBrowseTable(ctx, personID, empPosOrgRelationID, empPostExpHisID, bizManageTypeItem, oldHROrgUnitID, (String)ORMap.get(bizManageTypeItem), UserID, effectDate));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        SHRBizManageCommonTool.batchInsertReportDataSQL(ctx, batchInsertSql);
    }

    private String getEmpPosOrgRelationID(Context ctx, String personID, String positionID) throws BOSException, SQLException {
        String query = "SELECT FID FROM T_HR_EmpOrgRelation WHERE FPersonID = '" + personID + "' AND FPositionID = '" + positionID + "' AND FLEFFDT = {TS '2199-12-31'}";
        IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)query);
        if (ir.size() > 0) {
            ir.next();
            return ir.getString("FID");
        }
        return null;
    }

    private String getEmpPostExpHisID(Context ctx, String personID, String positionID) throws BOSException, SQLException {
        String query = "SELECT FID FROM T_HR_EmpPostExperienceHis WHERE FPersonID = '" + personID + "' AND FPositionID = '" + positionID + "' AND FLEFFDT = {TS '2199-12-31'}";
        IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)query);
        if (ir.size() > 0) {
            ir.next();
            return ir.getString("FID");
        }
        return null;
    }

    private String getExistsPersonBURealtionHROrgUnitID(Context ctx, String personID, String empPosOrgRelationID, String bizManageTypeID) throws BOSException, SQLException {
        String query = "SELECT FHrOrgUnitID FROM T_HR_PersonBURelation WHERE FpersonID = '" + personID + "' AND FEmpOrgRelationID = '" + empPosOrgRelationID + "' AND  FBizManageTypeID = '" + bizManageTypeID + "' AND FState = " + 1;
        IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)query);
        if (ir.size() > 0) {
            ir.next();
            return ir.getString("FHrOrgUnitID");
        }
        return null;
    }

    @Override
    protected void _savePersonBUBrowseToRelation(Context ctx, String UserID) throws BOSException, EASBizException {
        PersonBUBrowseCollection coll = PersonBUBrowseFactory.getLocalInstance(ctx).getPersonBUBrowseCollection(" where creator = '" + UserID + "' and IPAddress = '" + ctx.getClientHostIP() + "'");
        ArrayList<PersonBURelationInfo> transInfoList = this.transPersonBUBrowseColl2PersonBURelationColl(ctx, coll);
        PersonBizManageFacadeFactory.getLocalInstance(ctx).batchAddNewPersonBizManage(transInfoList);
    }

    @Override
    protected void _savePersonBUBrowseToRelation(Context ctx, List saveBrowseToBUIds) throws BOSException, EASBizException {
        StringBuffer inSql = new StringBuffer();
        for (int i = 0; i < saveBrowseToBUIds.size(); ++i) {
            inSql.append(saveBrowseToBUIds.get(i)).append("','");
        }
        inSql.insert(0, "'").delete(inSql.length() - 2, inSql.length());
        PersonBUBrowseCollection coll = PersonBUBrowseFactory.getLocalInstance(ctx).getPersonBUBrowseCollection(" where id IN (" + inSql + ") ");
        ArrayList<PersonBURelationInfo> transInfoList = this.transPersonBUBrowseColl2PersonBURelationColl(ctx, coll);
        PersonBizManageFacadeFactory.getLocalInstance(ctx).batchAddNewPersonBizManage(transInfoList);
    }

    public ArrayList<PersonBURelationInfo> transPersonBUBrowseColl2PersonBURelationColl(Context ctx, PersonBUBrowseCollection coll) {
        ArrayList<PersonBURelationInfo> resList = new ArrayList<PersonBURelationInfo>();
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        Date now = new Date();
        for (int i = 0; i < coll.size(); ++i) {
            PersonBUBrowseInfo item = coll.get(i);
            try {
                if (SHRPersonBizManageImpl.checkPersonBURelationExist(ctx, item.getEmpOrgRelation().getId().toString(), item.getPerson().getId().toString(), item.getBizManageType().getId().toString(), item.getNewHROrgUnit().getId().toString(), "1")) continue;
                PersonBURelationInfo tempInfo = new PersonBURelationInfo();
                tempInfo.setPerson(item.getPerson());
                tempInfo.setEmpOrgRelation(item.getEmpOrgRelation());
                tempInfo.setEmpPostExpHis(item.getEmpPostExpHis());
                tempInfo.setBizManageType(item.getBizManageType());
                tempInfo.setHrOrgUnit(item.getNewHROrgUnit());
                tempInfo.setState(BizManageState.New);
                tempInfo.setUseDefault(SHRBizManageHelpUtil.isPerosnBuRelationDefault(ctx, item.getBizManageType().getId().toString(), item.getEmpOrgRelation().getId().toString(), item.getNewHROrgUnit().getId().toString()));
                tempInfo.setCreator(currentUser);
                tempInfo.setLastUpdateUser(currentUser);
                tempInfo.setLastUpdateTime(new Timestamp(now.getTime()));
                tempInfo.setCreateTime(new Timestamp(now.getTime()));
                tempInfo.setEFFDT(item.getEFFDT());
                resList.add(tempInfo);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return resList;
    }

    @Override
    protected void _enablePersonBUBrowseToRelation(Context ctx, List saveBrowseToBUIds) throws BOSException, EASBizException {
        StringBuffer inSql = new StringBuffer();
        for (int i = 0; i < saveBrowseToBUIds.size(); ++i) {
            inSql.append(saveBrowseToBUIds.get(i)).append("','");
        }
        inSql.insert(0, "'").delete(inSql.length() - 2, inSql.length());
        PersonBUBrowseCollection coll = PersonBUBrowseFactory.getLocalInstance(ctx).getPersonBUBrowseCollection(" where id IN (" + inSql + ") ");
        ArrayList<PersonBURelationInfo> transInfoList = this.transPersonBUBrowseColl2PersonBURelationColl(ctx, coll);
        PersonBizManageFacadeFactory.getLocalInstance(ctx).batchAddSubmitNewPersonBizManage(transInfoList);
    }

    @Override
    protected void _enablePersonBUBrowseToRelation(Context ctx, String UserID) throws BOSException, EASBizException {
        PersonBUBrowseCollection coll = PersonBUBrowseFactory.getLocalInstance(ctx).getPersonBUBrowseCollection(" where creator = '" + UserID + "' and IPAddress = '" + ctx.getClientHostIP() + "'");
        ArrayList<PersonBURelationInfo> transInfoList = this.transPersonBUBrowseColl2PersonBURelationColl(ctx, coll);
        PersonBizManageFacadeFactory.getLocalInstance(ctx).batchAddSubmitNewPersonBizManage(transInfoList);
    }

    private String getFullInsertSqlOfBrowseTable(Context ctx, String personID, String empOrgRelationID, String empPostExpHisID, String bizManageTypeID, String oldHROrgUnitID, String newHROrgUnitID, String UserID, String effectDate) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO ").append("T_HR_PersonBUBrowse").append("(FID,FPersonID,FEmpOrgRelationID,FEmpPostExpHisID,FBizManageTypeID,FOldHROrgUnitID,FNewHROrgUnitID,FIPAddress,FCREATORID,FCREATETIME,FEFFDT) VALUES (").append("newbosid('B9E5AB53'),").append("'" + personID + "',").append("'" + empOrgRelationID + "',");
        if (StringUtils.isEmpty((String)empPostExpHisID)) {
            insertSql.append("null,");
        } else {
            insertSql.append("'" + empPostExpHisID + "',");
        }
        insertSql.append("'" + bizManageTypeID + "',");
        if (StringUtils.isEmpty((String)oldHROrgUnitID)) {
            insertSql.append("null,");
        } else {
            insertSql.append("'" + oldHROrgUnitID + "',");
        }
        insertSql.append("'" + newHROrgUnitID + "',").append("'" + ctx.getClientHostIP() + "',").append("'" + UserID + "',").append("now()");
        if (!StringUtils.isEmpty((String)effectDate)) {
            insertSql.append(",{ts'" + effectDate + "'})");
        } else {
            insertSql.append(",null)");
        }
        return insertSql.toString();
    }

    @Override
    protected void _submitAndAcceptPersonBUBrowseToRelation(Context ctx, String UserID) throws BOSException, EASBizException {
        PersonBUBrowseCollection coll = PersonBUBrowseFactory.getLocalInstance(ctx).getPersonBUBrowseCollection(" where creator = '" + UserID + "' and IPAddress = '" + ctx.getClientHostIP() + "'");
        ArrayList<PersonBURelationInfo> transInfoList = this.transPersonBUBrowseColl2PersonBURelationColl(ctx, coll);
        IObjectPK[] pks = PersonBizManageFacadeFactory.getLocalInstance(ctx).batchAddNewPersonBizManage(transInfoList);
        ArrayList<String> list = new ArrayList<String>();
        for (IObjectPK i : pks) {
            list.add(i.toString());
        }
        PersonBizManageFacadeFactory.getLocalInstance(ctx).batchSubmitAndReceivePersonBizManage(list);
    }

    @Override
    protected void _submitAndAcceptPersonBUBrowseToRelation(Context ctx, List saveBrowseToBUIds) throws BOSException, EASBizException {
        StringBuffer inSql = new StringBuffer();
        for (int i = 0; i < saveBrowseToBUIds.size(); ++i) {
            inSql.append(saveBrowseToBUIds.get(i)).append("','");
        }
        inSql.insert(0, "'").delete(inSql.length() - 2, inSql.length());
        PersonBUBrowseCollection coll = PersonBUBrowseFactory.getLocalInstance(ctx).getPersonBUBrowseCollection(" where id IN (" + inSql + ") ");
        ArrayList<PersonBURelationInfo> transInfoList = this.transPersonBUBrowseColl2PersonBURelationColl(ctx, coll);
        IObjectPK[] pks = PersonBizManageFacadeFactory.getLocalInstance(ctx).batchAddNewPersonBizManage(transInfoList);
        ArrayList<String> list = new ArrayList<String>();
        for (IObjectPK i : pks) {
            list.add(i.toString());
        }
        PersonBizManageFacadeFactory.getLocalInstance(ctx).batchSubmitAndReceivePersonBizManage(list);
    }
}

