/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.BizManageMessageFacadeFactory;
import com.kingdee.shr.base.bizmanage.log.BizManageLoggerUtil;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Set;
import org.apache.log4j.Logger;

public class SHRBizDataChangeMessageTask
implements Runnable {
    private static Logger logger = BizManageLoggerUtil.getLogger();
    private Context ctx = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String key;
        String string = key = SHRBizDataChangeMessageTask.class + this.ctx.getAIS();
        synchronized (string) {
            block9: {
                try {
                    String mainServerName = SHRBizManageCommonTool.getMainServerInstanceByDB(this.ctx);
                    Set<String> mainServerIpSet = SHRBizManageCommonTool.getMainServerIPStringSet(this.ctx);
                    Set<String> ipAddress = SHRBizManageCommonTool.getServerIPAddress();
                    String mainInstance = System.getProperty("EAS_INSTANCE_NAME");
                    if (mainServerName.equalsIgnoreCase(mainInstance)) {
                        if (!(ipAddress != null && mainServerIpSet != null && SHRBizDataChangeMessageTask.checkServerIPAddress(mainServerIpSet, ipAddress) || ipAddress != null && ipAddress.isEmpty()) && (mainServerIpSet == null || !mainServerIpSet.isEmpty()) || !SHRBizManageCommonTool.checkRecorderTaskEnd(this.ctx, "SHRBizDataChangeMessageTask")) break block9;
                        String recorderId = SHRBizManageCommonTool.recorderTaskBegin(this.ctx, "SHRBizDataChangeMessageTask");
                        try {
                            BizManageMessageFacadeFactory.getLocalInstance(this.ctx).dealAdminOrgChangeBizMessage();
                            BizManageMessageFacadeFactory.getLocalInstance(this.ctx).dealPersonChangeBizMessage();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        SHRBizManageCommonTool.recorderTaskEnd(this.ctx, recorderId);
                        this.deleteBizManageAccLogOverThreeMonth(this.ctx);
                        break block9;
                    }
                    if (SHRBizDataChangeMessageTask.checkServerIPAddress(mainServerIpSet, ipAddress) || mainServerIpSet == null || mainServerIpSet.size() == 0) {
                        SHRBizManageCommonTool.checkServerIsAlive(this.ctx, mainInstance);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    private void deleteBizManageAccLogOverThreeMonth(Context ctx) throws BOSException, SQLException {
        long decDay = 864000000L;
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd");
        String befSevenDate = "{ts'" + sFormat.format(new Date(cal.getTimeInMillis() - decDay)) + "'}";
        String sql = "select top 1 fid from T_HR_BizManageACCLog where FBeginTime<" + befSevenDate;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            sql = "delete from T_HR_BizManageACCLog where FBeginTime<" + befSevenDate;
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    public static boolean checkServerIPAddress(Set<String> mainServerIpSet, Set<String> ipAddress) {
        boolean result = false;
        if (mainServerIpSet == null) {
            result = true;
        } else {
            for (String ipString : ipAddress) {
                if (!mainServerIpSet.contains(ipString)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

