/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.thread;

import java.util.Date;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SHRBizDataScheduleTask<V>
extends FutureTask<V>
implements RunnableScheduledFuture<V> {
    private RunnableScheduledFuture<V> task;
    private ScheduledThreadPoolExecutor executor;
    private long period;
    private long startDate;

    public SHRBizDataScheduleTask(Runnable runnable, V result, RunnableScheduledFuture<V> task, ScheduledThreadPoolExecutor executor) {
        super(runnable, result);
        this.task = task;
        this.executor = executor;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        if (!this.isPeriodic()) {
            return this.task.getDelay(unit);
        }
        if (this.startDate == 0L) {
            return this.task.getDelay(unit);
        }
        Date now = new Date();
        long delay = this.startDate - now.getTime();
        return unit.convert(delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.task.compareTo(o);
    }

    @Override
    public boolean isPeriodic() {
        return this.task.isPeriodic();
    }

    @Override
    public void run() {
        if (this.isPeriodic() && !this.executor.isShutdown()) {
            Date now = new Date();
            this.startDate = now.getTime() + this.period;
            this.executor.getQueue().add(this);
        }
        super.runAndReset();
    }

    public void setPeriod(long period) {
        this.period = period;
    }
}

