/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.constant.CommonConstants;
import com.kingdee.shr.base.bizmanage.util.SHREmpPosOrgRelationUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SHRBizManageHelpUtil {
    public static List<Map<String, Object>> getEnableBizManageType(Context ctx) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            String l = LocaleUtils.getShortCode((Context)ctx);
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID,FNUMBER,FNAME_" + l + " FROM T_HR_BizManageType where FState=1 ORDER BY FINDEX ASC"));
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", executeQuery.getString("FID"));
                map.put("name", executeQuery.getString("FNAME_" + l + ""));
                map.put("value", executeQuery.getString("FNUMBER"));
                result.add(map);
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<Map<String, Object>> getEnableBizManageTypeForOrg(Context ctx) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            String l = LocaleUtils.getShortCode((Context)ctx);
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID,FNUMBER,FNAME_" + l + " FROM T_HR_BizManageType where FStateForOrg=1 ORDER BY FINDEX ASC"));
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", executeQuery.getString("FID"));
                map.put("name", executeQuery.getString("FNAME_" + l + ""));
                map.put("value", executeQuery.getString("FNUMBER"));
                result.add(map);
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getFirstParentHROrg(Context ctx, String adminOrgUnitID) {
        String hrOrgUnitID = "";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT FParentID,FLevel,FLongNumber FROM T_ORG_ADMIN WHERE FID = '" + adminOrgUnitID + "'"));
            while (executeQuery.next()) {
                String sql;
                IRowSet execute;
                String longNumber = executeQuery.getString("FLongNumber");
                String[] array = longNumber.split("!");
                String fileterIds = "";
                for (int i = 0; i < array.length; ++i) {
                    fileterIds = fileterIds + ",'" + array[i] + "'";
                }
                if (fileterIds.equals("") || !(execute = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT FID FROM T_ORG_HRO WHERE FNUMBER IN (" + fileterIds.substring(1) + ") ORDER BY FLEVEL DESC"))).next()) continue;
                hrOrgUnitID = execute.getString("FID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return hrOrgUnitID;
    }

    public static String getEnableAdminBuRelation(Context ctx, String adminOrgUnitID, String bizManageTypeID) {
        String hrOrgUnitID = "";
        try {
            String sql = "SELECT FManageHrOrgID FROM T_HR_AdminOrgBURelation WHERE FBizManageTypeID = '" + bizManageTypeID + "' AND FAdminOrgID = '" + adminOrgUnitID + "' AND FState = 1 ORDER BY FBeginDate DESC";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (executeQuery.next()) {
                hrOrgUnitID = executeQuery.getString("FManageHrOrgID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return hrOrgUnitID;
    }

    public static boolean isPerosnBuRelationDefault(Context ctx, String bizManageTypeID, String empOrgRelationID, String hrOrgUnitID) {
        boolean isDefault = false;
        try {
            String adminOrgUnitID = "";
            EmpPosOrgRelationInfo info = new EmpPosOrgRelationInfo();
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(SHREmpPosOrgRelationUtils.getSelectorCollection());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)empOrgRelationID));
            view.setFilter(filter);
            EmpPosOrgRelationCollection coll = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
            if (coll.size() > 0) {
                info = coll.get(0);
                adminOrgUnitID = info.getAdminOrg().getId().toString();
            }
            if (hrOrgUnitID.equals(SHRBizManageHelpUtil.getEnableAdminBuRelation(ctx, adminOrgUnitID, bizManageTypeID))) {
                isDefault = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return isDefault;
    }

    public static String getDepartureHRBizDefineIds(Context ctx) {
        String result = "";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_HR_HRBizDefine WHERE FBIZDEFINETYPE IN (4,6)");
            while (executeQuery.next()) {
                String id = executeQuery.getString("FID");
                result = result + ",'" + id + "'";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (!result.equals("")) {
            result = result.substring(1);
        }
        return result;
    }

    public static void deleteOrgManageBrowseDataAction(Context ctx) {
        String UserId = ctx.getCaller().toString();
        String deleteSql = "delete from T_HR_AdminOrgBUBrowse where fCreatorId = '" + UserId + "' and FIPAddress = '" + ctx.getClientHostIP() + "'";
        try {
            DbUtil.execute((Context)ctx, (String)deleteSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getParamHrOrgUnitListByBizManage(Context ctx, String bizManageTypeId) {
        ArrayList<String> resultList = new ArrayList<String>();
        String paramID = "";
        if (bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_ATS01)) {
            paramID = CommonConstants.ATS01_PARAM_ID;
        } else if (bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_ATS02)) {
            paramID = CommonConstants.ATS02_PARAM_ID;
        } else if (bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP01)) {
            paramID = CommonConstants.CMP01_PARAM_ID;
        } else if (bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP02)) {
            paramID = CommonConstants.CMP02_PARAM_ID;
        } else if (bizManageTypeId.equals(CommonConstants.BIZMANAGETYPE_CMP03)) {
            paramID = CommonConstants.CMP03_PARAM_ID;
        }
        if (!paramID.equals("")) {
            try {
                String sql = "select FOrgUnitID from T_BAS_PARAMitem where FKeyID = '" + paramID + "' AND FValue_l2 = 'true'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    resultList.add(executeQuery.getString("FOrgUnitID"));
                }
                StringBuilder sb = new StringBuilder();
                sb.append("select org.flongnumber longNumber from T_BAS_ParamManagerControl paramCon");
                sb.append("  left join t_org_hro org on paramCon.FSUPERIORCONTROLID=org.fid ");
                sb.append(" where FPARAMITEMID in( ");
                sb.append("select fid from t_bas_paramitem where fkeyid='").append(paramID).append("' ");
                sb.append("   and FVALUE_l2 ='true' ");
                sb.append("   ) and  FISINCLUDESUB=1 ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                String longNumber = "";
                IRowSet subRs = null;
                while (rs.next()) {
                    longNumber = rs.getString("longNumber");
                    sql = "select fid from t_org_hro where flongnumber like '" + longNumber + "!%' and fid not in(select FOrgUnitID from T_BAS_PARAMitem where FKeyID ='" + paramID + "')";
                    subRs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (subRs.next()) {
                        resultList.add(subRs.getString("fid"));
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertByBatch(Context ctx, List<String> sqlList, int count) throws BOSException, EASBizException {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            int j = 1;
            for (int i = 0; i < sqlList.size(); ++i) {
                ps.addBatch(sqlList.get(i));
                if (++j != count) continue;
                ps.executeBatch();
                ps.close();
                ps = conn.createStatement();
                j = 1;
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

